#include engine_interface

#title prison_door
#author DLL-LJS

export activate;
export init;

#define STATE_LOCKED	0
#define STATE_CLOSED	1
#define STATE_OPEN		2


void update_state(Object* me)
{
	switch (me->state)
	{
	case STATE_LOCKED:
		me->bitmap = get_bitmap("DOOR1_BMP");
		me->flags = me->flags | FLAG_OBSTACLE;
		break;
	case STATE_CLOSED:
		me->bitmap = get_bitmap("DOOR1_BMP");
		me->flags = me->flags | FLAG_OBSTACLE;
		break;
	case STATE_OPEN:
		me->bitmap = get_bitmap("DOOR1_OPEN_BMP");
		me->flags = me->flags & ~FLAG_OBSTACLE;
		break;
	}
}


void init(scArg arg)
{
	update_state(arg.me);
}

void activate(scArg arg)
{
	Object* obj = arg.obj;
	Object* me  = arg.me;
	Object* player;

	if (get_object("player") == obj)
	{
		switch (me->state)
		{
		case STATE_LOCKED:
			open_dialog(NULL, NULL);
			write_text("Zork", "Darn, this door is locked, and I don't have the key...");
			close_dialog();
			break;
		case STATE_CLOSED:
			me->state = STATE_OPEN;
			update_state(me);
			break;
		case STATE_OPEN:
			me->state = STATE_CLOSED;
			update_state(me);
			break;
		}
	}
}
