/**********************************************************
 *  T E T R I S v1.2
 *  programming and graphics Andrew Deren
 *
 * originally 1 / 30 / 97 Andrew Deren v1.0
 * modified   4 / 27 / 97 Timothy Dunn v1.1
 * modified   4 / 30 / 97 Andrew Deren v1.2
 *  Ok here is how the game works. The main variables of the game
 * are map[10][20] which holds the values of the blocks that have
 * been already put, block[4][4] which is the block that is currently
 * beeing moved, block_x and block_y are the location of the block
 * (upper left corner) on the map, and x_size and y_size is the
 * size of the block (it is different for different kinds of blocks
 * (see comment on GenerateBlock function). current_block is the type
 * of the block currently moved, and next_block is the next one.
 * timer is a interupt incremented variable and together with
 * speed is used to control the speed of the game. map_buffer is
 * used as a double buffer for drawing the map.
 * PlayGame function is the one that does the main loop of the game.
 * Look inside that function to see what it actually does.
 **********************************************************/

//inlucde files
#include <stdio.h>
#include <allegro.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dir.h>
#include "tdat.h"			/* holds defines for the datafile */

/*high score stucture */
struct HiScoreStruct {
	int score;				/* top score */
	int level;				/* level for that highscore */
	char name[35];			/* name of the person for highscore */
};

/*musics used from tdat.dat */
int Music[3] =
{MUSIC01, MUSIC02, MUSIC03};

int start_level;					  /*start from level selected under options */
int start_blocks;					  /*number of initial rows on the map */
int block[4][4];					  /*current block */
int next_block;					  /*next block to be put */
int map[10][20];					  /*map */
int block_x, block_y;			  /*location of the block */
int x_size, y_size;				  /*size of the block */
volatile int timer;				  /*timer of the game */
int current_block;				  /*current block type */
int speed;							  /*speed of the game */
int score, dels;					  /*game score and number of rows deleted */
char text[256];					  /*some text used for using textout */
struct HiScoreStruct HiScores[20];	/*high score */
int current_music;				  //music currently played

BITMAP *map_buffer;				  //double buffer for map displaying

DATAFILE *graphics;				  //data file with graphics and sounds

BITMAP *temp_bitmap;				  //temp 640x480 bitmap used by options and initial screens

int MusicVolume;					  //current volume of the music

int SoundVolume;					  //current volume of the sounds

bool soundOn;						  //sounds on or not

bool musicOn;						  //music on or not

//function prototypes
int Random (int x);
void IncrementTimer (...);
void DeleteRow (void);
int CanPut (void);
void NewGame (void);
void SetVolume (void);
void PlayGame (void);
void DrawVolume (int pos);
void SetVolume (void);
void Error (char *);
void InitGame (void);
void ClearBlock (void);
void GenerateBlock (int);
void DrawFrame (void);
void GenerateNew (void);
void PutBlock (void);
void RotateBlock (void);
void DrawMap (void);
void NewGame (void);
void DrawMenu (void);
void MainMenu (void);
void PlayGame (void);
void ViewHighScores (void);
void dtextout_centre (BITMAP *, FONT *, char *, int, int, int, int);
void dtextout (BITMAP *, FONT *, char *, int, int, int, int);
void Help(void);

//use textout to print text with shadow centered
void dtextout_centre (BITMAP * bmp, FONT * fnt, char *string, int x, int y, int bg, int fg)
{
	text_mode (-1);
	textout_centre (bmp, fnt, string, x + 2, y + 2, bg);
	textout_centre (bmp, fnt, string, x, y, fg);
}

//use textout to print text with shadow centered
void dtextout (BITMAP * bmp, FONT * fnt, char *string, int x, int y, int bg, int fg)
{
	text_mode (-1);
	textout (bmp, fnt, string, x + 2, y + 2, bg);
	textout (bmp, fnt, string, x, y, fg);
}

//returns random number up to x-1
int Random (int x)
{
	return random () % x;
}

//increment game timer
void IncrementTimer (...)
{
	timer++;
}

END_OF_FUNCTION (IncrementTimer);

// primitive dialog for displaying highscores
void ViewHighScores (void)
{
	clear (screen);
	text_mode (-1);
	drawing_mode (DRAW_MODE_COPY_PATTERN, (BITMAP *) graphics[PATTERN].dat, 0, 0);
	rectfill (screen, 0, 0, 640, 480, 0);
   solid_mode();
   rect(screen, 0, 0, 639, 479, 143);
	dtextout_centre (screen, font, "H I G H   S C O R E S", 320, 10, 0, 136);
	dtextout (screen, font, "Name", 65, 25, 0, 15);
	dtextout (screen, font, "Score", 380, 25, 0, 15);
	dtextout (screen, font, "Level", 450, 25, 0, 15);
	textout_centre (screen, font, "Press ESC to exit", 320, 460, 15);
   // loop through all 20 highscores and display them
	for (int i = 0; i < 20; i++) {
		sprintf (text, "%2d", i + 1);
		textout (screen, (FONT *) graphics[GAME_FONT].dat, text, 20, 50 + i * 20, 15);
		textout (screen, (FONT *) graphics[GAME_FONT].dat, HiScores[i].name, 60, 50 + i * 20, 15);
		sprintf (text, "%6d", HiScores[i].score);
		textout (screen, (FONT *) graphics[GAME_FONT].dat, text, 380, 50 + i * 20, 15);
		sprintf (text, "%2d", HiScores[i].level);
		textout (screen, (FONT *) graphics[GAME_FONT].dat, text, 450, 50 + i * 20, 15);
	}
	do {
		if (keypressed ()) {
			int ch = readkey ();
			if ((ch >> 8) == KEY_ESC)
				break;
		}
	} while (1 == 1);
}

//draw the options screen with cursor at pos
void DrawVolume (int pos)
{
	clear (temp_bitmap);			  //clear temp bitmap

	text_mode (-1);				  //set transparent text mode
	//set drawing mode to pattern from datafile

	drawing_mode (DRAW_MODE_COPY_PATTERN, (BITMAP *) graphics[PATTERN].dat, 0, 0);
	//fill the temp buffer
	rectfill (temp_bitmap, 0, 0, 640, 480, 0);
   solid_mode();
   rect(temp_bitmap, 0, 0, 639, 479, 143);
	//put some text
	dtextout (temp_bitmap, font, "O P T I O N S", 140, 10, 0, 136);
	dtextout (temp_bitmap, font, "Sound: ", 100, 50, 0, 136);
	dtextout (temp_bitmap, font, "Music: ", 100, 100, 0, 136);

	if (soundOn)
		dtextout (temp_bitmap, font, " On", 250, 50, 0, 136);
	else
		dtextout (temp_bitmap, font, "Off", 250, 50, 0, 136);
	if (musicOn)
		dtextout (temp_bitmap, font, " On", 250, 100, 0, 136);
	else
		dtextout (temp_bitmap, font, "Off", 250, 100, 0, 136);

	sprintf (text, "Sound Volume: %4d", SoundVolume);
	dtextout (temp_bitmap, font, text, 150, 130, 0, 136);
	sprintf (text, "Music Volume: %4d", MusicVolume);
	dtextout (temp_bitmap, font, text, 150, 180, 0, 136);
	sprintf (text, "Start Level: %4d", start_level);
	dtextout (temp_bitmap, font, text, 150, 230, 0, 136);
	sprintf (text, "Start Blocks: %4d", start_blocks);
	dtextout (temp_bitmap, font, text, 150, 280, 0, 136);
	//draw all the scorlbars
	for (int i = 0; i < 10; i++) {
		draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR].dat, 106 + i * 25, 150);
		draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR].dat, 106 + i * 25, 200);
		draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR].dat, 106 + i * 25, 250);
		draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR].dat, 106 + i * 25, 300);
	}
	draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR2].dat, 100 + SoundVolume, 150);
	draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR2].dat, 100 + MusicVolume, 200);
	draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR2].dat, 100 + start_level * 25, 250);
	draw_sprite (temp_bitmap, (BITMAP *) graphics[BAR2].dat, 100 + start_blocks * 25, 300);
	draw_sprite (temp_bitmap, (BITMAP *) graphics[CURSOR].dat, 80, pos * 50);
	dtextout (temp_bitmap, font, "Press arrow keys to change, ESC to exit", 100, 400, 0, 136);
	blit (temp_bitmap, screen, 0, 0, 0, 0, 640, 480);
}

//options screen
void SetVolume (void)
{
	int ch;
	int position = 1;
	DrawVolume (1);
	do {
		if (keypressed ()) {
			ch = readkey ();
			clear_keybuf ();
			if ((ch >> 8) == KEY_DOWN) {
				position++;
				if (position == 7)
					position = 1;
			}
			else if ((ch >> 8) == KEY_UP) {
				position--;
				if (position == 0)
					position = 6;
			}
			else if (((ch >> 8) == KEY_RIGHT) || ((ch >> 8) == KEY_LEFT)) {
				if (position == 1) {
					if (soundOn)
						soundOn = FALSE;
					else
						soundOn = TRUE;
				}
				else if (position == 2) {
					if (musicOn)
						musicOn = FALSE;
					else
						musicOn = TRUE;
				}
				else if (position == 3) {
					if ((ch >> 8) == KEY_RIGHT) {
						SoundVolume += 25;
						if (SoundVolume > 255)
							SoundVolume = 255;
					}
					else {
						SoundVolume -= 25;
						if (SoundVolume < 0)
							SoundVolume = 0;
					}
				}
				else if (position == 4) {
					if ((ch >> 8) == KEY_RIGHT) {
						MusicVolume += 25;
						if (MusicVolume > 255)
							MusicVolume = 255;
					}
					else {
						MusicVolume -= 25;
						if (MusicVolume < 0)
							MusicVolume = 0;
					}
				}
				else if (position == 5) {
					if ((ch >> 8) == KEY_RIGHT) {
						start_level++;
						if (start_level > 10)
							start_level = 10;
					}
					else {
						start_level--;
						if (start_level < 0)
							start_level = 0;
					}
				}
				else if (position == 6) {
					if ((ch >> 8) == KEY_RIGHT) {
						start_blocks++;
						if (start_blocks > 10)
							start_blocks = 10;
					}
					else {
						start_blocks--;
						if (start_blocks < 0)
							start_blocks = 0;
					}
				}
			}							  //end key up or down

			else if ((ch >> 8) == KEY_ESC) {
				break;
				DrawVolume (position);
			}
			DrawVolume (position);
		}								  //end keypressed;

	} while (1 == 1);
	set_volume (SoundVolume, MusicVolume);
	clear (screen);
}

// just print passed message and exit program
void Error (char *string)
{
	allegro_exit ();
	printf ("Error: %s\n", string);
	exit (1);
}

void InitGame (void)
{
	allegro_init ();				  //initialize allegro

	install_keyboard ();			  //install keyboard handler

	install_timer ();				  //install timer

	set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);	//set graphics mode to 640x480x256

   // initialize random seed
	srandom ((int) time (NULL));

   // initialize sound
	if (install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
		Error ("Error initializing sound.");

   // load data file
	if (!file_exists ("tdat.dat", FA_RDONLY | FA_ARCH, NULL))
		Error ("Cannot find tdat.dat file.");
	graphics = load_datafile ("tdat.dat");		//load graphics

   // create dubble buffer for the game screen
	map_buffer = create_bitmap (200, 400);		//create double buffer

   // temp buffer is used for drawing stuff to avoid flickering
	temp_bitmap = create_bitmap (640, 480);

   // start game timer with 0
	timer = 0;

   // timer is used by the game to time the movement
   // and is incremented in IncrementTimer function
   // those need to be locked so that are not swaped to the disk
	LOCK_VARIABLE (timer);
	LOCK_FUNCTION (IncrementTimer);

   // timer is incremented every 20 miliseconds
	install_int (IncrementTimer, 20);
   // initial speed of the moving blocks is 15
	speed = 15;
	set_clip (map_buffer, 0, 0, 200, 400);
	score = 0;	// initialize score
	dels = 1;	// dels is number of rows deleted

   // load highscores file
	FILE *file = fopen ("tetris.hsc", "rb");
	if (file) {
		fread (&HiScores, sizeof (struct HiScoreStruct), 20, file);
		fclose (file);
	}
	else { // if highscores file does not exist create new one
		for (int i = 0; i < 20; i++) {
			HiScores[i].score = (20 - i) * 1000;
			HiScores[i].level = 0;
			strcpy (HiScores[i].name, "..................................");
		}
	}

	font = (FONT *) graphics[TECH_FONT].dat;	// set active font
	soundOn = TRUE;
	musicOn = TRUE;
	SoundVolume = 180;
	MusicVolume = 180;
	set_volume (SoundVolume, MusicVolume);
	start_level = 0;
	start_blocks = 0;
	current_music = Random (3);
	set_pallete (black_pallete);
}

// draws the frame around playing area in the game
void DrawFrame (void)
{
	draw_sprite (screen, (BITMAP *) graphics[WALL03].dat, 80, 20);
	draw_sprite (screen, (BITMAP *) graphics[WALL04].dat, 300, 20);
	draw_sprite (screen, (BITMAP *) graphics[WALL05].dat, 80, 440);
	draw_sprite (screen, (BITMAP *) graphics[WALL06].dat, 300, 440);

	draw_sprite (screen, (BITMAP *) graphics[WALL03].dat, 340, 20);
	draw_sprite (screen, (BITMAP *) graphics[WALL04].dat, 580, 20);
	draw_sprite (screen, (BITMAP *) graphics[WALL05].dat, 340, 100);
	draw_sprite (screen, (BITMAP *) graphics[WALL06].dat, 580, 100);

	draw_sprite (screen, (BITMAP *) graphics[WALL03].dat, 340, 140);
	draw_sprite (screen, (BITMAP *) graphics[WALL04].dat, 440, 140);
	draw_sprite (screen, (BITMAP *) graphics[WALL05].dat, 340, 200);
	draw_sprite (screen, (BITMAP *) graphics[WALL06].dat, 440, 200);

	for (int i = 0; i < 11; i++) {
		draw_sprite (screen, (BITMAP *) graphics[WALL01].dat, 360 + i * 20, 20);
		draw_sprite (screen, (BITMAP *) graphics[WALL01].dat, 360 + i * 20, 100);
	}
	for (int i = 0; i < 3; i++) {
		draw_sprite (screen, (BITMAP *) graphics[WALL02].dat, 340, 40 + i * 20);
		draw_sprite (screen, (BITMAP *) graphics[WALL02].dat, 580, 40 + i * 20);

	}
	for (int i = 0; i < 4; i++) {
		draw_sprite (screen, (BITMAP *) graphics[WALL01].dat, 360 + i * 20, 140);
		draw_sprite (screen, (BITMAP *) graphics[WALL01].dat, 360 + i * 20, 200);
	}
	for (int i = 0; i < 10; i++) {
		draw_sprite (screen, (BITMAP *) graphics[WALL01].dat, 100 + i * 20, 20);
		draw_sprite (screen, (BITMAP *) graphics[WALL01].dat, 100 + i * 20, 440);
	}
	for (int i = 0; i < 2; i++) {
		draw_sprite (screen, (BITMAP *) graphics[WALL02].dat, 340, 160 + i * 20);
		draw_sprite (screen, (BITMAP *) graphics[WALL02].dat, 440, 160 + i * 20);
	}
	for (int i = 0; i < 20; i++) {
		draw_sprite (screen, (BITMAP *) graphics[WALL02].dat, 80, 40 + i * 20);
		draw_sprite (screen, (BITMAP *) graphics[WALL02].dat, 300, 40 + i * 20);
	}
}

// clears the current block
void ClearBlock (void)
{
	for (int i = 0; i < 4; i++)
		for (int j = 0; j < 4; j++)
			block[i][j] = 0;
}

// generates block depending on the kind of block to be generated
/* types of blocks: there are 7 kinds of blocks, and there can be
   4 different rotations of each block. To distinguish blocks
   block[][] holds the layout of the block and the blocks are:
   (x means 1..4 depending of the rotation of the block)
   X1:  X2:    X3:   X4:    X5:     X6:    X7: 
                                    
*/
void GenerateBlock (int kind)
{
	ClearBlock ();
	switch (kind) {
	case 1:
		block[1][0] = block[2][0] = block[0][1] = block[1][1] = 1;
		break;
	case 11:
		block[0][0] = block[0][1] = block[1][1] = block[1][2] = 1;
		break;
	case 21:
		block[1][0] = block[2][0] = block[0][1] = block[1][1] = 1;
		break;
	case 31:
		block[0][0] = block[0][1] = block[1][1] = block[1][2] = 1;
		break;

	case 2:
		block[0][0] = block[1][0] = block[1][1] = block[2][1] = 2;
		break;
	case 12:
		block[1][0] = block[1][1] = block[0][1] = block[0][2] = 2;
		break;
	case 22:
		block[0][0] = block[1][0] = block[1][1] = block[2][1] = 2;
		break;
	case 32:
		block[1][0] = block[1][1] = block[0][1] = block[0][2] = 2;
		break;

	case 3:
		block[0][0] = block[0][1] = block[1][0] = block[1][1] = 3;
		break;
	case 13:
		block[0][0] = block[0][1] = block[1][0] = block[1][1] = 3;
		break;
	case 23:
		block[0][0] = block[0][1] = block[1][0] = block[1][1] = 3;
		break;
	case 33:
		block[0][0] = block[0][1] = block[1][0] = block[1][1] = 3;
		break;

	case 4:
		block[1][0] = block[0][1] = block[1][1] = block[2][1] = 4;
		break;
	case 14:
		block[0][0] = block[0][1] = block[0][2] = block[1][1] = 4;
		break;
	case 24:
		block[0][0] = block[1][0] = block[2][0] = block[1][1] = 4;
		break;
	case 34:
		block[0][1] = block[1][0] = block[1][1] = block[1][2] = 4;
		break;

	case 5:
		block[2][0] = block[0][1] = block[1][1] = block[2][1] = 5;
		break;
	case 15:
		block[0][0] = block[0][1] = block[0][2] = block[1][2] = 5;
		break;
	case 25:
		block[0][0] = block[1][0] = block[2][0] = block[0][1] = 5;
		break;
	case 35:
		block[0][0] = block[1][0] = block[1][1] = block[1][2] = 5;
		break;

	case 6:
		block[0][0] = block[0][1] = block[1][1] = block[2][1] = 6;
		break;
	case 16:
		block[0][0] = block[1][0] = block[0][1] = block[0][2] = 6;
		break;
	case 26:
		block[0][0] = block[1][0] = block[2][0] = block[2][1] = 6;
		break;
	case 36:
		block[1][0] = block[1][1] = block[1][2] = block[0][2] = 6;
		break;

	case 7:
		block[0][0] = block[1][0] = block[2][0] = block[3][0] = 7;
		break;
	case 17:
		block[0][0] = block[0][1] = block[0][2] = block[0][3] = 7;
		break;
	case 27:
		block[0][0] = block[1][0] = block[2][0] = block[3][0] = 7;
		break;
	case 37:
		block[0][0] = block[0][1] = block[0][2] = block[0][3] = 7;
		break;
	default:
		Error ("Unknown element to be generated.");
		break;
	}

	if ((kind == 7) || (kind == 27)) {
		x_size = 4;
		y_size = 1;
	}
	else if ((kind == 17) || (kind == 37)) {
		x_size = 1;
		y_size = 4;
	}
	else if (kind % 10 == 3) {
		x_size = 2;
		y_size = 2;
	}
	else if ((kind / 10 == 0) || (kind / 10 == 2)) {
		x_size = 3;
		y_size = 2;
	}
	else if ((kind / 10 == 1) || (kind / 10 == 3)) {
		x_size = 2;
		y_size = 3;
	}
	current_block = kind;
}

/* this function generates new block when the current one has been put */
void GenerateNew (void)
{
 	/* next_block holds the value of the block that was shown as next last time,
   	so save it and later use it as a current one */
	int temp = next_block;
	next_block = Random (7) + 1; /* not get the next block */
   /* Now generate a next block depening on the value returned by random
      there can be 7 different kinds of block */
	GenerateBlock (next_block);
   /* loop through 4x4 double array and draw the correspoding squares
      for the next block. Depending on the type of block, each one
      uses different color of square */
	for (int i = 0; i < 4; i++) {
		for (int j = 0; j < 2; j++) {
			if (block[i][j] != 0) {
				switch (next_block) {
				case 1:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK].dat, 360 + i * 20, 160 + j * 20);
					break;
				case 2:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK_2].dat, 360 + i * 20, 160 + j * 20);
					break;
				case 3:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK_3].dat, 360 + i * 20, 160 + j * 20);
					break;
				case 4:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK_4].dat, 360 + i * 20, 160 + j * 20);
					break;
				case 5:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK_5].dat, 360 + i * 20, 160 + j * 20);
					break;
				case 6:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK_6].dat, 360 + i * 20, 160 + j * 20);
					break;
				case 7:
					draw_sprite (screen, (BITMAP *) graphics[BLOCK_7].dat, 360 + i * 20, 160 + j * 20);
					break;
				}
			}
			else
				draw_sprite (screen, (BITMAP *) graphics[EMPTY].dat, 360 + i * 20, 160 + j * 20);
		}
	}
	/* now generate the current block using the value used by the next_block last time */
	GenerateBlock (temp);
   /* set current locations of the block */
	block_x = 3;
	block_y = 0;
   /* if can't put block the game is over */
	if (!CanPut ()) {
		text_mode (-1);
		dtextout_centre (screen, font, "G A M E", 200, 150, 0, 136);
		dtextout_centre (screen, font, "O V E R", 200, 200, 0, 136);
		dtextout_centre (screen, (FONT *) graphics[GAME_FONT].dat, "Press Enter to", 200, 250, 0, 136);
		dtextout_centre (screen, (FONT *) graphics[GAME_FONT].dat, "to start a new game", 200, 275, 0, 136);
		sprintf (text, "Score: %3d", score);
		dtextout_centre (screen, (FONT *) graphics[GAME_FONT].dat, text, 202, 302, 0, 136);
		clear_keybuf ();
		do {
			if (key[KEY_ENTER])
				break;
		} while (1 == 1);
		clear_keybuf ();
		NewGame ();
	}
}

/* this function puts current block onto map[][] double array
	using block_x and block_y location. It is called when a block
   cannot move anymore downwards */
void PutBlock (void)
{
	for (int i = 0; i < 4; i++) {
		for (int j = 0; j < 4; j++) {
			if (block[i][j] != 0)
				map[block_x + i][block_y + j] = block[i][j];
		}
	}
	if (soundOn)
		play_sample ((SAMPLE *) graphics[MOVE_SOUND].dat, SoundVolume, 125, 1000, FALSE);
   /* now check if block deletes any rows */
	DeleteRow ();
}

/* this function rotates the block. It's called when the rotate button
   is pressed. It uses the GenerateBlock function using the same type of
   block but different rotation */
void RotateBlock (void)
{
 	/* save block so that when can't rotate block it can be restored */
	int old_block = current_block;
   /* set next rotation type */
	current_block += 10;
   /* there can be only four rotations so set block to first one if
      greater than 4th one */
	if (current_block > 40)
		current_block -= 40;
   /* generate new rotated block */
	GenerateBlock (current_block);

   /* if can't put block (could be out of map) restore old one */
	if (!CanPut ()) {
		current_block = old_block;
		GenerateBlock (current_block);
	}
}

/* this function checks if the current map fits onto map.
	Used by rotate */
int CanPut (void)
{
 	/* go through all parts of the block and check if they
      are in the map range */
	for (int i = 0; i < 4; i++) {
		for (int j = 0; j < 4; j++) {
			if (block[i][j] != 0) {
				if (block_x + i > 9)
					return FALSE;
				if (block_x + i < 0)
					return FALSE;
				if (block_y + j > 19)
					return FALSE;
				if (map[block_x + i][block_y + j] != 0)
					return FALSE;
			}
		}
	}
	/* block is in the range of map */
	return TRUE;
}


/* this function draws the map to map_buffer which is later
   blit to screen (Double buffering).  It goes through
   map double array and depending on the type of block there
   it draws the correspoding color box */
void DrawMap (void)
{
	clear (map_buffer);
	for (int i = 0; i < 10; i++) {
		for (int j = 0; j < 20; j++) {
			if (map[i][j] != 0) {
				switch (map[i][j]) {
				case 1:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK].dat, i * 20, j * 20);
					break;
				case 2:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_2].dat, i * 20, j * 20);
					break;
				case 3:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_3].dat, i * 20, j * 20);
					break;
				case 4:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_4].dat, i * 20, j * 20);
					break;
				case 5:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_5].dat, i * 20, j * 20);
					break;
				case 6:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_6].dat, i * 20, j * 20);
					break;
				case 7:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_7].dat, i * 20, j * 20);
					break;
				}
			}
		}
	}
	/* this function draws the current box onto map_buffer */
	for (int i = 0; i < 4; i++) {
		for (int j = 0; j < 4; j++) {
			if (block[i][j] != 0) {
				switch (block[i][j]) {
				case 1:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				case 2:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_2].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				case 3:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_3].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				case 4:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_4].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				case 5:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_5].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				case 6:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_6].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				case 7:
					draw_sprite (map_buffer, (BITMAP *) graphics[BLOCK_7].dat, block_x * 20 + i * 20, block_y * 20 + j * 20);
					break;
				}
			}
		}
	}
	blit (map_buffer, screen, 0, 0, 100, 40, 200, 400);
   /* display score and level info */
	text_mode (0);
	sprintf (text, "%7d", score);
	textout (screen, font, text, 570 - text_length (font, text), 50, 15);
	sprintf (text, "%7d", dels / 10);
	textout (screen, font, text, 570 - text_length (font, text), 65, 15);
}

/* this function goes through map and checks if there are any rows
	that can be deleted (all values in one colum filled in */
void DeleteRow (void)
{
	int sum, i, j, del = 0;
   /* loop through all 20 rows */
	for (i = 19; i >= 0; i--) {
		sum = 0;	/* sum holds number of non-empty cells */
      /* loop through all columns of the row */
		for (j = 0; j < 10; j++) {
			if (map[j][i] != 0)
				sum++; /* if cell not empty increment sum */
		}
   	/* if sum == 10 it means that the row is full so move
         all rows above it down */
		if (sum == 10) {
			for (j = i; j >= 1; j--)
				for (int k = 0; k < 10; k++)
					map[k][j] = map[k][j - 1];
			i += 2;
			del++;	/* incremente number of deleted rows */
		}
	}
	if (del > 0)
		if (soundOn)
			play_sample ((SAMPLE *) graphics[DELETE_SOUND].dat, SoundVolume, 125, 1000, FALSE);
	dels += del;
   /* give correspoding score for number of deleted rows */
	if (del > 0)
		score += (100 * del) + ((del - 1) * 25) + (dels / 10) * 25;
   /* change speed every 10 deleted rows */
	speed = 25 - (dels / 10) * 2;
	if (speed < 2)
		speed = 2;
}

/* this function just gets the name of the user when he/she got a highscore */
void GetName (int which)
{
	drawing_mode (DRAW_MODE_SOLID, NULL, 0, 0);
	blit (screen, temp_bitmap, 0, 0, 0, 0, 640, 480);
	int l = 0;
	int ch;
	char temp_str[40];
	simulate_keypress (283);
	ViewHighScores ();
	strcpy (temp_str, "                                   ");
	text_mode (0);
	textout (screen, (FONT *) graphics[GAME_FONT].dat, temp_str, 60, 50 + which * 20, 15);
   solid_mode();
   rect(screen, 58, 48 + which * 20, 62 + text_length((FONT*)graphics[GAME_FONT].dat, temp_str),
                52 + which * 20 + text_height((FONT*)graphics[GAME_FONT].dat), 143);
	text[0] = '\0';
	clear_keybuf ();
	do {
		if (keypressed ()) {
			ch = readkey () & 0x00ff;
			if ((ch > 31) && (ch < 127) && (l < 34)) {
				text[l + 1] = '\0';
				text[l] = ch;
				l++;
			}							  //end if

			else if ((key[KEY_BACKSPACE]) && (l > 0)) {
				l--;
				text[l] = '\0';
			}							  //end else if

			else if (key[KEY_ENTER] || key[KEY_ESC])
				break;
			textout (screen, (FONT *) graphics[GAME_FONT].dat, temp_str, 60, 50 + which * 20, 15);
			textout (screen, (FONT *) graphics[GAME_FONT].dat, text, 60, 50 + which * 20, 15);
		}								  //end if

		textout (screen, (FONT *) graphics[GAME_FONT].dat, "_", text_length ((FONT *) graphics[GAME_FONT].dat, text) + 60, 50 + which * 20, 15);
	} while (1 == 1);
	strcpy (HiScores[which].name, text);
	ViewHighScores ();
	blit (temp_bitmap, screen, 0, 0, 0, 0, 640, 480);
}

/* this function updates highscores array */
void UpdateHighScores ()
{
	int i;
	for (i = 19; i >= 0; i--) {
		if (score > HiScores[i].score) {
			if (i > 0) {
				HiScores[i].score = HiScores[i - 1].score;
				strcpy (HiScores[i].name, HiScores[i - 1].name);
				HiScores[i].level = HiScores[i - 1].level;
			}
		}
		else
			break;
	}
	HiScores[i + 1].score = score;
	HiScores[i + 1].level = dels / 10;
	GetName (i + 1);
}


/* initializes stuff for new game */
void NewGame (void)
{
	if (score > HiScores[19].score)
		UpdateHighScores ();
   /* clear the map */
	for (int i = 0; i < 20; i++)
		for (int j = 0; j < 10; j++)
			map[j][i] = 0;
	score = 0;
	next_block = Random (7) + 1;
	GenerateNew ();
	DrawMap ();
	dels = start_level * 10;
	speed = 25 - (dels / 10) * 2;
	text_mode (0);
	sprintf (text, "Score:");
	textout (screen, font, text, 365, 50, 15);
	sprintf (text, "Level:");
	textout (screen, font, text, 365, 65, 15);
	sprintf (text, "High Score: ");
	textout (screen, font, text, 365, 80, 15);
	sprintf (text, "%7d", HiScores[0].score);
	textout (screen, font, text, 570 - text_length (font, text), 80, 15);

   /* if initialy in options some rows of blocks are selected
   	generated them randomly and put them onto map */
	for (int i = 0; i < start_blocks; i++) {
		for (int j = 0; j < 10; j++) {
			if (Random (2))
				map[j][19 - i] = 1;
		}
	}
	timer = 0;
}

/* this function just draws the main menu */
void DrawMenu (int pos)
{
	text_mode (-1);
	clear (temp_bitmap);
	drawing_mode (DRAW_MODE_COPY_PATTERN, (BITMAP *) graphics[PATTERN].dat, 0, 0);
	rectfill (temp_bitmap, 0, 0, 640, 480, 0);
	draw_sprite (temp_bitmap, (BITMAP *) graphics[TETRIS].dat, 170, 50);
   dtextout_centre (temp_bitmap, font, "(c) Andrew Deren 1997", 320, 130, 0, 136);
	dtextout (temp_bitmap, font, "N E W  G A M E", 100, 200, 0, 136);
	dtextout (temp_bitmap, font, "O P T I O N S", 100, 250, 0, 136);
	dtextout (temp_bitmap, font, "H I G H  S C O R E S", 100, 300, 0, 136);
   dtextout (temp_bitmap, font, "H E L P", 100, 350, 0, 136);
	dtextout (temp_bitmap, font, "E X I T", 100, 400, 0, 136);

	draw_sprite (temp_bitmap, (BITMAP *) graphics[CURSOR].dat, 80, (pos - 1) * 50 + 200);
   solid_mode();
   rect(temp_bitmap, 0, 0, 639, 479, 143);
	blit (temp_bitmap, screen, 0, 0, 0, 0, 640, 480);
}

/* event handling for main menu */
void MainMenu ()
{
	int ch;
	int pos = 1;
	DrawMenu (1);
	fade_in ((RGB *) graphics[GAME_PALLETE].dat, 2);	//fade in slowly

	do {
		if (keypressed ()) {
			ch = readkey ();
			if ((ch >> 8) == KEY_UP) {
				pos--;
				if (pos == 0)
					pos = 5;
			}
			else if ((ch >> 8) == KEY_DOWN) {
				pos++;
				if (pos == 6)
					pos = 1;
			}
			else if ((ch >> 8) == KEY_ENTER) {
				if (pos == 1) {
					PlayGame ();
				}
				else if (pos == 2)
					SetVolume ();
            else if (pos == 4)
               Help();
				else if (pos == 5)
					break;
				else if (pos == 3)
					ViewHighScores ();
			}
			else if ((ch >> 8) == KEY_ESC)
				break;
			DrawMenu (pos);
		}								  // end if keypressed

	} while (1 == 1);
	fade_out (1);
	if (musicOn)
		stop_midi ();
}

/* display help */
void Help(void)
{
   FONT *temp_font = font;
	blit (screen, temp_bitmap, 0, 0, 0, 0, 640, 480);
	drawing_mode (DRAW_MODE_COPY_PATTERN, (BITMAP *) graphics[PATTERN].dat, 0, 0);
	rectfill (screen, 0, 0, 640, 480, 0);
   solid_mode();
   rect(screen, 0, 0, 639, 479, 143);
   dtextout_centre(screen, font, "H E L P", 320, 10, 0, 15);
   font = (FONT*)graphics[GAME_FONT].dat;
   #define START 100
   textout(screen, font, "KEYS", 100, START, 15);
   textout(screen, font, "----", 100, START+15, 15);
   textout(screen, font, "Left & Right : Move the piece left/right.", 20, START+30 , 15);
   textout(screen, font, "UP           : Rotate piece.", 20, START+45, 15);
   textout(screen, font, "DOWN         : Moves the piece down a little (Does *NOT* go all the way down)", 20, START+60, 15);
   textout(screen, font, "Space        : Move block to the bottom fast", 20, START+75, 15);
   textout(screen, font, "F1           : Help", 20, START+90, 15);
   textout(screen, font, "F2           : Start new game.", 20, START+105, 15);
   textout(screen, font, "F3           : PANIC BUTTON, clears the screen of blocks, but at a cost of", 20, START+120, 15);
   textout(screen, font, "               5 points * level number for each little square. If you do not", 20, START+135, 15);
   textout(screen, font, "               have that many points blocks will be deleted until you have", 20, START+150, 15);
   textout(screen, font, "               points", 20, START+165, 15);
   textout(screen, font, "F5           : Change music.", 20, START+180, 15);
   textout_centre(screen, font, "Press ESC to Exit", 320, 450, 15);
   while (1==1) {
      if (key[KEY_ESC]) {
         while (key[KEY_ESC]){}
         break;
      }
   }
   font = temp_font;
   clear_keybuf();
   blit(temp_bitmap, screen, 0, 0, 0, 0, 640, 480);
}

/* this is a game loop function */
void PlayGame (void)
{
	int ch;
	int loop, loop2;
   /* just do some initializing graphics stuff */
	drawing_mode (DRAW_MODE_COPY_PATTERN, (BITMAP *) graphics[PATTERN].dat, 0, 0);
	rectfill (screen, 0, 0, 640, 480, 0);
	DrawFrame ();
   solid_mode();
	rectfill (screen, 360, 40, 580, 100, 0);
   rect(screen, 0, 0, 639, 479, 143);
	current_music = Random (3);
	if (musicOn)
		play_midi ((MIDI *) graphics[Music[current_music]].dat, TRUE);
	draw_sprite (screen, (BITMAP *) graphics[TETRIS].dat, 340, 300);
	NewGame ();
   text_mode(-1);
   dtextout( screen, font, "N E X T", 370, 123, 0, 15);
   dtextout_centre(screen, font, "(c) Andrew Deren - 1997", 490, 370, 0, 15);
   dtextout_centre(screen, font, "Press F1 for Help", 490, 390, 0, 15);
   /* game loop */
	while (1 == 1) {
     	/* if user pressed a key */
		if (keypressed ()) {
			ch = readkey ();
         /* if it's one of the arrow keys move the block in correspoding
            direction checking if it can be moved there first */
			if ((ch >> 8) == KEY_LEFT) {
				block_x--;
				if (!CanPut ())
					block_x++;
			}
			if ((ch >> 8) == KEY_RIGHT) {
				block_x++;
				if (!CanPut ())
					block_x--;
			}
      	/* if it's key up rotate the block */
			if ((ch >> 8) == KEY_UP)
				RotateBlock ();
         /* if it's key down move block down */
			if ((ch >> 8) == KEY_DOWN) {
				if (CanPut ()) {
					DrawMap ();
					block_y++;
				}
				if (!CanPut ())
					block_y--;
				clear_keybuf ();
			}
      	/* if it's space move block fast all the way down */
			if ((ch >> 8) == KEY_SPACE) {
				while (CanPut ()) {
					DrawMap ();
					block_y++;
				}
				block_y--;
			}
      	/* f2 starts new game */
			if ((ch >> 8) == KEY_F2)
				NewGame ();
         /* f5 changes music */
			else if ((ch >> 8) == KEY_F5) {
				if (musicOn) {
					stop_midi ();
					current_music++;
					if (current_music > 2)
						current_music = 0;
					play_midi ((MIDI *) graphics[Music[current_music]].dat, TRUE);
				}
			}
      	/* esc exits game */
			else if ((ch >> 8) == KEY_ESC) {
				text_mode (-1);
				textout (screen, font, "Do you really want", 125, 200, 15);
				textout (screen, font, "to quit? (Y/N)", 125, 225, 15);
				if ((ch = readkey ()) >> 8 == KEY_Y)
					break;
			}
      	/* f12 saves screen to file */
			else if ((ch >> 8) == KEY_F12) {
				BITMAP *bmp;
				bmp = create_sub_bitmap (screen, 0, 0, SCREEN_W, SCREEN_H);
				save_pcx ("tetdat.pcx", bmp, (RGB *) graphics[GAME_PALLETE].dat);
				destroy_bitmap (bmp);
			}
      	/* f1 shows help */
         else if ((ch >> 8) == KEY_F1) Help();
         /* this was added by Timothy and it deltes all the blocks from
         	the map */
			else if ((ch >> 8) == KEY_F3) {
				for (loop = 0; loop < 20; loop++) {
					for (loop2 = 0; loop2 < 10; loop2++) {
						if (map[loop2][loop] != 0) {
							score -= (dels * 5);
							if (score < 0)
								score = 0;
							else
								map[loop2][loop] = 0;
						}				  // end if
					}					  // end for loop2
				}						  // end for loop
			}							  // end else if KEY_F3
			clear_keybuf ();
		}
   	/* this thing controls the game speed of the game
      	If the timer is greater than speed (changes)
         then block is moved down */
		if (timer > speed) {
			block_y++;
         /* and if the block is at the bottom new one is generated */
			if (!CanPut ()) {
				block_y--;
				PutBlock ();
				GenerateNew ();
			}
      	/* now set timer to 0, so that it can be checked with speed again */
			timer = 0;
		}
   	/* if can't put block generate new one */
		if (!CanPut ()) {
			PutBlock ();
			GenerateNew ();
		}
   	/* draw the map */
		DrawMap ();
	}
	stop_midi ();
}


main ()
{
 	/* initialize game */
	InitGame ();
   /* main menu stuff */
	MainMenu ();
	allegro_exit ();
	FILE *file;
	file = fopen ("tetris.hsc", "wb");
	if (file) {
		fwrite (&HiScores, sizeof (struct HiScoreStruct), 20, file);
		fclose (file);
	}
	printf ("                             T E T R I S   v1.2                        \n");
   printf ("                                May 12, 1997                           \n");
	printf (" --------------------------------------------------------------------- \n");
	printf ("                         Programing and Graphics by                    \n");
	printf ("                               Andrew Deren                            \n");
	printf (" --------------------------------------------------------------------- \n");
	printf ("                            Special Thanks To:                         \n");
	printf ("                      DJ Delorie - for making DJGPP                    \n");
	printf ("           Shawn Hargreaves - for making allegro game library          \n");
   printf ("               Timothy Dunn - for making some modifications            \n");
	printf ("              and all the other people who contributed to              \n");
	printf ("                 DJGPP development tools and utilities.                \n");
	printf (" --------------------------------------------------------------------- \n");
	printf ("\n\n\n");
}
