#include "Tetrisglobals.h"

int gamestatus;
int drawok;
int grid[160];
int score;
int highscore;
int next;

volatile int counter;

_block block;

BITMAP *back_buffer;
BITMAP *bgblock;
BITMAP *tblock;
BITMAP *nextview;

void do_menu();
void do_game();
void do_gameover();
void draw_background();
void clear_full_rows();
void clear_grid();
void draw_grid();
void create_next();

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

int main()
{
  srand(time(NULL));
  allegro_init();
  install_keyboard();
  set_color_depth(8);
  install_timer();
  install_int_ex(timer_handler, BPS_TO_TIMER(60));
  set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0);
  back_buffer = create_bitmap(320, 200);
  bgblock = create_bitmap(8, 8);
  nextview = create_bitmap(32, 32);
  clear(bgblock);
  rect(bgblock, 0, 0, 7, 7, 15);
  line(bgblock, 0, 0, 7, 7, 7);
  line(bgblock, 0, 7, 7, 0, 7);
  tblock = create_bitmap(8, 8);
  rectfill(tblock, 0, 0, 7, 7, 12);
  putpixel(tblock, 0, 0, 4);
  putpixel(tblock, 7, 0, 4);
  putpixel(tblock, 0, 7, 4);
  putpixel(tblock, 7, 7, 4);
  gamestatus = TMENU;
  drawok = 0;
  counter = 0;
  block.exists = 0;
  score = 0;
  ifstream s("t.dat");
  if (!s.bad())
  {
    s >> highscore;
  }
  else
  {
    highscore = 0;
  }
  next = rand()%5;
  while (gamestatus != TQUIT)
  {
    while (counter > 0)
    {
      switch(gamestatus)
      {
        case TMENU:
          do_menu();
          break;
        case TGAME:
          do_game();
          break;
        case GAMEOVER:
          do_gameover();
          break;
      }
      if (key[KEY_ESC])
      {
        counter = 0;
        gamestatus = TQUIT;
      }
      drawok = 1;
      counter--;
    }
    if (drawok == 1)
    {
      blit(back_buffer, screen, 0, 0, 0, 0, 320, 200);
      drawok = 0;
    }
    Sleep(1);
  }
  ofstream o("t.dat");
  if (!o.bad())
  {
    o << highscore;
  }
  destroy_bitmap(tblock);
  destroy_bitmap(bgblock);
  destroy_bitmap(back_buffer);
  destroy_bitmap(nextview);
  allegro_exit();
  return 0;
}
END_OF_MAIN();

void do_menu()
{
  static int keydelay = 0;
  clear(back_buffer);
  textout_centre(back_buffer, font, "Tetriclone", 160, 20, 15);
  textprintf_centre(back_buffer, font, 160, 40, 15, "High score: %-1d", highscore);
  textout_centre(back_buffer, font, "Press Enter", 160, 170, 15);
  if (keydelay == 0)
  {
    if (key[KEY_ENTER])
    {
      gamestatus = TGAME;
      block.exists = 0;
      score = 0;
      clear_grid();
      next = rand()%5;
      keydelay = 15;
      create_next();
    }
  }
  else
  {
    keydelay--;
  }
}

void do_game()
{
  static int keydelay = 0;
  clear(back_buffer);
  draw_background();
  if (block.exists == 0)
  {
    if (block.recreate() == 0)  //if the new block tries to appear where
    {                           //another block has already been placed
      gamestatus = GAMEOVER;
    }
    else
    {
      create_next();
    }
  }
  if (keydelay == 0)
  {
    if (key[KEY_LEFT])
    {
      block.move(LEFT);
      keydelay = 8;
    }
    if (key[KEY_RIGHT])
    {
      block.move(RIGHT);
      keydelay = 8;
    }
    if (key[KEY_UP])
    {
      block.rotate();
      keydelay = 8;
    }
  }
  else
  {
    keydelay--;
  }
  if (block.contact_made() == 1)
  {
    block.downdelay++;
    if (block.countdown == 0)
    {
      block.attach();
      score++;
      clear_full_rows();
    }
    else
    {
      block.countdown--;
    }
  }
  else
  {
    block.countdown = 15;
  }
  block.fall();
  block.draw();
  draw_grid();
}

void do_gameover()
{
  clear(back_buffer);
  draw_background();
  draw_grid();
  textout_centre(back_buffer, font, "GAME OVER", 160, 96, 11);
  if (key[KEY_ENTER])
  {
    gamestatus = TMENU;
    if (score > highscore)
    {
      highscore = score;
    }
  }
}

void draw_background()
{
  static float c = 32;
  static int cp = -1;
  int i = 0;
  int j = 0;
  if (c <= 16.05)
  {
    cp = 1;
  }
  else if (c >= 31.95)
  {
    cp = -1;
  }
  c += 0.05 * cp;
  textout_centre(back_buffer, font, "Tetriclone", 160, 5, int(c));
  while (i < 18)
  {
    if ((i != 0) && (i != 17))
    {
      draw_sprite(back_buffer, bgblock, 72, 24 + (i * 8));
      draw_sprite(back_buffer, bgblock, 160, 24 + (i * 8));
    }
    else
    {
      j = 0;
      while (j < 12)
      {
        draw_sprite(back_buffer, bgblock, 72 + (j * 8), 24 + (i * 8));
        j++;
      }
    }
    j = 0;
    while (j < 10)
    {
      draw_sprite(back_buffer, bgblock, 168 + (j * 8), 24 + (i * 8));
      j++;
    }
    rectfill(back_buffer, 176, 64, 231, 79, 0);
    rectfill(back_buffer, 184, 96, 223, 127, 0);
    i++;
  }
  textprintf_right(back_buffer, font, 230, 68, 15, "%-1d", score);
  draw_sprite(back_buffer, nextview, 192, 96);
}

void clear_full_rows()
{
  int i = 0;
  int j = 0;
  int z = 0;
  int full = 1;
  while (i < 16)
  {
    full = 1;
    j = 0;
    while (j < 10)
    {
      if (grid[j + (i * 10)] == 0)
      {
        full = 0;
      }
      j++;
    }
    if (full == 1)
    {
      j = 0;
      while (j < 10)
      {
        grid[j + (i * 10)] = 0;
        j++;
      }
      score += 20;
      z = i;
      while (z > 0)
      {
        j = 0;
        while (j < 10)
        {
          grid[j + (z * 10)] = grid[j + ((z - 1) * 10)];
          j++;
        }
        z--;
      }
    }
    i++;
  }
}

void clear_grid()
{
  int i = 0;
  int j = 0;
  while (i < 16)
  {
    j = 0;
    while (j < 10)
    {
      grid[j + (i * 10)] = 0;
      j++;
    }
    i++;
  }
}

void draw_grid()
{
  int i = 0;
  int j = 0;
  while (i < 16)
  {
    j = 0;
    while (j < 10)
    {
      if (grid[j + (i * 10)] == 1)
      {
        draw_sprite(back_buffer, tblock, 80 + (j * 8), 32 + (i * 8));
      }
      j++;
    }
    i++;
  }
}

void create_next()
{
  int i;
  _block temp;
  temp.init_set(next);
  clear(nextview);
  i = 0;
  while (i < 16)
  {
    if (temp.set[i] == 1)
    {
      draw_sprite(nextview, tblock, (i % 4) * 8, (i / 4) * 8);
    }
    i++;
  }
}
