#include "Tetrisglobals.h"

int _block::recreate()
{
  int i;
  int j;
  type = next;
  next = rand()%5;
  x = 0;
  while (x < 16)
  {
    set[x] = 0;
    x++;
  }
  init_set(type);
  x = 4;
  y = 0;
  downdelay = 8;
  exists = 1;
  i = 0;
  while (i < 4)
  {
    j = 0;
    while (j < 4)
    {
      if (set[j + (i * 4)] == 1)
      {
        if (grid[x + j + (y + i) * 10] == 1)  //if new piece collides immediately
        {
          attach();
          return 0;  //the pile is too high and the game is over
        }
      }
      j++;
    }
    i++;
  }
  return 1;
}

void _block::draw()
{
  int i = 0;
  int dx, dy;
  while (i < 16)
  {
    dx = i % 4;
    dy = i / 4;
    if (set[i] == 1)
    {
      grid[(x + dx) + (y + dy) * 10] = 1;
    }
    i++;
  }
}

void _block::erase()
{
  int i = 0;
  int dx, dy;
  while (i < 16)
  {
    dx = i % 4;
    dy = i / 4;
    if (set[i] == 1)
    {
      grid[(x + dx) + (y + dy) * 10] = 0;
    }
    i++;
  }
}

void _block::move(int dir)
{
  switch(dir)
  {
    case LEFT:
      if (can_move(LEFT) == 1)
      {
        erase();
        x--;
      }
      break;
    case RIGHT:
      if (can_move(RIGHT) == 1)
      {
        erase();
        x++;
      }
      break;
  }
}

void _block::rotate()
{
  int newset[16];
  int i = 0;
  int j = 0;
  int cancel = 0;
  erase();
  while (i < 4)
  {
    j = 0;
    while (j < 4)
    {
      newset[j + (i * 4)] = set[(12 + i) - (j * 4)];
      j++;
    }
    i++;
  }
  i = 0;
  while (i < 4)
  {
    j = 0;
    while (j < 4)
    {
      if (newset[j + (i * 4)] == 1)
      {
        if (grid[x + j + (y + i) * 10] == 1)  //if the rotated piece will collide
        {
          cancel = 1;  //cancel the rotation
        }
        if ((x + j < 0) || (x + j > 9))
        {
          cancel = 1;
        }
      }
      j++;
    }
    i++;
  }
  if (cancel == 0)
  {
    i = 0;
    while (i < 16)
    {
      set[i] = newset[i];
      i++;
    }
  }
}

void _block::fall()
{
  if (downdelay <= 0)
  {
    erase();
    y++;
    downdelay = 8;
  }
  else
  {
    downdelay--;
  }
}

int _block::contact_made()
{
  int lowest_y[4];
  int i = 0;
  int j = 0;
  while (i < 4)
  {
    lowest_y[i] = -1;
    j = 0;
    while (j < 4)
    {
      if (set[i + (j * 4)] == 1)
      {
        lowest_y[i] = j;
      }
      j++;
    }
    i++;
  }
  i = 0;
  while (i < 4)
  {
    if (lowest_y[i] != -1)
    {
      if (grid[x + i + ((y + lowest_y[i] + 1) * 10)] == 1)  //if it is touching another block
      {
        return 1;
      }
      else if (y + lowest_y[i] == 15)  //if it has reached the floor
      {
        return 1;
      }
    }
    i++;
  }
  return 0;
}

void _block::attach()
{
  exists = 0;
  draw();
}

void _block::set_on(int x, int y)
{
  int num = x + (y * 4);
  if ((x >= 0) && (x < 3))
  {
    if ((num >= 0) && (num < 16))
    {
      set[num] = 1;
    }
  }
}

int _block::can_move(int dir)
{
  int farthest_x[4];
  int i;
  int j;
  int z;
  switch(dir)
  {
    case LEFT:
      i = 0;
      while (i < 4)
      {
        farthest_x[i] = -1;
        j = 3;
        while (j >= 0)
        {
          if (set[j + (i * 4)] == 1)
          {
            farthest_x[i] = j;
          }
          j--;
        }
        i++;
      }
      z = -1;
      break;
    case RIGHT:
      i = 0;
      while (i < 4)
      {
        farthest_x[i] = -1;
        j = 0;
        while (j < 4)
        {
          if (set[j + (i * 4)] == 1)
          {
            farthest_x[i] = j;
          }
          j++;
        }
        i++;
      }
      z = 1;
      break;
  }
  i = 0;
  while (i < 4)
  {
    if (farthest_x[i] != -1)
    {
      j = x + farthest_x[i] + z;
      if ((j >= 0) && (j < 10))
      {
        if (grid[j + (y + i) * 10] == 1)
        {
          return 0;
        }
      }
      else
      {
        return 0;
      }
    }
    i++;
  }
  return 1;
}

void _block::init_set(int t)
{
  int i = 0;
  while (i < 16)
  {
    set[i] = 0;
    i++;
  }
  int x = 1;
  int y = 2;
  switch(t)
  {
    case SQUARE:
      set_on(x, y);
      set_on(x, y - 1);
      set_on(x + 1, y - 1);
      set_on(x + 1, y);
      break;
    case LSHAPE:
      set_on(x, y);
      set_on(x, y - 1);
      set_on(x, y + 1);
      set_on(x + 1, y + 1);
      break;
    case TRIPOINT:
      set_on(x, y);
      set_on(x - 1, y);
      set_on(x, y - 1);
      set_on(x + 1, y);
      break;
    case LINE:
      set_on(x, y);
      set_on(x, y - 1);
      set_on(x, y + 1);
      set_on(x, y - 2);
      break;
    case DIAG:
      set_on(x, y);
      set_on(x - 1, y);
      set_on(x - 1, y - 1);
      set_on(x, y + 1);
      break;
  }
}
