#ifndef _tetrisblock_h
#define _tetrisblock_h

const int SQUARE = 0;
const int LSHAPE = 1;
const int TRIPOINT = 2;
const int LINE = 3;
const int DIAG = 4;

typedef struct _block
{
  int x;
  int y;
  int downdelay;
  int countdown;
  int type;
  int rotation;
  int exists;
  void move(int dir);
  void draw();
  void erase();
  void attach();
  void rotate();
  int recreate();
  void init_set(int t);
  void fall();
  void set_on(int x, int y);
  int contact_made();
  int can_move(int dir);
  int set[16];
} _block;

#endif
