#ifndef _XMALLOC_H_
#define _XMALLOC_H_

void *xmalloc(unsigned int,char *,int);
void *xalloca(unsigned int,char *,int);
void *xcalloc(unsigned int nell, unsigned int size, char *file, int line);
void *xrealloc(void *,unsigned int,char *,int);
void xfree(void *,char *,int);

#ifdef DEBUG

#undef alloca

#define malloc(a)    xmalloc((a), __FILE__,__LINE__)
#define alloca(a)    xalloca((a), __FILE__,__LINE__)
#define calloc(a,b)  xcalloc((a),(b), __FILE__,__LINE__)
#define realloc(a,b) xrealloc((a),(b),__FILE__,__LINE__)
#define free(a)      xfree((a),   __FILE__,__LINE__)

#else /* !DEBUG */

#undef alloca
#define malloc(a)    malloc((a))
#define alloca(a)    alloca((a))
#define calloc(a,b)  calloc((a),(b))
#define realloc(a,b) realloc((a),(b))
#define free(a)      free((a))

#endif /* DEBUG */

#endif /* _XMALLOC_H_ */