#include <allegro.h>
#ifdef DJGPP
#include "xdbug.h"
#else
#define debug(a,b...)
#endif
#include "display.h"
#include "gui.h"

typedef struct SLOT {
   int id;
   int glow;
} SLOT;

typedef struct strings {
	int cursor_pos;
	int last;
	char text[52];
} strings;

strings cmd_string;

typedef struct GAMEINFO {
   int ballw,ballh;
   int mask_color;
   int col_depth;
   int board_w;
   int board_h;
   int board_x;
   int board_y;
   int screen_w;
   int screen_h;
   int display_w;
   int display_h;
   char *score_file;
   char *tile_dat;
   int b1r,b1g,b1b;
   int b2r,b2g,b2b;
   int b3r,b3g,b3b;
   int b4r,b4g,b4b;
   int score;
   int numball;
   int tho;
   int done;
   int pause;
   int scores;
   char name[55];
   int hiscores;
   int enter;
} GAMEINFO;

typedef struct HISCORE {
   char *name;
   unsigned int score;
} HISCORE;

HISCORE hiscores[11] = {{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1},{NULL,-1}};

GAMEINFO info;

SLOT **board=NULL;

BITMAP *ball1[4] = {NULL,NULL,NULL,NULL};
BITMAP *ball2[4] = {NULL,NULL,NULL,NULL};
BITMAP *ball3[4] = {NULL,NULL,NULL,NULL};
BITMAP *ball4[4] = {NULL,NULL,NULL,NULL};

int ballc[5] = {0,0,0,0,0};
volatile int glow=0;
volatile int gd=0;

int qsort_helper(const void *e1, const void *e2)
{
   return ((const HISCORE *)e2)->score - ((const HISCORE *)e1)->score;
}

int read_scores()
{
   int num=0;
   int i;
   char section[255];
   char **argv;
   char hs[][5] = {"hs1","hs2","hs3","hs4","hs5","hs6","hs7","hs8","hs9","hs10"};

   memset(section,0,255);
   sprintf(section,"%ix%i_scores",info.board_w,info.board_h);

   for(i=0; i!=10; i++) {
      argv = get_config_argv(section,hs[i],&num);
      if(num==2) {
         if(argv[0]) {
            hiscores[i].name = calloc(strlen(argv[0])+1,sizeof(char));
            if(!hiscores[i].name) return 0;
            strcpy(hiscores[i].name,argv[0]);
         }
         if(argv[1]) hiscores[i].score  = atoi(argv[1]);
      } else { hiscores[i].name = "nobody"; hiscores[i].score = (100*info.board_w)/(i+1); }
   }

   //qsort(hiscores, 10, sizeof(HISCORE), qsort_helper);
   return 1;
}

int write_scores()
{
   char txt[255];
   char section[255];
   char hs[][5] = {"hs1","hs2","hs3","hs4","hs5","hs6","hs7","hs8","hs9","hs10"};
   int i;
   qsort(hiscores, 10, sizeof(HISCORE), qsort_helper);

   memset(section,0,255);
   sprintf(section,"%ix%i_scores",info.board_w,info.board_h);

   for(i=0; i!=10; i++) {
      if(hiscores[i].name) {
         sprintf(txt,"%s %i",hiscores[i].name,hiscores[i].score);
         set_config_string(section,hs[i],txt);
      }
   }

   return 1;
}

void add_score(char *name, int score)
{
   if(!name) return;

   if(hiscores[10].name) free(hiscores[10].name);
   hiscores[10].name = malloc(sizeof(char)*strlen(name));
   if(!hiscores[10].name) return;
   strcpy(hiscores[10].name,name);
   hiscores[10].score = score;

   qsort(hiscores, 11, sizeof(HISCORE), qsort_helper);
}

int is_hiscore(int sc)
{
   return (sc>=hiscores[9].score) ? 1 : 0;
}

/* makes the balls glow */
void glow_timer()
{
   if(!info.tile_dat) {
      if(gd==0) glow++;
      if(gd==1) glow--;
      if(glow>=3) gd=1;
      if(glow<=0) gd=0;
   } else {
      if(glow>=3) glow=0;
      else glow++;
   }
} END_OF_FUNCTION(glow_timer);

int pausesec=0;
int pausemin=0;
int pausehour=0;
void pause_timer()
{
      if(pausesec<59) pausesec++;
      else {
         pausesec = 0;
         if(pausemin<59) pausemin++;
         else {
            pausemin = 0;
            pausehour++;
         }
      }
} END_OF_FUNCTION(pause_timer);

/* gets the game preferences */
int get_info()
{
   char **argv=NULL;
   int num;
   char *txt;

   argv = get_config_argv("config","board_size",&num);
   if(num==2) {
      info.board_w = atoi(argv[0]);
      info.board_h = atoi(argv[1]);
   }

   argv = get_config_argv("config","screen_res",&num);
   if(num==3) {
      info.screen_w  = atoi(argv[0]);
      info.screen_h  = atoi(argv[1]);
      info.col_depth = atoi(argv[2]);
   }

   argv = get_config_argv("config","ball1_color",&num);
   if(num==3) {
      info.b1r  = atoi(argv[0]);
      info.b1g  = atoi(argv[1]);
      info.b1b  = atoi(argv[2]);
   }

   argv = get_config_argv("config","ball2_color",&num);
   if(num==3) {
      info.b2r  = atoi(argv[0]);
      info.b2g  = atoi(argv[1]);
      info.b2b  = atoi(argv[2]);
   }

   argv = get_config_argv("config","ball3_color",&num);
   if(num==3) {
      info.b3r  = atoi(argv[0]);
      info.b3g  = atoi(argv[1]);
      info.b3b  = atoi(argv[2]);
   }

   argv = get_config_argv("config","ball4_color",&num);
   if(num==3) {
      info.b4r  = atoi(argv[0]);
      info.b4g  = atoi(argv[1]);
      info.b4b  = atoi(argv[2]);
   }

   return 1;
}

/* saves the game preferences */
void set_info()
{
   char txt[255];
   memset(txt,0,255);

   sprintf(txt,"%i %i",info.board_w,info.board_h);
   set_config_string("config","board_size",txt);
   memset(txt,0,255);

   sprintf(txt,"%i %i %i",info.screen_w,info.screen_h,info.col_depth);
   set_config_string("config","screen_res",txt);
   memset(txt,0,255);

   set_config_string("config","score_file",(info.score_file) ? info.score_file : NULL);
}

/* helper to create individual balls. (thx shawn! I'm lazy) */
BITMAP *make_ball(int w, int h, int br, int bg, int bb)
{
   BITMAP *bmp=NULL;
   int r, rx, ry;

   bmp = create_bitmap(w, h); 
   if(!bmp) { return NULL; }

   clear_to_color(bmp,makecol(255,0,255));

   for (r=0; r<16; r++) {
      rx = w*(15-r)/32;
      ry = h*(15-r)/32;
      ellipsefill(bmp, w/2, h/2, rx, ry, makecol(br*r/15, bg*r/15, bb*r/15));
   }

   return bmp;
}

/* creates the balls */
int make_default_balls()
{
   int i;

   for(i=0; i!=4; i++) {
      ball1[i] = make_ball(info.ballw,info.ballh,(info.b1r>100) ? info.b1r-(i*10) : info.b1r, (info.b1g>100) ? info.b1g-(i*10) : info.b1g, (info.b1b>100) ? info.b1b-(i*10) : info.b1b);
      if(!ball1[i]) return 0;

      ball2[i] = make_ball(info.ballw,info.ballh,(info.b2r>100) ? info.b2r-(i*10) : info.b2r, (info.b2g>100) ? info.b2g-(i*10) : info.b2g, (info.b2b>100) ? info.b2b-(i*10) : info.b2b);
      if(!ball2[i]) return 0;

      ball3[i] = make_ball(info.ballw,info.ballh,(info.b3r>100) ? info.b3r-(i*10) : info.b3r, (info.b3g>100) ? info.b3g-(i*10) : info.b3g, (info.b3b>100) ? info.b3b-(i*10) : info.b3b);
      if(!ball3[i]) return 0;

      ball4[i] = make_ball(info.ballw,info.ballh,(info.b4r>100) ? info.b4r-(i*10) : info.b4r, (info.b4g>100) ? info.b4g-(i*10) : info.b4g, (info.b4b>100) ? info.b4b-(i*10) : info.b4b);
      if(!ball4[i]) return 0;
   }

   return 1;
}

/* randomizes the balls */
int set_board()
{
   int i,j;
   srand(time(0));
   info.score = 0;
   info.numball = 0;

   if(!board) {
      board = calloc(info.board_w,sizeof(SLOT *));
      if(!board) return 0;

      for(i=0; i!=info.board_w+1; i++) {
         board[i] = calloc(info.board_h,sizeof(SLOT));
         if(!board[i]) return 0;
      }
   }

   for(i=0; i!=info.board_w; i++) {
      for(j=0; j!=info.board_h; j++) {
         board[i][j].id   = rand()%4+1;
         board[i][j].glow = 0;
      }
   }
   return 1;
}

void _check_l(int,int);
void _check_r(int,int);
void _check_u(int,int);
void _check_d(int,int);

/* checks for conected balls */
#define _check_lrud(x,y) do{ _check_l(x,y); _check_r(x,y); _check_u(x,y); _check_d(x,y); }while(0)

void _check_u(int mbx, int mby)
{
   if(mby-1<0 || mbx<0 || mbx>info.board_h) return;
   if(board[mbx][mby].id && !board[mbx][mby-1].glow && board[mbx][mby].id == board[mbx][mby-1].id) {
      board[mbx][mby-1].glow = 1;
      info.numball++;
      //_check_lrud(mbx,mby-1);
      _check_l(mbx,mby-1); _check_r(mbx,mby-1); _check_u(mbx,mby-1); _check_d(mbx,mby-1);
   }
}

void _check_d(int mbx, int mby)
{
   if(mby+1>info.board_h || mbx<0 || mbx>info.board_h) return;
   if(board[mbx][mby].id && !board[mbx][mby+1].glow && board[mbx][mby].id == board[mbx][mby+1].id) {
      board[mbx][mby+1].glow = 1;
      info.numball++;
      //_check_lrud(mbx,mby+1);
      _check_l(mbx,mby+1); _check_r(mbx,mby+1); _check_u(mbx,mby+1); _check_d(mbx,mby+1);
   }
}

void _check_l(int mbx, int mby)
{
   if(mbx-1<0 || mbx>info.board_w || mby<0 || mby>info.board_h) return;
   if(board[mbx][mby].id && !board[mbx-1][mby].glow && board[mbx][mby].id == board[mbx-1][mby].id) {
      board[mbx-1][mby].glow = 1;
      info.numball++;
      //_check_lrud(mbx-1,mby);
      _check_l(mbx-1,mby); _check_r(mbx-1,mby); _check_u(mbx-1,mby); _check_d(mbx-1,mby);
   }
}

void _check_r(int mbx, int mby)
{
   if(mbx+1>info.board_w || mby<0 || mby>info.board_h) return;
   if(board[mbx][mby].id && !board[mbx+1][mby].glow && board[mbx][mby].id == board[mbx+1][mby].id) {
      board[mbx+1][mby].glow = 1;
      info.numball++;
      //_check_lrud(mbx+1,mby);
      _check_l(mbx+1,mby); _check_r(mbx+1,mby); _check_u(mbx+1,mby); _check_d(mbx+1,mby);
   }
}

void check_board(int mbx, int mby)
{
   int i,j;
   info.numball=0;
   info.tho=1;
   info.done=1;

   for(i=0; i!=info.board_w; i++) {
      for(j=0; j!=info.board_h; j++) {
         if(i<info.board_w && j<info.board_h) board[i][j].glow = 0;
         if(i<info.board_w && j<info.board_h && board[i][j].id) info.tho = 0;

         if(i>0 && board[i][j].id && board[i][j].id == board[i-1][j].id) info.done=0;
         if(i+1<info.board_w && board[i][j].id && board[i][j].id == board[i+1][j].id) info.done=0;
         if(j>0 && board[i][j].id && board[i][j].id == board[i][j-1].id) info.done=0;
         if(j+1<info.board_h && board[i][j].id && board[i][j].id == board[i][j+1].id) info.done=0;
      }
   }

   if(info.tho) { info.score += 1000; return; }
   _check_l(mbx,mby); _check_r(mbx,mby); _check_u(mbx,mby); _check_d(mbx,mby);
   //_check_lrud(mbx,mby);
}

#define mapx(x) (x)
#define mapy(y) (info.board_h-1-(y))

/* removes all glowing/marked balls */

void compress_column (int x)
{
	int y, ym;
	
	for (y = info.board_h - 1; y >= 0; y--){
		if (!board [mapx(x)][mapy(y)].glow)
			continue;
		for (ym = y; ym < info.board_h - 1; ym++)
			board [mapx(x)][mapy(ym)] = board [mapx(x)][mapy(ym+1)];
		board [mapx(x)][mapy(ym)].id = 0;
		board [mapx(x)][mapy(ym)].glow   = 0;
	}
}

void compress_y ()
{
	int x;

	for (x = 0; x < info.board_w; x++)
		compress_column (x);
}

void copy_col (int dest, int src)
{
	int y;
	
	for (y = 0; y < info.board_h; y++)
		board [mapx(dest)][mapy(y)] = board [mapx(src)][mapy(y)];
}

void clean_last_col ()
{
	int y;

	for (y = 0; y < info.board_h; y++){
		board [mapx(info.board_w-1)][mapy(y)].id = 0;
		board [mapx(info.board_w-1)][mapy(y)].glow   = 0;
	}
}

void compress_x ()
{
	int x, xm, l;

	for (x = 0; x < info.board_w; x++){
		for (l = info.board_h; board [mapx(x)][mapy(0)].id == 0 && l; l--){
			for (xm = x; xm < info.board_w-1; xm++)
				copy_col (xm, xm+1);
			clean_last_col ();
		} 
	}
}

void fixup_board()
{
   debug("fixup_board: removing blanks.");
   if(info.numball > 2) info.score += (info.numball-2) * (info.numball-2);
   compress_y();
   compress_x();
}


int null_frame(gui_component_t *c, int msg, int ch)
{
   return GUI_FLAG_O_K;
}

int play_button(gui_component_t *c, int msg, int ch)
{
   if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;

   if(msg==GUI_MSG_LMUP) {
      info.pause = 1;
      gui_message_obj("pausebutton",GUI_MSG_LMUP,0);
      info.score = 0;
      if(!set_board()) return GUI_FLAG_EXIT;
   }

   return GUI_FLAG_O_K;
}

int pause_button(gui_component_t *c, int msg, int ch)
{
   if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;
   if(msg==GUI_MSG_LMUP) {
      if(info.pause) {
         info.pause = 0;
         hide_component("pauseframe");
         remove_int(pause_timer);
         pausemin = 0;
         pausesec = 0;
         pausehour = 0;
         gui_set_text("pausebutton","Pause");
      } else {
         info.pause = 1;
         gui_set_text("pausebutton","Continue");
         install_int_ex(pause_timer,BPS_TO_TIMER(1));
         show_component("pauseframe");
      }
   }
   return GUI_FLAG_O_K;
}

int exit_button(gui_component_t *c, int msg, int ch)
{
   if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;
   if(msg==GUI_MSG_LMDN) return GUI_FLAG_EXIT;
   if(msg==GUI_MSG_LMUP) return GUI_FLAG_EXIT;
   return GUI_FLAG_O_K;
}

int score_button(gui_component_t *c, int msg, int ch)
{
   if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;
   if(msg==GUI_MSG_LMUP) {
      if(!info.hiscores) {
          info.hiscores = 1;
          gui_set_text("scorebutton","Hide HiScores");
          show_component("scorewin");
      } else {
          info.hiscores = 0;
          hide_component("scorewin");
          gui_set_text("scorebutton","Show HiScores");
      }
   }
   return GUI_FLAG_O_K;
}


/* callback for gameboard. */
int draw_board(gui_component_t *c, int msg, int ch)
{
   int i=0,j=0,x=c->rect.x+4,y=c->rect.y+4;
   int mbx=cursor->x-c->rect.x,mby=cursor->y-c->rect.y;
   static int rmb=0,mx=0,my=0;
   static int x1,x2,x3,x1inc=4,x2inc=2,x3inc=2;
   static int y1,y2,y3,y1inc=2,y2inc=3,y3inc=4,set=0;

   if(!set) {
      set = 1;
      x1 = (c->rect.w/2)+x;
      y1 = (c->rect.h/2)+y;

      x2 = (c->rect.w/4)+x;
      y2 = (c->rect.h/4)+y;

      x3 = (c->rect.w/3)+x;
      y3 = (c->rect.h/3)+y;
   }

   switch(msg)
   {
      case GUI_MSG_START:
         if(!set_board()) return GUI_FLAG_EXIT;
         break;

      case GUI_MSG_DRAW:
         if(info.pause) {
           // rectfill(gui->buf,c->rect.x+5,c->rect.y+5,c->rect.x-5+c->rect.w,c->rect.y-5+c->rect.h,makecol(0,0,0));
            triangle(gui->buf, x1+30, y1+30, x2+30, y2+30, x3+30, y3+30, makecol(255,255,255));
            triangle(gui->buf, x2, y2, x1, y1, x3, y3, makecol(255,255,255));
            triangle(gui->buf, x1+15, y1+15, x2+15, y2+15, x3+15, y3+15, makecol(0,0,0));

            vline(gui->buf,c->rect.x+4,c->rect.y+4,c->rect.y+c->rect.h-4,makecol(150,150,150));
            hline(gui->buf,c->rect.x+4,c->rect.y+4,c->rect.x+c->rect.w-5,makecol(150,150,150));

            vline(gui->buf,c->rect.x+c->rect.w-4,c->rect.y+4,c->rect.y+c->rect.h-4,makecol(255,255,255));
            hline(gui->buf,c->rect.x+5,c->rect.y+c->rect.h-4,c->rect.x+c->rect.w-4,makecol(255,255,255));

            if(x1<=x) {
               x1inc = abs(x1inc);
            }

            if(x2<=x) {
               x2inc = abs(x2inc);
            }

            if(x3<=x) {
               x3inc = abs(x3inc);
            }

            if(y1<=y) {
               y1inc = abs(y1inc);
            }

            if(y2<=y) {
               y2inc = abs(y2inc);
            }

            if(y3<=y) {
               y3inc = abs(y3inc);
            }

            if(x1>=x+c->rect.w-8) {
               x1inc = -abs(x1inc);
            }

            if(x2>=x+c->rect.w-8) {
               x2inc = -abs(x2inc);
            }

            if(x3>=x+c->rect.w-8) {
               x3inc = -abs(x3inc);
            }

            if(y1>=y+c->rect.h-8) {
               y1inc = -abs(y1inc);
            }

            if(y2>=y+c->rect.h-8) {
               y2inc = -abs(y2inc);
            }

            if(y3>=y+c->rect.h-8) {
               y3inc = -abs(y3inc);
            }

            x1 += x1inc;
            y1 += y1inc;

            x2 += x2inc;
            y2 += y2inc;

            x3 += x3inc;
            y3 += y3inc;
         } else {
            rectfill(gui->buf,c->rect.x+5,c->rect.y+5,c->rect.x-5+c->rect.w,c->rect.y-5+c->rect.h,makecol(0,0,0));

            for(i=0; i!=info.board_w; i++) {
               for(j=0; j!=info.board_h; j++) {
                  if(board[i][j].id == 1 && ! board[i][j].glow) draw_sprite(gui->buf,ball1[0],i*info.ballw+x,j*info.ballh+y);
                  else if(board[i][j].id == 1 && board[i][j].glow) draw_sprite(gui->buf,ball1[glow],i*info.ballw+x,j*info.ballh+y);

                  if(board[i][j].id == 2 && !board[i][j].glow) draw_sprite(gui->buf,ball2[0],i*info.ballw+x,j*info.ballh+y);
                  else if(board[i][j].id == 2 && board[i][j].glow) draw_sprite(gui->buf,ball2[glow],i*info.ballw+x,j*info.ballh+y);

                  if(board[i][j].id == 3 && !board[i][j].glow) draw_sprite(gui->buf,ball3[0],i*info.ballw+x,j*info.ballh+y);
                  else if(board[i][j].id == 3 && board[i][j].glow) draw_sprite(gui->buf,ball3[glow],i*info.ballw+x,j*info.ballh+y);

                  if(board[i][j].id == 4 && !board[i][j].glow) draw_sprite(gui->buf,ball4[0],i*info.ballw+x,j*info.ballh+y);
                 else if(board[i][j].id == 4 && board[i][j].glow) draw_sprite(gui->buf,ball4[glow],i*info.ballw+x,j*info.ballh+y);
               }
            }

            vline(gui->buf,c->rect.x+4,c->rect.y+4,c->rect.y+c->rect.h-4,makecol(150,150,150));
            hline(gui->buf,c->rect.x+4,c->rect.y+4,c->rect.x+c->rect.w-5,makecol(150,150,150));

            vline(gui->buf,c->rect.x+c->rect.w-4,c->rect.y+4,c->rect.y+c->rect.h-4,makecol(255,255,255));
            hline(gui->buf,c->rect.x+5,c->rect.y+c->rect.h-4,c->rect.x+c->rect.w-4,makecol(255,255,255));

            if(rmb) textprintf(gui->buf,font,cursor->x+10,cursor->y+10,makecol(255,255,255),"pts. %i",(info.numball>2) ? (info.numball-2)*(info.numball-2) : 0);
            //mouse_ball(&mbx,&mby);
            //check_board(mbx,mby);
            break;
         }

      case GUI_MSG_LMDN:
        // set_cursor_color(ballc[board[mbx][mby].id]);
         fixup_board();
         // this needs to be put for the enter key too.
         break;

      case GUI_MSG_LMUP:
         if(c==gui->mouse_obj && mbx < info.board_w*info.ballw && mby < info.board_h*info.ballh) {
            mx = mbx/info.ballw;
            my = mby/info.ballh;
            check_board(mx,my);
         }

        // set_cursor_color(makecol(255,255,255));
         break;

      case GUI_MSG_RMDN:
         rmb = 1;
         break;

      case GUI_MSG_RMUP:
         rmb = 0;
         break;

      case GUI_MSG_MMDN:
         break;

      case GUI_MSG_MMUP:
         break;

      case GUI_MSG_MMOVE:
         if(c==gui->mouse_obj && mbx < info.board_w*info.ballw && mby < info.board_h*info.ballh) {
            mx = mbx/info.ballw;
            my = mby/info.ballh;
         }

         check_board(mx,my);
         break;

      case GUI_MSG_GOTMOUSE:
         if(c==gui->mouse_obj && mbx < info.board_w*info.ballw && mby < info.board_h*info.ballh) {
            mx = mbx/info.ballw;
            my = mby/info.ballh;
            check_board(mx,my);
         }
         break;

      case GUI_MSG_LOSTMOUSE:
         check_board(info.board_w+1,0);
         break;

      case GUI_MSG_GOTFOCUS:
         if(c==gui->mouse_obj && mbx < info.board_w*info.ballw && mby < info.board_h*info.ballh) {
            mx = mbx/info.ballw;
            my = mby/info.ballh;
            check_board(mx,my);
         }

         break;

      case GUI_MSG_LOSTFOCUS:
         check_board(info.board_w+1,0);
         break;

      case GUI_MSG_WANTFOCUS:
         return info.pause ? GUI_FLAG_O_K : GUI_FLAG_WANTFOCUS;
         break;

      case GUI_MSG_CHAR:
         break;

      default:
         break;
   }
   return GUI_FLAG_O_K;
}

int draw_pause(gui_component_t *c, int msg, int ch)
{
	static int mx=0,my=0;
	int i,color;
	int th=text_height(gui->font)+5;

	if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;

	if(msg==GUI_MSG_START){} 

	if(msg==GUI_MSG_DRAW)
	{
		color = makecol(255,255,255);

		textout_centre(gui->buf,gui->font,"Paused...",c->rect.x+c->rect.w/2,c->rect.y+th,color);
		textprintf_centre(gui->buf,gui->font,c->rect.x+c->rect.w/2,c->rect.y+th+20,color,"%02i:%02i:%02i",pausehour,pausemin,pausesec);
	}

	return GUI_FLAG_O_K;
}

int drawscorewin(gui_component_t *c, int msg, int ch)
{
   int w=0,h=0,i=0,x=0,y=0,tw=0;
   char txt[25];

   debug("scorewin: got msg %i",msg);

   if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;

   if(msg==GUI_MSG_DRAW) {

      for(i=0; i!=10; i++) {
         x = text_length(font,hiscores[i].name);
         if(x>tw) { y = i; tw = x; }
      }

      sprintf(txt,"%%2i. %%-%is %%-4i",strlen(hiscores[y].name));

      w = c->rect.w = tw+100;
      h = c->rect.h = 10*8+50;
      x = c->rect.x;// = gui->buf->w/2-w/2-DISPLAY_XPOS;
      y = c->rect.y;// = gui->buf->h/2-h/2-DISPLAY_YPOS;

      //roundrect(gui->buf,10,x,y,x+w,y+h,makecol(255,255,255));

      textout_centre(gui->buf, font, "High Scores", x+w-w/2, y+7, makecol(255,255,255));
      hline(gui->buf, x+2, y+7+text_height(font), x+w, makecol(200,200,200));

      for(i=0; i!=10; i++) {
         if(hiscores[i].score == info.score)
            textprintf_centre(gui->buf,font,x+w/2,y+(i*8+2)+35,makecol(255,255,255),txt,i+1,hiscores[i].name,hiscores[i].score);
         else textprintf_centre(gui->buf,font,x+w/2,y+(i*8+2)+35,makecol(100,100,100),txt,i+1,hiscores[i].name,hiscores[i].score);
      }
   }
   return GUI_FLAG_O_K;
}

int enter_frame(gui_component_t *c, int msg, int ch)
{
   int x,y,j;
   char b[255];

   if(msg==GUI_MSG_WANTFOCUS) return GUI_FLAG_WANTFOCUS;

   if(msg==GUI_MSG_DRAW) {
      x = c->rect.x;
      y = c->rect.y;

      c->rect.h = 50;
      c->rect.w = 300;

      textprintf_centre(gui->buf, font, x+300/2-2, y+7, makecol(255,255,255),"New High Score!!! %i",info.score);
      hline(gui->buf, x+3, y+7+text_height(font), x+300-2, makecol(200,200,200));

      rect(gui->buf, x+7, y+26, x+300-6, y+24+text_height(font)+4, makecol(100,100,100));

      textout(gui->buf, font, cmd_string.text, x+14, y+28, makecol(255,255,255));
      // if(glow==3) vline(gui->buf, x+8*cmd_string.cursor_pos+12, y+26, y+28+text_height(font), makecol(153,114,65));
      if(glow==3) {
         xor_mode(1);
         rectfill(gui->buf, x+8*cmd_string.cursor_pos+13, y+26, x+8*cmd_string.cursor_pos+20, y+28+text_height(font), makecol(255,255,255));
         xor_mode(0);
      }
   }

   if(msg==GUI_MSG_CHAR) {

      if((ch >> 8) == KEY_LEFT) {
         if(cmd_string.cursor_pos>0)
            cmd_string.cursor_pos--;
      }
      else if((ch >> 8) == KEY_RIGHT) {
         if(cmd_string.cursor_pos<35 && cmd_string.cursor_pos<cmd_string.last)
            cmd_string.cursor_pos++;
      }
      else if((ch >> 8) == KEY_HOME) {
         cmd_string.cursor_pos=0;
      }
      else if((ch >> 8) == KEY_END) {
         cmd_string.cursor_pos=35;
      }
      else if((ch >> 8) == KEY_DEL) {
         if(cmd_string.cursor_pos>-1) {
            uremove(cmd_string.text,cmd_string.cursor_pos);
            cmd_string.last--;
         }
      }
      else if((ch >> 8) == KEY_BACKSPACE) {
         if(cmd_string.cursor_pos>0) {
            cmd_string.cursor_pos--;
            uremove(cmd_string.text,cmd_string.cursor_pos);
            if(cmd_string.cursor_pos==-1) cmd_string.cursor_pos++;
            cmd_string.last--;
         }
      }
      else if((ch >> 8) == KEY_ENTER) {
         if(info.enter) {
            strcpy(b,cmd_string.text);
            add_score(b,info.score);
            hide_component("enterframe");
            if(!info.hiscores) gui_message_obj("scorebutton",GUI_MSG_LMUP,0);
            gui_message_obj("playbutton",GUI_MSG_LMUP,0);
            info.enter = 0;
            info.done = 0;
         }
      }
      else {
         ch &= 0xff;
         if(cmd_string.last<33) {
            if ((ch >= ' ') && (uisok(ch))) {
               memcpy(cmd_string.text+cmd_string.cursor_pos+1,cmd_string.text+cmd_string.cursor_pos,25);
               usetc(&cmd_string.text[cmd_string.cursor_pos], ch);
               cmd_string.cursor_pos++;
               cmd_string.last++;
            }
         }
      }
      return GUI_FLAG_USEDCHAR;
   }

   return GUI_FLAG_O_K;
}

int score_frame(gui_component_t *c, int msg, int ch)
{
   BITMAP *tmp = NULL;
   char score[7] = {0,0,0,0,0,0};
   int i,j,w,h;

   if(msg==GUI_MSG_DRAW) {
      itoa(info.score,score,10);

      w = text_length(font,score);
      h = text_height(font);

      tmp = create_bitmap(w,h);
      if(!tmp) return GUI_FLAG_EXIT;

      clear_to_color(tmp,makecol(175,175,175));

      for(i=0; score[i]; i++) {
         //textprintf(gui->buf,font,(i*8)+1+c->rect.x,1+c->rect.y,makecol(0,0,0),"%c",score[i]);
         textprintf(tmp,font,(i*8)+1,1,makecol(0,0,0),"%c",score[i]);
      }

      stretch_blit(tmp,gui->buf,0,0,tmp->w,tmp->h,c->rect.x+1,c->rect.y+1,w*2,h*2);

      c->rect.w = (w*2)+3;
      c->rect.h = (h*2)+3;
   }

   return GUI_FLAG_O_K;
}

int init()
{
   if(allegro_init()<0) { allegro_message("allegro_init() failed: %s",allegro_error); return 0; }
   if(install_timer()<0) { allegro_message("install_timer() failed: %s",allegro_error); return 0; }
   if(install_keyboard()<0) { allegro_message("install_keyboard() failed: %s",allegro_error); return 0; }
   if(install_display(DISPLAY_DBLBUF,0)==FALSE) { allegro_message("install_display() failed: %s",allegro_error); return 0; }

   if(!get_info()) { allegro_message("get_info() failed."); return 0; }
   if(!read_scores()) { allegro_message("read_scores() failed."); return 0; }

   //set_cursor_draw_func(my_mouse_draw);
   set_color_depth(info.col_depth);

   if(set_display_mode(GFX_AUTODETECT, info.screen_w, info.screen_h, info.screen_w, info.screen_h)==FALSE)
      { allegro_message("Error setting gfx mode! %s\n",allegro_error); return 0; }

   if(!gui_init(DISPLAY_BITMAP)) { allegro_message("couldn't init gui..."); return 0; }

   ballc[1] = makecol(info.b1r,info.b1g,info.b1b);
   ballc[2] = makecol(info.b2r,info.b2g,info.b2b);
   ballc[3] = makecol(info.b3r,info.b3g,info.b3b);
   ballc[4] = makecol(info.b4r,info.b4g,info.b4b);

   info.ballw = (info.screen_w-(info.screen_w/4)-1)/info.board_w;
   info.ballh = (info.screen_h-20)/info.board_h;

   //center_display();

   LOCK_VARIABLE(glow);
   LOCK_VARIABLE(gd);
   LOCK_FUNCTION(glow_timer);

   LOCK_VARIABLE(pausesec);
   LOCK_VARIABLE(pausemin);
   LOCK_VARIABLE(pausehour);
   LOCK_FUNCTION(pause_timer);

   install_int_ex(glow_timer,BPS_TO_TIMER(10));

   if(!make_default_balls()) { allegro_message("init: make_balls() failed."); return 0; }

   debug("board_w %i,board_h %i,screen_w %i,screen_h %i",info.board_w,info.board_h,info.screen_w,info.screen_h);

   if(create_component("frame","startframe",null_frame, 0, 1, info.screen_w/4, info.screen_h-2, 0,"null",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("button","playbutton",play_button, 10, 10, 100, 40, 0,"New",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("button","pausebutton",pause_button, 10, 38, 100, 40, 0,"Pause",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("button","scorebutton",score_button, 10, 66, 100, 40, 0,"Show HiScores",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("button","exitbutton",exit_button, 10, 94, 100, 40, 0,"Exit",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("frame", "pauseframe", draw_pause, info.screen_w/2-50, info.screen_h/2-25, 100, 50, GUI_FLAG_DRAGABLE|GUI_FLAG_HIDDEN," ",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("frame","scorewin",drawscorewin, info.screen_w/2-50, info.screen_h/2-25, 100, 40,GUI_FLAG_DRAGABLE|GUI_FLAG_HIDDEN,"Score",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("frame","enterframe",enter_frame, 100, 180, 100, 40,GUI_FLAG_DRAGABLE|GUI_FLAG_HIDDEN,"none",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("frame","scoreframe",score_frame, 10, info.screen_h-40, 100, 40,0,"none",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   if(create_component("frame", "gameboard", draw_board, info.screen_w/4+1, 1, info.screen_w-(info.screen_w/4)-1, info.screen_h-2,0," ",NULL)==0)
      { debug("main: create_component failed."); return 0; }

   show_display();
   clear(DISPLAY_BITMAP);

   return 1;
}

int main()
{
   int sh=0;
   if(!init()) return 0;

   if(!set_board()) return 0;
   while(!(gui_update()&GUI_FLAG_EXIT)) {
      if(!info.enter && info.done) {
         if(is_hiscore(info.score)) {
            info.enter = 1;
            show_component("enterframe");
         }
      }

      show_display();
      clear(DISPLAY_BITMAP);
   }

   write_scores();

   return 0;
}

END_OF_MAIN();

