#ifndef _KERN_H_
#define _KERN_H_

#include <stdio.h>
#include <allegro.h>
#define BETWEEN(var, left, right)  (((var) >= (left)) && ((var) <= (right)))

typedef struct rect_t {
	int x,y,w,h;
} rect_t;

typedef struct gui_component_t {
	char *id;
	char *class;
	rect_t rect;
	rect_t irect;
	rect_t drag;
	int dmx,dmy,dm;
	int flags;
	char *text;
	int (*draw)(struct gui_component_t *, int, int); // window,msg,char;
	void *data;
	struct gui_component_t *next;
	struct gui_component_t *prev;
} gui_component_t;

typedef struct gui_class_t {
	char *id;
	int (*draw)(gui_component_t *, int, int); // window,msg,char;
	gui_component_t *(*ci)(int,int,int,int,int,char *,void *); // create_instance();
	void (*di)(gui_component_t *); // destroy_instance();
	int  (*got_mouse)(gui_component_t *, int, int); // got_mouse(); it's actually a question. one way this might help is if theres a class that
                             // has some transparency and doesn't want the transparent part to count as part of the window.
	struct gui_class_t *next;
	struct gui_class_t *prev;
} gui_class_t;

typedef struct gui_t {
	rect_t          screen;
	gui_class_t     *class_list;          // list of all the component classes
	gui_component_t *obj_list;
	gui_component_t *focus_obj;             // curently selected gui component
	gui_component_t *mouse_obj;
	gui_component_t *desktop;
	FONT *font;
	BITMAP *buf;
	int fg_color,bg_color,d_color;
	int dtcolor;
	int focus_type;                       // focus type...
} gui_t;

#define GUI_FLAG_HIDDEN    1
#define GUI_FLAG_DISABLED  2
#define GUI_FLAG_GOTFOCUS  4
#define GUI_FLAG_GOTMOUSE  8
#define GUI_FLAG_DIRTY     16
#define GUI_FLAG_EXIT      32
#define GUI_FLAG_O_K       64
#define GUI_FLAG_WANTFOCUS 128
#define GUI_FLAG_USEDCHAR  256
#define GUI_FLAG_DRAGABLE  512
#define GUI_FLAG_LMDN      1024

#define GUI_MSG_START     1
#define GUI_MSG_END       2
#define GUI_MSG_CHAR      3
#define GUI_MSG_GOTFOCUS  4
#define GUI_MSG_LOSTFOCUS 5
#define GUI_MSG_GOTMOUSE  6
#define GUI_MSG_LOSTMOUSE 7
#define GUI_MSG_HIDE      8
#define GUI_MSG_SHOW      9
#define GUI_MSG_DISABLE   10
#define GUI_MSG_ENABLE    11
#define GUI_MSG_LMDN      12
#define GUI_MSG_LMUP      13
#define GUI_MSG_RMDN      14
#define GUI_MSG_RMUP      15
#define GUI_MSG_MMDN      16
#define GUI_MSG_MMUP      17
#define GUI_MSG_CLOSE     18
#define GUI_MSG_WANTFOCUS 19
#define GUI_MSG_DRAW      20
#define GUI_MSG_IDLE      21
#define GUI_MSG_MMOVE     22
#define GUI_MSG_USER      24

#define err(err,arr...) sprintf(gui_error, err, ## arr)

int gui_update(); // gui to update
int offer_focus(gui_component_t *);
int gui_init(BITMAP *);

int lock_top(char *);
	// no other component can be on over of a top locked one except annother top locked one.

int lock_bottom(char *);
	// no other component can be on under of a bottom locked one except annother bottom locked one.

int lock_screen(char *); 
	// no other component gets to draw it's self while a component is screen locked.
	// and a screen locked object has total control of the screen and can draw where ever it wants

int register_guiclass(char *, gui_component_t *(*)(), void (*)(gui_component_t *), int (*)(gui_component_t *, int, int), int (*)(gui_component_t *,int,int));
int reregister_guiclass(char *, gui_component_t *(*)(), void (*)(), int (*)(gui_component_t *, int, int), int (*)(gui_component_t *,int,int));
void unregister_guiclass(char *);
gui_class_t *get_gui_class(gui_component_t *);
void bring_to_front(gui_component_t *); // component to bring to front.
void send_to_back(gui_component_t *);   // component to send to back.

char *gui_get_text(char *);
int gui_set_text(char *, char *);
gui_component_t *remove_component(char *,gui_component_t *);
int gui_message(gui_component_t *, int, int);
int create_component(char *, char *, int (*)(gui_component_t *,int,int), int, int, int, int, int, char *, void *);
void destroy_component(char *);
int gui_broadcast_message(int, int);
void destroy_components();
gui_component_t *find_mouse_object(int, int);
gui_component_t *link_component(gui_component_t *, gui_component_t *);
gui_component_t *unlink_component(gui_component_t *, gui_component_t *);
gui_class_t *link_class(gui_class_t  *, gui_class_t  *);
gui_class_t *unlink_class(gui_class_t  *, gui_class_t  *);

void show_component(char *);
void hide_component(char *);
int offer_focus_obj(char *);

extern gui_t *gui;
char gui_error[255];

#define _hide(g)      if(g) { (g)->flags |= GUI_FLAG_HIDDEN; gui_message((g),GUI_MSG_HIDE,0); } else
#define _show(g)      if(g) { (g)->flags ^= GUI_FLAG_HIDDEN; gui_message((g),GUI_MSG_SHOW,0); } else
#define _disable(g)   if(g) { (g)->flags |= GUI_FLAG_DISABLED; gui_message((g),GUI_MSG_DISABLE,0); } else
#define _enable(g)    if(g) { (g)->flags ^= GUI_FLAG_DISABLED; gui_message((g),GUI_MSG_ENABLE,0); } else
#define _focus(g)     if(g) { (g)->flags |= GUI_FLAG_GOTFOCUS; gui_message((g),GUI_MSG_GOTFOCUS,0); } else
#define _unfocus(g)   if(g) { (g)->flags ^= GUI_FLAG_GOTFOCUS; gui_message((g),GUI_MSG_LOSTFOCUS,0); } else
#define _gotmouse(g)  if(g) { (g)->flags |= GUI_FLAG_GOTMOUSE; gui_message((g),GUI_MSG_GOTMOUSE,0); } else
#define _lostmouse(g) if(g) { (g)->flags ^= GUI_FLAG_GOTMOUSE; gui_message((g),GUI_MSG_LOSTMOUSE,0); } else
#define _dirty(g)     if(g) { (g)->flags |= GUI_FLAG_DIRTY; } else
#define _clean(g)     if(g) { (g)->flags ^= GUI_FLAG_DIRTY; } else

#endif