#ifndef _DISPLAY_H_
#define _DISPLAY_H_

typedef struct CURSOR { 
	int x,y,z,c,b,s; 
	BITMAP *spr; 
	void (*draw)(struct CURSOR *); 
} CURSOR; 


typedef struct DISPLAY_DRIVER {
   BITMAP *screen1;
   BITMAP *screen2;
   void (*display)();
   int (*resize)();
   int (*resize_virtual)();
   int (*scroll)();
   int (*pos)();
} DISPLAY_DRIVER;

typedef struct DISPLAY { 
   int d; // color depth 
   int w,h,vw,vh; // (virtual)size 
   int xscr; 
   int yscr; 
   int xpos,ypos; // where display is on physical screen 
   RGB *pal; // if aplicable (8bpp)
   int mode; // video_bitmap, normal, or sysbmp
   int scr;  // which screen bmp is set to if applicable
   BITMAP *bmp;
   DISPLAY_DRIVER *drv;
} DISPLAY; 

#define MAX_DRIVERS 4

extern DISPLAY *display; 
extern CURSOR  *cursor;

#define DISPLAY_DBLBUF     0
      // regular double buffer
#define DISPLAY_PAGEFLIP   1
      // double buffer with a twist. (or a show_video_bitmap(), which ever you prefer. :)
#define DISPLAY_SYSBMP     2
      // double buffer. uses a sys bmp instead of a regular allegro bmp. (same difference in most
      // situations.)

#define DISPLAY_DIRTYRECTS 3
      // totaly different animal than the other 3. only updates needed parts of the 'screen'
      // this has to be coded specially for. unlike the others.

// do optimized versions for the cursor to.

/* these can only be used once the install_display() function is called */ 
#define DISPLAY_W       display->w 
#define DISPLAY_H       display->h 
      // display width and height 
#define DISPLAY_VW      display->vw 
#define DISPLAY_VH      display->vh 
      // display (?:actual|virtual) width and height  
#define DISPLAY_XSCR    display->xscr 
#define DISPLAY_YSCR    display->yscr 
      // xscr and yscr is where an app thinks 0,0 is on the display 
#define DISPLAY_XPOS    display->xpos 
#define DISPLAY_YPOS    display->ypos 
      // xpos and ypos is where the display gets blitted to the actual screen. 
#define DISPLAY_DEPTH   display->d 
#define DISPLAY_BITMAP  display->bmp 
#define DISPLAY_PALETTE display->pal 
 
#define CURSOR_X cursor->x 
#define CURSOR_Y cursor->y 
#define CURSOR_SPRITE cursor->spr 
/* end */ 

int  install_display(int dmode, int mmode);
int  set_display_mode(int mode, int w, int h, int vw, int vh); 
void uninstall_display(); // called by the allegro 'atexit' func 
RGB *set_display_palette(RGB *); // returns old palette 
int  set_display_color_depth(int);   // returns old color depth 
void show_display(); // blits the 'DISPLAY' to the screen 
void center_display(); // centers the display onto the screen 
 
void display_scroll_to(int, int);  // will set xscr and yscr 
int  set_display_pos(int, int); // will set xpos and ypos if possible.
int  set_display_size(int, int, int, int); 
 
void position_cursor(int,int); // x,y 
void position_cursor_z(int); // z 
int  set_cursor_bitmap(BITMAP *); 
int  install_cursor(); 
void uninstall_cursor(); 
void set_cursor_color(int); 
void set_cursor_draw_func(void (*)(CURSOR *));  
void scare_cursor();
void unscare_cursor();

#endif
