/* BUG: fix the scroll code so it won't scroll down too far.
 */

#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <allegro.h>
#include "display.h"

#define DIF(a,b) ((a)-(b))

DISPLAY *display    = NULL; 
CURSOR  *cursor     = NULL;

BITMAP  *default_cursor_sprite = NULL;

#ifdef __MINGW32__
#define DEF_SCREEN_MODE GFX_GDI
#else
#define DEF_SCREEN_MODE GFX_AUTODETECT
#endif

#define DEFAULT_SPRITE_W 10
#define DEFAULT_SPRITE_H 16

static char curspr[DEFAULT_SPRITE_H][DEFAULT_SPRITE_W] =
{
   { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 },
   { 1, 2, 1, 0, 0, 0, 0, 0, 0, 0 },
   { 1, 2, 2, 1, 0, 0, 0, 0, 0, 0 },
   { 1, 2, 2, 2, 1, 0, 0, 0, 0, 0 },
   { 1, 2, 2, 2, 2, 1, 0, 0, 0, 0 },
   { 1, 2, 2, 2, 2, 2, 1, 0, 0, 0 },
   { 1, 2, 2, 2, 2, 2, 2, 1, 0, 0 },
   { 1, 2, 2, 2, 2, 2, 2, 2, 1, 0 },
   { 1, 2, 2, 2, 2, 2, 2, 2, 2, 1 },
   { 1, 2, 2, 2, 2, 2, 1, 1, 1, 0 },
   { 1, 2, 2, 1, 2, 2, 1, 0, 0, 0 },
   { 1, 2, 1, 0, 1, 2, 2, 1, 0, 0 },
   { 0, 1, 0, 0, 1, 2, 2, 1, 0, 0 },
   { 0, 0, 0, 0, 0, 1, 2, 2, 1, 0 },
   { 0, 0, 0, 0, 0, 1, 2, 2, 1, 0 },
   { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0 }
};

void cursor_callback(int);
void blit_cursor();

/* start display.c */

#define DDRV(type,d,name,parms) static type _drv_##d##_##name parms

/* double buffer functions */
DDRV(void,dblbuf,display,());
DDRV(int,dblbuf,resize,(int w, int h, int vw, int vh));
DDRV(int,dblbuf,scroll,(int x, int y));
DDRV(int,dblbuf,pos,(int x, int y));

/* page flip functions */
DDRV(void,pageflip,display,());
DDRV(int,pageflip,resize,(int w, int h, int vw, int vh));
DDRV(int,pageflip,scroll,(int x, int y));
DDRV(int,pageflip,pos,(int x, int y));

int scared_cursor=0;

void scare_cursor() { scared_cursor++; }
void unscare_cursor() { scared_cursor--; }

int set_display_mode(int mode, int w, int h, int vw, int vh)
{
	if(!w || !h) return FALSE;
	if(!vw) vw = w;
	if(!vh) vh = h;

   if(display->mode==DISPLAY_DBLBUF) {
      if(set_gfx_mode(mode, vw, vh, 0, 0)<0) return FALSE;
   	
      if(display->drv->screen1) free(display->drv->screen1);
      display->drv->screen1 = create_bitmap(vw,vh);
      if(!display->drv->screen1) return FALSE;

      display->drv->display = _drv_dblbuf_display;
      display->drv->resize  = _drv_dblbuf_resize;
      display->drv->scroll  = _drv_dblbuf_scroll;
      display->drv->pos = _drv_dblbuf_pos;
      
      display->w = w;
      display->h = h;
      display->vw = vw;
      display->vh = vh;
      display->scr = 1;
      display->bmp = display->drv->screen1;
      clear_to_color(display->drv->screen1,makecol(100,100,100)); // another good var to get from a cnf file!
   } else if(display->mode==DISPLAY_PAGEFLIP) {
   	if(set_gfx_mode(mode, w, h, vw, vh)<0) return FALSE;
   	
      display->w = w;
      display->h = h;
      display->vw = VIRTUAL_W;
      display->vh = VIRTUAL_H;

      display->drv->screen1 = create_video_bitmap(display->w,display->h);
      if(!display->drv->screen1) return FALSE;

      display->drv->screen2 = create_video_bitmap(display->w,display->h);
      if(!display->drv->screen2) return FALSE;

      display->drv->display = _drv_pageflip_display;
      display->drv->resize  = _drv_pageflip_resize;
      display->drv->scroll  = _drv_pageflip_scroll;
      display->drv->pos = _drv_pageflip_pos;
      
      display->bmp = display->drv->screen1;
      display->scr = 1;
      clear_to_color(display->drv->screen1,makecol(100,100,100));
      show_video_bitmap(display->drv->screen1);
      
   } else if(display->mode == DISPLAY_SYSBMP) {
      // not availible
      return FALSE;
   } else if(display->mode == DISPLAY_DIRTYRECTS) {
      // not available
      return FALSE;
   }

	display->d = 8;
	display->xscr = 0;
	display->yscr = 0;
	display->pal = default_palette;

	install_cursor();

	return TRUE;
}

int install_display(int dmode, int mmode)
{
   
	if(dmode>=MAX_DRIVERS) return FALSE;
   // if(mmode>=MAX_DRIVERS) return FALSE;

	display = calloc(1, sizeof(DISPLAY));
	if(!display) return FALSE;

   display->drv = calloc(1,sizeof(DISPLAY_DRIVER));
   if(!display->drv) return FALSE;

/*	display->d = defd;
	display->w = defw;
	display->h = defh;
	display->vw = defvw;
	display->vh = defvh;
	display->xscr = 0;
	display->yscr = 0;
	display->pal = default_palette;
	display->mode = dmode;

	set_display_mode(defmode, defw, defh, defvw, defvh);
*/
	install_cursor();

	return TRUE;
}

void uninstall_display()
{
  if(display) {
  	destroy_bitmap(DISPLAY_BITMAP);
  	free(display);
  }
  if(cursor) {
	uninstall_cursor();
  }
}

RGB *set_display_palette(RGB *pal)
{
	RGB *tmp = NULL;
	if(!pal) return NULL;
	tmp = display->pal;
	display->pal = pal;
	set_palette(pal);
	return (tmp) ? tmp : default_palette;
}

int set_display_color_depth(int cd)
{
	int tmp;
	if(!cd) return 0;
	tmp = display->d;
	display->d = cd;
	return tmp ? tmp : 8;
}

void show_display()
{
   display->drv->display();
}

void display_scroll_to(int x, int y)
{
   display->drv->scroll(x,y);
}

void display_set_pos(int x, int y)
{
   display->drv->pos(x,y);
}

void center_display()
{
	display->drv->pos(SCREEN_W/2-DISPLAY_W/2,SCREEN_H/2-DISPLAY_H/2);
}

int set_display_size(int w, int h, int vw, int vh)
{
   return display->drv->resize(w,h,vw,vh);
}


void position_cursor(int x, int y)
{
	position_mouse(x,y);
}

void position_cursor_z(int z)
{
	position_mouse_z(z);
}

void set_cursor_sprite(BITMAP *spr)
{
	if(spr) {
		CURSOR_SPRITE = spr;
	} else CURSOR_SPRITE = default_cursor_sprite;
}

void cursor_callback(int c)
{
	if(c & MOUSE_FLAG_MOVE || c & MOUSE_FLAG_MOVE_Z) {
		cursor->x = mouse_x;
		cursor->y = mouse_y;
		cursor->z = mouse_z;
	}
   if(c & MOUSE_FLAG_LEFT_DOWN || c & MOUSE_FLAG_LEFT_UP || c & MOUSE_FLAG_RIGHT_DOWN || c & MOUSE_FLAG_RIGHT_UP ||
		c & MOUSE_FLAG_MIDDLE_DOWN || c & MOUSE_FLAG_MIDDLE_UP) {
		cursor->b = mouse_b;
	}
}
END_OF_FUNCTION(cursor_callback);

void cursor_callack_end(void) {};
int _mk_default_cursor();

int  install_cursor()
{
	if(cursor) return TRUE;
	install_mouse();
	install_timer();
	cursor = calloc(1,sizeof(CURSOR));
	if(!cursor) return FALSE;

	LOCK_FUNCTION(cursor_callback);
	LOCK_VARIABLE(cursor);

	_mk_default_cursor();
	cursor->spr = default_cursor_sprite;
	mouse_callback = cursor_callback;
        cursor->draw = blit_cursor;
        cursor->s = 2;
   
	return TRUE;
}

void uninstall_cursor()
{
        if(!cursor) return;
	mouse_callback = NULL;
	destroy_bitmap(cursor->spr);
	free(cursor);
        cursor=NULL;
}

void set_cursor_color(int c)
{
	if(cursor->draw == blit_cursor || !cursor->draw) floodfill(cursor->spr,3,3,c);
	else cursor->c = c;
}

void set_cursor_draw_func(void (*v)(CURSOR *))
{
	cursor->draw = v;
}

void blit_cursor()
{
	draw_sprite(DISPLAY_BITMAP,cursor->spr,cursor->x,cursor->y);
}


int _mk_default_cursor()
{
      int x,y,col;

      default_cursor_sprite = create_bitmap(DEFAULT_SPRITE_W, DEFAULT_SPRITE_H);
      if(!default_cursor_sprite) return FALSE;

      for (y=0; y<DEFAULT_SPRITE_H; y++) {
	 for (x=0; x<DEFAULT_SPRITE_W; x++) {
	    if (bitmap_color_depth(default_cursor_sprite) == 8) {
	       switch (curspr[y][x]) {
		  case 2:  col = 16;  break;
		  case 1:  col = 255; break;
		  default: col = 0;   break;
	       }
	    }
	    else {
	       switch (curspr[y][x]) {
		  case 1:  col = makecol(255, 255, 255); break;
		  case 2:  col = makecol(0, 0, 0);       break;
		  default: col = makecol(255,0,255);     break;
	       }
	    } 
	    putpixel(default_cursor_sprite, x, y, col);
	 }
       }

      set_mouse_range(0,0,DISPLAY_W-320,DISPLAY_H-320);
      position_mouse(0,0);
      set_mouse_speed(3,3);
      return TRUE;
}

static void _drv_dblbuf_display()
{
	if(!scared_cursor) cursor->draw(cursor);
	blit(DISPLAY_BITMAP,screen,DISPLAY_XSCR,DISPLAY_YSCR,DISPLAY_XPOS,DISPLAY_YPOS,DISPLAY_W,DISPLAY_H);
}

static int _drv_dblbuf_resize(int w, int h, int vw, int vh)
{
	BITMAP *tmp;
	if(!w) w = DISPLAY_W;
	if(!h) h = DISPLAY_H;
	if(!vw) vw = DISPLAY_VW;
	if(!vh) vh = DISPLAY_VH;

	if(vw != DISPLAY_VW || vh != DISPLAY_VH) {
		tmp = create_bitmap(vw,vh);
		if(!tmp) return FALSE;
		destroy_bitmap(DISPLAY_BITMAP);
		DISPLAY_BITMAP = tmp;
	}

	DISPLAY_W = w;
	DISPLAY_H = h;
	DISPLAY_VW = vw;
	DISPLAY_VH = vh;

	return TRUE;	
}

static int _drv_dblbuf_scroll(int x, int y)
{
	int xdif=DIF(DISPLAY_VW,abs(x)); // should I abs() here? It makes sence to me.
	int ydif=DIF(DISPLAY_VH,abs(y));

	if(xdif<DIF(DISPLAY_VW,DISPLAY_W))
		x -= DIF(DISPLAY_W,xdif);

	if(ydif<DIF(DISPLAY_VH,DISPLAY_H))
		y -= DIF(DISPLAY_H,ydif);

	DISPLAY_XSCR = x;
	DISPLAY_YSCR = y;

	if(DISPLAY_W-1+DISPLAY_XSCR<DISPLAY_VW || DISPLAY_H-1+DISPLAY_YSCR<DISPLAY_VH)
		set_mouse_range(DISPLAY_XSCR,DISPLAY_YSCR,DISPLAY_W-1+DISPLAY_XSCR,DISPLAY_H-1+DISPLAY_YSCR);
        return TRUE;
}

static int _drv_dblbuf_pos(int x, int y)
{
	DISPLAY_XPOS = x;
	DISPLAY_YPOS = y;
        return TRUE;
}

static void _drv_pageflip_display()
{
   vsync();
   if(!scared_cursor) cursor->draw(cursor);
   if(display->scr==1) {
      show_video_bitmap(display->drv->screen1);
      display->bmp = display->drv->screen2;
      display->scr=2;
   } else {
      show_video_bitmap(display->drv->screen2);
      display->bmp = display->drv->screen1;
      display->scr=1;
   }
}

static int _drv_pageflip_resize(int w, int h, int vw, int vh) { return FALSE; }
static int _drv_pageflip_scroll(int x, int y) { return FALSE; }
static int _drv_pageflip_pos(int x, int y) { return FALSE; }

#ifdef STANDALONE

void blend_blit(BITMAP *src, BITMAP *dest, int x, int y)
{
	BITMAP *tmp = create_bitmap(src->w,src->h);
	register int j;
	register int i;
	register int r2,g2,b2,r,g,b,c;
	register int a1,a2;
	if(!src || !dest || !tmp) return;

	for(i=0; i!=src->h; i++) {
		for(j=0; j!=src->w; j++) {
			a1 = getpixel(dest,j+x,i+y);
			r = getr(a1);
			g = getg(a1);
			b = getb(a1);

			a2 = getpixel(src,j,i);
			r2 = getr(a2);
			g2 = getg(a2);
			b2 = getb(a2);
			
			/*if(a1!=0)*/ c = a2^a1; // makecol((r2^r),(g2^g),(b2^b));
			//else c = a2;
			if(a2!=makecol(255,0,255)) putpixel(dest,j+x,i+y,c);

		}
	}
}

void my_mouse_draw()
{
   blend_blit(cursor->spr,DISPLAY_BITMAP,cursor->x,cursor->y);
}

#include <stdlib.h>
#include <time.h>

int main()
{
   BITMAP *lin=NULL;
	static int x=0,y=0;
	int i=0,j=125,palswitch=0;
	srand(time(0));
	allegro_init();
	install_keyboard();
	set_color_depth(32);

	install_display(DISPLAY_DBLBUF,0);
	set_display_mode(GFX_GDI,800,600,0,0);
	
	set_cursor_draw_func(my_mouse_draw);
	center_display();
   j=0;

   text_mode(-1);
	while(!key[KEY_ESC]) {
	   clear_to_color(DISPLAY_BITMAP,makecol(100,100,100));

		if(cursor->b & 1) {  set_cursor_color(makecol(255,0,0)); }
		else if(cursor->b & 2) set_cursor_color(makecol(0,255,0));
		else if(cursor->b & 4) { set_cursor_color(makecol(0,0,255)); }
		else set_cursor_color(makecol(0,0,0));

      for(i=50; i!=150; i++) {
         ellipse(DISPLAY_BITMAP,100+i/2,100+i,50-j,50,makecol(i,i,i));
      }

      j++;
		textprintf(DISPLAY_BITMAP,font,5,5,makecol(255,255,255),"mouse x = %i",cursor->x);
		textprintf(DISPLAY_BITMAP,font,5,15,makecol(255,255,255),"mouse y = %i",cursor->y);
		textprintf(DISPLAY_BITMAP,font,5,25,makecol(255,255,255),"mouse z = %i",cursor->z);
		textprintf(DISPLAY_BITMAP,font,5,35,makecol(255,255,255),"mouse lb = %s",cursor->b&1? "yes" : "no");
		textprintf(DISPLAY_BITMAP,font,5,45,makecol(255,255,255),"mouse rb = %s",cursor->b&2? "yes" : "no");
		textprintf(DISPLAY_BITMAP,font,5,55,makecol(255,255,255),"mouse mb = %s",cursor->b&4? "yes" : "no"); 
		show_display();
	}
}
END_OF_MAIN();
#endif
