
/*
 * CPlayer.cpp
 *
 * Implimentation of CPlayer class.
 *
 */

#include <fstream>
#include <allegro.h>
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CPlayer.h"
#include "CItem.h"



/*****************************************************************************

		Update()

	virtual update function, update AI, movement, etc

*****************************************************************************/

bool CPlayer::Update()
{
	// count down damage timer
	if(m_iDamageTimer > 0)
		m_iDamageTimer--;
	else
	{
		m_bDrawDamaged = false;
		m_bIsHit = false;
	}

	// run base class update function
	CBaseObject::Update();

	return true;
}





/*****************************************************************************

		Reset()

	virtual reset function, reset all variables to default values

*****************************************************************************/

void CPlayer::Reset()
{
	// run base class reset function
	CBaseObject::Reset();	

	m_iHealth = 0;
	m_iLives = 0;
	m_iDamageTimer = 0;
	m_iCoins = 0;
	m_iPoints = 0;


	// set the correct animation data
	m_Animations[ANIM_STAND].FirstFrame = 0;
	m_Animations[ANIM_STAND].LastFrame = 0;//17
	m_Animations[ANIM_STAND].FrameDelay = 5;
	m_Animations[ANIM_STAND].Loop = true;
	m_Animations[ANIM_MOVE].FirstFrame = 18;
	m_Animations[ANIM_MOVE].LastFrame = 25;
	m_Animations[ANIM_MOVE].FrameDelay = 3;
	m_Animations[ANIM_MOVE].Loop = true;
	m_Animations[ANIM_JUMP].FirstFrame = 26;
	m_Animations[ANIM_JUMP].LastFrame = 26;
	m_Animations[ANIM_JUMP].FrameDelay = 5;
	m_Animations[ANIM_JUMP].Loop = true;
	m_Animations[ANIM_FALL].FirstFrame = 27;
	m_Animations[ANIM_FALL].LastFrame = 27;
	m_Animations[ANIM_FALL].FrameDelay = 5;
	m_Animations[ANIM_FALL].Loop = true;
	m_Animations[ANIM_DAMAGE].FirstFrame = 28;
	m_Animations[ANIM_DAMAGE].LastFrame = 28;
	m_Animations[ANIM_DAMAGE].FrameDelay = 5;
	m_Animations[ANIM_DAMAGE].Loop = true;

	// set object to 'player' type
	SetType(TYPE_PLAYER);

}





/*****************************************************************************

		TakeDamage()

	make player take damage

*****************************************************************************/

void CPlayer::TakeDamage(int Type)
{
	switch(Type)
	{
		case DAMAGE_LEVEL:
			{
				if(m_iDamageTimer <= 0)
				{
					m_iHealth--;
					m_iDamageTimer = 90;
					m_bDrawDamaged = true;
				}

			} break;

		case DAMAGE_OBJECT:
			{
				if(m_iDamageTimer <= 0)
				{
					m_iHealth--;
					m_iDamageTimer = 90;
					m_bDrawDamaged = true;
				}
				

			} break;

		default: break;
	}

	if(m_iHealth <= 0)
	{
		SetActive(false);
		m_iLives--;

		if(m_iLives < 0)
		{
			
		}
	}

}





/*****************************************************************************

		GiveItem()

	give item to player

*****************************************************************************/

void CPlayer::GiveItem(int Type)
{
	switch(Type)
	{
		case ITEM_HEALTH:
			{
				if(m_iHealth < MAX_HEALTH)
				{
					m_iHealth++;
					m_iPoints += 400;
				}
				else
					m_iPoints += 1000;
			} break;

		case ITEM_LIFE:
			{
				if(m_iLives <= MAX_LIVES)
				{
					m_iLives++;
					m_iPoints += 1000;
				}
				else
					m_iPoints += 5000;

			} break;

		case ITEM_COIN:
			{
				m_iCoins++;
				m_iPoints += 100;

			/*	if(m_iCoins >= MAX_COINS)
				{
					m_iCoins = 0;

					if(m_iLives <= MAX_LIVES)
						m_iLives++;
					else
						m_iPoints += 3000;
				}*/

			} break;

		default: break;

	}
}