#include <allegro.h>
#include "AllegEx.h"

#define PI		3.1415927		// value of PI, needed for SINE tables

float SineTable[360];			// the sine lookup table





/******************************************************************************

		KeyPress()

	setup the table of sine values for quicker calculations

******************************************************************************/

bool KeyPress(unsigned char Key)
{
   static bool keyHitArray[256];
   
   if (keyHitArray[Key]&&!key[Key])
      keyHitArray[Key] = false;
   if (!keyHitArray[Key]&&key[Key])
   {
      keyHitArray[Key] = true;
      return true;
   }
   return false;
}





/******************************************************************************

		MouseClick()

	check for a single mouse click

******************************************************************************/

bool MouseClick(int Button)
{
	static bool ButtonClickArray[2] = { 0, 0 };
   
   if (ButtonClickArray[Button-1]&&!mouse_b&Button)
      ButtonClickArray[Button-1] = false;
   if (!ButtonClickArray[Button-1]&&mouse_b&Button)
   {
      ButtonClickArray[Button-1] = true;
      return true;
   }

   return false;
}





/******************************************************************************

		init_sine_table()

	setup the table of sine values for quicker calculations

******************************************************************************/

void init_sine_table()
{
	for(int i = 0; i < 360; i++)
	{
		SineTable[i] = sin(i*PI/180); // setup the table
	}
}





/******************************************************************************

		blit_sine_wave()

	draw *src to *dest with a sine wave distortion, requires that the sine table has
	been set up with init_sine_table();

******************************************************************************/

inline void blit_sine_wave(BITMAP *Dest, BITMAP *Src,int PosX, int PosY, float Speed,int Length)
{
	int y;

	for(y = 0; y < Src->h; y++)
	{
		blit(Src, Dest, 0, y, (SineTable[(int)Speed%360]*Length)+PosX, y+PosY, Src->w, 1);
		Speed += 5.0f;
	}
}





/***************************************************************************

		draw_status_bar()

	Draw a status bar around x1,y1,x2,y2. "max" is the maximum 
	value for the stat bar, "value" is the current value (which is 
	greater than 0 and less than or equal to "max").

***************************************************************************/

inline void draw_status_bar(BITMAP *buffer, float value, float max,
				   float x1, float y1, float x2, float y2, int color)
{
	float x;
	float length=(float)x2-(float)x1;
	x=(value*length)/max;
	rect(buffer,x1,y1,x2,y2,color);
	rectfill(buffer,(int)(x1),(int)(y1+3),(int)(x1+x),(int)(y2-3),color);
}





/***************************************************************************

		draw_status_bar_gradient()

	Draw a status bar similar to above, but draw a gradient between the two
	colours given.

	(Taken from allegro.cc from some random person on there)

***************************************************************************/

inline void draw_status_bar_gradient(BITMAP *dest, int x, int y, int w, int h, int h2, int col1, int col2)
{
    int r1, r2, g1, g2, b1, b2, i, col3;
    float r_grad, b_grad, g_grad;
    r1 = getr(col1);
    r2 = getr(col2);
    g1 = getg(col1);
    g2 = getg(col2);
    b1 = getb(col1);
    b2 = getb(col2);
    r_grad = ((r1 - r2) / (float)h2);
    b_grad = ((b1 - b2) / (float)h2);
    g_grad = ((g1 - g2) / (float)h2);
    for(i = 0; i < h; i++){
        col3 = makecol(r1 - (i * r_grad), g1 - (i * g_grad), b1 - (i * b_grad));
        hline(dest, x, y - i, w, col3);
    }    
}





/******************************************************************************

		highcolour_fade_in()

	fades in a highcolour bitmap (similar to 8bpp fade_in() using palettes)
	note this is a blantant rip of mathews original code from allegro.cc 

******************************************************************************/

inline void highcolour_fade_in(BITMAP *bmp_orig, int speed)
{
    BITMAP *bmp_buff;

    if ((bmp_buff = create_bitmap(SCREEN_W, SCREEN_H)))
    {
        int a;
        if (speed <= 0) speed = 16;
        
        for (a = 0; a < 256; a+=speed)
        {
            clear(bmp_buff);
            set_trans_blender(0,0,0,a);
            draw_trans_sprite(bmp_buff, bmp_orig, 0, 0);
            vsync();
            blit(bmp_buff, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
        }
        destroy_bitmap(bmp_buff);
   }

    blit(bmp_orig, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
}





/******************************************************************************

		highcolour_fade_out()

	as above, except this fades out the screen
	note this is a blantant rip of mathew's original code from allegro.cc 

******************************************************************************/

inline void highcolour_fade_out(int speed)
{
    BITMAP *bmp_orig, *bmp_buff;

    if ((bmp_orig = create_bitmap(SCREEN_W, SCREEN_H)))
    {
        if ((bmp_buff = create_bitmap(SCREEN_W, SCREEN_H)))
        {
            int a;
            blit(screen, bmp_orig, 0,0, 0,0, SCREEN_W, SCREEN_H);
            if (speed <= 0) speed = 16;
        
            for (a = 255-speed; a > 0; a-=speed)
            {
                clear(bmp_buff);
                set_trans_blender(0,0,0,a);
                draw_trans_sprite(bmp_buff, bmp_orig, 0, 0);
                vsync();
                blit(bmp_buff, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
            }
            destroy_bitmap(bmp_buff);
        }
        destroy_bitmap(bmp_orig);
    }

    rectfill(screen, 0,0, SCREEN_W,SCREEN_H, makecol(0,0,0));
}

