
/*
 *	Game.cpp
 *
 *	Main game loop.  All new code should start
 *	from here and call functions in other files.
 *
 */

#include <fstream>
#include <allegro.h>
#include "AllegEx.h"
#include "Collision.h"
#include "GGame.h"
#include "GEdit.h"
#include "Main.h"
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CEnemy.h"
#include "CItem.h"
#include "Game.h"

int g_iGameState = GAME_STATE_GAME;		// variable holding current game state
int g_iPrevGameState = -1;				// variable holding previous game state

bool g_bShowFPS = false;				// bool deciding whether to show FPS

CEnemy Enemys[MAX_ENEMYS];
CItem Items[MAX_ITEMS];
DATAFILE *StickDudeGFX = NULL;
DATAFILE *RedDude = NULL;
DATAFILE *GreenDude = NULL;
DATAFILE *YellowDude = NULL;
DATAFILE *GreyDude = NULL;
DATAFILE *Item = NULL;
DATAFILE *Music = NULL;
CTilemap Map;





/********************************************************************************

		InitGame()

	initialise the game for play

********************************************************************************/

bool InitGame()
{
	// load stick dude graphics
	StickDudeGFX = load_datafile("data//player//dude.dat");
	if(!StickDudeGFX)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//player//dude.dat'! ***\n");
		return false;
	}

	RedDude = load_datafile("data//enemys//reddude.dat");
	if(!RedDude)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//enemys//reddude.dat'! ***\n");
		return false;
	}
	
	GreenDude = load_datafile("data//enemys//greendude.dat");
	if(!GreenDude)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//enemys//greendude.dat'! ***\n");
		return false;
	}

	YellowDude = load_datafile("data//enemys//yellowdude.dat");
	if(!YellowDude)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//enemys//Yellowdude.dat'! ***\n");
		return false;
	}

	GreyDude = load_datafile("data//enemys//greydude.dat");
	if(!GreyDude)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//enemys//greydude.dat'! ***\n");
		return false;
	}


	Item = load_datafile("data//items//items.dat");
	if(!Item)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//items//items.dat'! ***\n");
		return false;
	}


	Music = load_datafile("data//sfx//music.dat");
	if(!Music)
	{
		WriteLog("*** ERROR : Couldn't open file 'data//sfx//music.dat'! ***\n");
		return false;
	}

	// clear the enemys array
	for(int i = 0; i < MAX_ENEMYS; i++)
		Enemys[i].SetActive(false);

	// clear items array
	for(i = 0; i < MAX_ITEMS; i++)
		Items[i].SetActive(false);

	return true;
}





/********************************************************************************

		ShutdownGame()

	unload anything loaded in InitGame()

********************************************************************************/

bool ShutdownGame()
{
	if(!Map.UnloadTileset())
		return false;
	if(!Map.Unload())
		return false;
	unload_datafile(StickDudeGFX);
	StickDudeGFX = NULL;
	unload_datafile(RedDude);
	RedDude = NULL;
	unload_datafile(GreenDude);
	GreenDude = NULL;
	unload_datafile(YellowDude);
	YellowDude = NULL;
	unload_datafile(GreyDude);
	GreyDude = NULL;
	unload_datafile(Item);
	Item = NULL;
	unload_datafile(Music);
	Music = NULL;

	return true;
}





/********************************************************************************

		GameGraphicsLoop()

	main graphic drawing loop for playing game

********************************************************************************/

inline bool GameGraphicsLoop()
{	
	// act depending on what current state is
	switch(g_iGameState)
	{

		case GAME_STATE_GAME:
			{
				// do the main graphics loop, check for errors
				if(!DoGameGraphics(g_Buffer))
				{
					WriteLog("*** ERROR : Error in DoGameGraphics()!  Exiting... ***\n");
					return false;
				}

				if(g_bShowFPS)
					DrawFPS(g_Buffer);									// draw FPS counter to screen
				blit(g_Buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);	// draw backbuffer to screen
				clear_bitmap(g_Buffer);									// and clear backbuffer for next loop


			} break;

		case GAME_STATE_EDIT:
			{
				// do the main graphics loop, check for errors
				if(!DoEditGraphics(g_Buffer))
				{
					WriteLog("*** ERROR : Error in DoEditGraphics()!  Exiting... ***\n");
					return false;
				}

				if(g_bShowFPS)
					DrawFPS(g_Buffer);									// draw FPS counter to screen
				blit(g_Buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);	// draw backbuffer to screen
				clear_bitmap(g_Buffer);									// and clear backbuffer for next loop

			} break;

		default: break;

	};

	return true;
}





/********************************************************************************

		GameLogicLoop()

	main logic loop for playing game

********************************************************************************/

inline bool GameLogicLoop()
{
	// pressing this will instantly close game no matter where it is
	if(key[KEY_ESC])
		g_iGameState = GAME_STATE_QUIT;

	// pressing this key will toggle the FPS meter on or off
	static int F1Pressed;
	if(key[KEY_F1])
	{
		if(F1Pressed == false)
		{
			F1Pressed = true;
			if(g_bShowFPS == false)
				g_bShowFPS = true;
			else
				g_bShowFPS = false;
		}
	}
	else
	{
		if(F1Pressed = true)
		{
			F1Pressed = false;
		}
	}

	// this will take a screenshot of what is currently showing on screen
//	if(key[KEY_F12])
	//	TakeScreenshot();

	if(KeyPress(KEY_F5))
		g_iGameState = GAME_STATE_GAME;
	else if(KeyPress(KEY_F6))
		g_iGameState = GAME_STATE_EDIT;

	// act depending on what current state is
	switch(g_iGameState)
	{

		case GAME_STATE_GAME:
			{
				// if the last loop wasn't this state, we need to load the new data
				if(g_iPrevGameState != GAME_STATE_GAME)
				{
					if(g_iPrevGameState == GAME_STATE_EDIT)
						DoEditShutdown();

					if(!DoGameInit())
					{
						WriteLog("*** ERROR : Error in DoGameInit()!  Exiting... ***\n");
						return false;
					}
				}

				// do main logic loop
				if(!DoGameLogic())
				{
					WriteLog("*** ERROR : Error in DoGameLogic()!  Exiting... ***\n");
					return false;
				}

				// make sure we dont reload everything in the next loop
				g_iPrevGameState = GAME_STATE_GAME;

			} break;

		case GAME_STATE_EDIT:
			{
				// if the last loop wasn't this state, we need to load the new data
				if(g_iPrevGameState != GAME_STATE_EDIT)
				{
					if(g_iPrevGameState == GAME_STATE_GAME)
						DoGameShutdown();

					if(!DoEditInit())
					{
						WriteLog("*** ERROR : Error in DoEditInit()!  Exiting... ***\n");
						return false;
					}
				}

				// do main logic loop
				if(!DoEditLogic())
				{
					WriteLog("*** ERROR : Error in DoEditLogic()!  Exiting... ***\n");
					return false;
				}

				// make sure we dont reload everything in the next loop
				g_iPrevGameState = GAME_STATE_EDIT;

			} break;

		case GAME_STATE_QUIT:
			{
				// shutdown the game, close all states
				if(g_iPrevGameState == GAME_STATE_EDIT)
					DoEditShutdown();
				else if(g_iPrevGameState == GAME_STATE_GAME)
					DoGameShutdown();

				g_iPrevGameState = -1;

				// set the quit state
				QuitGame = true;

			} break;

		default: break;

	};

	return true;
}





/********************************************************************************

		AddEnemy()

  add enemy of given type to the game world

********************************************************************************/

bool AddEnemy(float fPosX, float fPosY, int iType, bool bDir)
{
	for(int i = 0; i < MAX_ENEMYS; i++)
	{
		if(!Enemys[i].GetActive())
		{
			Enemys[i].Reset();
			Enemys[i].SetActive(true);
			Enemys[i].SetPos(fPosX, fPosY);
			Enemys[i].SetMap(Map);
			Enemys[i].SetDirX(bDir);
			Enemys[i].SetMoveRight(bDir);
			Enemys[i].SetAnim(ANIM_STAND);
			Enemys[i].SetEnemyType(iType);
			
			switch(iType)
			{
				case ENEMY_RUNNER_SLOW:
					{
						Enemys[i].SetAccel(ENEMY_RUNNER_SLOW_ACCELX, ENEMY_RUNNER_SLOW_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_RUNNER_SLOW_MAXVELX, ENEMY_RUNNER_SLOW_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(RedDude);
						Enemys[i].SetAiType(AI_RUNNER);

					} break; 

				case ENEMY_RUNNER_MEDIUM:
					{
						Enemys[i].SetAccel(ENEMY_RUNNER_MEDIUM_ACCELX, ENEMY_RUNNER_MEDIUM_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_RUNNER_MEDIUM_MAXVELX, ENEMY_RUNNER_MEDIUM_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(RedDude);
						Enemys[i].SetAiType(AI_RUNNER);

					} break;

				case ENEMY_RUNNER_FAST:
					{
						Enemys[i].SetAccel(ENEMY_RUNNER_FAST_ACCELX, ENEMY_RUNNER_FAST_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_RUNNER_FAST_MAXVELX, ENEMY_RUNNER_FAST_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(RedDude);
						Enemys[i].SetAiType(AI_RUNNER);

					} break;

				case ENEMY_JUMPER_LOW:
					{
						Enemys[i].SetAccel(ENEMY_JUMPER_LOW_ACCELX, ENEMY_JUMPER_LOW_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_JUMPER_LOW_MAXVELX, ENEMY_JUMPER_LOW_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreenDude);
						Enemys[i].SetAiType(AI_JUMPER);

					} break;

				case ENEMY_JUMPER_MEDIUM:
					{
						Enemys[i].SetAccel(ENEMY_JUMPER_MEDIUM_ACCELX, ENEMY_JUMPER_MEDIUM_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_JUMPER_MEDIUM_MAXVELX, ENEMY_JUMPER_MEDIUM_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreenDude);
						Enemys[i].SetAiType(AI_JUMPER);

					} break;

				case ENEMY_JUMPER_HIGH:
					{
						Enemys[i].SetAccel(ENEMY_JUMPER_HIGH_ACCELX, ENEMY_JUMPER_HIGH_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_JUMPER_HIGH_MAXVELX, ENEMY_JUMPER_HIGH_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreenDude);
						Enemys[i].SetAiType(AI_JUMPER);

					} break;

				case ENEMY_JUMPER_CRAZY:
					{
						Enemys[i].SetAccel(ENEMY_JUMPER_CRAZY_ACCELX, ENEMY_JUMPER_CRAZY_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_JUMPER_CRAZY_MAXVELX, ENEMY_JUMPER_CRAZY_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreenDude);
						Enemys[i].SetAiType(AI_JUMPER);

					} break;
					
				case ENEMY_RUNJUMPER_SLOW:
					{
						Enemys[i].SetAccel(ENEMY_RUNJUMPER_SLOW_ACCELX, ENEMY_RUNJUMPER_SLOW_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_RUNJUMPER_SLOW_MAXVELX, ENEMY_RUNJUMPER_SLOW_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(YellowDude);
						Enemys[i].SetAiType(AI_RUNJUMPER);

					} break;

				case ENEMY_RUNJUMPER_MEDIUM:
					{
						Enemys[i].SetAccel(ENEMY_RUNJUMPER_MEDIUM_ACCELX, ENEMY_RUNJUMPER_MEDIUM_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_RUNJUMPER_MEDIUM_MAXVELX, ENEMY_RUNJUMPER_MEDIUM_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(YellowDude);
						Enemys[i].SetAiType(AI_RUNJUMPER);

					} break;

				case ENEMY_RUNJUMPER_FAST:
					{
						Enemys[i].SetAccel(ENEMY_RUNJUMPER_FAST_ACCELX, ENEMY_RUNJUMPER_FAST_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_RUNJUMPER_FAST_MAXVELX, ENEMY_RUNJUMPER_FAST_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(YellowDude);
						Enemys[i].SetAiType(AI_RUNJUMPER);

					} break;

				case ENEMY_FLIER_SLOW:
					{
						Enemys[i].SetAccel(ENEMY_FLIER_SLOW_ACCELX, ENEMY_FLIER_SLOW_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_FLIER_SLOW_MAXVELX, ENEMY_FLIER_SLOW_MAXVELY);
						Enemys[i].SetGravity(0);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(RedDude);
						Enemys[i].SetAiType(AI_FLIER);

					} break;
					
				case ENEMY_FLIER_MEDIUM:
					{
						Enemys[i].SetAccel(ENEMY_FLIER_MEDIUM_ACCELX, ENEMY_FLIER_MEDIUM_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_FLIER_MEDIUM_MAXVELX, ENEMY_FLIER_MEDIUM_MAXVELY);
						Enemys[i].SetGravity(0);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(RedDude);
						Enemys[i].SetAiType(AI_FLIER);

					} break;
					
				case ENEMY_FLIER_FAST:
					{
						Enemys[i].SetAccel(ENEMY_FLIER_FAST_ACCELX, ENEMY_FLIER_FAST_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_FLIER_FAST_MAXVELX, ENEMY_FLIER_FAST_MAXVELY);
						Enemys[i].SetGravity(0);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(RedDude);
						Enemys[i].SetAiType(AI_FLIER);

					} break;

				case ENEMY_SMARTRUNNER_SLOW:
					{
						Enemys[i].SetAccel(ENEMY_SMARTRUNNER_SLOW_ACCELX, ENEMY_SMARTRUNNER_SLOW_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_SMARTRUNNER_SLOW_MAXVELX, ENEMY_SMARTRUNNER_SLOW_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreyDude);
						Enemys[i].SetAiType(AI_SMARTRUNNER);

					} break; 

				case ENEMY_SMARTRUNNER_MEDIUM:
					{
						Enemys[i].SetAccel(ENEMY_SMARTRUNNER_MEDIUM_ACCELX, ENEMY_SMARTRUNNER_MEDIUM_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_SMARTRUNNER_MEDIUM_MAXVELX, ENEMY_SMARTRUNNER_MEDIUM_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreyDude);
						Enemys[i].SetAiType(AI_SMARTRUNNER);

					} break;

				case ENEMY_SMARTRUNNER_FAST:
					{
						Enemys[i].SetAccel(ENEMY_SMARTRUNNER_FAST_ACCELX, ENEMY_SMARTRUNNER_FAST_ACCELY);
						Enemys[i].SetMaxVel(ENEMY_SMARTRUNNER_FAST_MAXVELX, ENEMY_SMARTRUNNER_FAST_MAXVELY);
						Enemys[i].SetGravity(0.5);
						Enemys[i].SetOffset(7,1);
						Enemys[i].SetSize(15,30);
						Enemys[i].SetDatafile(GreyDude);
						Enemys[i].SetAiType(AI_SMARTRUNNER);

					} break;





				default: 
					{
						return false; 
					} break;
			}

			break;
		}
	}

	return true;
}





/********************************************************************************

		RemoveEnemy()

  remove enemy from the game world

********************************************************************************/

bool RemoveEnemy(int i)
{
	if((i >= 0) && (i < MAX_ENEMYS-1))
		Enemys[i].SetActive(false);
	else
		return false;

	return true;
}





/********************************************************************************

		AddItem()

  add item of given type to the game world

********************************************************************************/

bool AddItem(float fPosX, float fPosY, int iType)
{
	for(int i = 0; i < MAX_ITEMS; i++)
	{
		if(!Items[i].GetActive())
		{
			Items[i].Reset();
			Items[i].SetActive(true);
			Items[i].SetPos(fPosX, fPosY);
			Items[i].SetMap(Map);
			Items[i].SetAnim(ANIM_STAND);
			Items[i].SetItemType(iType);
			Items[i].SetAccel(0, 0);
			Items[i].SetMaxVel(0, 0);
			
			switch(iType)
			{
				case ITEM_HEALTH:
					{
						Items[i].SetSize(31,31);
						Items[i].SetDatafile(Item);
						Items[i].SetImageFrame(0);

					} break; 

				case ITEM_LIFE:
					{
						Items[i].SetSize(31,31);
						Items[i].SetDatafile(Item);
						Items[i].SetImageFrame(1);


					} break; 

				case ITEM_COIN:
					{
						Items[i].SetSize(31,31);
						Items[i].SetDatafile(Item);
						Items[i].SetImageFrame(2+rand()%9);

					} break; 

				default: break;
			}

			break;
		}
	}

	return true;
}





/********************************************************************************

		RemoveItem()

  remove Item from the game world

********************************************************************************/

bool RemoveItem(int i)
{
	if((i >= 0) && (i < MAX_ITEMS-1))
		Items[i].SetActive(false);
	else
		return false;

	return true;
}


