
/*
 *	GGame.cpp
 *
 *	This file contains the code for the main drawing and
 *	logic loops for the actual gameplay.
 *
 */

#include <fstream>
#include <string>
#include <allegro.h>
#include "AllegEx.h"
#include "Collision.h"
#include "Main.h"
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CPlayer.h"
#include "CEnemy.h"
#include "CItem.h"
#include "Game.h"
#include "Menus.h"
#include "GGame.h"
#include "df_interface.h"

DATAFILE *Interface = NULL;
FONT *ScoreFont = NULL;
#define LAST_LEVEL		8
bool g_bWinLevel = false;
int iCurrentLevel = 0;
CPlayer Player;
char Temp[256];

std::string LevelFilenames[8] =  {  "data//levels//level001.map",
									"data//levels//level002.map", 
									"data//levels//level003.map", 
									"data//levels//level004.map", 
									"data//levels//level005.map", 
									"data//levels//level006.map", 
									"data//levels//level007.map", 
									"data//levels//level008.map" };




/********************************************************************************

		DoGameInit()

	load data needed for actual gameplay.

********************************************************************************/

bool DoGameInit()
{
	g_bWinLevel = false;

	Player.Reset();
	Player.SetAccel(5,12);
	Player.SetActive(true);
	Player.SetGravity(0.5);
	Player.SetMaxVel(5,16);
	Player.SetPos(0,0);	
	Player.SetVel(0,0);
	Player.SetMap(Map);
	Player.SetOffset(7,1);
	Player.SetSize(15,30);
	Player.SetDatafile(StickDudeGFX);
	Player.SetHealth(MAX_HEALTH);
	Player.SetLives(START_LIVES);

	// clear all items and enemys
	for(int i = 0; i < MAX_ENEMYS; i++)
		Enemys[i].Reset();

	for(i = 0; i < MAX_ITEMS; i++)
		Items[i].Reset();

	iCurrentLevel = 0;
	Map.New(3, 100, 100);
	Map.ClearTo(0);
	Map.LoadTileset("data//levels//tiles.dat");
	Map.Load((char*)LevelFilenames[iCurrentLevel].c_str());
	play_midi((MIDI*)Music[iCurrentLevel].dat,1);
	Map.DrawMapData(false);
	Player.SetPos(Map.GetPlayerStartX(), Map.GetPlayerStartY()); // set start pos
	Map.SetHasHitRespawn(false);

	Interface = load_datafile("data//misc//interface.dat");
	if(!Interface)
	{
		WriteLog("*** ERROR : Couldn't load 'data/interface.dat'! ***\n");
		return false;
	}
	ScoreFont = (FONT*)Interface[SCOREFONT].dat;

	// draw first frame and fade in
	clear_bitmap(g_Buffer);
	DoGameGraphics(g_Buffer);
	highcolour_fade_in(g_Buffer, 32);

	return true;
}





/********************************************************************************

		DoGameGraphics()

	Main graphics loop for actual gameplay.

********************************************************************************/

bool DoGameGraphics(BITMAP *Bitmap)
{
	if(QuitGame)
		return true;

	// draw background
//	for(int i = 0; i < SCREEN_H; i+=3)
//		rectfill(Bitmap, 0, i, SCREEN_W, (i+2), makecol(0,(255-(i/2))/1.5,(255-(i/2))/1));
	blit((BITMAP*)Interface[BACKGROUND].dat,Bitmap,0,0,0,0,SCREEN_W,SCREEN_H);

	Map.Draw(Bitmap);
	Player.Draw(Bitmap);

	for(int i = 0; i < MAX_ITEMS; i++)
		Items[i].Draw(Bitmap);

	for(i = 0; i < MAX_ENEMYS; i++)
		Enemys[i].Draw(Bitmap);

	// draw current health
	for(i = 0; i < Player.GetHealth(); i++)
		draw_sprite(Bitmap,(BITMAP*)Interface[HEALTHPOINT].dat,0+i*32+18,10);

	// draw current lives
	draw_sprite(Bitmap, (BITMAP*)Interface[LIVESLEFT].dat, 
		SCREEN_W-(((BITMAP*)Interface[LIVESLEFT].dat)->w)-30, 10);
	sprintf(Temp, "%d", Player.GetLives());
	textout(Bitmap, ScoreFont, Temp, SCREEN_W-27+1, 12+1, makecol(128,128,128));
	textout(Bitmap, ScoreFont, Temp, SCREEN_W-27, 12, makecol(255,255,255));

	// draw score
	draw_sprite(Bitmap, (BITMAP*)Interface[SCORE].dat, 10, SCREEN_H-(((BITMAP*)Interface[SCORE].dat)->h)-8);
	sprintf(Temp, "%d", Player.GetPoints());
	textout(Bitmap, ScoreFont, Temp, 
		((BITMAP*)Interface[SCORE].dat)->w+10+10+1, 
		SCREEN_H-(((BITMAP*)Interface[SCORE].dat)->h)-10-3+1, makecol(128,128,128));
	textout(Bitmap, ScoreFont, Temp, 
		((BITMAP*)Interface[SCORE].dat)->w+10+10, 
		SCREEN_H-(((BITMAP*)Interface[SCORE].dat)->h)-10-3, makecol(255,255,255));

	return true;
}





/********************************************************************************

		DoGameLogic()

	Main logic loop for actual gameplay.

********************************************************************************/

bool DoGameLogic()
{
	if(QuitGame)
		return true;

	if(key[KEY_LEFT])
		Player.MoveLeft();
	else if(key[KEY_RIGHT])
		Player.MoveRight();
	if(key[KEY_SPACE])
	{
		if(!Player.HasJumped())
				play_sample((SAMPLE*)Interface[SFX_JUMP].dat,255,128,950+rand()%100,0);
		Player.Jump();
	}


	Player.Update();

	for(int i = 0; i < MAX_ENEMYS; i++)
	{
		// make sure any enemys that can be seen are activated
		if(!Enemys[i].GetSeen())
		{
			if(RectRectCol(Enemys[i].GetPosX(), 
				Enemys[i].GetPosY(), 
				Enemys[i].GetPosX() + Enemys[i].GetWidth(), 
				Enemys[i].GetPosY() + Enemys[i].GetHeight(),
				Map.Viewport.GetScrollX(), 
				Map.Viewport.GetScrollY(), 
				Map.Viewport.GetScrollX() + SCREEN_W, 
				Map.Viewport.GetScrollY() + SCREEN_H))
			{
				Enemys[i].SetSeen(true);
			}
		}


		if(Player.CheckObjectCollision(&Enemys[i]))
		{
			if(!Player.IsHit())
				play_sample((SAMPLE*)Interface[SFX_HIT].dat,255,128,900+rand()%200,0);
			Player.SetIsHit(true);
		}
		Enemys[i].Update();
	}

	// check collision for level respawn
	if(!Map.GetHasHitRespawn())
	{
		if(RectRectCol(Player.GetPosX(), Player.GetPosY(), 
			Player.GetPosX() + Player.GetWidth(),
			Player.GetPosY() + Player.GetHeight(),
			Map.GetRespawnPosX(), Map.GetRespawnPosY(),
			Map.GetRespawnPosX() + TILE_SIZE,
			Map.GetRespawnPosY() + TILE_SIZE))
		{
			Map.SetHasHitRespawn(true);
			play_sample((SAMPLE*)Interface[SFX_GETRESPAWN].dat,255,128,900+rand()%200,0);
		}
	}

	for(i = 0; i < MAX_ITEMS; i++)
	{	
		if(Items[i].GetActive())
		{
			if(Player.CheckObjectCollision(&Items[i]))
			{

				Player.GiveItem(Items[i].GetItemType());
				Items[i].SetActive(false);
				if(Items[i].GetItemType() == ITEM_HEALTH)
					play_sample((SAMPLE*)Interface[SFX_GETHEALTH].dat,255,128,900+rand()%200,0);
				else if(Items[i].GetItemType() == ITEM_LIFE)
					play_sample((SAMPLE*)Interface[SFX_GETLIFE].dat,255,128,900+rand()%200,0);
				else if(Items[i].GetItemType() == ITEM_COIN)
					play_sample((SAMPLE*)Interface[SFX_GETCOIN].dat,255,128,900+rand()%200,0);

			}
			
			Items[i].Update();
		}
	}
	

	if(Player.GetPosX() - Map.Viewport.GetScrollX() > 350)
		Map.Scroll(RIGHT, Player.GetAccelX());
	else if(Player.GetPosX() - Map.Viewport.GetScrollX() < 250)
		Map.Scroll(LEFT, Player.GetAccelX());
	
	if(Player.GetPosY() - Map.Viewport.GetScrollY() > 360)
		Map.Scroll(DOWN, Player.GetVelY());
	else if(Player.GetPosY() - Map.Viewport.GetScrollY() < 150)
		Map.Scroll(UP, -Player.GetVelY());

	// check if player has touched level end tile
	if(g_bWinLevel)
	{
		iCurrentLevel++;
		if(iCurrentLevel >= LAST_LEVEL)
		{
			DoGameWinScreen();
			// each life player finishes with gives an xtra XXXX points
			for(int k = 0; k <= Player.GetLives(); k++)
				Player.GivePoints(8000);
			DoHighScoreScreen(Player.GetPoints(), iCurrentLevel+1);
			Map.SetHasHitRespawn(false);
			QuitGame = true;
			iCurrentLevel = 0;
		}
		else
		{
			play_sample((SAMPLE*)Interface[SFX_WINLEVEL].dat,255,128,900+rand()%200,0);
			rest(800);
			highcolour_fade_out(14);	// fade out screen
			DoLevelWinScreen();
			for(int i = 0; i < MAX_ENEMYS; i++)
				Enemys[i].Reset();

			for(i = 0; i < MAX_ITEMS; i++)
				Items[i].Reset();
			if(!Map.Load((char*)LevelFilenames[iCurrentLevel].c_str()))
			{
				WriteLog("*** ERROR : Couldn't load level %d! ***\n", iCurrentLevel);
				return false;
			}
			play_midi((MIDI*)Music[iCurrentLevel].dat,1);
			Player.SetPos(Map.GetPlayerStartX(), Map.GetPlayerStartY());
			Map.SetHasHitRespawn(false);
			g_bWinLevel = false;
		}		
	}

	// if player is out of lives, do gameover screen
	if(Player.GetLives() < 0)
	{
		play_sample((SAMPLE*)Interface[SFX_HIT].dat,255,128,900+rand()%200,0);
		highcolour_fade_out(14);	// fade out screen

		DoHighScoreScreen(Player.GetPoints(), iCurrentLevel+1);

		// reset player
		Player.SetHealth(MAX_HEALTH);
		Player.SetLives(START_LIVES);
		Player.SetAnim(ANIM_STAND);
		Player.SetHealth(MAX_HEALTH);
		Player.SetDamageTimer(0);
		Player.SetIsHit(false);
		Map.SetHasHitRespawn(false);

		for(int i = 0; i < MAX_ENEMYS; i++)
			Enemys[i].Reset();
		for(i = 0; i < MAX_ITEMS; i++)
			Items[i].Reset();

		if(DoGameOverScreen())
		{
			// reload game
			//Map.Unload();
			Map.New(3, 100, 100);
			Map.ClearTo(0);
			//Map.LoadTileset("data//levels//tiles.dat");
			if(iCurrentLevel > 0)
				iCurrentLevel--;
			Map.Load((char*)LevelFilenames[iCurrentLevel].c_str());
			play_midi((MIDI*)Music[iCurrentLevel].dat,1);
			Player.SetPos(Map.GetPlayerStartX(), Map.GetPlayerStartY()); // move back to start
			Player.SetActive(true);		// activate player
			Map.Viewport.SetScroll(Map.GetPlayerStartX()-(SCREEN_W/2),Map.GetPlayerStartY()-(SCREEN_H/2)-100);
			Map.SetHasHitRespawn(false);

			// draw first frame and fade in
			clear_bitmap(g_Buffer);
			DoGameGraphics(g_Buffer);
			highcolour_fade_in(g_Buffer, 32);
		}
		else
		{
			// reload game
			//Map.Unload();
			Map.New(3, 100, 100);
			Map.ClearTo(0);
			//Map.LoadTileset("data//levels//tiles.dat");
			iCurrentLevel = 0;
			Map.Load((char*)LevelFilenames[iCurrentLevel].c_str());
			Player.SetActive(true);		// activate player
			Player.SetPos(Map.GetPlayerStartX(), Map.GetPlayerStartY()); // move back to start
			Map.Viewport.SetScroll(Map.GetPlayerStartX()-(SCREEN_W/2),Map.GetPlayerStartY()-(SCREEN_H/2)-100);
			Map.SetHasHitRespawn(false);

			// player wants to quit
			QuitGame = true;
			return true;
		}
	}
	else
	{
		// if player dies and has lives left, fade out and restart level
		if(!Player.GetActive())
		{
			// play sound
			rest(1500);					// wait 1.5 seconds
			highcolour_fade_out(14);	// fade out screen

			// reset game objects
			for(int i = 0; i < MAX_ENEMYS; i++)
				Enemys[i].Reset();
			for(i = 0; i < MAX_ITEMS; i++)
				Items[i].Reset();

			// reload game
			g_bWinLevel = false;

			Player.SetActive(true);
			Player.SetGravity(0.5);
			Player.SetMaxVel(5,16);
			Player.SetVel(0,0);
			Player.SetAnim(ANIM_STAND);
			Player.SetHealth(MAX_HEALTH);
			Player.SetDamageTimer(0);

			Map.New(3, 100, 100);
			Map.ClearTo(0);
			Map.LoadTileset("data//levels//tiles.dat");
			Map.Load((char*)LevelFilenames[iCurrentLevel].c_str());
			Map.DrawMapData(false);

			if(Map.GetHasHitRespawn())
			{
				Player.SetPos(Map.GetRespawnPosX(), Map.GetRespawnPosY()); // move back to start			
				Map.Viewport.SetScroll(Map.GetRespawnPosX()-(SCREEN_W/2),Map.GetRespawnPosY()-(SCREEN_H/2)-100);
			}
			else
			{
				Player.SetPos(Map.GetPlayerStartX(), Map.GetPlayerStartY()); // move back to start			
				Map.Viewport.SetScroll(Map.GetPlayerStartX()-(SCREEN_W/2),Map.GetPlayerStartY()-(SCREEN_H/2)-100);
			}


			//Map.Unload();
		/*	Map.New(3, 100, 100);
			Map.ClearTo(0);
			//Map.LoadTileset("data//levels//tiles.dat");
			Map.Load("data//levels//level004.map");	// reload level	
			Player.SetPos(Map.GetPlayerStartX(), Map.GetPlayerStartY()); // move back to start
			Player.SetActive(true);		// activate player
			Player.SetHealth(MAX_HEALTH);		// reset health the maximum
			Player.SetAnim(ANIM_STAND);
			Map.Viewport.SetScroll(Map.GetPlayerStartX()-(SCREEN_W/2),Map.GetPlayerStartY()-(SCREEN_H/2)-100);
*/
			// draw first frame and fade in
			clear_bitmap(g_Buffer);
			DoGameGraphics(g_Buffer);
			highcolour_fade_in(g_Buffer, 30);
			Player.SetHealth(MAX_HEALTH);

		}
	}

	return true;
}





/********************************************************************************

		DoGameShutdown()

	Unload anything loaded in DoGameInit()

********************************************************************************/

bool DoGameShutdown()
{	
	unload_datafile(Interface);
	stop_midi();

	return true;
}







