
/*
 *	GGame.cpp
 *
 *	This file contains the code for the main drawing and
 *	logic loops for the actual gameplay.
 *
 */

#include <fstream>
#include <string>
#include <allegro.h>
#include "AllegEx.h"
#include "Collision.h"
#include "Main.h"
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CPlayer.h"
#include "CEnemy.h"
#include "CItem.h"
#include "Game.h"

int iCurrentLayer = 1;
int iCurrentTile = 1;
int iCurrentTileType = 1;
int iCurrentEnemy = 0;
int iCurrentItem = 0;
bool bCurrentDir = true;

#define AI_RUNNER			0
#define AI_JUMPER			1
#define AI_RUNJUMPER		2
#define AI_FLIER			3
#define AI_SMARTRUNNER		4

char EnemyNames[16][16] = { "run slow", 
							"run med", 
							"run fast", 
							"jump low",
							"jump med",
							"jump high",
						    "jump crazy",
						    "runjump slow",
						    "runjump med",
						    "runjump fast",
						    "flier slow",
						    "flier med",
						    "flier fast",
						    "smartrun slow",
						    "smartrun med",
						    "smartrun fast" };

char ItemNames[3][11] =	 { "health",
							"extra life",
							"coin"			};




/********************************************************************************

		DoEditInit()

	load data needed for actual gameplay.

********************************************************************************/

bool DoEditInit()
{
	Map.New(3, 100, 100);
	Map.ClearTo(0);
	Map.LoadTileset("data//levels//tiles.dat");
	Map.DrawMapData(true);

	for(int i = 0; i < MAX_ENEMYS; i++)
		Enemys[i].Reset();

	for(i = 0; i < MAX_ITEMS; i++)
		Items[i].Reset();

	return true;
}





/********************************************************************************

		DoEditGraphics()

	Main graphics loop for actual gameplay.

********************************************************************************/

bool DoEditGraphics(BITMAP *Bitmap)
{
	// hide mouse for drawing
	show_mouse(NULL);

	clear_to_color(Bitmap, makecol(0,32,196));

	Map.Draw(Bitmap);

	char Temp[255];

	for(int i = 0; i < MAX_ENEMYS; i++)
	{
		if(Enemys[i].GetActive())
		{
			Enemys[i].Draw(Bitmap);

			sprintf(Temp, "%d", Enemys[i].GetEnemyType());
			textout(Bitmap, font, Temp, 
				Enemys[i].GetPosX() - Map.Viewport.GetScrollX(), 
				Enemys[i].GetPosY() - Map.Viewport.GetScrollY(), 
				makecol(255,0,0));

			float fPosX = Enemys[i].GetPosX();
			float fPosY = Enemys[i].GetPosY();
			float iScrollX = Map.Viewport.GetScrollX();
			float iScrollY = Map.Viewport.GetScrollY();
			float fWidth = Enemys[i].GetWidth();
			float fHeight = Enemys[i].GetHeight();

			if(Enemys[i].GetDirX())
				line(Bitmap, 
					fPosX - iScrollX + (fWidth/2),
					fPosY - iScrollY + (fHeight/2),
					fPosX - iScrollX + (fWidth),
					fPosY - iScrollY + (fHeight/2),
					makecol(255,0,0));
			else
				line(Bitmap, 
					fPosX - iScrollX,
					fPosY - iScrollY + (fHeight/2),
					fPosX - iScrollX + (fWidth/2),
					fPosY - iScrollY + (fHeight/2),
					makecol(255,0,0));
		}
	}

	for(i = 0; i < MAX_ITEMS; i++)
	{
		if(Items[i].GetActive())
		{
			Items[i].Draw(Bitmap);

			sprintf(Temp, "%d", Items[i].GetItemType());
			textout(Bitmap, font, Temp, 
				Items[i].GetPosX() - Map.Viewport.GetScrollX(), 
				Items[i].GetPosY() - Map.Viewport.GetScrollY(), 
				makecol(255,0,0));

		}
	}

	if(iCurrentLayer == 0)
	{
		sprintf(Temp, "Layer: Tile Type");
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 0, makecol(255,255,255));
		sprintf(Temp, "Type: %d", iCurrentTileType);
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 10, makecol(255,255,255));
	}
	else if(iCurrentLayer == 100)
	{
		sprintf(Temp, "Layer: Enemys");
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 0, makecol(255,255,255));
		sprintf(Temp, "Enemy: %d %s", iCurrentEnemy, EnemyNames[iCurrentEnemy]);
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 10, makecol(255,255,255));
		if(bCurrentDir)
		{
			sprintf(Temp, "Facing: Right");
			textout_right(Bitmap, font, Temp, SCREEN_W-5, 20, makecol(255,255,255));
		}
		else
		{
			sprintf(Temp, "Facing: Left");
			textout_right(Bitmap, font, Temp, SCREEN_W-5, 20, makecol(255,255,255));
		}
	}
	else if(iCurrentLayer == 200)
	{
		sprintf(Temp, "Layer: Items");
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 0, makecol(255,255,255));
		sprintf(Temp, "Item: %d %s", iCurrentItem, ItemNames[iCurrentItem]);
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 10, makecol(255,255,255));
	}
	else
	{
		sprintf(Temp, "Layer: %d", iCurrentLayer);
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 0, makecol(255,255,255));
		sprintf(Temp, "Tile: %d", iCurrentTileType);
		textout_right(Bitmap, font, Temp, SCREEN_W-5, 10, makecol(255,255,255));
	}

	// show mouse over everything
	show_mouse(Bitmap);

	return true;
}





/********************************************************************************

		DoEditLogic()

	Main logic loop for actual gameplay.

********************************************************************************/

bool DoEditLogic()
{	
	int iScrollX = Map.Viewport.GetScrollX();
	int iScrollY = Map.Viewport.GetScrollY();
	int iMouseX = (mouse_x + iScrollX) / TILE_SIZE;
	int iMouseY = (mouse_y + iScrollY) / TILE_SIZE;


	// mouse clicks add objects and tiles
	if(iCurrentLayer == 100)
	{
		if(MouseClick(1))
			AddEnemy(iMouseX * TILE_SIZE, iMouseY * TILE_SIZE, iCurrentEnemy, bCurrentDir);
	}
	else if(iCurrentLayer == 200)
	{
		if(MouseClick(1))
			AddItem(iMouseX * TILE_SIZE, iMouseY * TILE_SIZE, iCurrentItem);
	}
	if(mouse_b&1)
	{		
		if(iCurrentLayer > 0)
			Map.SetTile(iCurrentLayer, iMouseX, iMouseY, iCurrentTile);
		else
			Map.SetTileType(iMouseX, iMouseY, iCurrentTileType);
	}

	if(mouse_b&2)
	{	
		if(iCurrentLayer == 100)
		{
			// bbox collision with all enemys, delete one clicked on
			for(int i = 0; i < MAX_ENEMYS; i++)
			{
				if(Enemys[i].CheckPointCollision(mouse_x + iScrollX, mouse_y + iScrollY))
				{
					RemoveEnemy(i);
				}
			}
		}
		if(iCurrentLayer == 200)
		{
			// bbox collision with all Items, delete one clicked on
			for(int i = 0; i < MAX_ITEMS; i++)
			{
				if(Items[i].CheckPointCollision(mouse_x + iScrollX, mouse_y + iScrollY))
				{
					RemoveItem(i);
				}
			}
		}
		else if(iCurrentLayer > 0)
			Map.SetTile(iCurrentLayer, iMouseX, iMouseY, 0);
		else
			Map.SetTileType(iMouseX, iMouseY, 0);
		
	}

	// arrow keys scroll map
	if(key[KEY_LEFT])
		Map.Scroll(LEFT,6);
	if(key[KEY_RIGHT])
		Map.Scroll(RIGHT,6);
	if(key[KEY_UP])
		Map.Scroll(UP,6);
	if(key[KEY_DOWN])
		Map.Scroll(DOWN,6);

	// space bar changes object starting direction
	if(KeyPress(KEY_SPACE))
	{
		bCurrentDir = !bCurrentDir;
	}

	// A and Z change current tile selected
	if(KeyPress(KEY_A))
	{	
		if(iCurrentLayer == 100)
		{
			if(iCurrentEnemy < (NUM_ENEMYS-1))
				iCurrentEnemy++;
		}
		else if(iCurrentLayer == 200)
		{
			if(iCurrentItem < (NUM_ITEMS-1))
				iCurrentItem++;
		}
		else if(iCurrentLayer > 0)
		{
			if(iCurrentTile < (NUM_TILES-1))
				iCurrentTile++;
		}
		else
		{
			if(iCurrentTileType < (NUM_TILE_TYPES-1))
				iCurrentTileType++;
		}
	}
	else if(KeyPress(KEY_Z))
	{	
		if(iCurrentLayer == 100)
		{
			if(iCurrentEnemy > 0)
				iCurrentEnemy--;
		}
		else if(iCurrentLayer == 200)
		{
			if(iCurrentItem > 0)
				iCurrentItem--;
		}
		else if(iCurrentLayer > 0)
		{
			if(iCurrentTile > 1)
				iCurrentTile--;
		}
		else
		{
			if(iCurrentTileType > 1)
				iCurrentTileType--;	
		}
	}

	// number keys change layer
	if(key[KEY_TILDE])
		iCurrentLayer = 0;
	else if(key[KEY_1])
		iCurrentLayer = 1;
	else if(key[KEY_2])
		iCurrentLayer = 2;
	else if(key[KEY_E])
		iCurrentLayer = 100;
	else if(key[KEY_I])
		iCurrentLayer = 200;

	// CTRL + C + I clears all items
	if(((key[KEY_LCONTROL]) || (key[KEY_RCONTROL])) && (KeyPress(KEY_C)))
	{
		for(int i = 0; i < 100; i++)
			Items[i].SetActive(false);
	}

	// CTRL + S saves map
	if(((key[KEY_LCONTROL]) || (key[KEY_RCONTROL])) && (KeyPress(KEY_S)))
	{
		//Map.Save("data//map.map");

		drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
		// change this string for release
		char Path[255] = "C:\\Documents and Settings\\Eskimo Ninja\\My Documents\\Programming\\Projects\\Allegro\\StickDude\\data\\levels\\";
		if(file_select("Save Map File", Path, "MAP"))
		{
			if((!Map.Save(Path)))
			{
				allegro_message("Error saving map file!");
				return false;
			}
		}
		drawing_mode(DRAW_MODE_SOLID,NULL,0,0);

	}

	// CTRL + L loads map
	if(((key[KEY_LCONTROL]) || (key[KEY_RCONTROL])) && (key[KEY_L]))
	{
		Map.New(3,100,100);
		Map.ClearTo(0);
		Map.LoadTileset("data//levels//tiles.dat");
		for(int i = 0; i < 100; i++)
			Items[i].SetActive(false);
		for(i = 0; i < 100; i++)
			Enemys[i].SetActive(false);

		drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
		// change this string for release
		char Path[255] = "C:\\Documents and Settings\\Eskimo Ninja\\My Documents\\Programming\\Projects\\Allegro\\StickDude\\data\\levels\\";
		if(file_select("Load Map File", Path, "MAP"))
		{
			if((!Map.Load(Path)))
			{
				allegro_message("Error loading map file!");
				return false;
			}
		}
		drawing_mode(DRAW_MODE_SOLID,NULL,0,0);

//		if(!Map.Load("data//map.map"))
//			allegro_message("error loading map");
	}

	// P sets player start position
	if(key[KEY_P])
	{
		Map.SetPlayerStartPos(iMouseX * TILE_SIZE, iMouseY * TILE_SIZE);
	}

	// R sets restart position
	if(key[KEY_R])
	{
		Map.SetRespawnPos(iMouseX * TILE_SIZE, iMouseY * TILE_SIZE);
	}

	return true;
}





/********************************************************************************

		DoEditShutdown()

	Unload anything loaded in DoEditInit()

********************************************************************************/

bool DoEditShutdown()
{	

	return true;
}