
/*
 *	CTileset.h
 *
 *	Interface for CTileset class.
 *	CTileset allows the loading, unloading and management
 *	of Tilesets within a Tilemap.  A tileset is basically
 *	a list of all the tiles availble within the map, and
 *	and is accessed just like an array, with each element
 *	representing a different tile in the datafile.
 *
 */



class CTileset
{

private:

	int m_iNumTiles;			// number of tiles in tileset
	DATAFILE *m_dfData;			// the tileset data

public:

	CTileset();					// default class constructor
	~CTileset();				// default class destructor
	CTileset(char *cFilename);	// overloaded constructor, load a tileset

	bool Load(char *cFilename);	// load a tileset into memory, return false on error
	void Unload();				// unload the tileset

	bool Exists();				// returns true if tileset is loaded, false if otherwise

	BITMAP* GetTile(int iNumber);	// return pointer to bitmap of this tile
	int NumTiles();					// return number of tiles in tileset

};