
/*
 *	CEnemy.h
 *
 *	Header file for CEnemy class.
 *	This class is used for the enemy.
 *
 */


// types of ai for enemys
#define AI_RUNNER			0
#define AI_JUMPER			1
#define AI_RUNJUMPER		2
#define AI_FLIER			3
#define AI_SMARTRUNNER		4



// Classes ///////////////////////////////////////////////////


class CEnemy : public CBaseObject
{

public:

	CEnemy()					{}
	~CEnemy()					{}

	bool Update();
	void Reset();

	void SetEnemyType(int t)	{ m_iType = t;			}
	void SetAiType(int t)		{ m_iAiType = t;		}
	void SetMoveRight(bool b)	{ m_bMoveRight = b;		}
	void SetSeen(bool s)		{ m_bSeen = s;			}

	int GetEnemyType()			{ return m_iType;		}
	bool GetSeen()				{ return m_bSeen;		}


private:

	void TakeDamage(int Type);

	int m_iType;
	int m_iAiType;
	bool m_bMoveRight;
	bool m_bSeen;

};



// Defines ////////////////////////////////////////////////////

#define NUM_ENEMYS						16

// runner AI, moves slowest
#define ENEMY_RUNNER_SLOW				0
#define ENEMY_RUNNER_SLOW_ACCELX		2.5
#define ENEMY_RUNNER_SLOW_ACCELY		12
#define ENEMY_RUNNER_SLOW_MAXVELX		2.5
#define ENEMY_RUNNER_SLOW_MAXVELY		6

// runner AI, moves medium speed
#define ENEMY_RUNNER_MEDIUM				1
#define ENEMY_RUNNER_MEDIUM_ACCELX		5
#define ENEMY_RUNNER_MEDIUM_ACCELY		12
#define ENEMY_RUNNER_MEDIUM_MAXVELX		5
#define ENEMY_RUNNER_MEDIUM_MAXVELY		6

// runner AI, moves fastest
#define ENEMY_RUNNER_FAST				2
#define ENEMY_RUNNER_FAST_ACCELX		7.5
#define ENEMY_RUNNER_FAST_ACCELY		12
#define ENEMY_RUNNER_FAST_MAXVELX		7.5
#define ENEMY_RUNNER_FAST_MAXVELY		6

// jumper AI, jumps lowest
#define ENEMY_JUMPER_LOW				3
#define ENEMY_JUMPER_LOW_ACCELX			0
#define ENEMY_JUMPER_LOW_ACCELY			6
#define ENEMY_JUMPER_LOW_MAXVELX		0
#define ENEMY_JUMPER_LOW_MAXVELY		4

// jumper AI, jumps medium height
#define ENEMY_JUMPER_MEDIUM				4
#define ENEMY_JUMPER_MEDIUM_ACCELX		0
#define ENEMY_JUMPER_MEDIUM_ACCELY		10
#define ENEMY_JUMPER_MEDIUM_MAXVELX		0
#define ENEMY_JUMPER_MEDIUM_MAXVELY		8

// jumper AI, jumps higher
#define ENEMY_JUMPER_HIGH				5
#define ENEMY_JUMPER_HIGH_ACCELX		0
#define ENEMY_JUMPER_HIGH_ACCELY		12
#define ENEMY_JUMPER_HIGH_MAXVELX		0
#define ENEMY_JUMPER_HIGH_MAXVELY		12

// jumper AI, jumps highest
#define ENEMY_JUMPER_CRAZY				6
#define ENEMY_JUMPER_CRAZY_ACCELX		0
#define ENEMY_JUMPER_CRAZY_ACCELY		16
#define ENEMY_JUMPER_CRAZY_MAXVELX		0
#define ENEMY_JUMPER_CRAZY_MAXVELY		14

// run jumper AI, moves slowest jumps lowest
#define ENEMY_RUNJUMPER_SLOW			7
#define ENEMY_RUNJUMPER_SLOW_ACCELX		2.5
#define ENEMY_RUNJUMPER_SLOW_ACCELY		10
#define ENEMY_RUNJUMPER_SLOW_MAXVELX	2.5
#define ENEMY_RUNJUMPER_SLOW_MAXVELY	8

// run jumper AI, moves medium jumps medium
#define ENEMY_RUNJUMPER_MEDIUM			8
#define ENEMY_RUNJUMPER_MEDIUM_ACCELX	5
#define ENEMY_RUNJUMPER_MEDIUM_ACCELY	12
#define ENEMY_RUNJUMPER_MEDIUM_MAXVELX	5
#define ENEMY_RUNJUMPER_MEDIUM_MAXVELY	12

// run jumper AI, moves medium jumps highest
#define ENEMY_RUNJUMPER_FAST			9
#define ENEMY_RUNJUMPER_FAST_ACCELX		6
#define ENEMY_RUNJUMPER_FAST_ACCELY		14
#define ENEMY_RUNJUMPER_FAST_MAXVELX	6
#define ENEMY_RUNJUMPER_FAST_MAXVELY	13

// flier AI, moves slowest
#define ENEMY_FLIER_SLOW				10
#define ENEMY_FLIER_SLOW_ACCELX			2
#define ENEMY_FLIER_SLOW_ACCELY			0
#define ENEMY_FLIER_SLOW_MAXVELX		2
#define ENEMY_FLIER_SLOW_MAXVELY		0

// flier AI, moves medium
#define ENEMY_FLIER_MEDIUM				11
#define ENEMY_FLIER_MEDIUM_ACCELX		4
#define ENEMY_FLIER_MEDIUM_ACCELY		0
#define ENEMY_FLIER_MEDIUM_MAXVELX		4
#define ENEMY_FLIER_MEDIUM_MAXVELY		0	

// flier AI, moves fastest
#define ENEMY_FLIER_FAST				12
#define ENEMY_FLIER_FAST_ACCELX			6
#define ENEMY_FLIER_FAST_ACCELY			0
#define ENEMY_FLIER_FAST_MAXVELX		6
#define ENEMY_FLIER_FAST_MAXVELY		0

// smart runner AI, moves slowest
#define ENEMY_SMARTRUNNER_SLOW				13
#define ENEMY_SMARTRUNNER_SLOW_ACCELX		2.5
#define ENEMY_SMARTRUNNER_SLOW_ACCELY		12
#define ENEMY_SMARTRUNNER_SLOW_MAXVELX		2.5
#define ENEMY_SMARTRUNNER_SLOW_MAXVELY		6

// smart runner AI, moves medium speed
#define ENEMY_SMARTRUNNER_MEDIUM			14
#define ENEMY_SMARTRUNNER_MEDIUM_ACCELX		5
#define ENEMY_SMARTRUNNER_MEDIUM_ACCELY		12
#define ENEMY_SMARTRUNNER_MEDIUM_MAXVELX	5
#define ENEMY_SMARTRUNNER_MEDIUM_MAXVELY	6

// smart runner AI, moves fastest
#define ENEMY_SMARTRUNNER_FAST				15
#define ENEMY_SMARTRUNNER_FAST_ACCELX		7.5
#define ENEMY_SMARTRUNNER_FAST_ACCELY		12
#define ENEMY_SMARTRUNNER_FAST_MAXVELX		7.5
#define ENEMY_SMARTRUNNER_FAST_MAXVELY		6





