
/*
 *	CViewport.h
 *
 *	Interface for CViewport class.
 *	This class works with the tilemap to provide a scrolling 
 *	or viewport over a tilemap.  The viewport can be controlled
 *	by the player, or by the game engine.
 *
 */

// watch for multiple inclusions
#ifndef CVIEWPORT_HEADER
#define CVIEWPORT_HEADER


// 4 different directions for scrolling
#define UP		0
#define DOWN	1
#define LEFT	2
#define RIGHT	3


// needed to return 2 values at once
struct Vector2D
{
	int x;
	int y;
};



class CViewport
{

private:

	int m_iScrollX;			// amount of pixels scrolled in x and y directions
	int m_iScrollY;			

	int m_iLimitX;			// max amount of scrolling in x and y directions
	int m_iLimitY;			


public:

	CViewport();			// default constructor
	~CViewport();			// default destructor

	bool SetScroll(int iScrollX, int iScrollY);	// set the current scroll values
	bool SetLimits(int iLimitX, int iLimitY);	// set the maximum scroll values for map

	bool Scroll(int iDirection, int iSpeed);	// scroll map to scroll in specified direction using iSpeed paramater

	Vector2D GetScroll();	// return the current scroll values
	int GetScrollX()	{ return m_iScrollX;	}
	int GetScrollY()	{ return m_iScrollY;	}

};


#endif