
/*
 *	CViewport.cpp
 *
 *	Implimentation of CViewport class.
 *	This class works with the tilemap to provide a scrolling 
 *	or viewport over a tilemap.  The viewport can be controlled
 *	by the player, or by the game engine.
 *
 */

#include <allegro.h>
#include "CViewport.h"		// CViewport class header




// CViewport()
// default constructor
CViewport::CViewport()
{
	// reset all variables
	m_iScrollX = 0;
	m_iScrollY = 0;

	m_iLimitX = 0;
	m_iLimitY = 0;
}





// ~CViewport()
// default destructor
CViewport::~CViewport()
{

}





// SetLimits(int,int)
// sets the maximum scrolling limits (basically the map width and height in pixels),
// returns false if value is invalid
bool CViewport::SetLimits(int iLimitX, int iLimitY)
{
	// make sure the given values aren't negative
	if((iLimitX < 0) || (iLimitY < 0))
	{
		// negative values are illegal - return false
		return false;
	}

	// no problems, set the values
	m_iLimitX = iLimitX;
	m_iLimitY = iLimitY;

	return true;
}





// SetScroll(int,int)
// set the current scrolling value to a specific point, returns false if invalid value
// the maximum scroll values need to be set BEFORE calling this
bool CViewport::SetScroll(int iScrollX, int iScrollY)
{
	// make sure the given values aren't negative
	if(iScrollX < 0)
		iScrollX = 0;
	if(iScrollY < 0)
		iScrollY = 0;

	// make sure the given values do not exceed the scroll limits
	if((iScrollX >= m_iLimitX) || (iScrollY >= m_iLimitY))
	{
		// value is too large, return false
		return false;
	}

	// no errors, set the scroll coordinates
	m_iScrollX = iScrollX;
	m_iScrollY = iScrollY;

	return true;
}





// Scroll(int,int)
// scroll the map in the specified direction
bool CViewport::Scroll(int iDirection, int iSpeed)
{
	// check the given direction is valid
	if((iDirection < 0) || (iDirection > 3))
	{
		// direction invalid - isn't one of the #defines in CViewport.h, return error
		return false;
	}

	// check given speed is valid
	if(iSpeed < 1)
	{
		// speed is invalid - to low to do anything 
		return false;
	}

	// now depending on which direction is given, scroll 
	switch(iDirection)
	{
		case UP:
			{

				// scroll viewport UP
				m_iScrollY -= iSpeed;

				// make sure scroll stays within limits
				if(m_iScrollY < 0)
				{
					m_iScrollY = 0;
				}

			} break;

		case DOWN:
			{

				// scroll viewport DOWN
				m_iScrollY += iSpeed;

				// make sure scroll stays within limits
				if(m_iScrollY > m_iLimitY)
				{
					m_iScrollY = m_iLimitY;
				}

			} break;

		case LEFT:
			{

				// scroll viewport LEFT
				m_iScrollX -= iSpeed;

				// make sure scroll stays within limits
				if(m_iScrollX < 0)
				{
					m_iScrollX = 0;
				}

			} break;

		case RIGHT:
			{

				// scroll viewport RIGHT
				m_iScrollX += iSpeed;

				// make sure scroll stays within limits
				if(m_iScrollX > m_iLimitX)
				{
					m_iScrollX = m_iLimitX;
				}

			} break;

		default:
			break;
	}

	return true;
}





// GetScroll()
// return the current scroll values
Vector2D CViewport::GetScroll()
{
	// create a temporary variable to hold the 2 scroll values
	Vector2D ScrollValues;

	// put the scroll values in the variable
	ScrollValues.x = m_iScrollX;
	ScrollValues.y = m_iScrollY;

	// now return the structure
	return ScrollValues;
}
