
/*
 *	Collision.cpp
 *
 *	This file has functions for handling various collision detection
 *	issues.
 *
 */

#include <math.h>
#include "Collision.h"


/*****************************************************************************

		PointPointCol()

	Checks collision between 2 points

*****************************************************************************/

inline int PointPointCol(float p1x, float p1y, float p2x, float p2y)
{
   return (p1x == p2x && p1y == p2y);
}





/*****************************************************************************

		PointCircleCol()

	Checks collision between a point and a circle

*****************************************************************************/

inline int PointCircleCol(float px, float py, float cx, float cy, float cr)
{
   return (sqrt(pow(cx - px, 2) + pow(cy - py, 2)) <= cr);
}





/*****************************************************************************

		PointRectCol()

	Checks collision between a point and a rectangle

*****************************************************************************/

inline int PointRectCol(float px, float py, float rx1, float ry1, float rx2, float ry2)
{
   return (px >= rx1 && px <= rx2 && py >= ry1 && py <= ry2);
}





/*****************************************************************************

		CircleCircleCol()

	Checks collision between 2 circles

*****************************************************************************/

inline int CircleCircleCol(float c1x, float c1y, float c1r, float c2x, float c2y, float c2r)
{
   return (sqrt(pow(c1x - c2x, 2) + pow(c1y - c2y, 2)) <= c1r + c2r);
}





/*****************************************************************************

		CircleRectCol()

	Checks collision between a circle and a rectangle

*****************************************************************************/

inline int CircleRectCol(float cx, float cy, float cr, float rx1, float ry1, float rx2, float ry2)
{
   return sqrt(pow(cx - (cx < rx1 ? rx1 : cx > rx2 ? rx2 : cx), 2) + pow(cy - (cy < ry1 ? ry1 : cy > ry2 ? ry2 : cy), 2)) <= cr;
}





/*****************************************************************************

		RectRectCol()

	Checks collision between 2 rectangles

*****************************************************************************/

inline int RectRectCol(float r1x1, float r1y1, float r1x2, float r1y2, float r2x1, float r2y1, float r2x2, float r2y2)
{
   return !((r1x1 < r2x1 && r1x2 < r2x1) ||
            (r1x1 > r2x2 && r1x2 > r2x2) ||
            (r1y1 < r2y1 && r1y2 < r2y1) ||
            (r1y1 > r2y2 && r1y2 > r2y2));
}

