
/*
 *	CTileset.cpp
 *
 *	Implimentation of CTileset class.
 *	CTileset allows the loading, unloading and management
 *	of Tilesets within a Tilemap.  A tileset is basically
 *	a list of all the tiles availble within the map, and
 *	and is accessed just like an array, with each element
 *	representing a different tile in the datafile.
 *
 */

#include <allegro.h>

#include "CTileset.h"		// CTileset class header

#define NUM_TILES 100


// CTileset()
// default constructor
CTileset::CTileset()
{
	// set pointer to NULL
	m_dfData = NULL;
}





// ~CTileset()
// default destructor
CTileset::~CTileset()
{
	//Unload();
}





// CTileset(char)
// overloaded constructor, load a tileset
CTileset::CTileset(char *cFilename)
{
	// set pointer to NULL
	m_dfData = NULL;

	// now load the tileset
	Load(cFilename);
}





// Exists()
// returns true if tileset is loaded into memory, false if not
bool CTileset::Exists()
{
	// check if pointer is valid
	if(m_dfData == NULL)
	{
		// no data, return false
		return false;
	}

	return true;
}





// Load(char)
// load a tileset into memory, return false on error
bool CTileset::Load(char *cFilename)
{
	// make sure filename is valid
	if(!cFilename)
	{
		// invalid filename, return error
		return false;
	}

	// no errors, load the tileset
	m_dfData = load_datafile(cFilename);

	// !!!!!
	//m_iNumTiles = 100;
	m_iNumTiles = NUM_TILES;
	// !!!!!
	//m_iNumTiles = (int)m_dfData[0].dat;

	// check the file was loaded properly
	if(!Exists())
	{
		// error loading file, return false
		return false;
	}

	return true;
}





// Unload()
// unload the tileset, if loaded 
void CTileset::Unload()
{
	// check if tileset exists
	if(Exists())
	{
		// clear the tileset from memory

		// CRASHALICIOUS
		unload_datafile(m_dfData);
		// DIE FUCKER DIE
	}
}





// GetTile(int)
// return a pointer to the specified tile
BITMAP* CTileset::GetTile(int iNumber)
{
	// make sure number is valid
	if((iNumber < 0) || (iNumber > m_iNumTiles))
	{
		// tile does not exist, return NULL pointer
		return NULL;
	}

	// return the pointer
	return (BITMAP*)m_dfData[iNumber].dat;
}





// NumTiles()
// return number of tiles in tileset
int CTileset::NumTiles()
{
	return m_iNumTiles;
}