
/*
 *	CPlayer.h
 *
 *	Header file for CPlayer class.
 *	This class is used for the player.
 *
 */


// Defines ///////////////////////////////////////////////////

// max amounts
#define MAX_HEALTH		2//3
#define START_LIVES		2
#define MAX_LIVES		9
#define MAX_COINS		100




// Classes ///////////////////////////////////////////////////


class CPlayer : public CBaseObject
{

public:

	bool Update();
	void Reset();

	void SetHealth(int l)	{ m_iHealth = l;	}
	int GetHealth()			{ return m_iHealth;	}
	void SetLives(int l)	{ m_iLives = l;		}
	int GetLives()			{ return m_iLives;	}
	void SetCoins(int c)	{ m_iCoins = c;		}
	int GetCoins()			{ return m_iCoins;	}
	void SetPoints(int p)	{ m_iPoints = p;	}
	int GetPoints()			{ return m_iPoints;	}
	void GivePoints(int p)	{ m_iPoints += p;	}
	bool IsHit()			{ return m_bIsHit;	}
	void SetIsHit(bool b)	{ m_bIsHit = b;		}
	void SetDamageTimer(int i)	{ m_iDamageTimer = i; }

	void GiveItem(int t);


private:

	void TakeDamage(int Type);

	int m_iHealth;
	int m_iLives;
	int m_iCoins;
	int m_iDamageTimer;
	int m_iPoints;
	bool m_bIsHit;

};