
/*
 * CItem.cpp
 *
 * Implimentation of CItem class.
 *
 */

#include <fstream>
#include <allegro.h>
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CItem.h"



/*****************************************************************************

		Update()

	virtual update function, update AI, movement, etc

*****************************************************************************/

bool CItem::Update()
{
	// run base class update function
	CBaseObject::Update();

	return true;
}





/*****************************************************************************

		Reset()

	virtual reset function, reset all variables to default values

*****************************************************************************/

void CItem::Reset()
{
	// run base class reset function
	CBaseObject::Reset();	

	// set the correct animation data
	SetImageFrame(0);

	// set object to 'item' type
	SetType(TYPE_ITEM);

}





/*****************************************************************************

		SetImageFrame()

	helper function to set correct frame

*****************************************************************************/

void CItem::SetImageFrame(int i)
{
	m_Animations[ANIM_STAND].FirstFrame = i;
	m_Animations[ANIM_STAND].LastFrame = i;
	m_Animations[ANIM_STAND].FrameDelay = 1;
	m_Animations[ANIM_STAND].Loop = true;
	m_Animations[ANIM_MOVE].FirstFrame = i;
	m_Animations[ANIM_MOVE].LastFrame = i;
	m_Animations[ANIM_MOVE].FrameDelay = 1;
	m_Animations[ANIM_MOVE].Loop = true;
	m_Animations[ANIM_JUMP].FirstFrame = i;
	m_Animations[ANIM_JUMP].LastFrame = i;
	m_Animations[ANIM_JUMP].FrameDelay = 1;
	m_Animations[ANIM_JUMP].Loop = true;
	m_Animations[ANIM_FALL].FirstFrame = i;
	m_Animations[ANIM_FALL].LastFrame = i;
	m_Animations[ANIM_FALL].FrameDelay = 1;
	m_Animations[ANIM_FALL].Loop = true;
	m_Animations[ANIM_DAMAGE].FirstFrame = i;
	m_Animations[ANIM_DAMAGE].LastFrame = i;
	m_Animations[ANIM_DAMAGE].FrameDelay = 1;
	m_Animations[ANIM_DAMAGE].Loop = true;
	m_iCurrentFrame = i;
}

