
/*
 *	CBaseObject.cpp
 *
 *	Implimentation of CBaseObject class.
 *
 */

#include <fstream>
#include <allegro.h>
#include "Collision.h"
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "GGame.h"



/*****************************************************************************

		Update()

	virtual update function, update AI, movement, etc

*****************************************************************************/

bool CBaseObject::Update()
{
	if(!m_bActive)
		return true;

	// first check map collision, make sure object has a map first
	if(m_pCurrentMap)
		CheckMapCollision();

	// update animation
	UpdateAnim();

	// slow object down over time on X axis
	if((m_fVelX > m_fAccelX) && (!m_bMovedRight))
		m_fVelX -= m_fAccelX;
	else
		m_fVelX = 0;

	if((m_fVelX < -m_fAccelX) && (!m_bMovedLeft))
		m_fVelX += m_fAccelX;
	else m_fVelX = 0;

	// make sure velocity doesnt exceed limits
	if(m_fVelX > m_fMaxVelX)
		m_fVelX = m_fMaxVelX;
	else if(m_fVelX < -m_fMaxVelX)
		m_fVelX = -m_fMaxVelX;
	if(m_fVelY > m_fMaxVelY)
		m_fVelY = m_fMaxVelY;
	else if(m_fVelY < -m_fMaxVelY)
		m_fVelY = -m_fMaxVelY;

	// set the correct animation for current action
	if((m_bJumped) && (m_fVelY <= 0))
		SetAnim(ANIM_JUMP);
	else if((m_bJumped) && (m_fVelY > 0))
		SetAnim(ANIM_FALL);
	else if((m_bMovedLeft) || (m_bMovedRight))
		SetAnim(ANIM_MOVE);
	else
		SetAnim(ANIM_STAND);

	// reset movement variables for next loop
	m_bMovedRight = false;
	m_bMovedLeft = false;
	m_bJumped = false;

	return true;
}




/*****************************************************************************

		Draw(BITMAP *b)

	virtual draw function, draw object to screen

*****************************************************************************/

bool CBaseObject::Draw(BITMAP *b)
{
	if(!m_bActive)
		return true;

	// make sure map exists
	if(!m_pCurrentMap)
		return false;

	int iScrollX = m_pCurrentMap->Viewport.GetScrollX();
	int iScrollY = m_pCurrentMap->Viewport.GetScrollY();

/*	rect(b, m_fPosX - iScrollX + m_fOffsetX, m_fPosY - iScrollY + m_fOffsetY, 
		m_fPosX + m_fWidth - iScrollX + m_fOffsetX, m_fPosY + m_fHeight - iScrollY + m_fOffsetY, 
		makecol(255,255,255));*/
				
	// draw current animtion normally, making sure data is loaded
	if(m_dfDatafile)
	{		
		
		if(!m_bFaceRight)
				draw_sprite_h_flip(b, (BITMAP*)m_dfDatafile[m_iCurrentFrame].dat,
					m_fPosX - iScrollX, m_fPosY - iScrollY);
		else
				draw_sprite(b, (BITMAP*)m_dfDatafile[m_iCurrentFrame].dat,
					m_fPosX - iScrollX, m_fPosY - iScrollY);
		
		if(m_bDrawDamaged)
		{
			draw_sprite(b, (BITMAP*)m_dfDatafile[m_Animations[ANIM_DAMAGE].FirstFrame].dat,
				m_fPosX - iScrollX, m_fPosY - iScrollY);
		}

	}

	return true;
}





/*****************************************************************************

		Reset()

	virtual reset function, reset all variables to default values

*****************************************************************************/

void CBaseObject::Reset()
{
	m_fPosX = 0;
	m_fPosY = 0;
	m_fAccelX = 0;
	m_fAccelY = 0;
	m_fVelX = 0;
	m_fVelY = 0;
	m_bActive = false;
	m_bLockJump = 0;
	m_bFaceRight = 0;
	m_fGravity = 0;
	m_bMovedLeft = 0;
	m_bMovedRight = 0;
	m_bJumped = 0;
	m_pCurrentMap = NULL;
	m_dfDatafile = NULL;						
	m_iCurrentFrame = 0;	 
	m_iCurrentAnim = 0;		
	m_iCurrentDelayTimer = 0;	
	m_fOffsetX = 0;
	m_fOffsetY = 0;
	m_fWidth = 0;
	m_fHeight = 0;
	
}





/*****************************************************************************

		CheckMapCollision()

	check for collision between object and map
	return true on collision
	code from these collisions is taken from the excellent tutorial
	by jhrdev: http://jnrdev.weed-crew.net

*****************************************************************************/

bool CBaseObject::CheckMapCollision()
{
	int tilecoord;

	//x axis first (--)
	if(m_fVelX > 0)
	{		//moving right
		if(int Tile = collision_ver(m_fPosX+m_fVelX+TILE_SIZE-1, m_fPosY, TILE_SIZE-1, tilecoord))	//collision on the right side.
		{
			m_fPosX = tilecoord*TILE_SIZE -TILE_SIZE-1-1;			//move to the edge of the tile (tile on the right -> mind the plam_fPosYer TILE_SIZE-1idth)
			m_bHitWall = true;

			if(Tile == TILE_TYPE_WIN)
			{
				if(m_iType == TYPE_PLAYER)
					g_bWinLevel = true;
			}
		}
		else			//no collision
		{
			m_fPosX += m_fVelX;
			m_bHitWall = false;
		}
	}		 
	else if(m_fVelX < 0)
	{	//moving left
		if(int Tile = collision_ver(m_fPosX+m_fVelX, m_fPosY, TILE_SIZE-1, tilecoord))		//collision on the left side
		{
			m_fPosX = (tilecoord+1)*TILE_SIZE +1;				//move to the edge of the tile
			m_bHitWall = true;

			if(Tile == TILE_TYPE_WIN)
			{
				if(m_iType == TYPE_PLAYER)
					g_bWinLevel = true;
			}
		}
		else
		{
			m_fPosX += m_fVelX;
			m_bHitWall = false;
		}
	}

	//tTILE_SIZE-1en m_fPosY axis (|)
	if(m_fVelY < 0){	//moving up
		int Tile = collision_hor(m_fPosX, m_fPosY+m_fVelY, TILE_SIZE-1, tilecoord);
		if(Tile)
		{
			if(Tile == TILE_TYPE_BLOCKED)
			{
				m_fPosY		= (tilecoord+1)*TILE_SIZE +1;
				m_fVelY	= 0;
			}
			else if(Tile == TILE_TYPE_DAMAGE)
			{
				m_fPosY		= (tilecoord+1)*TILE_SIZE +1;
				m_fVelY	= 0;

				//m_bActive = false;
				TakeDamage(DAMAGE_LEVEL);
			}
			else if(Tile == TILE_TYPE_BOUNCE)
			{
				m_fPosY		= (tilecoord+1)*TILE_SIZE +1;
				m_fVelY	= 0;

				if(m_fVelY > 0)
					m_fVelY	= -m_fAccelY;			
				else
					m_fVelY = m_fAccelY;
			}
			else if(Tile == TILE_TYPE_WIN)
			{
				if(m_iType == TYPE_PLAYER)
					g_bWinLevel = true;
			}
		}
		else{
			m_fPosY		+= m_fVelY;
			m_fVelY	+=m_fGravity;
			m_bJumped = true;
		}
	}		 
	else
	{		//moving down / on ground
		//printf("test: down, m_fVelY:%d\n", m_fVelY);
		int Tile = collision_hor(m_fPosX, m_fPosY+m_fVelY+TILE_SIZE-1, TILE_SIZE-1, tilecoord);
		if(Tile)
		{	//on ground
			if(Tile == TILE_TYPE_BLOCKED)
			{
				m_fPosY		= tilecoord*TILE_SIZE -TILE_SIZE-1+1;
				m_fVelY	= 1;				//1 so we test against tTILE_SIZE-1e ground again int tTILE_SIZE-1e nem_fPosXt frame (0 would test against tTILE_SIZE-1e ground in tTILE_SIZE-1e nem_fPosXt+1 frame)

				m_bLockJump = false;
				m_bJumped = false;
			}
			else if(Tile == TILE_TYPE_DAMAGE)
			{
				m_fPosY		= tilecoord*TILE_SIZE -TILE_SIZE-1+1;
				m_fVelY	= 1;				//1 so we test against tTILE_SIZE-1e ground again int tTILE_SIZE-1e nem_fPosXt frame (0 would test against tTILE_SIZE-1e ground in tTILE_SIZE-1e nem_fPosXt+1 frame)

				m_bLockJump = false;
				m_bJumped = false;

				//m_bActive = false;
				TakeDamage(DAMAGE_LEVEL);
			}
			else if(Tile == TILE_TYPE_BOUNCE)
			{
				m_fPosY	  = tilecoord*TILE_SIZE -TILE_SIZE-1+1;
				if(m_fVelY > 0)
					m_fVelY	= -m_fAccelY;			
				else
					m_fVelY = m_fAccelY;

				m_bLockJump = false;
				m_bJumped = false;
			}
			else if(Tile == TILE_TYPE_WIN)
			{
				if(m_iType == TYPE_PLAYER)
					g_bWinLevel = true;
			}
		}
		else
		{	//falling (in air)
			m_fPosY		+= m_fVelY;
			m_fVelY	+=m_fGravity;

			if(m_fVelY >= TILE_SIZE)		//if tTILE_SIZE-1e speed is TILE_SIZE-1igTILE_SIZE-1er tTILE_SIZE-1an tTILE_SIZE-1is we migTILE_SIZE-1t fall tTILE_SIZE-1rougTILE_SIZE-1 a tile
				m_fVelY = TILE_SIZE;

			m_bLockJump = true;			//don't allow jumping after falling of an edge
			m_bJumped = true;
		}
	}

	return false;
}





/*****************************************************************************

		CheckObjectCollision()

	check for collision between object and another object
	return true on collision

*****************************************************************************/

bool CBaseObject::CheckObjectCollision(CBaseObject *o)
{
	float x1 = m_fPosX + m_fOffsetX;
	float y1 = m_fPosY + m_fOffsetY;
	float x2 = m_fPosX + m_fOffsetX + m_fWidth;
	float y2 = m_fPosY + m_fOffsetY + m_fHeight;

	float x3 = o->GetPosX() + o->GetOffsetX();
	float y3 = o->GetPosY() + o->GetOffsetY();
	float x4 = o->GetPosX() + o->GetOffsetX() + o->GetWidth();
	float y4 = o->GetPosY() + o->GetOffsetY() + o->GetHeight();

	if(RectRectCol(x1, y1, x2, y2,
				   x3, y3, x4, y4))
	{
		if(o->GetType() != TYPE_ITEM)
			TakeDamage(DAMAGE_OBJECT);

		return true;
	}

	return false;
}





/*****************************************************************************

		CheckPointCollision()

	check for collision between object and a point on the map

*****************************************************************************/

bool CBaseObject::CheckPointCollision(float fPosX, float fPosY)
{
	float x1 = m_fPosX;
	float y1 = m_fPosY;
	float x2 = m_fPosX + m_fWidth;
	float y2 = m_fPosY + m_fHeight;

	if(PointRectCol(fPosX, fPosY, x1, y1, x2, y2))
	{
		return true;
	}

	return false;
}





/*****************************************************************************

		SetAnim()

	set current animation for object

*****************************************************************************/

bool CBaseObject::SetAnim(int iAnim)
{
	if((iAnim < 0) || (iAnim > MAX_ANIMS))
		return false;

	// only change animation and reset frame if we need to
	if(m_iCurrentAnim != iAnim)
	{
		m_iCurrentAnim = iAnim;
		m_iCurrentFrame = m_Animations[iAnim].FirstFrame;
	}

	return true;
}





/*****************************************************************************

		UpdateAnim()

	update frame of animation for object

*****************************************************************************/

void CBaseObject::UpdateAnim()
{
	m_iCurrentDelayTimer++;
	if(m_iCurrentDelayTimer > m_Animations[m_iCurrentAnim].FrameDelay)
	{
		m_iCurrentDelayTimer = 0;
		m_iCurrentFrame++;
		if(m_iCurrentFrame > m_Animations[m_iCurrentAnim].LastFrame)
		{
			// only restart the animation if its looped
			if(m_Animations[m_iCurrentAnim].Loop)
				m_iCurrentFrame = m_Animations[m_iCurrentAnim].FirstFrame;
			else
				m_iCurrentFrame = m_Animations[m_iCurrentAnim].LastFrame;
		}
	}
}





/*****************************************************************************

		TakeDamage()

	make object take damage

*****************************************************************************/

void CBaseObject::TakeDamage(int Type)
{

}





/*****************************************************************************

		these two functions are taken from the tutorial mentioned above

*****************************************************************************/

int CBaseObject::collision_hor(int x, int y, int w, int &tilecoordy){
	int tilexpixels = x-(x%TILE_SIZE);	//calculate the x position (pixels!) of the tiles we check against
	int testend = x + w;		//calculate the end of testing (just to save the x+w calculation each for loop)

	tilecoordy = y/TILE_SIZE;			//calculate the y position (map coordinates!) of the tiles we want to test

	int tilecoordx = tilexpixels/TILE_SIZE;	//calculate map x coordinate for first tile


	//loop while the start point (pixels!) of the test tile is inside the players bounding box
	while(tilexpixels <= testend){
		if(m_pCurrentMap->GetTileType(tilecoordx, tilecoordy))	//is a solid tile is found at tilecoordx, tilecoordy?
			return m_pCurrentMap->GetTileType(tilecoordx, tilecoordy);	

		tilecoordx++;		//increase tile x map coordinate
		tilexpixels+=TILE_SIZE;	//increase tile x pixel coordinate
	}

	return 0;
}

//for explanation see CPlayer::collision_hor()
int CBaseObject::collision_ver(int x, int y, int h, int &tilecoordx){
	int tileypixels = y-(y%TILE_SIZE);
	int testend = y + h;

	tilecoordx = x/TILE_SIZE;

	int tilecoordy = tileypixels/TILE_SIZE;

	while(tileypixels <= testend){
		if(m_pCurrentMap->GetTileType(tilecoordx, tilecoordy))
			return m_pCurrentMap->GetTileType(tilecoordx, tilecoordy);

		tilecoordy++;
		tileypixels += TILE_SIZE;
	}

	return 0;
}

	
