
/*
 *	Menus.cpp
 *
 *	This file contains the code for all the menus
 *	including main menu, intro, etc.
 *
 */
								
#include <string>
#include <allegro.h>
#include "AllegEx.h"
#include "Collision.h"
#include "GGame.h"
#include "GEdit.h"
#include "Main.h"
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CEnemy.h"
#include "CItem.h"
#include "Game.h"
#include "Menus.h"
#include "df_menus.h"

using namespace std;
#include <fstream>	
DATAFILE *Data = NULL;



/********************************************************************************

		DoIntro()

	run the introduction to the game

********************************************************************************/

bool DoIntro()
{
	// fade out previous screen
	highcolour_fade_out(14);
	
	// stop any other music playing
	stop_midi();

	// load Data graphics
	if(!Data)
		Data = load_datafile("data//misc//menus.dat");

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	// start music playing
	play_midi((MIDI*)Data[MUSIC_INTRO].dat,1);
	rest(700);

	// clear background and draw first Data screen and fade in/out
	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[INTRO1].dat, 200, 206);
	highcolour_fade_in(g_Buffer,15);
	rest(700);
	highcolour_fade_out(14);

	// second Data screen
	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[INTRO2].dat, SCREEN_W/2-113, SCREEN_H/2-17);
	highcolour_fade_in(g_Buffer,15);
	rest(1000);
	highcolour_fade_out(13);

	// title screen
	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[TITLE].dat, 0, 0);
	highcolour_fade_in(g_Buffer,15);
	rest(2200);
	highcolour_fade_out(13);
	
	// stop music
//	stop_midi();

	return true;
}





/********************************************************************************

		DoMainMenu()

	run the main menu

********************************************************************************/

bool DoMainMenu()
{
	// stop any other music playing
//	stop_midi();

	highcolour_fade_out(24);

	// load Data graphics
	if(!Data)
		Data = load_datafile("data//misc//menus.dat");

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	clear_to_color(g_Buffer,makecol(0,0,0));

	int i = 0;
	bool end = false;

	while(!end)
	{
		while((!key[KEY_ENTER]) && (!key[KEY_SPACE]))
		{
	/*		if(KeyPress(KEY_ESC))
			{
				i = 2;
				break;
			}*/

			if(KeyPress(KEY_UP))
			{
				if(i > 0)
					i--;
			}
			else if(KeyPress(KEY_DOWN))
			{
				if(i < 2)
					i++;
			}

			draw_sprite(g_Buffer, (BITMAP*)Data[HEADING].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[HEADING].dat)->w/2), 50);

			if(i == 0)
				draw_sprite(g_Buffer, (BITMAP*)Data[MAIN_NEWGAME_UP].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[MAIN_NEWGAME_UP].dat)->w/2), 250);
			else
				draw_sprite(g_Buffer, (BITMAP*)Data[MAIN_NEWGAME_DOWN].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[MAIN_NEWGAME_UP].dat)->w/2), 250);
			if(i == 1)
				draw_sprite(g_Buffer, (BITMAP*)Data[MAIN_HIGHSCORE_UP].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[MAIN_HIGHSCORE_UP].dat)->w/2), 300);
			else
				draw_sprite(g_Buffer, (BITMAP*)Data[MAIN_HIGHSCORE_DOWN].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[MAIN_HIGHSCORE_UP].dat)->w/2), 300);
			if(i == 2)
				draw_sprite(g_Buffer, (BITMAP*)Data[MAIN_EXIT_UP].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[MAIN_EXIT_UP].dat)->w/2), 350);
			else
				draw_sprite(g_Buffer, (BITMAP*)Data[MAIN_EXIT_DOWN].dat,
					(SCREEN_W/2)-(((BITMAP*)Data[MAIN_EXIT_UP].dat)->w/2), 350);

			blit(g_Buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
			clear_bitmap(g_Buffer);
					
		}

		if(i == 0)
		{
			// start new game
			QuitGame = false;
			g_iGameState = GAME_STATE_GAME;
			return true;
		}
		else if(i == 1)
		{
			// highscore screen
			DoHighScoreScreen(-1,-1);
		}
		else if(i == 2)
		{
			// quit game
			unload_datafile(Data);
			return false;
		}
	}



	return true;
}





/********************************************************************************

		DoLevelWinScreen()

	display screen for winning next level

********************************************************************************/

bool DoLevelWinScreen()
{
	// fade out previous screen
	highcolour_fade_out(14);

	// stop any other music playing
	stop_midi();

	// load Data graphics
	if(!Data)
		Data = load_datafile("data//misc//menus.dat");

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	// start music playing, choose random variation
	int num = rand()%5;
	play_midi((MIDI*)Data[MUSIC_WIN1 + num].dat,0);
	rest(650);

	// clear background and draw first Data screen and fade in/out
	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[LEVELOVER].dat, 0, 0);
	highcolour_fade_in(g_Buffer,15);
	while( (!key[KEY_SPACE]) && (!key[KEY_ENTER]) && (!key[KEY_ESC]) )
	{}
	
	// stop music
	stop_midi();

	return true;
}





/********************************************************************************

		DoGameOverScreen()

	display screen for game over (out of lives)

********************************************************************************/

bool DoGameOverScreen()
{
	// stop any other music playing
	stop_midi();

	// load Data graphics
	if(!Data)
		Data = load_datafile("data//misc//menus.dat");

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	// play game over music
	play_midi((MIDI*)Data[MUSIC_GAMEOVER].dat,0);

	clear_to_color(g_Buffer,makecol(0,0,0));

	// draw first frame and fade in
	draw_sprite(g_Buffer, (BITMAP*)Data[GAMEOVER].dat, 0, 0);
	draw_sprite(g_Buffer, (BITMAP*)Data[OPTION_YES_UP].dat,175,256);
	draw_sprite(g_Buffer, (BITMAP*)Data[OPTION_NO_DOWN].dat,197,310);
	highcolour_fade_in(g_Buffer,16);
	clear_bitmap(g_Buffer);

	int i = 0;

	while((!key[KEY_ENTER]) && (!key[KEY_SPACE]))
	{
		if(KeyPress(KEY_UP))
		{
			if(i > 0)
				i--;
		}
		else if(KeyPress(KEY_DOWN))
		{
			if(i < 1)
				i++;
		}

		draw_sprite(g_Buffer, (BITMAP*)Data[GAMEOVER].dat, 0, 0);

		if(i == 0)
			draw_sprite(g_Buffer, (BITMAP*)Data[OPTION_YES_UP].dat,	175, 256);
		else
			draw_sprite(g_Buffer, (BITMAP*)Data[OPTION_YES_DOWN].dat,175,256);
		if(i == 1)
			draw_sprite(g_Buffer, (BITMAP*)Data[OPTION_NO_UP].dat, 197, 310);
		else
			draw_sprite(g_Buffer, (BITMAP*)Data[OPTION_NO_DOWN].dat, 197, 310);

		blit(g_Buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
		clear_bitmap(g_Buffer);
				
	}

	if(i == 0)
	{
		// start new game
		highcolour_fade_out(16);
		return true;
	}
	else if(i == 1)
	{
		// quit game
		highcolour_fade_out(16);
		return false;	
	}

	return true;
}





/********************************************************************************

		DoHighScoreScreen()

	display screen current high scores

********************************************************************************/

bool DoHighScoreScreen(int score, int level)
{
	// fade out
	highcolour_fade_out(20);

	// open high score file and read in scores
	string Names[10];
	int Scores[10];
	int Level[10];

	ifstream fin;
	fin.open("data//misc//highscores.dat");

	if(fin.fail())
	{
		WriteLog("*** ERROR: Couldn't open 'misc/highscores.dat'! ***\n");
		return false;
	}

	// read in the data
	for(int i = 0; i < 10; i++)
	{
		fin >> Names[i] >> Scores[i] >> Level[i];
	}

	// load Data graphics
	if(!Data)
		Data = load_datafile("data//misc//menus.dat");

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	// get the font to draw with
	FONT *Font = (FONT*)Data[HIGHSCORE_FONT].dat;

	// if a score is passed, check if it makes the list and if so, enter playr details

	// variables for entering name
	int rank = -1;
	string  edittext;                         // an empty string for editting
	string::iterator iter = edittext.begin(); // string iterator
	int     caret  = 0;                       // tracks the text caret
	bool    insert = true;                    // true of should text be inserted

	if(score > 0)
	{
		// check if this score makes the list
		for(i = 0; i < 10; i++)
		{
			if(score > Scores[i])
			{
				// get user details
				// this input string code is code from a post on allegro.cc
				// can't remember who by tho, sorry! 
				do
				{
				  while(keypressed())
				  {
					 int  newkey   = readkey();
					 char ASCII    = newkey & 0xff;
					 char scancode = newkey >> 8;

					 // a character key was pressed; add it to the string
					 if(ASCII >= 32 && ASCII <= 126)
					 {
						 if((edittext.length() < 16) && (scancode != KEY_SPACE))
						 {
							// add the new char, inserting or replacing as need be
							if(insert || iter == edittext.end())
							   iter = edittext.insert(iter, ASCII);
							else
							   edittext.replace(caret, 1, 1, ASCII);

							// increment both the caret and the iterator
							caret++;
							iter++;
						 }
					 }
					 // some other, "special" key was pressed; handle it here
					 else
						switch(scancode)
						{
						   case KEY_DEL:
							  if(iter != edittext.end()) iter = edittext.erase(iter);
						   break;

						   case KEY_BACKSPACE:
							  if(iter != edittext.begin())
							  {
								 caret--;
								 iter--;
								 iter = edittext.erase(iter);
							  }
						   break;
            
						   case KEY_RIGHT:
							  if(iter != edittext.end())   caret++, iter++;
						   break;
            
						   case KEY_LEFT:
							   if(iter != edittext.begin()) caret--, iter--;
						   break;
            
						   case KEY_INSERT:
							  if(insert) insert = 0; else insert = 1;
						   break;

						   default:

						   break;
						}
				  }

					draw_sprite(g_Buffer, (BITMAP*)Data[HIGHSCORES_NEWSCORE].dat, 
						(SCREEN_W/2)-((BITMAP*)Data[HIGHSCORES_NEWSCORE].dat)->w/2, 90);
					draw_sprite(g_Buffer, (BITMAP*)Data[HIGHSCORES_ENTERNAME].dat, 
						(SCREEN_W/2)-((BITMAP*)Data[HIGHSCORES_ENTERNAME].dat)->w/2, 230);
					
					textout(g_Buffer, font, edittext.c_str(), SCREEN_W/2-65, SCREEN_H/2+45,makecol(255,255,255));
					vline(g_Buffer, SCREEN_W/2 + caret * 8-65, SCREEN_H/2+45-2, SCREEN_H/2+45+10, makecol(255,255,255));

					blit(g_Buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
					clear_bitmap(g_Buffer);

				}
				while(!key[KEY_ENTER]);

				if(edittext.length() <= 0)
					edittext = "______";

				while(key[KEY_ENTER]) {}

				// move rest of the list 'down' a notch 
				for(int k = 9; k > i; k--)
				{
					Names[k] = Names[k-1];
					Scores[k] = Scores[k-1];
					Level[k] = Level[k-1];
				}

				// set new scores
				Names[i] = edittext.c_str();
				Scores[i] = score;
				Level[i] = level;
				rank = i;

				// save the new score table
				std::ofstream fout;
				fout.open("data//misc//highscores.dat");
				
				for(int j = 0; j < 10; j++)
					fout << Names[j] << " " << Scores[j] << " " << Level[j] << endl;

				fout.close();			
				break;
			}
		}
	}

	clear_to_color(g_Buffer,makecol(0,0,0));

	// draw first frame and fade in
	draw_sprite(g_Buffer, (BITMAP*)Data[HIGHSCORES].dat, (SCREEN_W/2)-((BITMAP*)Data[HIGHSCORES].dat)->w/2, 0);
	draw_sprite(g_Buffer, (BITMAP*)Data[HIGHSCORES_NAME].dat, 100, 120);
	draw_sprite(g_Buffer, (BITMAP*)Data[HIGHSCORES_LEVEL].dat, 
		(SCREEN_W/2)-((BITMAP*)Data[HIGHSCORES_LEVEL].dat)->w/2, 120);
	draw_sprite(g_Buffer, (BITMAP*)Data[HIGHSCORES_SCORE].dat, SCREEN_W-180, 120);

	// draw high score table
	char c[255];
	int col = 0;
	for(i = 0; i < 10; i++)
	{		
		if(i == rank)
			col = makecol(255,255,0);
		else if(i%2)
			col = makecol(196,196,196);	
		else
			col = makecol(255,255,255);

		sprintf(c, "%s", Names[i].c_str());
		textout(g_Buffer, Font, c, 120, 170 + i*30, col);

		sprintf(c, "%d", Level[i]);
		textout_centre(g_Buffer, Font, c, SCREEN_W/2, 170 + i*30, col);

		sprintf(c, "%d", Scores[i]);
		textout_right(g_Buffer, Font, c, SCREEN_W-120, 170 + i*30, col);
	}

	highcolour_fade_in(g_Buffer,20);

	while((!key[KEY_ENTER]) && (!key[KEY_SPACE]) && (!key[KEY_ESC]))
	{
		blit(g_Buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);		
	}

	highcolour_fade_out(20);
	clear(g_Buffer);
	clear(screen);

	while((key[KEY_ENTER]) || (key[KEY_SPACE]) || (key[KEY_ESC]))
	{}

	return true;
}





/********************************************************************************

		DoGameWinScreen()

	display end game sequence

********************************************************************************/

bool DoGameWinScreen()
{
	// fade out previous screen
	highcolour_fade_out(14);
	
	// stop any other music playing
	stop_midi();

	// load Data graphics
	if(!Data)
		Data = load_datafile("data//misc//menus.dat");

	// error checking
	if((!Data) || (!g_Buffer))
		return false;

	// start music playing
	play_midi((MIDI*)Data[MUSIC_GAMEWIN1].dat,1);
	rest(1500);

	// clear background and draw first Data screen and fade in/out
	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[GAMEWIN1].dat, 
		SCREEN_W/2-((BITMAP*)Data[GAMEWIN1].dat)->w/2, 
		SCREEN_H/2-((BITMAP*)Data[GAMEWIN1].dat)->h/2);
	highcolour_fade_in(g_Buffer,15);
	rest(6000);
	highcolour_fade_out(14);
	
	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[GAMEWIN2].dat, 
		SCREEN_W/2-((BITMAP*)Data[GAMEWIN2].dat)->w/2, 
		SCREEN_H/2-((BITMAP*)Data[GAMEWIN2].dat)->h/2);
	highcolour_fade_in(g_Buffer,15);
	rest(3000);
	highcolour_fade_out(14);

	stop_midi();
	play_midi((MIDI*)Data[MUSIC_GAMEWIN2].dat,1);
	rest(400);

	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[GAMEWIN3].dat, 
		SCREEN_W/2-((BITMAP*)Data[GAMEWIN3].dat)->w/2, 
		SCREEN_H/2-((BITMAP*)Data[GAMEWIN3].dat)->h/2);
	highcolour_fade_in(g_Buffer,15);
	rest(10000);
	highcolour_fade_out(14);

	clear_to_color(g_Buffer, makecol(0,0,0));
	draw_sprite(g_Buffer, (BITMAP*)Data[GAMEWIN4].dat, 
		SCREEN_W/2-((BITMAP*)Data[GAMEWIN4].dat)->w/2, 
		SCREEN_H/2-((BITMAP*)Data[GAMEWIN4].dat)->h/2);
	draw_sprite(g_Buffer, (BITMAP*)Data[GAMEWIN5].dat, 
		SCREEN_W/2-((BITMAP*)Data[GAMEWIN5].dat)->w/2, 
		SCREEN_H/2-((BITMAP*)Data[GAMEWIN5].dat)->h/2+100);
	highcolour_fade_in(g_Buffer,15);
	rest(5000);
	highcolour_fade_out(10);

	return true;
}
