
/*
 *	Game.h
 *
 *	Header file for Game.cpp.
 *	Contains function prototypes for the main game loop
 *	elements.
 *
 */



// Global Variables ///////////////////////////////////////////////////


// game can be in one of these states, determines what to do
#define GAME_STATE_GAME		 0
#define GAME_STATE_EDIT		 1
#define GAME_STATE_QUIT		 2

// we need to know what state we are in and what the last one was as well
extern int g_iGameState;				// variable holding current game state
extern int g_iPrevGameState;			// variable holding previous game state

extern bool g_bShowFPS;					// bool deciding whether to show FPS

#define MAX_ENEMYS		100
#define MAX_ITEMS		100
class CEnemy;
class CItem;
extern CEnemy Enemys[MAX_ENEMYS];
extern CItem Items[MAX_ITEMS];
extern DATAFILE *StickDudeGFX;
extern DATAFILE *RedDude;
extern DATAFILE *GreenDude;
extern DATAFILE *YellowDude;
extern DATAFILE *GreyDude;
extern DATAFILE *Item;
extern DATAFILE *Music;
extern CTilemap Map;



// Function Prototypes ////////////////////////////////////////////////

extern bool InitGame();
extern bool ShutdownGame();
extern bool GameGraphicsLoop();
extern bool GameLogicLoop();
extern bool AddEnemy(float fPosX, float fPosY, int iType, bool bDir);
extern bool RemoveEnemy(int i);
extern bool AddItem(float fPosX, float fPosY, int iType);
extern bool RemoveItem(int i);
