
/*
 * CEnemy.cpp
 *
 * Implimentation of CEnemy class.
 *
 */

#include <fstream>
#include <allegro.h>
#include "CViewport.h"
#include "CTileset.h"
#include "CTilemap.h"
#include "CBaseObject.h"
#include "CEnemy.h"



/*****************************************************************************

		Update()

	virtual update function, update AI, movement, etc

*****************************************************************************/

bool CEnemy::Update()
{
	// only update if object has been seen
	if(!m_bSeen)
		return true;

	switch(m_iAiType)
	{
		case AI_RUNNER: // runs left and right, bounces off walls, falls off edges
			{				
				if(HitWall())
					m_bMoveRight = !m_bMoveRight;

				if(m_bMoveRight)
					MoveRight();
				else 
					MoveLeft();

			} break;

		case AI_JUMPER: // stands on spot and jumps
			{
				Jump();

			} break;

		case AI_RUNJUMPER: // runs and jumps left and right, bounces off walls, falls of edfes
			{
				if(HitWall())
					m_bMoveRight = !m_bMoveRight;

				if(m_bMoveRight)
					MoveRight();
				else 
					MoveLeft();

				Jump();

			} break;

		case AI_FLIER: // flies left and right, not affected by gravity
			{
				if(HitWall())
					m_bMoveRight = !m_bMoveRight;

				if(m_bMoveRight)
					MoveRight();
				else 
					MoveLeft();

			} break;

		case AI_SMARTRUNNER:  // runs left and right, bounces of walls, doesnt fall of edges
			{
				int iScrollX = GetMap()->Viewport.GetScrollX();
				int iScrollY = GetMap()->Viewport.GetScrollY();
				int iTileX = (GetPosX()) / TILE_SIZE;
				int iTileY = (GetPosY()) / TILE_SIZE;
				int Tile;

				if(HitWall())
					m_bMoveRight = !m_bMoveRight;

				if(m_bMoveRight)
				{
					Tile = GetMap()->GetTileType(iTileX+1, iTileY+1);
					if(Tile == TILE_TYPE_CLEAR)
						m_bMoveRight = !m_bMoveRight;
				}
				else
				{
					Tile = GetMap()->GetTileType(iTileX, iTileY+1);
					if(Tile == TILE_TYPE_CLEAR)
						m_bMoveRight = !m_bMoveRight;
				}

				if(m_bMoveRight)
					MoveRight();
				else 
					MoveLeft();

			} break;

		default: break;

	}

	// run base class update function
	CBaseObject::Update();

	return true;
}





/*****************************************************************************

		Reset()

	virtual reset function, reset all variables to default values

*****************************************************************************/

void CEnemy::Reset()
{
	// run base class reset function
	CBaseObject::Reset();	

	// set the correct animation data
	m_Animations[ANIM_STAND].FirstFrame = 0;
	m_Animations[ANIM_STAND].LastFrame = 0;
	m_Animations[ANIM_STAND].FrameDelay = 5;
	m_Animations[ANIM_STAND].Loop = true;
	m_Animations[ANIM_MOVE].FirstFrame = 1;
	m_Animations[ANIM_MOVE].LastFrame = 8;
	m_Animations[ANIM_MOVE].FrameDelay = 5;
	m_Animations[ANIM_MOVE].Loop = true;
	m_Animations[ANIM_JUMP].FirstFrame = 9;
	m_Animations[ANIM_JUMP].LastFrame = 9;
	m_Animations[ANIM_JUMP].FrameDelay = 5;
	m_Animations[ANIM_JUMP].Loop = true;
	m_Animations[ANIM_FALL].FirstFrame = 10;
	m_Animations[ANIM_FALL].LastFrame = 10;
	m_Animations[ANIM_FALL].FrameDelay = 5;
	m_Animations[ANIM_FALL].Loop = true;
	m_Animations[ANIM_DAMAGE].FirstFrame = 11;
	m_Animations[ANIM_DAMAGE].LastFrame = 11;
	m_Animations[ANIM_DAMAGE].FrameDelay = 5;
	m_Animations[ANIM_DAMAGE].Loop = true;

	m_bSeen = false;
	m_iType = 0;
	m_iAiType = 0;
	m_bMoveRight = false;

	// set object to 'enemy' type
	SetType(TYPE_ENEMY);

}





/*****************************************************************************

		TakeDamage()

	make Enemy take damage

*****************************************************************************/

void CEnemy::TakeDamage(int Type)
{
	switch(Type)
	{
		case DAMAGE_LEVEL:
			{

			} break;

		case DAMAGE_OBJECT:
			{		

			} break;

		default: break;
	}


}
