
/*
 *	CBaseObject.h
 *
 *	Header file for CBaseObject class.
 *	This class is used as the base for all enemies, players, 
 *	etc, and not to be used by itself.
 *
 */

// data for animations
#define MAX_ANIMS			5
#define ANIM_STAND			0
#define ANIM_MOVE			1
#define ANIM_JUMP			2
#define ANIM_FALL			3
#define ANIM_DAMAGE			4

// types of damage
#define DAMAGE_LEVEL		0
#define DAMAGE_OBJECT		1

// different types of object
#define TYPE_PLAYER			0
#define TYPE_ENEMY			1
#define TYPE_ITEM			2


// animation struct, used to hold data for each animation
struct ANIMATION
{
	int FirstFrame;		// first frame in the animation
	int LastFrame;		// last frame in the animation
	int FrameDelay;		// delay in game cycles between next frame and current
	bool Loop;			// true if animation loops, otherwise it stops at last frame
};



// Classes ///////////////////////////////////////////////////

class CBaseObject
{

public:

	CBaseObject()					{ Reset();							}
	~CBaseObject()					{}

	virtual bool Update();
	virtual bool Draw(BITMAP *b);
	virtual void Reset();

	void SetPos(float x, float y)	{ m_fPosX = x; m_fPosY = y;			}
	void SetAccel(float x, float y)	{ m_fAccelX = x; m_fAccelY = y;		}
	void SetSize(float x, float y)	{ m_fWidth = x; m_fHeight = y;		}
	void SetVel(float x, float y)	{ m_fVelX = x; m_fVelY = y;			}
	void SetMaxVel(float x, float y){ m_fMaxVelX = x; m_fMaxVelY = y;	}
	void SetGravity(float g)		{ m_fGravity = g; m_bGravityAffected = true;	}
	void SetActive(bool a)			{ m_bActive = a;					}
	bool GetActive()				{ return m_bActive;					}
	void SetMap(CTilemap &m)		{ m_pCurrentMap = &m;				}
	bool SetAnim(int i);
	void SetDatafile(DATAFILE *d)	{ if(!d) return; m_dfDatafile = d;	}
	void SetDirX(bool d)			{ m_bFaceRight = d;					}

	float GetPosX()					{ return m_fPosX;					}
	float GetPosY()					{ return m_fPosY;					}
	float GetVelX()					{ return m_fVelX;					}
	float GetVelY()					{ return m_fVelY;					}
	float GetAccelX()				{ return m_fAccelX;					}
	float GetAccelY()				{ return m_fAccelY;					}
	float GetWidth()				{ return m_fWidth;					}
	float GetHeight()				{ return m_fHeight;					}
	int GetType()					{ return m_iType;					}
	bool GetDirX()					{ return m_bFaceRight;				}
	CTilemap *GetMap()				{ return m_pCurrentMap;				}

	// functions allowing object to be moved
	void MoveLeft()					{	m_fVelX -= m_fAccelX;
										m_bFaceRight = false;			
										if(m_fVelX < -m_fMaxVelX)
											m_fVelX = -m_fMaxVelX;	
										m_bMovedLeft = true;			}
	void MoveRight()				{	m_fVelX += m_fAccelX;
										m_bFaceRight = true;		
										if(m_fVelX > m_fMaxVelX)
											m_fVelX = m_fMaxVelX;		
										m_bMovedRight = true;			}
	void Jump()						{	if(m_bLockJump)	return;
										m_bJumped = true;
										m_fVelY -= m_fAccelY;
										m_bLockJump = true;				}
										
	DATAFILE *m_dfDatafile;				// this data is used for animation		
	ANIMATION m_Animations[MAX_ANIMS];	
	int m_iCurrentFrame;	 
	int m_iCurrentAnim;		
	int m_iCurrentDelayTimer;	

	bool m_bDrawDamaged;

	void SetType(int t)				{ m_iType = t;						}
	bool HitWall()					{ return m_bHitWall;				}
	
	bool CheckObjectCollision(CBaseObject *o);
	bool CheckPointCollision(float fPosX, float fPosY);

	void SetOffset(float x, float y){ m_fOffsetX = x; m_fOffsetY = y;	}
	float GetOffsetX()				{ return m_fOffsetX;				}
	float GetOffsetY()				{ return m_fOffsetY;				}

	bool HasJumped()				{ return m_bLockJump;				}

private:

	bool CheckMapCollision();
	
	void UpdateAnim();

	virtual void TakeDamage(int Type);	// handled by child classes
	
	int collision_hor(int x, int y, int w, int &tilecoordy);
	int collision_ver(int x, int y, int w, int &tilecoordx);

	float m_fPosX;
	float m_fPosY;

	float m_fWidth;
	float m_fHeight;

	float m_fAccelX;
	float m_fAccelY;

	float m_fVelX;
	float m_fVelY;

	float m_fMaxVelX;
	float m_fMaxVelY;

	float m_fOffsetX;
	float m_fOffsetY;

	bool m_bActive;
	bool m_bLockJump;
	bool m_bFaceRight;
	bool m_bGravityAffected;
	float m_fGravity;

	int m_iType;

	bool m_bMovedLeft;
	bool m_bMovedRight;	
	bool m_bJumped;
	bool m_bHitWall;		// needed for ai

	CTilemap *m_pCurrentMap;

};
