/*
   Stehovak3D

   semestralni prace Michala Molhance 1. rocnik, skupina 5

   molsoft.hyperlink.cz
*/
// Tento soubor obsahuje vlastni tridu Aplikace

#include "common.h"
#include "gfx.h"
#include "eventmng.h"
#include "levels.h"
#include "app.h"
#include "hrac.h"

namespace {
	const float KROK = -0.05f;	// Krok pouzivany pri ovladani pohledu
//	const int DEFAULTZ = 25;	// Standardni vzdalenost pohledu o hraci plochy
	const int DEFAULTZ = 10;	// Standardni vzdalenost pohledu o hraci plochy
}

/****************************************************************************
	SokoApp::run
   ~~~~~~~~~~~~
	Spusti vlastni hru -- provadi vlastni aplikacni smycku.
****************************************************************************/
void SokoApp::run()
{
   Udalost u;
   Hrac hrac(gfx);
   float x=0, y=0, z=DEFAULTZ;
   int leveln = 0;
   hrac.assign(levely[leveln]);
   bool need_new_aligned = true;
   do {
  		hrac.generate_3D_objects();
      if (need_new_aligned) {
      	gfx.move3D(x, y, z, 0-x, 0-y, -1, 0, 1, 0);
         need_new_aligned = false;
      }
		gfx.draw3DwithAnim();
      gfx.swap();
		if (hrac.zbyva_cilu()==0 && leveln<levely.size()-1) { // vyhrali jsme?
	      ++leveln;
         u = restart;
      } else
		   u = eventmng.wait_for_event();
      switch (u) {
      	// pohyb hrace
      	case vlevo : 	hrac.move_left(); break;
      	case vpravo : 	hrac.move_right(); break;
      	case nahoru : 	hrac.move_up(); break;
      	case dolu : 	hrac.move_down(); break;
         // ovladani pohledu
      	case plusP : 	z += KROK; need_new_aligned = true; break;
         case minusP : 	z -= KROK; need_new_aligned = true; break;
         case vlevoP : 	x -= KROK; need_new_aligned = true; break;
         case vpravoP : x += KROK; need_new_aligned = true; break;
         case nahoruP : y += KROK; need_new_aligned = true; break;
         case doluP : 	y -= KROK; need_new_aligned = true; break;
         case hvezdaP : x=0; y=0; z=DEFAULTZ; need_new_aligned = true; break;
         // prochazeni levely
         case vpred : 	if (leveln < levely.size()-1 &&
         						eventmng.time_for_move()) ++leveln;
                           hrac.assign(levely[leveln]); break;
         case vzad : 	if (leveln > 0 && eventmng.time_for_move()) --leveln;
         						hrac.assign(levely[leveln]); break;
         // zobrazeni pomocne site bodu
         case debug : debugflag = !debugflag; need_new_aligned = true; break;
         // zobrazeni pocitace snimku za sekundu
         case fps : fpsflag = !fpsflag; break;
			// uloz obrazek
         case save_pict : gfx.save_screen_to_file(); break;
         // pomocne fce pro ovladani panacka
         case undo : 	hrac.undo(); break;
         case restart : hrac.assign(levely[leveln]); break;
         // zmena poctu animacni fazi panacka => zmena rychlosti
         case vicframu : if (eventmng.time_for_move()) gfx.moreframes(); break;
         case minframu : if (eventmng.time_for_move()) gfx.lessframes(); break;
      }
   } while (u != konec);
}

/****************************************************************************
	konstruktor
   ~~~~~~~~~~~
   Nastavi vnitrni promenne: gfx, eventmng a levely podle parametru.
****************************************************************************/
SokoApp::SokoApp(GFX& g, EventMng& em, Levely& l) :
	gfx(g),
   eventmng(em),
   levely(l)
{
}
