{ Stehovak3D : Semestralni prace Michala Molhance, 1. rocnik, 5. skupina }
{ Leveleditor }

{ tato unita obsahuje editor levelu }
unit LevEd;

interface

{ spusti editor levelu; parametrem je nazev souboru s levely }
procedure leveledit_run(const jmeno : string);















implementation
uses common, eventmng, gfx, graph, mys;

var currlev : integer; { aktualni level }
    filename : string; { nazev souboru s levely }

{ vypise informace o souboru levlu, cislo prave editovaneho
  a strucna napoveda pro klavesy }
procedure drawleveleditinfo;
const KAM = 522;
      BARVA = 149;
var i : integer;
    s : string;
begin
  setfillstyle(solidfill, 0);
  bar(KAM, 280, getmaxx-12, 340);
  setlittfont;
  outtextxy(KAM, 260, 'Soubor:');
  outtextxy(KAM, 270, '~~~~~~~');
  outtextxy(KAM, 280, filename);
  i := nlevel;
  str(i, s);
  s := 'Level: ' + s;
  outtextxy(KAM, 290, s);
  str(currlev, s);
  s := 'Aktuln level: ' + s;
  outtextxy(KAM, 300, s);
  outtextxy(KAM, 340, 'PgUp - nsledujc');
  outtextxy(KAM, 350, 'PgDn - pedchoz');
  outtextxy(KAM, 370, 'F1 - nov level');
  outtextxy(KAM, 380, 'F2 - ulo levely');
  outtextxy(KAM, 390, 'F3 - obnov levely');
  outtextxy(KAM, 410, 'F5 - przdn pole');
  outtextxy(KAM, 420, 'F6 - ze');
  outtextxy(KAM, 430, 'F7 - panek');
  outtextxy(KAM, 440, 'F8 - krabice');
  outtextxy(KAM, 450, 'F9 - cl');
end;

var cursor : record x, y : integer end; { informace o umisteni kurzoru }

{ ukaze kurzor na novych souradnicich predanych jako parametr
  a tyto nove souradnice uchova do promenne kurzor; zobrazi mys }
procedure showcursor(x, y : integer);
begin
  setfillstyle(emptyfill, 26);
  setcolor(170);
  rectangle(kolik+strana*(x-1), kolik+strana*(y-1), kolik+strana*x,
    kolik+strana*y);
  cursor.x := x;
  cursor.y := y;
  showmys;
end;

{ skryje kurzor i mys }
procedure hidecursor;
var x,y : integer;
begin
  hidemys;
  setfillstyle(emptyfill, 15);
  setcolor(15);
  with cursor do
    rectangle(kolik+strana*(x-1), kolik+strana*(y-1), kolik+strana*x,
      kolik+strana*y);
end;

{ vytvori novy level }
procedure createnewlevel;
var i,j : integer;
begin
  if nlevel = MAXLEVELS then
    exit;
  inc(nlevel);
  for i := 1 to Yn do
    for j := 1 to Xn do
      levels[nlevel][i,j] := prazdne;
end;

{ spusti editor levelu; parametrem je nazev souboru s levely }
procedure leveledit_run(const jmeno : string);
var konec : boolean;
    event : events;
    x, y  : word;
    last  : pole;       { posledni pouzity druh policka }
begin
  drawmainlayout;
  filename := jmeno;
  loadlevelfromfile(filename);
  currlev := 1;
  last := zed;

  if nlevel = 0 then { pokud zadny level neexistuje, vytvor aspon 1 }
    createnewlevel;

  drawleveleditinfo;
  drawlevel(currlev);
  konec := false;
  showcursor(1, 1); { zobraz kurzor na 1 policko }
  repeat
    event := waitforevent;
    case event of
      vlevo : if cursor.x > 1 then begin hidecursor;
              showcursor(cursor.x-1, cursor.y); end;
      vpravo : if cursor.x < Xn then begin hidecursor;
              showcursor(cursor.x+1, cursor.y); end;
      nahoru : if cursor.y > 1 then begin hidecursor;
              showcursor(cursor.x, cursor.y-1); end;
      dolu : if cursor.y < Yn then begin hidecursor;
              showcursor(cursor.x, cursor.y+1); end;
      zpet : konec := true;
      F1   : begin createnewlevel; currlev := nlevel; drawleveleditinfo;
             drawlevel(currlev); showcursor(1, 1); end;
      F2   : saveleveltofile(filename);
      F3   : begin loadlevelfromfile(filename); currlev := 1;
             drawleveleditinfo; drawlevel(currlev); showcursor(1, 1); end;
      F5   : begin levels[currlev][cursor.y, cursor.x] := prazdne; last := prazdne;
             drawlevel(currlev); showcursor(cursor.x, cursor.y); end;
      F6   : begin levels[currlev][cursor.y, cursor.x] := zed; last := zed;
             drawlevel(currlev); showcursor(cursor.x, cursor.y); end;
      F7   : begin levels[currlev][cursor.y, cursor.x] := panacek; last := panacek;
             drawlevel(currlev); showcursor(cursor.x, cursor.y); end;
      F8   : begin levels[currlev][cursor.y, cursor.x] := krabice; last := krabice;
             drawlevel(currlev); showcursor(cursor.x, cursor.y); end;
      F9   : begin levels[currlev][cursor.y, cursor.x] := cil; last := cil;
             drawlevel(currlev); showcursor(cursor.x, cursor.y); end;
      zvys : if currlev < nlevel then begin inc(currlev);
             drawlevel(currlev); showcursor(1, 1); drawleveleditinfo; end;
      sniz : if currlev > 1 then begin dec(currlev);
             drawlevel(currlev); showcursor(1, 1); drawleveleditinfo; end;
      pohyb: begin novesouradnice(x, y); dec(x, kolik); dec(y, kolik);
             x:=x div strana+1; y:=y div strana+1;
             if (x<=Xn) and (y<=Yn) then begin hidecursor;
             showcursor(x, y); end end;
      OK   : begin levels[currlev][cursor.y, cursor.x] := last;
             drawlevel(currlev); showcursor(cursor.x, cursor.y); end;
    end;
  until konec;
end;

end.