{ Stehovak3D : Semestralni prace Michala Molhance, 1. rocnik, 5. skupina }
{ Leveleditor }

{ tato unita obsahuje pomocne funkce pro praci s mysi }
unit Mys;

interface

{ inicializace mysi, vytvoreni kurzoru ap. }
procedure initmys;

{ vypne mys, zrusi kurzor }
procedure donemys;

{ ,,pollovani'' nutno casto volat, aby se pohyboval kurzor }
procedure pollmys;

{ skova mys }
procedure hidemys;

{ ukaze mys }
procedure showmys;

{ jestlize bylo zmacknuto tlacitko mysi vrati true a naplni x a y
  souradnicemi mysiho kurzoru a left naplni true pokud to bylo leve
  tlacitko jinak bude left false }
function pressedmys(var x, y : word; var left : boolean) : boolean;






















implementation
uses graph, dos;

var kurzor : pointer;   { uchovava obrazek ukazatele mysi }
    oldx   : word;      { posledni zjistene souradnice mysi }
    oldy   : word;
    showed : boolean;   { true, kdyz je kurzor mysi zobrazen }

{ jestlize bylo zmacknuto tlacitko mysi vrati true a naplni x a y
  souradnicemi mysiho kurzoru a left naplni true pokud to bylo leve
  tlacitko jinak bude left false }
function pressedmys(var x, y : word; var left : boolean) : boolean;
var regs : registers;
begin
  pressedmys := false;
  regs.ax := 3;
  intr($33, regs); { zjisti stav mysi }
  left := (regs.bx and 1) <> 0;  { leve }
  if left or ((regs.bx and 2) <> 0) then begin  { leve nebo prave }
    x := regs.cx div 8 + 10;
    y := regs.dx div 8 + 10;
    pressedmys := true;
  end;
end;

{ ,,pollovani'' nutno casto volat, aby se pohyboval kurzor }
procedure pollmys;
var x, y : word;
    regs : registers;
begin
  regs.ax := 3;
  intr($33, regs);
  x := regs.cx div 8;
  y := regs.dx div 8;
  if (x <> oldx) or (y <> oldy) then begin
    hidemys;
    oldx := x;
    oldy := y;
    showmys;
  end;
end;

{ skova mys }
procedure hidemys;
begin
  if showed then begin
    putimage(oldx, oldy, kurzor^, xorput);
    showed := false;
  end;
end;

{ ukaze mys }
procedure showmys;
begin
  if not showed then begin
    putimage(oldx, oldy, kurzor^, xorput);
    showed := true;
  end;
end;

{ inicializace mysi, vytvoreni kurzoru ap. }
procedure initmys;
begin
  asm
    mov ax, 21h         { reset }
    int 33h
    mov ax, 0Fh         { rychlost }
    mov cx, 3
    mov dx, 3
    int 33h
    mov ax, 07          { horizontalni rozsah }
    xor cx, cx
    mov dx, 1400h       { 640*8 }
    int 33h
    mov ax, 08          { vertikalni rozsah }
    xor cx, cx
    mov dx, 0F00h       { 480*8 }
    int 33h
  end;
  cleardevice;          { vykresleni kurzoru }
  setcolor(14);
  line(10, 0, 10, 20);
  line(0, 10, 20, 10);
  getmem(kurzor, imagesize(0, 0, 20, 20));
  getimage(0, 0, 20, 20, kurzor^);
  oldx := 0;
  oldy := 0;
  showed := false;
end;

{ vypne mys, zrusi kurzor }
procedure donemys;
begin
  hidemys;
  freemem(kurzor, imagesize(0, 0, 20, 20));
end;

end.