{ Stehovak3D : Semestralni prace Michala Molhance, 1. rocnik, 5. skupina }
{ Leveleditor }

{ tato unita obsahuje pomocne funkce pro praci s grafikou }
unit GFX;

interface

{ inicializuje grafiku, nacte fonty }
procedure initgfx;

{ zavre grafiku }
procedure donegfx;

{ precte soubor s paletou (predany jako parametr bez pripony) a nastavi ji }
procedure setpal(s : string);

{ procedura nastavi cesky litt font }
procedure setlittfont;





implementation
uses graph, dos;

var lcomfont, littfont : integer;

{$I svga256.inc}
{$I svgautil.inc}

{ precte soubor s paletou (predany jako parametr bez pripony) a nastavi ji }
procedure setpal(s : string);
var f     : file of byte;
    pal   : dacpalette256;
    i     : integer;
begin
  assign(f, s+'.pal');        { paleta }
  reset(f);
  for i := 0 to 255 do begin
    read(f, pal[i, 0]);
    pal[i, 0] := pal[i, 0] shr 2;
    read(f, pal[i, 1]);
    pal[i, 1] := pal[i, 1] shr 2;
    read(f, pal[i, 2]);
    pal[i, 2] := pal[i, 2] shr 2;
  end;
  close(f);
  SetVGAPalette256(pal);
end;

{ inicializuje grafiku, nacte fonty }
procedure initgfx;
var graphdriver : integer;
    graphmode   : integer;
begin
  graphdriver := installuserdriver('SVGA256', nil);
  if graphdriver = grerror then
    halt(1);

  graphmode := SVGA640x480x256;
  initgraph(graphdriver, graphmode, '');
  if graphresult <> grok then
    halt(1);

  lcomfont := installuserfont('lcom');
  littfont := installuserfont('litt');
end;

{ zavre grafiku }
procedure donegfx;
begin
  closegraph;
end;

{ procedura nastavi cesky litt font }
procedure setlittfont;
begin
  settextstyle(littfont, 0, 4);
end;

end.