{ Stehovak3D : Semestralni prace Michala Molhance, 1. rocnik, 5. skupina }
{ Leveleditor }

{ tato unita obsahuje obecne funkce pouzitelne i mimo leveleditor }
unit Common;

interface

{ nakresli zakladni layout (ramecky, texty ap.) }
procedure drawmainlayout;

{ nacte soubor s levely }
procedure loadlevelfromfile(s : string);

{ zapise soubor s levely }
procedure saveleveltofile(s : string);

{ zobrazi dany level }
procedure drawlevel(n : integer);

const MAXLEVELS = 10; { maximalni pocet levelu v 1 souboru }
      Xn        = 19; { pocet poli vodorovne }
      Yn        = 18; { pocet poli svisle }
      strana    = 25; { delka strany pole v pixelech }
      kolik     = 11; { sirka ramecku }

type pole  = (prazdne, zed, panacek, krabice, cil);
     level = array[1..Yn, 1..Xn] of pole;

var levels  : array[1..MAXLEVELS] of level; { pole levelu }
    nlevel  : integer; { pocet levelu }
















implementation
uses gfx, graph, crt, mys;

const ODKUD = 15; { index barvy od ktere se maji kreslit ramecky }
      PRPRPR = 500; { prostredek prostredniho pruhu }

{ nakresli zakladni layout (ramecky, texty ap.) }
procedure drawmainlayout;
var i : integer;
    kamx, kamy : word;
begin
  hidemys;
  cleardevice;
  setpal('stdpal');

  {levy pruh}
  for i := 0 to KOLIK do begin
    setcolor(ODKUD+i);
    line(i, i, i, getmaxy-i);
  end;

  {horni pruh}
  for i := 0 to KOLIK do begin
    setcolor(ODKUD+i);
    line(i, i, getmaxx-i, i);
  end;

  {dolni pruh}
  for i := 0 to KOLIK do begin
    setcolor(ODKUD+i);
    line(i, getmaxy-i, getmaxx-i, getmaxy-i);
  end;

  {pravy pruh}
  for i := 0 to KOLIK do begin
    setcolor(ODKUD+i);
    line(getmaxx-i, i, getmaxx-i, getmaxy-i);
  end;

  {prostredni pruh}
  for i := 0 to KOLIK do begin
    setcolor(ODKUD+i);
    line(PRPRPR-i, i, PRPRPR-i, getmaxy-i);
  end;
  for i := 0 to KOLIK do begin
    setcolor(ODKUD+i);
    line(PRPRPR+i, i, PRPRPR+i, getmaxy-i);
  end;

  setlittfont;
  setusercharsize(2, 1, 2, 1);
  setcolor(170);
  kamx := prprpr+kolik+1;
  kamy := textheight('H');
  outtextxy(kamx, 30,        'Sthovk3D');
  outtextxy(kamx, 30+kamy,   '~~~~~~~~~~');
  outtextxy(kamx, 30+kamy*2, '  editor  ');
  outtextxy(kamx, 30+kamy*3, '  level  ');
  setusercharsize(1, 1, 1, 1);
  inc(kamx);
  kamy := textheight('H');
  outtextxy(kamx, 30+kamy*10, '  Michal Molhanec  ');
  outtextxy(kamx, 30+kamy*11, ' semestln  prce ');
  outtextxy(kamx, 30+kamy*13, ' vytvoeno  pomoc ');
  outtextxy(kamx, 30+kamy*14, ' Borland Pascalu 7 ');
  outtextxy(kamx, 30+kamy*16, '    esk fonty    ');
  outtextxy(kamx, 30+kamy*17, '  (c) OCSoftware   ');
  outtextxy(kamx, 30+kamy*19, '  SVGA256 BGI (c)  ');
  outtextxy(kamx, 30+kamy*20, ' Jordan Hargraphix ');
  showmys;
end;

{ nacte soubor s levely }
procedure loadlevelfromfile(s : string);
var f    : file of level;
begin
  nlevel := 0;
  assign(f, s);
  {$I-}
  reset(f);
  {$I+}
  if ioresult <> 0 then
    exit;
  while not eof(f) do begin
    inc(nlevel);
    read(f, levels[nlevel]);
  end;
  close(f);
end;

{ zapise soubor s levely }
procedure saveleveltofile(s : string);
var f : file of level;
    i : integer;
begin
  assign(f, s);
  rewrite(f);
  for i := 1 to nlevel do
    write(f, levels[i]);
  close(f);
end;

{ zobrazi dany level }
procedure drawlevel(n : integer);
var i, j : integer;
    l    : level;
begin
  hidemys;
  setcolor(15);
  l := levels[n];
  for i := 1 to Yn do
    for j := 1 to Xn do begin
      case l[i,j] of
        prazdne : setfillstyle(solidfill, 0);
        zed : setfillstyle(solidfill, 50);
        panacek : setfillstyle(solidfill, 182);
        krabice : setfillstyle(solidfill, 218);
        cil : setfillstyle(solidfill, 243);
      end;
      bar3d((j-1)*strana+kolik, (i-1)*strana+kolik,
              j*strana+kolik,     i*strana+kolik,  0, true);
    end;
end;

end.
