/*
   Stehovak3D

   semestralni prace Michala Molhance 1. rocnik, skupina 5

   molsoft.hyperlink.cz
*/
// Tento soubor obsahuje implementaci tridy Hrac

#include "common.h"
#include "gfx.h"
#include "levels.h"
#include "hrac.h"

/****************************************************************************
	Hrac::assign
   ~~~~~~~~~~~~
   Priradi hraci novy level, predany jako parametr.
   Meni atribut lev a nuluje atribut zaloha.
****************************************************************************/
void Hrac::assign(Level& l)
{
	lev = l;
   if (zaloha) {
   	delete zaloha;
      zaloha = NULL;
   }
}

/****************************************************************************
	konstruktor
   ~~~~~~~~~~~
   Vynuluje atribut zaloha, priradi vnitrnimu atributu gfx referenci
   ziskanou jako parametr.
****************************************************************************/
Hrac::Hrac(GFX& g) :
	zaloha(NULL),
   gfx(g)
{
}

/****************************************************************************
	destruktor
   ~~~~~~~~~~
   Zrusi atribut zaloha.
****************************************************************************/
Hrac::~Hrac()
{
	if (zaloha)
   	delete zaloha;
}

/****************************************************************************
   Hrac::zaloz
   ~~~~~~~~~~~
   Vytvori zalohu aktualniho stavu levelu pro undo. Pred tim zrusi starou
   zalohu, pokud existuje. Zaloha je vytvorena jednoduse kopii atributu lev.
   Meni atribut zaloha.
****************************************************************************/
void Hrac::zaloz()
{
	if (zaloha)
   	delete zaloha;
   zaloha = new Level(lev);
}

/****************************************************************************
   Hrac::undo
   ~~~~~~~~~~
   Vrati stav hry do podoby, jaka je uchovana v atributu zaloha (pokud
   je naplnen) a zalohu zrusi.
   Meni atributy zaloha a lev.
****************************************************************************/
void Hrac::undo()
{
	if (zaloha) {
   	lev = *zaloha;
      delete zaloha;
      zaloha = NULL;
   }
}

/****************************************************************************
   Hrac::getold
   ~~~~~~~~~~~~
   Vrati druh policka ktery byl puvodne na miste, kde je dnes policko p
   predane jako parametr. Pokud je na p cil_a_krabice, pak se zvetsi
   pocet nezaplnenych cilu, protoze to znamena, ze panacek posouva krabici
   z cile.
   Meni lev.cilu.
****************************************************************************/
Pole Hrac::getold(Pole p)
{
	if (p==cil_a_panacek)
	   return cil;
   if (p==cil_a_krabice) {
   	lev.cilu++;
   	return cil;
   }
 	return prazdne;
}

/****************************************************************************
	Hrac::getnew
   ~~~~~~~~~~~~
   Vrati druh policka, ktere vznikne kombinaci druhu policek p a q predanych
   jako parametr. Pokud ma byt novym polickem cil_a_krabice, pak se snizi
   pocet nezaplnenych cilu, nebot to znamena, ze panacek posouva krabici
   na cil.
   Meni lev.cilu.
****************************************************************************/
Pole Hrac::getnew(Pole p, Pole q)
{
	if ( (p==prazdne && q==panacek) ||
   	  (p==panacek && q==prazdne) )
   	return panacek;
      
   if ( (p==cil && q==panacek) ||
   	  (p==panacek && q==cil) )
   	return cil_a_panacek;

	if ( (p==cil && q==krabice) ||
   	  (p==krabice && q==cil) ) {
      lev.cilu--;
   	return cil_a_krabice;
   }
   return krabice;	// posledni moznost je prazdne a krabice
}

/****************************************************************************
	Hrac::isfree
   ~~~~~~~~~~~~
   Vrati true, pokud je policko predane jako parametr prazdne.
****************************************************************************/
bool Hrac::isfree(Pole p)
{
	if (p==prazdne || p==cil)
   	return true;
   return false;
}

/****************************************************************************
	Hrac::isbox
   ~~~~~~~~~~~
   Vrati true, pokud je na policku predanem jako parametr krabice.
****************************************************************************/
bool Hrac::isbox(Pole p)
{
	if (p==krabice || p==cil_a_krabice)
   	return true;
   return false;
}

/****************************************************************************
	Hrac::move
   ~~~~~~~~~~
   Pokusi se umistit hrace na nove policko, ktere je od soucasneho policka
   hrace (lev.hx, lev.hy) vzdaleno o smerx ve vodorovnem a o smery
   ve svislem smeru. Pokud je na novem policku krabice, pokusi se posunout
   i ji. Aktualizuje zalohu pro undo. Vrati true, pokud se posunuti podari.
   Meni lev.hx, lev.hy, lev.
****************************************************************************/
bool Hrac::move(int smerx, int smery)
{
	int novex = lev.hx + smerx;
   int novey = lev.hy + smery;
   if (novex<0 || novex==Xn || novey<0 || novey==Yn) return false;
   Pole& nove = lev[novey][novex];
   Pole& stare = lev[lev.hy][lev.hx];
   if (isbox(nove)) {
   	int novenovex = novex + smerx;
      int novenovey = novey + smery;
	   if (novenovex>=0 || novenovex<Xn || novenovey>=0 || novenovey<Yn) {
	      Pole& novenove = lev[novenovey][novenovex];
   	   if (isfree(novenove)) {
            zaloz();
				novenove = getnew(novenove, krabice);
         	nove = getold(nove);
	      }
      }
   }
   if (isfree(nove)) {
   	nove = getnew(nove, panacek);
      stare = getold(stare);
      lev.hx = novex;
      lev.hy = novey;
      return true;
   }
   return false;
}

/****************************************************************************
	Hrac::move_left
   ~~~~~~~~~~~~~~~
   Pokusi se posunout hrace doleva, volanim move(). Pokud se posunuti
   podari, zavola stejnojmenou metodu graf. systemu a preda mu index
   bodu, ktery je rohem hracovy textury.
****************************************************************************/
void Hrac::move_left()
{
	if (move(-1, 0))
   	gfx.moveleft(2*lev.hy*(Xn+1)+2*lev.hx);
}

/****************************************************************************
	Hrac::move_right
   ~~~~~~~~~~~~~~~~
   Pokusi se posunout hrace doprava, volanim move(). Pokud se posunuti
   podari, zavola stejnojmenou metodu graf. systemu a preda mu index
   bodu, ktery je rohem hracovy textury.
****************************************************************************/
void Hrac::move_right()
{
	if (move(1, 0))
   	gfx.moveright(2*lev.hy*(Xn+1)+2*lev.hx);
}

/****************************************************************************
	Hrac::move_up
   ~~~~~~~~~~~~~
   Pokusi se posunout hrace nahoru, volanim move(). Pokud se posunuti
   podari, zavola stejnojmenou metodu graf. systemu a preda mu index
   bodu, ktery je rohem hracovy textury.
****************************************************************************/
void Hrac::move_up()
{
	if (move(0, -1))
   	gfx.moveup(2*lev.hy*(Xn+1)+2*lev.hx);
}

/****************************************************************************
	Hrac::move_down
   ~~~~~~~~~~~~~~~
   Pokusi se posunout hrace dolu, volanim move(). Pokud se posunuti
   podari, zavola stejnojmenou metodu graf. systemu a preda mu index
   bodu, ktery je rohem hracovy textury.
****************************************************************************/
void Hrac::move_down()
{
	if (move(0, 1))
   	gfx.movedown(2*lev.hy*(Xn+1)+2*lev.hx);
}

/****************************************************************************
	Hrac::generate_3D_objects
   ~~~~~~~~~~~~~~~~~~~~~~~~~
   Volanim metod tridy GFX vytvori 3D reprezentaci levelu. Nejprve se
   do promennych nX ulozi indexy bodu mezi ktere se ma dany prvek vykreslit.
   Podle typu prvku se pro dany prvek generuje horni nebo dolni textura
   a pro nektere i bocni steny.
****************************************************************************/
void Hrac::generate_3D_objects()
{
	gfx.reset3D();
   for (int i=0; i<lev.size(); i++)
   	for (int j=0; j<lev[i].size(); j++) {
      	int color;
      	int n1 = 2*i*(Xn+1)+2*j;
         int n2 = n1 + 2;
         int n3 = n1 + 2*(Xn+1);
         int n4 = n3 + 2;
      	switch (lev[i][j]) {
         	case prazdne : continue;
         	case zed : gfx.add_texhore(n1, n2, n4, n3, gfx.zedtex);
         					color = gfx.makecol(0, 0, 255); break;
            case cil_a_panacek: gfx.add_texdole(n1+1, n2+1, n4+1, n3+1, gfx.ciltex);
         	case panacek : gfx.add_texhore(n1, n2, n4, n3, gfx.panaktex); continue;
            case cil_a_krabice:
         	case krabice : gfx.add_texhore(n1, n2, n4, n3, gfx.krabtex);
         					color = gfx.makecol(255, 0, 0); break;
         	case cil : gfx.add_texdole(n1+1, n2+1, n4+1, n3+1, gfx.ciltex); continue;
         }
         if (i==0 || lev[i-1][j]==prazdne || lev[i-1][j]==cil || lev[i-1][j]==panacek
         	 || lev[i-1][j]==cil_a_panacek)
         	gfx.add_wall(n2, n1, n1+1, n2+1, color);
         if (j==Xn-1 || lev[i][j+1]==prazdne || lev[i][j+1]==cil || lev[i][j+1]==panacek
         	 || lev[i][j+1]==cil_a_panacek)
	         gfx.add_wall(n4, n2, n2+1, n4+1, color);
         if (i==Yn || lev[i+1][j]==prazdne || lev[i+1][j]==cil || lev[i+1][j]==panacek
         	 || lev[i+1][j]==cil_a_panacek)
		      gfx.add_wall(n3, n4, n4+1, n3+1, color);
         if (j==0 || lev[i][j-1]==prazdne || lev[i][j-1]==cil || lev[i][j-1]==panacek
         	 || lev[i][j-1]==cil_a_panacek)
	         gfx.add_wall(n1, n3, n3+1, n1+1, color);
      }
}

/****************************************************************************
	Hrac::zbyva_cilu
   ~~~~~~~~~~~~~~~~
   Vrati pocet jeste nezaplnenych cilu.
****************************************************************************/
int Hrac::zbyva_cilu()
{
	return lev.cilu;
}
