/*
   Stehovak3D

   semestralni prace Michala Molhance 1. rocnik, skupina 5

   molsoft.hyperlink.cz
*/
// Tento soubor obsahuje graficky system

#ifndef __GFX_H__
#define __GFX_H__

struct BITMAP;
struct V3D_f;

class GFX
{
	static int kontrola;			// jen 1 instance povolena
   static int X;					// rozliseni obrazovky X
   static int Y;											  // Y
   static int Depth;  			// bitova hloubka obrazovky
	BITMAP* s[2];					// 2 obrazovky pro page flipping
   int draw;						// index do pole s
   vector<V3D_f> world;		// vektor s body v netransformovanych souradnicich
   vector<V3D_f> aligned;  	// body zarovnane podle pohledu
   vector<V3D_f> projected;	// body projektovane do 2D (pouze pro ladeni)
   struct Wall { int a,b,c,d,color; };	// zaznam steny - indexy 4 bodu a barva
   struct Tex { int a,b,c,d; BITMAP* t; };  // zaznam textury - dtto a textura
   vector<Wall> walls;		// zdi
   vector<Tex> texsdole;	// textury na zemi
   vector<Tex> texshore;	// textury nahore
   int frames;					// pocet snimku
   static int kroku; 	// pocet kroku prechodu pri pohybu hrace mezi 2 poli
   bool wantmovepanacek;	// true, jestlize se bude animovat panacek
   bool dontdrawpanacek;// true, jestlize nechceme aby draw3D panacka kreslilo
   enum {nahoru, dolu, doleva, doprava} smer;  // smer pohybu panacka
   struct { int a, b, c, d; } odkud, kam;	// indexy bodu odkud a kam se bude panacek pohybovat
   vector<BITMAP*> panakdole;		// textury s panackem pro animaci
   vector<BITMAP*> panakhore;		// dtto
   vector<BITMAP*> panakvlevo;	// dtto
   vector<BITMAP*> panakvpravo;	// dtto
   void setkam(int i);		// nastavi cil pohybu
   void generatetexs();		// vygeneruje textury pro animaci (viz. panakXXXX)
   bool showframes;		// zobrazit pocet animacnich fazi hrace
public:
	GFX();
   ~GFX();
	void save_screen_to_file();		// ulozi obrazovku do souboru
   void swap();							// zobrazi skrytou video stranku
   void reset3D(); // zrusi pole aligned, projected, walls, texsdole, texshore
   void draw3D();	// vykresli staticky pohled na hraci plochu
   void draw3DwithAnim();	// vykresli pohled na hraci plochu s animaci panacka
   // nastavi novy pohled na scenu; parametry jsou souradnice kamery,
   // vektor pohledu dopredu a vektor pohledu nahoru
   void move3D(float x, float y, float z, float xfront, float yfront,
   				float zfront, float xup, float yup, float zup);
   // prida stenu (parametry jsou indexy bodu a barva)
   void add_wall(int a, int b, int c, int d, int color);
   // prida texturu na podlaze (parametry jsou indexy bodu a textura)
   void add_texdole(int a, int b, int c, int d, BITMAP* tex);
   // prida texturu nahoru (parametry jsou indexy bodu a textura)
   void add_texhore(int a, int b, int c, int d, BITMAP* tex);
   // textury
   BITMAP* zedtex;		// textura zdi
   BITMAP* krabtex;		// textura krabice
   BITMAP* panaktex;		// textura hrace
   BITMAP* ciltex;		// textura cile

   void moveup(int i);		// nastavi pohyb textury hrace nahoru (parametrem je index bodu)
   void movedown(int i);										//  dolu
   void moveleft(int i);										//  vlevo
   void moveright(int i);										//  vpravo
   void dontmove();			// zrusi nastaveni animace textury hrace

   void moreframes();	// zvysi pocet animacnich fazi panacka
   void lessframes();   //	snizi pocet animacnich fazi panacka
   
   int makecol(int r, int g, int b);	// vygeneruje kod barvy ze slozek RGB
};

extern bool debugflag;  // zobrazovat pomocnou sit bodu pro ladeni
extern bool fpsflag;    // zobrazovat pocet snimku za sekundu pro ladeni

#endif
