/*
   Stehovak3D

   semestralni prace Michala Molhance 1. rocnik, skupina 5

   molsoft.hyperlink.cz
*/
// Tento soubor obsahuje graficky system

#include <allegro.h>
#include "common.h"
#include "gfx.h"


bool debugflag = false; // zobrazovat pomocnou sit bodu pro ladeni
bool fpsflag = false;   // zobrazovat pocet snimku za sekundu pro ladeni

int GFX::kroku = 5;  // pocet kroku prechodu pri pohybu hrace mezi 2 poli

/****************************************************************************
	GFX::draw3DwithAnim
   ~~~~~~~~~~~~~~~~~~~
   Vykresli scenu i s pripadnou animaci.
   Meni wantmovepanacek.
****************************************************************************/
void GFX::draw3DwithAnim()
{
	if (wantmovepanacek) {
   	dontdrawpanacek = true;

      vector<BITMAP*> *odkudtexs, *kamtexs;
      switch (smer) {
      	case doleva : odkudtexs = &panakvlevo; kamtexs = &panakvpravo; break;
         case doprava : odkudtexs = &panakvpravo; kamtexs = &panakvlevo; break;
         case dolu : odkudtexs = &panakdole; kamtexs = &panakhore; break;
         case nahoru : odkudtexs = &panakhore; kamtexs = &panakdole; break;
      }

      int i, ii;	// pomocne promenne
	   V3D_f *vout[8]; for (i=0; i<8; i++) vout[i] = new V3D_f;
	   V3D_f *vtmp[8]; for (i=0; i<8; i++) vtmp[i] = new V3D_f;
   	V3D_f *vprojected[8]; for (i=0; i<8; i++) vprojected[i] = new V3D_f;
	   int out[8];
   	V3D_f *vtx[4];
      for (i=0; i<kroku-1; i++) {
      	draw3D();	// vykresli scenu bez panacka
         vtx[0] = &aligned[odkud.a];
         vtx[1] = &aligned[odkud.b];
         vtx[2] = &aligned[odkud.c];
         vtx[3] = &aligned[odkud.d];
         vtx[0]->u = 0; vtx[0]->v = 0;
         vtx[1]->u = 31; vtx[1]->v = 0;
         vtx[2]->u = 31; vtx[2]->v = 31;
         vtx[3]->u = 0; vtx[3]->v = 31;
         int n;
         n = clip3d_f(POLYTYPE_ATEX, 0.001, 1000, 4, (CONST V3D_f **)vtx, vout, vtmp, out);
         for (ii=0; ii<n; ii++) {
         	persp_project_f(vout[ii]->x, vout[ii]->y, vout[ii]->z,
         		&vprojected[ii]->x, &vprojected[ii]->y);
            vprojected[ii]->z = vout[ii]->z;
            vprojected[ii]->u = vout[ii]->u;
            vprojected[ii]->v = vout[ii]->v;
         }
         polygon3d_f(s[draw], POLYTYPE_ATEX_MASK, (*odkudtexs)[i] , n, vprojected);
         vtx[0] = &aligned[kam.a];
         vtx[1] = &aligned[kam.b];
         vtx[2] = &aligned[kam.c];
         vtx[3] = &aligned[kam.d];
         vtx[0]->u = 0; vtx[0]->v = 0;
         vtx[1]->u = 31; vtx[1]->v = 0;
         vtx[2]->u = 31; vtx[2]->v = 31;
         vtx[3]->u = 0; vtx[3]->v = 31;
         n = clip3d_f(POLYTYPE_ATEX, 0.001, 1000, 4, (CONST V3D_f **)vtx, vout, vtmp, out);
         for (ii=0; ii<n; ii++) {
         	persp_project_f(vout[ii]->x, vout[ii]->y, vout[ii]->z,
         		&vprojected[ii]->x, &vprojected[ii]->y);
            vprojected[ii]->z = vout[ii]->z;
            vprojected[ii]->u = vout[ii]->u;
            vprojected[ii]->v = vout[ii]->v;
         }
         polygon3d_f(s[draw], POLYTYPE_ATEX_MASK, (*kamtexs)[kroku-i-2], n, vprojected);
         swap();
      }
		for (i=0; i<8; i++) delete vout[i];
		for (i=0; i<8; i++) delete vtmp[i];
		for (i=0; i<8; i++) delete vprojected[i];

   	wantmovepanacek = false;
      dontdrawpanacek = false;
   }

   draw3D();	// redraw with final
}

/****************************************************************************
	GFX::draw3D
   ~~~~~~~~~~~
   Vykresli (statickou) scenu na obrazovku s panackem nebo bez panacka
   podle stavu atributu dontdrawpanacek.
****************************************************************************/
void GFX::draw3D()
{
	int i, ii;	// pomocne promenne
	acquire_bitmap(s[draw]);
   V3D_f *vout[8]; for (i=0; i<8; i++) vout[i] = new V3D_f;
   V3D_f *vtmp[8]; for (i=0; i<8; i++) vtmp[i] = new V3D_f;
   V3D_f *vprojected[8]; for (i=0; i<8; i++) vprojected[i] = new V3D_f;
   int out[8];
   V3D_f *vtx[4];

   clear(s[draw]);

   // nejprve textury na podlaze
	for (i=0; i<texsdole.size(); i++) {
   	if (polygon_z_normal_f(&projected[texsdole[i].a],	// backface culling
      		&projected[texsdole[i].b], &projected[texsdole[i].c]) > 0) {
         vtx[0] = &aligned[texsdole[i].a];
         vtx[1] = &aligned[texsdole[i].b];
         vtx[2] = &aligned[texsdole[i].c];
         vtx[3] = &aligned[texsdole[i].d];
         vtx[0]->u = 0; vtx[0]->v = 0;
         vtx[1]->u = 31; vtx[1]->v = 0;
         vtx[2]->u = 31; vtx[2]->v = 31;
         vtx[3]->u = 0; vtx[3]->v = 31;
         int n;
         n = clip3d_f(POLYTYPE_ATEX, 0.001, 1000, 4, (CONST V3D_f **)vtx, vout, vtmp, out);
         for (ii=0; ii<n; ii++) {
         	persp_project_f(vout[ii]->x, vout[ii]->y, vout[ii]->z,
         		&vprojected[ii]->x, &vprojected[ii]->y);
            vprojected[ii]->z = vout[ii]->z;
            vprojected[ii]->u = vout[ii]->u;
            vprojected[ii]->v = vout[ii]->v;
         }
         polygon3d_f(s[draw], POLYTYPE_ATEX, texsdole[i].t, n, vprojected);
   	}
   }


   // pak zdi
	for (i=0; i<walls.size(); i++) {
   	if (polygon_z_normal_f(&projected[walls[i].a],	// backface culling
      		&projected[walls[i].b], &projected[walls[i].c]) > 0) {
         vtx[0] = &aligned[walls[i].a];
         vtx[1] = &aligned[walls[i].b];
         vtx[2] = &aligned[walls[i].c];
         vtx[3] = &aligned[walls[i].d];
         int n;
         n = clip3d_f(POLYTYPE_FLAT, 0.001, 1000, 4, (CONST V3D_f **)vtx, vout, vtmp, out);
         for (ii=0; ii<n; ii++)
         	persp_project_f(vout[ii]->x, vout[ii]->y, vout[ii]->z,
         		&vprojected[ii]->x, &vprojected[ii]->y);
         vprojected[0]->c = walls[i].color;
         polygon3d_f(s[draw], POLYTYPE_FLAT, NULL, n, vprojected);
   	}
   }


   // a nakonec textury nahore
	for (i=0; i<texshore.size(); i++) {
   	if (polygon_z_normal_f(&projected[texshore[i].a],	// backface culling
      		&projected[texshore[i].b], &projected[texshore[i].c]) > 0) {
         vtx[0] = &aligned[texshore[i].a];
         vtx[1] = &aligned[texshore[i].b];
         vtx[2] = &aligned[texshore[i].c];
         vtx[3] = &aligned[texshore[i].d];
         vtx[0]->u = 0; vtx[0]->v = 0;
         vtx[1]->u = 31; vtx[1]->v = 0;
         vtx[2]->u = 31; vtx[2]->v = 31;
         vtx[3]->u = 0; vtx[3]->v = 31;
         int n;
         n = clip3d_f(POLYTYPE_ATEX, 0.001, 1000, 4, (CONST V3D_f **)vtx, vout, vtmp, out);
         for (ii=0; ii<n; ii++) {
         	persp_project_f(vout[ii]->x, vout[ii]->y, vout[ii]->z,
         		&vprojected[ii]->x, &vprojected[ii]->y);
            vprojected[ii]->z = vout[ii]->z;
            vprojected[ii]->u = vout[ii]->u;
            vprojected[ii]->v = vout[ii]->v;
         }
         if (texshore[i].t == panaktex)	// je to textura panacka => pruhledna
         	if (!dontdrawpanacek)
		         polygon3d_f(s[draw], POLYTYPE_ATEX_MASK, texshore[i].t, n, vprojected);
				else ;
         else
	         polygon3d_f(s[draw], POLYTYPE_ATEX, texshore[i].t, n, vprojected);
   	}
   }


   if (debugflag)
		for (i=0; i<projected.size(); i++) {
   		putpixel(s[draw], (int)projected[i].x, (int)projected[i].y,
   		makecol(255, 255, 255));
	   }

   ++frames;
   static int oldframes = 0;
   if (fpsflag) {
   	if (retrace_count > 70) {
         oldframes = frames;
         frames = 0;
         retrace_count = 0;
      }
   	textprintf(s[draw], font, 0, 0, makecol(255, 255, 255), "%d FPS",
  			oldframes);
   }

   if (showframes) {
      textprintf(s[draw], font, 0, text_height(font), makecol(255, 255,255),
      	"%d kroku", kroku);
   	showframes = false;
   }

	for (i=0; i<8; i++) delete vout[i];
	for (i=0; i<8; i++) delete vtmp[i];
	for (i=0; i<8; i++) delete vprojected[i];

	release_bitmap(s[draw]);
}

/****************************************************************************
	GFX::move3D
   ~~~~~~~~~~~
   Posune kameru na nove misto na souradnicich x, y, z. Smer, kterym
   se ma kamera divat je udan dvojici vektoru: dopredu (?front)
   a nahoru (?up).
   Meni aligned a projected.
****************************************************************************/
void GFX::move3D(float x, float y, float z, float xfront, float yfront,
				float zfront, float xup, float yup, float zup)
{
	MATRIX_f m;
   get_camera_matrix_f(&m, x, y, z, xfront, yfront, zfront, xup, yup, zup,
   						  32, 1);
   for (int i=0; i<world.size(); i++) {
   	V3D_f v, w;
	   apply_matrix_f(&m, world[i].x, world[i].y, world[i].z,
	   					&v.x, &v.y, &v.z);
      aligned.push_back(v);
      persp_project_f(v.x, v.y, v.z, &w.x, &w.y);
      w.z = v.z;
      projected.push_back(w);
   }
}

/****************************************************************************
	GFX::add_wall
   ~~~~~~~~~~~~~
   Prida stenu. Parametry jsou indexy bodu a barva.
   Meni walls.
****************************************************************************/
void GFX::add_wall(int a, int b, int c, int d, int color)
{
	Wall w;
   w.a = a;
   w.b = b;
   w.c = c;
   w.d = d;
   w.color = color;
   walls.push_back(w);
}

/****************************************************************************
	GFX::add_texdole
   ~~~~~~~~~~~~~~~~
   Prida texturu na podlaze. Parametry jsou indexy bosu a textura.
   Meni texsdole.
****************************************************************************/
void GFX::add_texdole(int a, int b, int c, int d, BITMAP* tex)
{
	Tex t;
   t.a = a;
   t.b = b;
   t.c = c;
   t.d = d;
   t.t = tex;
   texsdole.push_back(t);
}

/****************************************************************************
	GFX::add_texhore
   ~~~~~~~~~~~~~~~~
   Prida texturu nahore. Parametry jsou indexy bodu a textura.
   Meni texshore.
****************************************************************************/
void GFX::add_texhore(int a, int b, int c, int d, BITMAP* tex)
{
	Tex t;
   t.a = a;
   t.b = b;
   t.c = c;
   t.d = d;
   t.t = tex;
   texshore.push_back(t);
}

/****************************************************************************
	GFX::reset3D
   ~~~~~~~~~~~~
   Zrusi ulozenou 3D scenu.
   Meni aligned, projected, walls, texsdole a texshore.
****************************************************************************/
void GFX::reset3D()
{
	aligned.resize(0);
   projected.resize(0);
   walls.resize(0);
   texsdole.resize(0);
   texshore.resize(0);
}

/****************************************************************************
	GFX::swap
   ~~~~~~~~~
	Ukaze neviditelnou video stranku a zmeni draw, aby indexoval
   tu neviditelnou urcenou pro kresleni.
   Meni draw.
****************************************************************************/
void GFX::swap()
{
	show_video_bitmap(s[draw]);
   draw = !draw;
}

int GFX::kontrola = 0;	// pro kontrolu pocet instanci
int GFX::X = 640;			// sirka obrazovky
int GFX::Y = 480;			// vyska obrazovky
int GFX::Depth = 8;		// bitova hloubka obrazovky


/****************************************************************************
	konstruktor
   ~~~~~~~~~~~
   Nastavi atributy, zkontroluje, ze je jen 1 instance, da vybrat pomoci
   dialogu video rezim, vytvori 2 stranky videopameti, vygeneruje body
   v prostoru, mezi ktere se mapuji objekty, nacte textury atd..
   Meni vsechno.
****************************************************************************/
GFX::GFX() :
	wantmovepanacek(false),
   dontdrawpanacek(false),
   smer(doleva),
   showframes(false)
{
	if (kontrola > 0)		// uz existuje objekt tridy GFX
   	exit(EXIT_FAILURE);
   kontrola++;

	int mys = install_mouse();
   set_color_depth(8);
   set_gfx_mode(GFX_SAFE, 320, 200, 0, 0);
   int card = GFX_AUTODETECT;
	if (!gfx_mode_select_ex(&card, &X, &Y, &Depth)) exit(EXIT_FAILURE);
   if (mys > -1) remove_mouse();
   set_color_depth(Depth);

   if (set_gfx_mode(card, X, Y, X, 2*Y) != 0) 
		if (set_gfx_mode(card, X, Y, X, Y) != 0) {
   			cerr << "Unable to set gfx mode!"
      			<< endl;
			exit(EXIT_FAILURE);
		}

   s[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
   s[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
   
   draw = 1;
   set_projection_viewport(0, 0, X, Y);

   // create standard world
   for (int i=0; i<=Yn; i++)
   	for (int j=0; j<=Xn; j++) {
			V3D_f v;
         v.x = j - mX;
         v.y = mY - i;
         v.z = 0;
         world.push_back(v);
         v.z = -1;
         world.push_back(v);
      }

	// nacteni textur
   PALETTE p;
   zedtex = load_pcx("zed3d.pcx", p);
   krabtex = load_pcx("krab3d.pcx", NULL);
   panaktex = load_pcx("panak3d.pcx", NULL);
   ciltex = load_pcx("cil3d.pcx", NULL);
   set_palette(p);

   panakdole.reserve(kroku);
   panakhore.reserve(kroku);
   panakvlevo.reserve(kroku);
   panakvpravo.reserve(kroku);
   generatetexs();

   frames = 0;
   retrace_count = 0;
}

/****************************************************************************
	destruktor
   ~~~~~~~~~~
   Aby spravne fungovala kontrola poctu instanci, uvolni pamet.
   Meni atribut kontrola.
****************************************************************************/
GFX::~GFX()
{
	kontrola--;
   destroy_bitmap(zedtex);
   destroy_bitmap(panaktex);
   destroy_bitmap(krabtex);
   destroy_bitmap(ciltex);
	for (int i=0; i<panakdole.size(); i++) {
   	destroy_bitmap(panakdole[i]);
   	destroy_bitmap(panakhore[i]);
   	destroy_bitmap(panakvlevo[i]);
   	destroy_bitmap(panakvpravo[i]);
   }
}

/****************************************************************************
	GFX::generatetexs
   ~~~~~~~~~~~~~~~~~
   Vygeneruje prechodove textury pro animaci panacka. V pripade potreby
   smaze stare.
   Meni panakdole, panakhore, panakvlevo, panakvpravo.
****************************************************************************/
void GFX::generatetexs()
{
	int i;
	for (i=0; i<panakdole.size(); i++) {
   	destroy_bitmap(panakdole[i]);
   	destroy_bitmap(panakhore[i]);
   	destroy_bitmap(panakvlevo[i]);
   	destroy_bitmap(panakvpravo[i]);
   }
   panakdole.resize(0);
   panakhore.resize(0);
   panakvlevo.resize(0);
   panakvpravo.resize(0);
   float deltax = (float)panaktex->w / (float)kroku;
   float deltay = (float)panaktex->h / (float)kroku;
   for (i=1; i<kroku; i++) {
   	BITMAP* b1 = create_bitmap(panaktex->w, panaktex->h);
   	BITMAP* b2 = create_bitmap(panaktex->w, panaktex->h);
   	BITMAP* b3 = create_bitmap(panaktex->w, panaktex->h);
   	BITMAP* b4 = create_bitmap(panaktex->w, panaktex->h);
      int c;
      if (Depth==8)
         c = 0;
      else
      	c = makecol(255, 0, 255);  // transparent color
      clear_to_color(b1, c);
      clear_to_color(b2, c);
      clear_to_color(b3, c);
      clear_to_color(b4, c);
      int Y = int((float)i*(float)deltay);
      int X = int((float)i*(float)deltax);
      blit(panaktex, b1, 0, 0, 0, Y, panaktex->w, panaktex->h-i*(int)deltay);
      blit(panaktex, b2, 0, Y, 0, 0, panaktex->w, panaktex->h-i*(int)deltay);
      blit(panaktex, b3, X, 0, 0, 0, panaktex->w-i*(int)deltax, panaktex->h);
      blit(panaktex, b4, 0, 0, X, 0, panaktex->w-i*(int)deltax, panaktex->h);
      panakdole.push_back(b1);
      panakhore.push_back(b2);
      panakvlevo.push_back(b3);
      panakvpravo.push_back(b4);
   }
}

/****************************************************************************
	GFX::save_screen_to_file
   ~~~~~~~~~~~~~~~~~~~~~~~~
   Ulozi obrazovku do souboru save.bmp.
****************************************************************************/
void GFX::save_screen_to_file()
{
   save_bmp("save.bmp", s[!draw], NULL);
}

/****************************************************************************
	GFX::setkam
   ~~~~~~~~~~~
   Nastavi cilove pole, kam se ma panacek pohnout a zapne zobrazeni animace.
   Meni kam a wantmovepanacek.
****************************************************************************/
void GFX::setkam(int i)
{
   kam.a = i;
   kam.b = i + 2;
   kam.c = i + 2*(Xn+2);
   kam.d = kam.c - 2;
   wantmovepanacek = true;
}

/****************************************************************************
	GFX::moveup
   ~~~~~~~~~~~
   Nastavi odkud pro pohyb nahoru.
   Meni odkud.
****************************************************************************/
void GFX::moveup(int i)
{
	smer = nahoru;
   setkam(i);
   odkud.a = kam.d;
   odkud.b = kam.c;
   odkud.c = kam.c + 2*(Xn+1);
   odkud.d = odkud.c - 2;
}

/****************************************************************************
	GFX::movedown
   ~~~~~~~~~~~~~
   Nastavi odkud pro pohyb dolu.
   Meni odkud.
****************************************************************************/
void GFX::movedown(int i)
{
	smer = dolu;
   setkam(i);
   odkud.c = kam.b;
   odkud.d = kam.a;
   odkud.a = kam.a - 2*(Xn+1);
   odkud.b = odkud.a + 2;
}

/****************************************************************************
	GFX::moveright
   ~~~~~~~~~~~~~~
   Nastavi odkud pro pohyb vpravo.
   Meni odkud.
****************************************************************************/
void GFX::moveright(int i)
{
	smer = doprava;
   setkam(i);
   odkud.b = kam.a;
   odkud.c = kam.d;
   odkud.a = kam.a - 2;
   odkud.d = kam.d - 2;
}

/****************************************************************************
	GFX::moveleft
   ~~~~~~~~~~~~~
   Nastavi odkud pro pohyb vlevo.
   Meni odkud.
****************************************************************************/
void GFX::moveleft(int i)
{
	smer = doleva;
   setkam(i);
   odkud.a = kam.b;
   odkud.d = kam.c;
   odkud.b = kam.b + 2;
   odkud.c = kam.c + 2;
}

/****************************************************************************
	GFX::dontmove
   ~~~~~~~~~~~~~
   Zrusi zadost o animaci panacka.
   Meni wantmovepanacek.
****************************************************************************/
void GFX::dontmove()
{
   wantmovepanacek = false;
}

/****************************************************************************
	GFX::moreframes
   ~~~~~~~~~~~~~~~
   Zvysi o 1 pocet animacnich fazi hrace a vygeneruje pro nej nove textury.
	Meni showframes a kroku.
****************************************************************************/
void GFX::moreframes()
{
	if (kroku < panaktex->w-2)
		kroku++;
   generatetexs();
   showframes = true;
}

/****************************************************************************
	GFX::lessframes
   ~~~~~~~~~~~~~~~
   Snizi o 1 pocet animacnich fazi hrace a vygeneruje pro nej nove textury.
	Meni showframes a kroku.
****************************************************************************/
void GFX::lessframes()
{
	if (kroku > 1)
   	kroku--;
   generatetexs();
   showframes = true;
}

/****************************************************************************
	GFX::makecol
   ~~~~~~~~~~~~
   Vygeneruje a vrati kod barvy vznikle slozenim RGB slozek ziskanych jako
   parametr.
****************************************************************************/
int GFX::makecol(int r, int g, int b)
{
	return ::makecol(r, g, b);
}
