/*
   Stehovak3D

   semestralni prace Michala Molhance 1. rocnik, skupina 5

   molsoft.hyperlink.cz
*/
// Tento soubor obsahuje Event Manager pro Allegro

#include <allegro.h>
#include "common.h"
#include "eventmng.h"

/****************************************************************************
	EventMng::get_event
   ~~~~~~~~~~~~~~~~~~~
	Vrati posledni vzniklou udalost, pokud zadna nenastala vrati
   udalost ,,zadna''.
****************************************************************************/
Udalost EventMng::get_event()
{
	if (keypressed()) {
   	if (key[KEY_LEFT])
      	return vlevo;
   	if (key[KEY_RIGHT])
      	return vpravo;
   	if (key[KEY_UP])
      	return nahoru;
   	if (key[KEY_DOWN])
      	return dolu;
   	if (key[KEY_4_PAD])
      	return vlevoP;
   	if (key[KEY_6_PAD])
      	return vpravoP;
   	if (key[KEY_8_PAD])
      	return nahoruP;
   	if (key[KEY_2_PAD])
      	return doluP;
   	if (key[KEY_ESC])
      	return konec;
      if (key[KEY_PLUS_PAD])
      	return plusP;
      if (key[KEY_MINUS_PAD])
      	return minusP;
      if (key[KEY_ASTERISK])
      	return hvezdaP;
      if (key[KEY_PGUP])
      	return vpred;
      if (key[KEY_PGDN])
      	return vzad;
      if (key[KEY_D])
      	return debug;
      if (key[KEY_F])
      	return fps;
      if (key[KEY_F12])
      	return save_pict;
      if (key[KEY_U])
      	return undo;
      if (key[KEY_R])
      	return restart;
      if (key[KEY_A])
      	return vicframu;
      if (key[KEY_Z])
      	return minframu;
   }
   return zadna;
}

/****************************************************************************
   EventMng::wait_for_event
   ~~~~~~~~~~~~~~~~~~~~~~~~
   Pocka na udalost a vrati ji.
****************************************************************************/
Udalost EventMng::wait_for_event()
{
	Udalost u;
	while ((u = get_event()) == zadna)
   	;
   return u;
}

int EventMng::kontrola = 0; //pocet instanci pro kontrolu

/****************************************************************************
	konstruktor
   ~~~~~~~~~~~
	Pokud potreba nastavi handler klavesnice.
****************************************************************************/
EventMng::EventMng()
{
	if (kontrola == 0)
		install_keyboard();
   kontrola++;
}

/****************************************************************************
	destruktor
   ~~~~~~~~~~
   Pokud potreba odstrani handler klavesnice.
****************************************************************************/
EventMng::~EventMng()
{
	kontrola--;
	if (kontrola == 0)
	   remove_keyboard();
}

/****************************************************************************
	EventMng::time_for_move
   ~~~~~~~~~~~~~~~~~~~~~~~
   Vrati true, pokud od predchoziho volani teto metody ubehla nejaka pevne
   dana doba (momentalne 5/14 sekundy).
****************************************************************************/
bool EventMng::time_for_move()
{
   if (retrace_count > 25) {
     retrace_count = 0;
     return true;
   }
   return false;
}

