/* $Id: mcontrol.h,v 1.15 2006/06/02 13:38:22 geomannl Exp $ */ 
#ifndef __MCONTROL_H__
#define __MCONTROL_H__

#include "../melee.h"
#include "mframe.h"
#include "mship.h"

extern const char num_controls;
extern char **control_name;
Control *getController(const char *type, const char *name, int channel);

/** control class */
class Control : public Presence
{
 public:
	bool cyborg_control;
	Control *cyborg;
  
  /*! \brief  controls CANNOT arbitrarily be killed off, because the deal with networking directly */
  virtual bool die(); 
  
  /*! \brief true if this control will delete itself when it's ship dies */
  bool temporary;                   
  unsigned char target_sign_color;
  /*! \brief this pertains to network traffic - see comment above calculate() in mcontrol.cpp */
  int already;
  int channel;
  
  
  /*! \brief points at the current ship being controlled */
  Ship *ship;

  Ship *original_ship;
  int lifetime;

  /*! \brief keys currently pressed */
  KeyCode keys;
  /*! \brief name of instance */
//  char *iname;
  SpaceObject *target;
  int index;
  bool valid_target(SpaceObject *t);
  /*! \brief always-random selection, for the always-random button on the default ship selector */
  int always_random;
  /** auto-update: if true, the control will update each frame. If false, it won't update (namely,
  place a call to think()), then this has to be done externally ; this allows one to synch networks.
  This is only needed (and in fact, compulsory), for human (ie. networked), players */
  bool auto_update;
 public:
  /*! \brief handles camera focusing on a controls ship */
  virtual SpaceLocation *get_focus();
//  int rand();
  /*! \brief loads configuration data from a ini file.
	\example  player1.load("scp.ini", "Keyboard1"); */
  virtual void load(const char* inifile, const char* inisection);
  /*! \brief saves configuration data to a ini file. */
  virtual void save(const char* inifile, const char* inisection);
  /*! \brief presents the ship selection dialog */
  virtual int choose_ship(VideoWindow *window, char *prompt, class Fleet *fleet);
  /*! \brief called whenever the ship being controlled changes 
	WARNING: select_ship() is not thread-safe */
  virtual void select_ship(Ship* ship_pointer, const char* ship_name);
  /*! \brief called every frame of physics */
  virtual void calculate();
  /*! \brief called by calculate... this is where the important stuff goes. But only if
  the auto_update is true*/
  virtual int think();
  /*! \brief returns the name of the control type, like "Joystick" */
  virtual const char *getTypeName() = 0;
  /*! \brief returns the description of the control, like "NetworkGame(local)_Keyboard0" */
//  virtual char *getDescription();
  /*! \brief the constructor initializes ship to NULL */
  Control (const char *name, int channel) ;
  /*! \brief the destructor, which is rarely used */
  virtual ~Control () ;
  virtual void set_target(int i);
  virtual void target_stuff();
  virtual void animate(Frame *space);
  
  
  enum {_prediction_keys_size = 128};//must be a power of 2
  //half-assed network bypass for prediction
  KeyCode *_prediction_keys;
  unsigned char _prediction_keys_index;
  
  /*! \brief for future mid-game lag changes */
  virtual void _event ( Event *e );
  
//  virtual void gen_buffered_data();
};




#endif // __MCONTROL_H__
