#ifndef SB_GFX_H
#define SB_GFX_H

#include <allegro.h>
#include <alfont.h>
#include <sstream>

#include "sb_main_data.h"
#include "sb_coin.h"

class GFX{
      
      private:
              BITMAP *buffer;
              
              DATAFILE *main_data;
              
              ALFONT_FONT *omicron;
              
              Coin *coins[4][4];
              
              int white, red;
              
      public: 
              GFX();
              ~GFX();
              
              void buffer_to_screen();
              
              void main_menu_to_buffer(int selected, int hiscore);
              
              void pass_coin(Coin *coin, int x, int y);
              
              void select_entries_to_buffer(int selected, int entries[4]);
              
              void draw_game(int x, int y, int turn, int quota, int timer,
                             int sum, int core_value, int multiple);
                             
              void game_over_to_buffer();
              
              void won_to_buffer(int quota);
                             
              void play_sound(int sound);
              
              void midi_stop();
              
              void midi_play(int midi);
};

#endif
