#include "sb_gfx.h"

GFX::GFX()
{
     set_color_depth(16);
     set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);
     
     set_window_title("Sphere Break");
     
     buffer = create_bitmap(800, 600);
     
     //checks if the buffer was created
        if(buffer==NULL)
        {
             set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
             allegro_message("I should consider buying a new computer");
             exit(EXIT_FAILURE);
        }
        
     main_data = load_datafile("sb_main.dat");
     
     //checks if the datafiles are loaded
        if(main_data==NULL)
        {
             set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
             allegro_message("Never. Never. Mess. With. Datafiles. Idiot."); 
             exit(EXIT_FAILURE);
        }
     
     white = makecol(255, 255, 255); red = makecol(255, 0, 0);
     
     alfont_init();
     
     omicron = alfont_load_font( "omicron.ttf" );
     
     //checks if the font s loaded
       if(omicron==NULL)
       {
             set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
             allegro_message("It was indeed a splendid idea to delete a critical font."); 
             exit(EXIT_FAILURE);
       }
     
     //sound
     install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
     set_volume( 255/*DIGI*/, 255/*MIDI*/);
     
     play_sample( (SAMPLE*) main_data[wahwah].dat, 255, 127, 1000, 0);
}

GFX::~GFX()
{          
     destroy_bitmap(buffer);
     unload_datafile(main_data);
     alfont_destroy_font(omicron);
     allegro_exit();
     exit(0); //voor diene stommen error als ge het afsluit
}

void GFX::buffer_to_screen()
{
     draw_sprite( screen, buffer, 0, 0);
     clear_bitmap(buffer);
}

void GFX::main_menu_to_buffer(int selected, int hiscore)
{
     draw_sprite( buffer, (BITMAP*) main_data[logo].dat, 100, 50);
     
     //selector
         draw_sprite( buffer, (BITMAP*) main_data[select].dat, 325, 200 + selected*80);
     
     alfont_set_font_size( omicron, 70);
     alfont_textout_centre_ex(buffer, omicron, "play", 400, 240, white, -1);
     alfont_textout_centre_ex(buffer, omicron, "help", 400, 320, white, -1);
     alfont_textout_centre_ex(buffer, omicron, "quit", 400, 400, white, -1);
     
     alfont_set_font_size( omicron, 45);
     
     std::stringstream hiscore_stream;
     hiscore_stream << "Your current hiscore is " << hiscore << ".";
     
     alfont_textout_centre_ex(buffer, omicron, hiscore_stream.str().c_str(), 400, 490, white, -1);
     
     alfont_set_font_size(omicron, 20);
     alfont_textout_right_ex(buffer, omicron,
                             "game design and programming by Repsa_Jih", 780, 560, white, -1);
}

void GFX::pass_coin(Coin *coin, int x, int y)
{
     coins[x][y] = coin;
}

void GFX::select_entries_to_buffer(int selected, int entries[4])
{
     //logo
     draw_sprite( buffer, (BITMAP*) main_data[logo].dat, 100, 50);
     
     alfont_set_font_size(omicron, 50);
     
     alfont_textout_centre_ex(buffer, omicron, "Select your entry coins.", 400, 220,
                              white, -1);
                              
     if(selected==4)
     {
          draw_sprite( buffer, (BITMAP*) main_data[select].dat, 325, 450);
     }else{
          draw_sprite( buffer, (BITMAP*) main_data[entry_selector].dat, 350,
                       290+selected*50);
     }
     
     std::stringstream lines[4];
     
     for(int i=0; i<4; i++)
     {
             lines[i] << entries[i];
             
             alfont_textout_centre_ex(buffer, omicron, lines[i].str().c_str(), 400,
                                      290+i*50, white, -1);
     }
     
     alfont_textout_centre_ex(buffer, omicron, "continue", 400, 500, white, -1);
}

void GFX::draw_game(int x, int y, int turn, int quota, int timer,
                    int sum, int core_value, int multiple)
{
     //background
     draw_sprite(buffer, (BITMAP*) main_data[general_bg].dat, 0, 0);
     
     //selector
     draw_sprite( buffer, (BITMAP*) main_data[coin_selector].dat, 52+x*140, 42+y*100);
     
     alfont_set_font_size( omicron, 80);
     
     //core_value
     std::stringstream core_value_stream;
     core_value_stream << core_value;
     
     alfont_textout_centre_ex( buffer, omicron, core_value_stream.str().c_str(),
                               305, 186, makecol(0, 0, 0), -1);
                               
     alfont_set_font_size( omicron, 70);
     
     //coins
     for(int i=0; i<4; i++)
     {
         for(int a=0; a<4; a++)
         {
             if(coins[i][a]->Value()>0)
             {
                  if((i>0 && i<3) && (a>0 && a<3))
                      draw_sprite(buffer, (BITMAP*) main_data[entry_coin].dat, 52+i*140, 42+a*100);
                  else
                      draw_sprite(buffer, (BITMAP*) main_data[border_coin].dat, 52+i*140, 42+a*100);
                  
                  std::stringstream coin_value;
                  coin_value << coins[i][a]->Value();
                    if(coins[i][a]->Selected())
                        alfont_textout_centre_ex( buffer, omicron, coin_value.str().c_str() , 92+i*140, 42+a*100, red, -1);
                    else
                        alfont_textout_centre_ex( buffer, omicron, coin_value.str().c_str() , 92+i*140, 42+a*100, white, -1);
             }
         }
     }
     
     alfont_set_font_size( omicron, 40);
     
     //tekst turn
       std::stringstream turn_stream_text;
       turn_stream_text << "turns:";
       alfont_textout_ex( buffer, omicron, turn_stream_text.str().c_str(), 600, 50, white, -1);

       std::stringstream turn_stream;
       turn_stream << turn << "/15";
       alfont_textout_right_ex( buffer, omicron, turn_stream.str().c_str(), 750, 90, white, -1);
       
     //tekst quota
       std::stringstream quota_stream_text;
       quota_stream_text << "quota:";
       alfont_textout_ex( buffer, omicron, quota_stream_text.str().c_str(), 600, 130, white, -1);
       
       std::stringstream quota_stream;
       quota_stream << quota;
       alfont_textout_right_ex( buffer, omicron, quota_stream.str().c_str(), 750, 170, white, -1);

     //tekst timer
       std::stringstream timer_stream_text;
       timer_stream_text << "timer:";
       alfont_textout_ex( buffer, omicron, timer_stream_text.str().c_str(), 600, 210, white, -1);
       
       std::stringstream timer_stream;
       timer_stream << timer;
       alfont_textout_right_ex( buffer, omicron, timer_stream.str().c_str(), 750, 250, white, -1);
       
     //tekst sum
       std::stringstream sum_stream_text;
       sum_stream_text << "sum:";
       alfont_textout_ex( buffer, omicron, sum_stream_text.str().c_str(), 600, 290, white, -1);
       
       std::stringstream sum_stream;
       sum_stream << sum;
       alfont_textout_right_ex( buffer, omicron, sum_stream.str().c_str(), 750, 330, white, -1);

     //tekst multiple
       std::stringstream multiple_stream_text;
       multiple_stream_text << "next:";
       alfont_textout_ex( buffer, omicron, multiple_stream_text.str().c_str(), 600, 370, white, -1);
       
       std::stringstream multiple_stream;
       multiple_stream << multiple << " " << multiple + core_value;
       alfont_textout_right_ex( buffer, omicron, multiple_stream.str().c_str(), 750, 410, white, -1);
}

void GFX::game_over_to_buffer()
{
       alfont_set_font_size( omicron, 70);
       alfont_textout_centre_ex( buffer, omicron, "Game Over", 400, 280, white, -1);
}

void GFX::won_to_buffer(int quota)
{
       alfont_set_font_size( omicron, 50);
       alfont_textout_centre_ex( buffer, omicron, "You broke the sphere!", 400, 200, white, -1);
       
       std::stringstream quota_stream;
       quota_stream << "You scored " << quota << " quota.";
       
       alfont_textout_centre_ex( buffer, omicron, quota_stream.str().c_str(), 400, 280, white, -1);
} 

void GFX::play_sound(int sound)
{
       int pan = (rand() % 255);
       play_sample( (SAMPLE*) main_data[sound].dat, 255, pan, 1000, 0);
}

void GFX::midi_stop()
{
       stop_midi();
}

void GFX::midi_play(int midi)
{
       play_midi ( (MIDI*) main_data[midi].dat , 1);
}
