#include "sb_game.h"

volatile long speed_counter;

void increment_speed_counter()
{
     speed_counter++;
}
END_OF_FUNCTION(incrment_speed_counter)



Game::Game()
{
     speed_counter = 0;
     
     allegro_init();
     install_keyboard();
     install_timer();
     
     LOCK_VARIABLE(speed_counter);
     LOCK_FUNCTION(increment_speed_counter);
     
     install_int_ex(increment_speed_counter, BPS_TO_TIMER( 60 ));
     
     gfx = new GFX();
}
END_OF_FUNCTION(Game::Game)
     
void Game::main_menu()
{    
     bool menu_finished = false;
     int selected = 0;
     bool keypressed = false;
     
     gfx->midi_play(seymour);
     
     //read hiscore from sb_misc.dat
     std::ifstream myFile("sb_coins.dat");
       for(int a=0; a<5; a++)
       { myFile >> hiscore; }
     myFile.close();
     
     while(!menu_finished && !key[KEY_ESC])
     {
          while(speed_counter>0)
          {
                if(key[KEY_ENTER])
                {
                      if(selected==0)
                      {
                           set_volume( 200/*DIGI*/, 200/*MIDI*/);
                           //here the game begins
                              select_entries();
                              game_loop();
                           //game has finished
                           set_volume( 255, 255 );
                      }
                      else if(selected==1)
                      {
                           system("manual.rtf");
                      }
                      else if(selected==2)
                      {
                           menu_finished = true;
                      }
                }
                else if(key[KEY_DOWN] && !keypressed)
                {
                      selected++;
                      if(selected==3)
                        selected = 0;
                      keypressed = true;
                }
                else if(key[KEY_UP] && !keypressed)
                {
                      selected--;
                      if(selected==-1)
                        selected = 2;
                      keypressed = true;
                }
                else if(!key[KEY_ENTER] && !key[KEY_UP] && !key[KEY_DOWN])
                {
                      keypressed = false;
                }
                
                speed_counter--;
          }
          
          gfx->main_menu_to_buffer( selected , hiscore);
          gfx->buffer_to_screen();
     }
     
     delete gfx;
}

void Game::select_entries()
{  
     //set coins in gfx
       for(int i=0; i<4; i++)
       {
           for(int a=0; a<4; a++)
           {
                coins[i][a] = new Coin();
                gfx->pass_coin(coins[i][a], i, a);
           }
       }
       
       bool select_finished = false;
       int selected = 4;
       bool key_pressed;
       int values[4];
       
       std::fstream misc_data("sb_misc.dat");
       for(int i=0; i<4; i++)
       {
               misc_data >> values[i];
       }
       
       misc_data.close();
       
       while(!select_finished)
       {
           while(speed_counter>0)
           {
               if(key[KEY_UP] && !key_pressed)
               {
                   selected--;
                   if(selected==-1)
                     selected = 4;
                   key_pressed = true;
               }
               else if(key[KEY_DOWN] && !key_pressed)
               {
                   selected++;
                   if(selected==5)
                     selected = 0;
                   key_pressed = true;
               }
               else if(key[KEY_LEFT] && !key_pressed && selected!=4)
               {
                   values[selected]--;
                     if(values[selected]==0)
                       values[selected] = 9;
                   key_pressed = true;
               }
               else if(key[KEY_RIGHT] && !key_pressed && selected!=4)
               {
                   values[selected]++;
                     if(values[selected]==10)
                       values[selected] = 1;
                   key_pressed = true;
               }
               else if(key[KEY_ENTER] && !key_pressed && selected==4)
               {
                   select_finished = true;
               }
               else if(key[KEY_ESC])
               {
                   return;
               }
               else if(!key[KEY_ENTER] && !key[KEY_UP] && !key[KEY_DOWN] &&
                       !key[KEY_LEFT] && !key[KEY_RIGHT])
               {
                   key_pressed = false;
               }
               
               speed_counter--;
           }
           
           gfx->select_entries_to_buffer(selected, values);
           gfx->buffer_to_screen();
       }
       
       coins[1][1]->set_entry(values[0]);
       coins[1][2]->set_entry(values[1]);
       coins[2][1]->set_entry(values[2]);
       coins[2][2]->set_entry(values[3]);
       
       std::fstream out_misc_data("sb_misc.dat");
       for(int i=0; i<4; i++)
       {
               out_misc_data << values[i] << "\n";
       }
       
       out_misc_data.close();
       
}

void Game::game_loop()
{
       game_over = false;
       number_of_turn = 1;
       quota = 0;
       
       set_coins();
       
       for(number_of_turn; number_of_turn<16 && (!game_over && !key[KEY_ESC]);number_of_turn++)
       {
               turn();
               change_coins();
       }

       if(game_over && !direct_quit)
       {
              int i=0;
              gfx->play_sound(gameover_sample);
              set_volume(255, 255);
              gfx->midi_stop();
              while(i<450) 
              {
                       while(speed_counter>0)
                       {
                            i++;
                            speed_counter--;
                       }
                   gfx->game_over_to_buffer();
                   gfx->buffer_to_screen();
              }
              gfx->midi_play(seymour);
       }
       else if(!game_over && !direct_quit)
       {
            if(quota>hiscore)
            {
                 std::ofstream myFile("sb_coins.dat", std::ios::trunc);
                 myFile << quota;
                 hiscore = quota;
                 myFile.close();
            }

              int i=0;
              gfx->play_sound(eternity);
              set_volume(255, 255);
              gfx->midi_stop();
              while(i<378) 
              {
                       while(speed_counter>0)
                       {
                            i++;
                            speed_counter--;
                       }
                   gfx->won_to_buffer(quota);
                   gfx->buffer_to_screen();
              }
              gfx->midi_play(seymour);
            
       }
       
       while(key[KEY_ESC] || key[KEY_ENTER])
       {/*zorgt ervoor dat je het main menu ook niet afsluit*/}
}

void Game::turn()
{
     bool select_entry = true;
     bool key_pressed = false;
     int sum = 0;
     int core_multiple;
     int x, y;
     int mili_timer, timer;
     mili_timer = 0; timer = 30;
     int number_of_selected_coins = 0;
     int number_of_selected_border_coins = 0;
     x=1; y=1;
     
     core_multiple = core_value;
     
     while(key[KEY_ENTER])
     {}
     
     while(sum != core_multiple && !key[KEY_ESC])
     {
          while(speed_counter>0)
          {
                if(key[KEY_ENTER] && !key_pressed)//men duwt op enter
                {
                    if(!coins[x][y]->Selected() && coins[x][y]->Value()>0)
                    {
                          if((x>0 && x<3) && (y>0 && y<3)) //dus is een enrty coin
                          {
                                sum += coins[x][y]->Value();
                                coins[x][y]->select_coin();
                          }else{                            //dus is een border coin
                                number_of_selected_coins++;
                                number_of_selected_border_coins++;
                                sum += coins[x][y]->Value();
                                coins[x][y]->select_coin();
                          }
                          
                          gfx->play_sound(piano_tone);
                    }
                    key_pressed = true;
                } else if(key[KEY_LEFT] && !key_pressed)//men duwt links
                {
                    x--;
                    if(x<0)
                      x=0;
                    if(x<1 && select_entry)
                      x=1;
                    key_pressed = true;
                } else if(key[KEY_RIGHT] && !key_pressed)//men duwt rechts
                {
                    x++;
                    if(x>3)
                      x=0;
                    if(x>2 && select_entry)
                      x=2;
                    key_pressed = true;
                } else if(key[KEY_UP] && !key_pressed)//men duwt boven
                {
                    y--;
                    if(y<0)
                      y=0;
                    if(y<1 && select_entry)
                      y=1;
                    key_pressed = true;
                } else if(key[KEY_DOWN] && !key_pressed)//men duwt onder
                {
                    y++;
                    if(y>3)
                      y=3;
                    if(y>2 && select_entry)
                      y=2;
                    key_pressed = true;
                } else if(!key[KEY_ENTER] && !key[KEY_UP] && !key[KEY_DOWN] &&
                          !key[KEY_LEFT] && !key[KEY_RIGHT])
                {
                    key_pressed = false;
                }
                
                if(number_of_selected_coins == 12)//als alle coins geselecteerd zijn
                {
                    game_over = true;
                    return;
                }
                
                if(sum > core_multiple)//als de som hoger is dan de core break
                {
                    core_multiple += core_value;
                }
                
                mili_timer++;
                if(mili_timer == 60)
                {
                    mili_timer = 0;
                    timer--;
                      if(timer == 0)
                      {
                           game_over = true;
                           return;
                      }
                }
                
                if(sum>0)
                {
                    select_entry = false;
                }
                
                speed_counter--;
          }
          
          gfx->draw_game(x, y, number_of_turn, quota, timer, sum, core_value, core_multiple);
          gfx->buffer_to_screen();
     }
     quota += number_of_selected_border_coins;
     
     if(key[KEY_ESC])
       direct_quit = true;
}

void Game::set_coins()
{
     core_value = (rand() % 9) + 1;
     
     for(int i=0; i<4; i++)
     {
           for(int a=0; a<4; a++)
           {
                 if(!( (i>0 && i<3) && (a>0 && a<3) ))
                   coins[i][a]->set_value();
           }
     }
}

void Game::change_coins()
{
     core_value = (rand() % 9) +1;
     
     for(int x=0; x<4; x++)
     {
           for(int y=0; y<4; y++)
           {
                if(!( (x>0 && x<3) && (y>0 && y<3) ))
                {
                       coins[x][y]->change_value(false);
                }
                else
                {
                       coins[x][y]->change_value(true);
                }
           }
     }
}
