#include <allegro.h>
#include "defines.h"
#include "sidefines.h"
#include "waitForCreditScreens.h"
#include "sifunctions.h"
#include "pmask.h"
#include "spaceInvaders.h"

void checkForCredit()
{
   if (key[KEY_ESC]) boolShutDown=1;
   if (key[KEY_3]) {intCredits++;rest(200);clear_keybuf();}
}

int updateScoreAdvanceScreen(int boolDoAnimation, SAS * startStatus)
{
   clear(buffer);

   char strPlay[5] = "PLAY";
   
   if (boolDoAnimation && startStatus->intStage<11) strPlay[3] = ' ';

   char strSP[] = "SPACE     ..INVADERS";
   char strM[] = "=?  ..  ....MYSTERY";
   char str30[] = "=30  ....POINTS";
   char str20[] = "=20  ....POINTS";
   char str10[] = "=10  ....POINTS";

   if (boolDoAnimation && startStatus->intStage<8) {
      draw_sprite(buffer, upsideDownYImage, upsideDownY->x, upsideDownY->y);
   }
   
   if (startStatus->intStage==0) {  
      if (startStatus->intTextTick==0)
         startStatus->intPosition=moveNextPosition(strPlay, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, strPlay, startStatus->intPosition, 194 + XSHIFT, 144+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
      
   }
   
   if (startStatus->intStage>0) 
      writeString(buffer, strPlay, 194 + XSHIFT, 144+YSHIFT, letters);
   
   if (startStatus->intStage==1) {
      if (startStatus->intTextTick==0)
         startStatus->intPosition=moveNextPosition(strSP, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, strSP, startStatus->intPosition, 114 + XSHIFT, 192+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   if (startStatus->intStage>1) writeString(buffer, strSP, 114 + XSHIFT, 192+YSHIFT, letters);
   
   if (startStatus->intStage>1) {
      writeString(buffer, "*SCORE  ....ADVANCE  .... TABLE*", 66 + XSHIFT,256+YSHIFT, letters);
      draw_sprite(buffer, saucerImage, 128 + XSHIFT, 288+YSHIFT);
      draw_sprite(buffer, alienImage[2][0], 132 + XSHIFT, 318+YSHIFT);
      draw_sprite(buffer, alienImage[1][0], 132 + XSHIFT, 350+YSHIFT);
      draw_sprite(buffer, alienImage[0][0], 132 + XSHIFT, 383+YSHIFT);
   }
   
   if (startStatus->intStage==2) {
      if (startStatus->intTextTick==0)
         startStatus->intPosition=moveNextPosition(strM, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, strM, startStatus->intPosition, 162 + XSHIFT, 290+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   
   if (startStatus->intStage>2) 
      writeString(buffer, strM, 162 + XSHIFT, 290+YSHIFT, letters);

   if (startStatus->intStage==3) {
      if (startStatus->intTextTick==0)
         startStatus->intPosition=moveNextPosition(str30, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, str30, startStatus->intPosition, 162 + XSHIFT, 322+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   
   if (startStatus->intStage>3) 
      writeString(buffer, str30, 162 + XSHIFT, 322 + YSHIFT, letters);
   
   if (startStatus->intStage==4) {
      if (startStatus->intTextTick==0)
         startStatus->intPosition=moveNextPosition(str20, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, str20, startStatus->intPosition, 162 + XSHIFT, 354+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   
   if (startStatus->intStage>4) 
      writeString(buffer, str20, 162 + XSHIFT, 354 + YSHIFT, letters);
   
   if (startStatus->intStage==5) {
      if (startStatus->intTextTick==0)
         startStatus->intPosition=moveNextPosition(str10, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, str10, startStatus->intPosition, 162 + XSHIFT, 386+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   
   if (startStatus->intStage>5) 
      writeString(buffer, str10, 162 + XSHIFT, 386+YSHIFT, letters);
   
   if (startStatus->intStage==6 && boolDoAnimation) {
      startScreenAlien->x=600 + XSHIFT;
      startScreenAlien->y=144+YSHIFT;
      startScreenAlien->xdir=-1;
      startScreenAlien->xdelay=0;
      startScreenAlien->xspeed =1;
      startScreenAlien->framedelay=6;
      startStatus->intStage=7;
      startScreenAlien->alive=1;
   }
   else if(startStatus->intStage==6) {
      startStatus->intStage=13;
   }

   if (startStatus->intStage>6  && boolDoAnimation)
      updateAlienYSprite(startStatus);
 
   drawBorders();
   displayScore(0,0);
   displayScore(0,1);
   displayScoreHeading();
   displayHiScore(intHiScore);
   displayCredits(intCredits);
   displayLives(intLives[0]);

   actual_cycle++;   
   startStatus->intTextTick++;
   if (startStatus->intTextTick==15) startStatus->intTextTick=0;
   if (startStatus->intStage==13) {
      rest(1000); 
      return 1;
   }
   return 0;

}

void updateAlienYSprite(SAS * startStatus)
{

   if (startScreenAlien->alive==1) {  
      if (startStatus->intStage<=12) 
         updatesprite(startScreenAlien);
   }
   
   if (startStatus->intStage==7 && startScreenAlien->x < 194 + 48 + 10 + XSHIFT) {
      startStatus->intStage = 8;
      startScreenAlien->xdir=1;
   }
   if (startStatus->intStage==8) {
      draw_sprite(buffer, upsideDownYImage, startScreenAlien->x-10, startScreenAlien->y);
   }
   if (startScreenAlien->x > 648 && startStatus->intStage==8) {
      startScreenAlien->xdelay=300;
      startScreenAlien->xcount=1;
      startStatus->intStage=9;
   }
     
   if (startStatus->intStage==9 && startScreenAlien->xcount==0) {
      startStatus->intStage=10;
      startScreenAlien->xdir=-1;
      startScreenAlien->xdelay=0;
   }
   
   if (startStatus->intStage==10) {
      draw_sprite(buffer, letters[90], startScreenAlien->x-10, startScreenAlien->y);      
   }  
   if (startScreenAlien->x <=194 + 48 + 10 + XSHIFT && startStatus->intStage==10) {
      startStatus->intStage=11;
   }
   
   if (startStatus->intStage==11) {
      startScreenAlien->xdelay=200;
      startScreenAlien->xcount=1;
      startStatus->intStage=12;
   }
   
   if (startStatus->intStage==12 && startScreenAlien->xcount==0)
      startStatus->intStage=13;
   if (startStatus->intStage<=11) {
      draw_sprite(buffer, alienImage[2][startScreenAlien->curframe], startScreenAlien->x, startScreenAlien->y);
   }
   else if(startStatus->intStage==12) {
      draw_sprite(buffer, alienImage[2][0], startScreenAlien->x, startScreenAlien->y);
   }
}
   
void drawScoreAdvanceScreen()
{
   drawFrame();
}

void scoreAdvanceScreen(int boolDoAnimation)
{
   actual_cycle = ticks = target_cycle = 0;
   int boolScoreAdvanceExit=0;

   SAS * screenState = malloc(sizeof(SAS));
   screenState->intPosition=1;
   screenState->intTextTick=0;
   screenState->intStage=0;
  
   boolScoreAdvanceExit = updateScoreAdvanceScreen(boolDoAnimation,screenState);  
   while(!boolShutDown && !boolScoreAdvanceExit && intCredits<1) {
      drawScoreAdvanceScreen();
      while(target_cycle>actual_cycle && !boolShutDown && 
            !boolScoreAdvanceExit && intCredits<1) {  
         checkForCredit();
         boolScoreAdvanceExit = updateScoreAdvanceScreen(boolDoAnimation, screenState);
      }
   }
   if (intCredits==0 && !boolShutDown) {
      drawScoreAdvanceScreen();
      rest(1600);           
   }
   free(screenState);
}  

void drawPlayerInfoScreen()
{
   drawFrame();  
}

int updatePlayerInfoScreen(int boolDoAnimation, SAS * startStatus)
{
   char strOneorTwo[] = "<1  ....OR  ....2  ...PLAYERS>";
   char str1Player[] = "*1  ....PLAYER ..   ....1  ....COIN";
   char str2Player[] = "*2  ....PLAYERS  ....2  ....COINS";
   clear(buffer);
   if ( startStatus->intStage==6) startStatus->intStage=7;
   writeString(buffer, "INSERT  ....  ....COIN", 130 + XSHIFT, 240 +YSHIFT, letters);
   
   if (coinC->alive==1) 
      draw_sprite(buffer, coinCImage, coinC->x, coinC->y);

   if (startStatus->intStage==0) {
      if (startStatus->intTextTick==0)
          startStatus->intPosition=moveNextPosition(strOneorTwo, startStatus->intPosition);
      if (startStatus->intPosition>0) printSubString(buffer, strOneorTwo, startStatus->intPosition, 98 + XSHIFT, 304+YSHIFT, letters);              
      if (startStatus->intPosition==0) {startStatus->intStage++;startStatus->intPosition=1;}
   }
   
   if (startStatus->intStage>0) 
      writeString(buffer, strOneorTwo, 98 + XSHIFT, 304+ YSHIFT, letters);
   
   if (startStatus->intStage==1) {
      if (startStatus->intTextTick==0)
          startStatus->intPosition=moveNextPosition(str1Player, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, str1Player, startStatus->intPosition, 98 + XSHIFT, 352+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   
   if (startStatus->intStage>1) 
      writeString(buffer, str1Player, 98 + XSHIFT, 352+ YSHIFT, letters);
   
   if (startStatus->intStage==2) {
      if (startStatus->intTextTick==0)
          startStatus->intPosition=moveNextPosition(str2Player, startStatus->intPosition);
      if (startStatus->intPosition>0) 
         printSubString(buffer, str2Player, startStatus->intPosition, 98 + XSHIFT, 400+YSHIFT, letters);              
      if (startStatus->intPosition==0) {
         startStatus->intStage++;
         startStatus->intPosition=1;
      }
   }
   
   if (startStatus->intStage>2) 
      writeString(buffer, str2Player, 98 + XSHIFT, 400 + YSHIFT, letters);

   if (!boolDoAnimation && startStatus->intStage==3) 
      startStatus->intStage=7;
   
   if (startStatus->intStage==3) {
      startScreenAlien->x = 0 + XSHIFT;
      startScreenAlien->y = 100;
      startScreenAlien->xdir=1;
      startScreenAlien->xdelay=0;
      startScreenAlien->xspeed=1;
      startScreenAlien->alive = 1;
      startStatus->intStage=4;
   }
   
   if (startStatus->intStage==4) {
      updatesprite(startScreenAlien);
   }

   if (startStatus->intStage==5) {
      updatesprite(alienBullets[0]);
   }
   
   if (startStatus->intStage==4 && startScreenAlien->x>=(130+ 16*6 + 16-6 + XSHIFT)) {
      startScreenAlien->xspeed=0;
      startStatus->intStage=5;
      alienBullets[0]->type=2;
      alienBullets[0]->y = startScreenAlien->y + 16;
      alienBullets[0]->x = startScreenAlien->x + 6;
      alienBullets[0]->alive=1;
   }
    
   if (startStatus->intStage==5 && 
       check_pmask_collision(coinCMask,  alienBulletMask[2][alienBullets[0]->curframe], 
                             coinC->x, coinC->y, alienBullets[0]->x, alienBullets[0]->y)) {
      coinC->alive=0;
      alienBullets[0]->alive=0;
      startStatus->intStage=6;
   }
      
   if (startScreenAlien->alive==1) 
      draw_sprite(buffer, alienImage[2][startScreenAlien->curframe], startScreenAlien->x, startScreenAlien->y);
   if (alienBullets[0]->alive==1) 
      draw_sprite(buffer, alienBulletImage[2][alienBullets[0]->curframe], alienBullets[0]->x, alienBullets[0]->y);
   drawBorders();
   displayScore(0,0);
   displayScore(0,1);
   displayScoreHeading();
   displayHiScore(intHiScore);
   displayCredits(intCredits);
   displayLives(intLives[0]);
   actual_cycle++;   
   startStatus->intTextTick++;
   if (startStatus->intTextTick==15) startStatus->intTextTick=0;
   if (startStatus->intStage==7) return 1;
   return 0;      
}
      
void playerInfoScreen(int boolDoAnimation)
{
   actual_cycle = ticks = target_cycle = 0;
   int boolPlayerInfoExit=0;

   SAS * screenState = malloc(sizeof(SAS));
   screenState->intPosition=1;
   screenState->intTextTick=0;
   screenState->intStage=0;

   if (boolDoAnimation) {
      coinC->alive=1;
      startScreenAlien->alive=0;
   }
   else {
      coinC->alive=0;
      startScreenAlien->alive=0;
   }
   boolPlayerInfoExit = updatePlayerInfoScreen(boolDoAnimation,screenState);  
   while(!boolShutDown && !boolPlayerInfoExit && intCredits<1) {
      drawPlayerInfoScreen();
      while(target_cycle>actual_cycle && !boolShutDown && !boolPlayerInfoExit && intCredits<1) {  
         checkForCredit();
         boolPlayerInfoExit = updatePlayerInfoScreen(boolDoAnimation, screenState);
      }
   }
   
   if (intCredits==0 && !boolShutDown) {
      drawPlayerInfoScreen();
      rest(3000);           
   }
   free(screenState);
}

void drawStartGameScreen()
{
   drawFrame();
}

void updateStartGameScreen()
{
   clear(buffer);
   writeString(buffer, "PUSH", 195 + XSHIFT,194, letters);
   if (intCredits==1) {
      writeString(buffer, "ONLY  ....1PLAYER  ....BUTTON", 67 + XSHIFT, 242,letters);
   } else {
      writeString(buffer,"1  ....OR  ....2PLAYER  ....BUTTON",67 + XSHIFT,242,letters);
   }
   drawBorders();
   displayScore(0,0);
   displayScore(0,1);
   displayScoreHeading();
   displayHiScore(intHiScore);
   displayCredits(intCredits);
   displayLives(intLives[0]);
   actual_cycle++;
}   

void startGameCheckInput()
{
   if (key[KEY_3]) {
      clear_keybuf();
      intCredits++; 
      rest(1500);
      clear_keybuf();
   }
   if (key[KEY_2] && intCredits>=2) boolStartGame=2;
   if (key[KEY_1]) boolStartGame=1;
   if (key[KEY_ESC]) boolShutDown=1;
}
void startGameScreen()
{
   actual_cycle = ticks = target_cycle = 0;
   int boolStartGameScreenExit=0;
   updateStartGameScreen();
   clear_keybuf();
   
   while(!boolShutDown && !boolStartGame) {
      drawStartGameScreen();
      while (target_cycle>actual_cycle) {
         startGameCheckInput();
         updateStartGameScreen();
      }
   }
}

void drawPlayPlayerScreen()
{
   drawFrame();
}

int updatePlayPlayerScreen(int player, int intFlashTick)
{
   clear(buffer);
   if (player==0) {
      writeString(buffer, "PLAY   ....PLAYER<1>", 114 + XSHIFT, 240, letters);
   } 
   else if(player==1) {
      writeString(buffer, "PLAY   ....PLAYER<2>", 114 + XSHIFT, 240, letters);
   }
   else {
      writeString(buffer, "PLAYER ERROR", 114 + XSHIFT, 240, letters);
   }
   if (player==0) {
      if (intFlashTick % 20 > 10)
         displayScore(intScore[0],0); 
   }
   else
      displayScore(intScore[0],0);
   
   if (player==1) {
      if (intFlashTick % 20 > 10)
         displayScore(intScore[1],1); 
   }
   else
      displayScore(intScore[1],1);

   drawBorders();
   displayScoreHeading();
   displayHiScore(intHiScore);
   displayCredits(intCredits);
   displayLives(intLives[player]);
   intFlashTick++;
   actual_cycle++;
   return intFlashTick;
}

void playPlayerScreen(int player)
{
   actual_cycle = ticks = target_cycle = 0;
   int intFlashTick=0;
   updatePlayPlayerScreen(player, intFlashTick);

   while (!boolShutDown && intFlashTick<400) {
      drawPlayPlayerScreen();
      while(target_cycle>actual_cycle && !boolShutDown && intFlashTick<400) {
         if (key[KEY_ESC]) boolShutDown=1;
         intFlashTick = updatePlayPlayerScreen(player, intFlashTick);
      }
   }
}
   

void drawBuildAliensScreen()
{
   drawFrame();
}

int updateBuildAliens(int player, int displayTicks)
{
   int i,j, c;
   c=0;
   for (i=0; i<=4; i++) {
      for(j=0; j<=10; j++) {
         c++;
         if (c==((int)(displayTicks/3)) && aliens[player]->alive[i][j]==1)
            draw_sprite(buffer, alienImage[getAlienType(i)][aliens[player]->curframe[i]], aliens[player]->x[i][j], aliens[player]->y[i][j]);
      }   
   }
   drawBorders();
   displayScore(intScore[0],0);
   displayScore(intScore[1],1);
   displayScoreHeading();
   displayHiScore(intHiScore);
   displayCredits(intCredits);
   displayLives(intLives[player]);
   displayTicks++;
   actual_cycle++;
   return displayTicks;
}

void buildAliens(int player)
{   
   actual_cycle = ticks = target_cycle = 0;
   int intDisplayTicks=0;
   clear(buffer);
   intDisplayTicks = updateBuildAliens(player, intDisplayTicks);
   while (!boolShutDown && intDisplayTicks<165) {
      drawBuildAliensScreen();
      while (target_cycle>actual_cycle && !boolShutDown && intDisplayTicks<165) {
         if (key[KEY_ESC]) boolShutDown=1;
            intDisplayTicks = updateBuildAliens(player, intDisplayTicks);
      }
   }
}

void drawClearAliensScreen()
{
   drawFrame();
}
int updateClearAliens(int intDisplayTicks)
{
   vline(buffer, (int)(intDisplayTicks)+ XSHIFT -4, 50 ,440, 0);
   vline(buffer, (int)(intDisplayTicks+1)+ XSHIFT -4, 50,440, 0);
   vline(buffer, (int)(intDisplayTicks+2) + XSHIFT-4, 50,440, 0);    
   intDisplayTicks+=3;
   actual_cycle++;
   return intDisplayTicks;
}
   
void clearAliens()
{   
   actual_cycle = ticks = target_cycle = 0;
   int intDisplayTicks=0;
   intDisplayTicks = updateClearAliens(intDisplayTicks);
     
   while (!boolShutDown && intDisplayTicks<447) {
      drawClearAliensScreen();
      while (target_cycle>actual_cycle && !boolShutDown && intDisplayTicks<447 ) {
         if (key[KEY_ESC]) boolShutDown=1;
            intDisplayTicks = updateClearAliens(intDisplayTicks);
      }
   }
}
   
   
