#include <allegro.h>
#include "defines.h"
#include "sidefines.h"
#include "pmask.h"

BITMAP *grabframe(BITMAP *source,
                  int width, int height,
                  int startx, int starty,
                  int columns, int frame)
{
   BITMAP * temp = create_bitmap(width, height);
   int x = startx + (frame % columns) * width;
   int y = starty + (frame / columns) * height;
   
   blit(source, temp, x,y,0,0,width,height);
   return temp;
}

void loadLetterBitmaps(BITMAP * letters[], BITMAP * allLetters, BITMAP * allNumbers)
{
//   BITMAP * allLetters = data[ALPHABET_BMP].dat;
//   BITMAP * allNumbers = data[NUMBERS_BMP].dat;
   int i;
   for (i=0; i<=128-1; i++) letters[i] = 0;
         /*  A,B,C............*/
   for (i=65; i<=90; i++) letters[i] = (BITMAP*)grabframe(allLetters, LETTER_WIDTH, LETTER_HEIGHT, 0, 0, 34, i-65);
   /* <,=,>,? */
   for (i=60; i<=63; i++) letters[i] = (BITMAP*)grabframe(allLetters, LETTER_WIDTH, LETTER_HEIGHT, 0, 0, 34, i-34);
   /* - */ 
   letters[45] = (BITMAP*)grabframe(allLetters, LETTER_WIDTH, LETTER_HEIGHT, 0, 0, 34, 30);
   /* * */
   letters[42] = (BITMAP*)grabframe(allLetters, LETTER_WIDTH, LETTER_HEIGHT, 0, 0, 34, 31);
   for (i=48; i<=57; i++) letters[i] = (BITMAP*)grabframe(allNumbers, LETTER_WIDTH, LETTER_HEIGHT, 0, 0, 10, i-48);
//   destroy_bitmap(allLetters);
}

void destroyLetterBitmaps(BITMAP * letters[])
{
   int i;
   for (i=0; i<128-1; i++) if (letters[i]!=0) destroy_bitmap(letters[i]);
}

void writeString(BITMAP * buffer, char s[], int x, int y, BITMAP * letters[])
{
   unsigned int i;
   for (i=0; i<=strlen(s)-1; i++) {
      if (s[i]==' ') x = x + 6;
      if (s[i]=='.') x = x + 1;
      if (s[i]!=' ' && s[i]!='.')  {
         draw_sprite(buffer, letters[s[i]], x, y);
         x = x + 10 + 6;
      }
   }
}
int moveNextPosition(char s[], int pos)
{
   //char s2[50]="";
  
    while (s[pos] == ' ' || s[pos]=='.') {   
      pos++;
      if (pos>(strlen(s)))  {
 //      writeString(buffer, s, x, y, letters); 
       return 0;
      }
   }
//   strncpy(s2, s, pos);
//   writeString(buffer, s2, x, y, letters);
   pos++;
   if (pos>(strlen(s))) return 0;
   return pos;
}

void printSubString(BITMAP * buffer, char s[], int pos, int x, int y, BITMAP * letters[])
{
   char s2[50]="";
   strncpy(s2, s, pos);
   writeString(buffer, s2, x, y, letters); 
}

int revealTextAt(BITMAP * buffer, char s[], int pos, int x, int y, BITMAP * letters[])
{
   char s2[50]="";
  strncpy(s2, s, pos);
  
    while (s[pos] == ' ' || s[pos]=='.') {   
      pos++;
      if (pos>(strlen(s))) {
       writeString(buffer, s, x, y, letters); 
       return 0;
      }
   }
   strncpy(s2, s, pos);
   writeString(buffer, s2, x, y, letters);
   pos++;
   if (pos>(strlen(s))) return 0;
   return pos;
}

