#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <string.h>
#include <math.h>
#include "pmask.h"
#include "defines.h"
#include "sidefines.h"
#include "sifunctions.h"
#include "spaceInvaders.h"
#include "waitForCreditScreens.h"
#include "demo.h"
#define MODE GFX_AUTODETECT_FULLSCREEN
//#define _RECORDINGDEMO

void drawBorders()
{
  rectfill(buffer, XSHIFT-8, 0, 0 + XSHIFT-5, HEIGHT, 15);
  rectfill(buffer, 447+XSHIFT+5, 0, 447+ XSHIFT+8,HEIGHT,15);
}
void drawBordersScreen()
{
  rectfill(screen, XSHIFT-8, 0, 0 + XSHIFT-5, HEIGHT, 4);
  rectfill(screen, 447+XSHIFT+5, 0, 447+ XSHIFT+8,HEIGHT,4);
}
void displayLives(int lives)
{
   char strLives[2];
   sprintf(strLives,"%i",lives);
   writeString(buffer, strLives, 18 + XSHIFT, 496 + YSHIFT,  letters);
   rectfill(buffer, 0 + XSHIFT,491+YSHIFT, 447 + XSHIFT,491+YSHIFT+1,10);
   int i;
   for (i=1;i<=lives-1;i++) {
      draw_sprite(buffer, laserImage, 52+((i-1) * (LASER_WIDTH+6)) + XSHIFT, 491+YSHIFT+2);
   }
}
void displayHiScore(int intHiScore)
{
   int intDScore = intHiScore;
   int intDivide = 1000;
   
   int vals[4];
   int i;
   char strScore[8];
   for (i=0; i<=3; i++) {
      vals[i] = 0;
      
      if (intDScore>=intDivide) {
         vals[i] = intDScore/intDivide;
         intDScore = intDScore - (intDivide * vals[i]);
      }
      intDivide /=10;
   }
   sprintf(strScore, "%d %d %d %d", vals[0],vals[1],vals[2],vals[3]);
   writeString(buffer, strScore,178 + XSHIFT, 64+YSHIFT, letters);
}
void displayScore(int score, int intWhich)
{
   int intDScore = score;
   int intDivide = 1000;
   
   int vals[4];
   int i;
   char strScore[8];
   for (i=0; i<=3; i++) {
      
      vals[i] = 0;
      if (intDScore>=intDivide) {
         vals[i] = (int)intDScore/intDivide;
         intDScore %=intDivide;
   //      intDScore = intDScore - (intDivide * vals[i]);
      }
      intDivide /=10;
   }
   sprintf(strScore, "%i %i %i %i", vals[0],vals[1],vals[2],vals[3]);

   if (intWhich==0)

       writeString(buffer, strScore,50 + XSHIFT, 64+YSHIFT, letters);
   else
       writeString(buffer, strScore,340 + XSHIFT, 64+YSHIFT, letters);
}
   
void displayCredits(int intCredits)
{
   int intCredit1 = (int)(intCredits/10);
   int intCredit2 = intCredits - ((int)(intCredits/10) * 10);
   char strCredits[3];
   sprintf(strCredits, "%i%i", intCredit1, intCredit2);
   writeString(buffer,  strCredits, 386 + XSHIFT, 496+ YSHIFT, letters);
   writeString(buffer, "CREDIT", 274 + XSHIFT, 496 + YSHIFT,letters);

}
void displayScoreHeading()
{
   writeString(buffer, "SCORE<1>  ....HI-SCORE  ....SCORE<2>",18 + XSHIFT,32+YSHIFT,letters);
}
   
void aliensMoveDown()
{
   int i,j;
   aliens[intPlayer]->yspeed = 16;
   aliens[intPlayer]->xspeed = 0;
   aliens[intPlayer]->framedelay=10000; 
   aliens[intPlayer]->ydelay = alienDelay[intPlayer];
   for (i=0; i<=4; i++) {
      aliens[intPlayer]->ycount[i] = alienDelay[intPlayer] - (i + 1)*(alienDelayDX[intPlayer]);
      aliens[intPlayer]->framecount[i]=0;
   }
}

void updateAlienDelay(int init)
{
   int i, oldDelay;
   aliens[intPlayer]->ydelay=0;
   
   aliens[intPlayer]->yspeed=0;
   aliens[intPlayer]->xspeed=4;
   oldDelay = aliens[intPlayer]->xdelay;
   aliens[intPlayer]->xdelay=alienDelay[intPlayer];
   aliens[intPlayer]->framedelay=alienDelay[intPlayer];
   boolAliensMovedH=1;

   for (i=0; i<=4; i++) {
      aliens[intPlayer]->ycount[i]=0;
      aliens[intPlayer]->xcount[i]=
                  alienDelay[intPlayer] - (i + 1)*alienDelayDX[intPlayer];
      aliens[intPlayer]->framecount[i]=
                  alienDelay[intPlayer] - (i+1)*alienDelayDX[intPlayer];
     
   }

}
void initAliensForLevel(int lev, int p)
{
   int i,j;
   aliens[p]->xdir = 1;
   aliens[p]->ydir = 1;

   for (i=0; i<=4; i++) {
      aliens[p]->curframe[i]=0;
      for (j=0; j<=10; j++) {
         aliens[p]->alive[i][j] = 1;
   
         aliens[p]->x[i][j] = ALIEN_STARTX + (j * (ALIEN_STARTDX + ALIEN_WIDTH));
         aliens[p]->y[i][j] = ALIEN_STARTY - (i * (ALIEN_HEIGHT + ALIEN_HEIGHT)) + ALIEN_HEIGHT * (lev-1);
      }
   }
} 

void loadStartScreenAlien()
{
   startScreenAlien = malloc(sizeof(SPRITE));
   startScreenAlien->xdir = 0;
   startScreenAlien->ydir = 0;
   startScreenAlien->alive = 0;
   startScreenAlien->x = 0;
   startScreenAlien->y = 0;
   startScreenAlien->width = 0;
   startScreenAlien->height = 0;
   startScreenAlien->xspeed=0;
   startScreenAlien->yspeed=0;
   startScreenAlien->xdelay=0;
   startScreenAlien->ydelay=25;
   startScreenAlien->xcount=0;
   startScreenAlien->ycount=0;
   startScreenAlien->curframe = 0;
   startScreenAlien->maxframe=1;
   startScreenAlien->animdir=1;
   startScreenAlien->framecount=1;
   startScreenAlien->framedelay=0;
}
void destroyStartScreenAlien()
{
   free(startScreenAlien);
}

void loadAliens()
{
   alienImage[0][0] =(BITMAP*)grabframe(data[ALIEN10A_BMP].dat, ALIEN_WIDTH, ALIEN_HEIGHT, 0, 0, 1, 0);
   alienMask[0][0] = create_allegro_pmask(alienImage[0][0]);
   alienImage[0][1] =(BITMAP*)grabframe(data[ALIEN10B_BMP].dat, ALIEN_WIDTH, ALIEN_HEIGHT, 0, 0, 1, 0);
   alienMask[0][1] = create_allegro_pmask(alienImage[0][0]);
   alienImage[1][0] =(BITMAP*)grabframe(data[ALIEN20A_BMP].dat, ALIEN_WIDTH, ALIEN_HEIGHT, 0, 0, 1, 0);
   alienMask[1][0] = create_allegro_pmask(alienImage[0][0]);
   alienImage[1][1] =(BITMAP*)grabframe(data[ALIEN20B_BMP].dat, ALIEN_WIDTH, ALIEN_HEIGHT, 0, 0, 1, 0);
   alienMask[1][1] = create_allegro_pmask(alienImage[0][0]);
   alienImage[2][0] =(BITMAP*)grabframe(data[ALIEN30A_BMP].dat, ALIEN_WIDTH, ALIEN_HEIGHT, 0, 0, 1, 0);
   alienMask[2][0] = create_allegro_pmask(alienImage[0][0]);
   alienImage[2][1] =(BITMAP*)grabframe(data[ALIEN30B_BMP].dat, ALIEN_WIDTH, ALIEN_HEIGHT, 0, 0, 1, 0);
   alienMask[2][1] = create_allegro_pmask(alienImage[0][0]);

   aliensSound[0] = (SAMPLE*)data[ALIENMOVE1_WAV].dat;
   aliensSound[1] = (SAMPLE*)data[ALIENMOVE2_WAV].dat;
   aliensSound[2] = (SAMPLE*)data[ALIENMOVE3_WAV].dat;
   aliensSound[3] = (SAMPLE*)data[ALIENMOVE4_WAV].dat;   

   int p,i,j;
   for(p=0; p<=1; p++) {
      aliens[p] = malloc(sizeof(ALIENSX));
      aliens[p]->xdir = 1;
      aliens[p]->ydir = 1;
      aliens[p]->xspeed=4;
      aliens[p]->yspeed=0;
      aliens[p]->xdelay=0;
      aliens[p]->ydelay=0;
      aliens[p]->maxframe=1;
      aliens[p]->animdir=1;
      aliens[p]->framedelay=0;
      for (i=0; i<=4; i++) {
         aliens[p]->width[i] = alienImage[0][0]->w;
         aliens[p]->height[i] = alienImage[0][0]->h;
         aliens[p]->xcount[i]=0;


         aliens[p]->ycount[i]=0;
         aliens[p]->curframe[i] = 0;
         aliens[p]->framecount[i]=0;

         for (j=0; j<=10; j++) {
            aliens[p]->alive[i][j] = 1;
            aliens[p]->x[i][j] = ALIEN_STARTX + (j * (ALIEN_STARTDX + ALIEN_WIDTH));
            aliens[p]->y[i][j] = ALIEN_STARTY - (i * (ALIEN_HEIGHT + ALIEN_HEIGHT));  
         }
      }
   }
}

void destroyAliens()
{ 
   int p,i,j;
   for (i=0; i<=2; i++) {
     for (j=0; j<=1; j++) {
        destroy_bitmap(alienImage[i][j]);
        destroy_pmask(alienMask[i][j]);
     } 
   }
   for (p=0;p<=1; p++)
         free(aliens[p]);
//   for (i=0; i<=4; i++)
  //    for (j=0; j<=10; j++)



}

void loadAlienExplode()
{
 alienExplodeImage=  (BITMAP*)grabframe(data[ALIENEXPLODEX_BMP].dat, 26, 16, 0, 0, 1, 0);
   alienExplodeSound = (SAMPLE*)data[ALIENHIT_WAV].dat;
   alienExplode = malloc(sizeof(SPRITE));
   alienExplode->xdir = 0;
   alienExplode->ydir = 0;
   alienExplode->alive = 0;
   alienExplode->x = 0;
   alienExplode->y = 0;
   alienExplode->width = 0;
   alienExplode->height = 0;
   alienExplode->xspeed=0;
   alienExplode->yspeed=0;
   alienExplode->xdelay=0;
   alienExplode->ydelay=25;
   alienExplode->xcount=0;
   alienExplode->ycount=0;
   alienExplode->curframe = 0;
   alienExplode->maxframe=1;
   alienExplode->animdir=1;
   alienExplode->framecount=1;
   alienExplode->framedelay=0;
}
void destroyAlienExplode()
{
   destroy_bitmap(alienExplodeImage);
   free(alienExplode);
}

void destroyLaserBulletExplode()
{
   destroy_bitmap(laserBulletExplodeImage);
   free(laserBulletExplode);
}
void loadLaserBulletExplode()
{
   laserBulletExplodeImage=  (BITMAP*)grabframe(data[LASERBULLETEXPLODE_BMP].dat, 16, 16, 0, 0, 1, 0);
   laserBulletExplode = malloc(sizeof(SPRITE));
   laserBulletExplode->xdir = 1;
   laserBulletExplode->ydir = -1;
   laserBulletExplode->alive = 0;
   laserBulletExplode->x = 0;
   laserBulletExplode->y = 0;
   laserBulletExplode->width = 0;
   laserBulletExplode->height = 0;
   laserBulletExplode->xspeed=0;
   laserBulletExplode->yspeed=6;
   laserBulletExplode->xdelay=50;
   laserBulletExplode->ydelay=25;
   laserBulletExplode->xcount=0;
   laserBulletExplode->ycount=0;
   laserBulletExplode->curframe = 0;
   laserBulletExplode->maxframe=1;
   laserBulletExplode->animdir=1;
   laserBulletExplode->framecount=1;
   laserBulletExplode->framedelay=0;
}

void destroyAlienBulletExplode()
{
   int i;
   for (i=0;i<=2; i++) {
      destroy_bitmap(alienBulletExplodeImage);
      free(alienBulletExplode[i]);
   }
}
void loadAlienBulletExplode()
{
   int i;
   for (i=0;i<=2;i++) {
      alienBulletExplodeImage=  (BITMAP*)grabframe(data[ALIENBULLETEXPLODE_BMP].dat, 12, 16, 0, 0, 1, 0);
      alienBulletExplode[i] = malloc(sizeof(SPRITE));
      alienBulletExplode[i]->xdir = 0;
      alienBulletExplode[i]->ydir = 1;
      alienBulletExplode[i]->alive = 0;
      alienBulletExplode[i]->x = 0;
      alienBulletExplode[i]->y = 0;
      alienBulletExplode[i]->width = alienBulletExplodeImage->w;
      alienBulletExplode[i]->height = alienBulletExplodeImage->h;
      alienBulletExplode[i]->xspeed=0;
      alienBulletExplode[i]->yspeed=2;
      alienBulletExplode[i]->xdelay=50;
      alienBulletExplode[i]->ydelay=20;
      alienBulletExplode[i]->xcount=0;
      alienBulletExplode[i]->ycount=0;
      alienBulletExplode[i]->curframe = 0;
      alienBulletExplode[i]->maxframe=1;
      alienBulletExplode[i]->animdir=1;
      alienBulletExplode[i]->framecount=1;
      alienBulletExplode[i]->framedelay=0;
   }
}

void destroyBulletCollision()
{
//   destroy_bitmap(bulletCollisionImage);
   int i;
   for (i=0;i<=2;i++)
      free(bulletCollision);
}
void loadBulletCollision()
{
   int i;
   for (i=0;i<=2;i++) {
      bulletCollision[i] = malloc(sizeof(SPRITE));
      bulletCollision[i]->xdir = 0;
      bulletCollision[i]->ydir = 0;
      bulletCollision[i]->alive = 0;
      bulletCollision[i]->x = 0;
      bulletCollision[i]->y = 0;
      bulletCollision[i]->width = 0;
      bulletCollision[i]->height = 0;
      bulletCollision[i]->xspeed=0;
      bulletCollision[i]->yspeed=0;
      bulletCollision[i]->xdelay=30;
      bulletCollision[i]->ydelay=0;
      bulletCollision[i]->xcount=0;
      bulletCollision[i]->ycount=0;
      bulletCollision[i]->curframe = 0;
      bulletCollision[i]->maxframe=1;
      bulletCollision[i]->animdir=1;
      bulletCollision[i]->framecount=1;
      bulletCollision[i]->framedelay=0;
   }
}
void destroyUpsideDownY()
{
   destroy_bitmap(upsideDownYImage);
   free(upsideDownY);
}
void loadUpsideDownY()
{
 upsideDownYImage=  (BITMAP*)grabframe(data[UPSIDEDOWNY_BMP].dat, 26, 16, 0, 0, 1, 0);
   upsideDownY = malloc(sizeof(SPRITE));
   upsideDownY->xdir = 0;
   upsideDownY->ydir = 0;
   upsideDownY->alive = 0;
   upsideDownY->x = 194+48 + XSHIFT;
   upsideDownY->y = 144+YSHIFT;
   upsideDownY->width = upsideDownYImage->w;
   upsideDownY->height = upsideDownYImage->h;
   upsideDownY->xspeed=0;
   upsideDownY->yspeed=0;
   upsideDownY->xdelay=30;
   upsideDownY->ydelay=0;
   upsideDownY->xcount=0;
   upsideDownY->ycount=0;
   upsideDownY->curframe = 0;
   upsideDownY->maxframe=1;
   upsideDownY->animdir=1;
   upsideDownY->framecount=1;
   upsideDownY->framedelay=0;
}

void destroyCoinC()
{
   destroy_pmask(coinCMask);
   //destroy_bitmap(coinCImage);
   free(coinC);
}
void loadCoinC()
{
 coinCImage=  (BITMAP*)letters[67];
  coinCMask = create_allegro_pmask(coinCImage);

   coinC = malloc(sizeof(SPRITE));
   coinC->xdir = 0;
   coinC->ydir = 0;
   coinC->alive = 0;
   coinC->x = 130 + 16*6 + 16 + XSHIFT;
   coinC->y =240 + YSHIFT;
   coinC->width = coinCImage->w;
   coinC->height = coinCImage->h;
   coinC->xspeed=0;
   coinC->yspeed=0;
   coinC->xdelay=0;
   coinC->ydelay=0;
   coinC->xcount=0;
   coinC->ycount=0;
   coinC->curframe = 0;
   coinC->maxframe=1;
   coinC->animdir=1;
   coinC->framecount=1;
   coinC->framedelay=0;
}

void loadSaucer()
{
  saucerImage=  (BITMAP*)grabframe(data[SAUCER_BMP].dat, SAUCER_WIDTH, SAUCER_HEIGHT, 0, 0, 1, 0);
 // saucerImage = load_bitmap("saucer.bmp",NULL);
  saucerMask = create_allegro_pmask(saucerImage);
  saucerSound = (SAMPLE*) data[SAUCER_WAV].dat;

//   saucerImage = data[SAUCER_BMP].dat;
   saucer = malloc(sizeof(SPRITE));
   saucer->xdir = 1;
   saucer->ydir = 1;
   saucer->alive = 0;
   saucer->x = 50 + XSHIFT;
   saucer->y = SAUCER_STARTY;
   saucer->width = saucerImage->w;
   saucer->height = saucerImage->h;
   saucer->xspeed=1;
   saucer->yspeed=0;
   saucer->xdelay=1;
   saucer->ydelay=0;
   saucer->xcount=0;
   saucer->ycount=0;
   saucer->curframe = 0;
   saucer->maxframe=1;
   saucer->animdir=1;
   saucer->framecount=1;
   saucer->framedelay=0;
}

void loadSaucerExplode()
{
   saucerExplodeImage[0] = (BITMAP*)grabframe(data[SAUCERSCORE50_BMP].dat, SAUCER_WIDTH, SAUCER_HEIGHT, 0, 0, 1, 0);
   saucerExplodeImage[1] = (BITMAP*)grabframe(data[SAUCERSCORE100_BMP].dat, SAUCER_WIDTH, SAUCER_HEIGHT, 0, 0, 1, 0);
   saucerExplodeImage[2] = (BITMAP*)grabframe(data[SAUCERSCORE150_BMP].dat, SAUCER_WIDTH, SAUCER_HEIGHT, 0, 0, 1, 0);
   saucerExplodeImage[3] = (BITMAP*)grabframe(data[SAUCERSCORE300_BMP].dat, SAUCER_WIDTH, SAUCER_HEIGHT, 0, 0, 1, 0);
   saucerExplodeImage[4] = (BITMAP*)grabframe(data[SAUCEREXPLODE_BMP].dat, 42, 16, 0, 0, 1, 0);
   saucerExplodeSound = (SAMPLE*) data[LASERHIT_WAV].dat;

   saucerExplode = malloc(sizeof(SPRITE));
   saucerExplode->dir = 0;
   saucerExplode->alive = 0;
   saucerExplode->x = 0;
   saucerExplode->y = 0;
   saucerExplode->width = saucerExplodeImage[0]->w;
   saucerExplode->height = saucerExplodeImage[0]->h;
   saucerExplode->xspeed=0;
   saucerExplode->yspeed=0;
   saucerExplode->xdelay=100;
   saucerExplode->ydelay=0;
   saucerExplode->xcount=1;
   saucerExplode->ycount=0;
   saucerExplode->curframe = 0;
   saucerExplode->maxframe=2;
   saucerExplode->animdir=1;
   saucerExplode->framecount=2;
   saucerExplode->framedelay=100;
}
void destroySaucerExplode()
{
   int i;
   for (i=0;i<=4;i++) destroy_bitmap(saucerExplodeImage[i]);
   free(saucerExplode);
}
    
void loadLaser()
{
  laserImage=  (BITMAP*)grabframe(data[LASERX_BMP].dat, LASER_WIDTH, LASER_HEIGHT, 0, 0, 1, 0);
  laserMask = create_allegro_pmask(laserImage);
  // laserImage = data[SAUCER_BMP].dat;
   laser = malloc(sizeof(SPRITE));
   laser->dir = 0;
   laser->xdir = 1;
   laser->ydir = 1;
   laser->alive = 1;
   laser->x = LASER_STARTX;
   laser->y = LASER_STARTY;
   laser->width = laserImage->w;
   laser->height = laserImage->h;
   laser->xspeed=0;
   laser->yspeed=0;
   laser->xdelay=1;
   laser->ydelay=0;
   laser->xcount=0;
   laser->ycount=0;
   laser->curframe = 0;
   laser->maxframe=1;
   laser->animdir=1;
   laser->framecount=1;
   laser->framedelay=0;
}
void destroyLaserExplode()
{
   destroy_bitmap(laserExplodeImage[0]);
   destroy_bitmap(laserExplodeImage[1]);
   free(laserExplode);
}

void loadLaserExplode()
{
  laserExplodeImage[0]=  (BITMAP*)grabframe(data[LASEREXPLODEAX_BMP].dat, 30, 16, 0, 0, 1, 0);
  laserExplodeImage[1]=  (BITMAP*)grabframe(data[LASEREXPLODEBX_BMP].dat, 32, 16, 0, 0, 1, 0);
  laserExplodeSound = (SAMPLE*) data[LASERHIT_WAV].dat;
   laserExplode = malloc(sizeof(SPRITE));
   laserExplode->dir = 0;
   laserExplode->xdir = 0;
   laserExplode->ydir = 0;
   laserExplode->alive = 0;
   laserExplode->x = 0;
   laserExplode->y = 0;
   laserExplode->width=0;
   laserExplode->height =0;
   laserExplode->xspeed=0;
   laserExplode->yspeed=0;
   laserExplode->xdelay=400;
   laserExplode->ydelay=0;
   laserExplode->xcount=0;
   laserExplode->ycount=0;
   laserExplode->curframe = 0;
   laserExplode->maxframe=1;
   laserExplode->animdir=1;
   laserExplode->framecount=2;
   laserExplode->framedelay=20;
}

void loadLaserBullet()
{
   
   laserBulletImage = (BITMAP*)grabframe(data[LASERBULLET_BMP].dat, 2, 6, 0, 0, 1, 0);
   laserBulletSound = (SAMPLE*)data[LASERFIRE_WAV].dat;

   laserBulletMask=create_allegro_pmask(laserBulletImage);
    
    laserBullet = malloc(sizeof(SPRITE));
   laserBullet->dir = 0;
   laserBullet->xdir=0;
   laserBullet->ydir=-1;
   laserBullet->alive = 0;
//   laserBullet->x = laser->x + laser->width/2;
//   laserBullet->y = laser->height-100;
   laserBullet->x = 0;
   laserBullet->y = 0;

   laserBullet->width = laserBulletImage->w;
   laserBullet->height = laserBulletImage->h;
    
     laserBullet->xspeed=0;
   laserBullet->yspeed=3;
   laserBullet->xdelay=0;
   laserBullet->ydelay=0;
   laserBullet->xcount=0;
   laserBullet->ycount=0;
   laserBullet->curframe = 0;
   laserBullet->maxframe=1;
   laserBullet->animdir=1;
   laserBullet->framecount=1;
   laserBullet->framedelay=0;
}

void initSheltersForLevel(int p)
{
   int i;
   for (i=0; i<=3; i++) {
      destroy_bitmap(shelterImage[p][i]);
      destroy_pmask(shelterMask[p][i]);
      shelterImage[p][i]=  (BITMAP*)grabframe(data[SHELTERX_BMP].dat, SHELTER_WIDTH, SHELTER_HEIGHT, 0, 0, 1, 0);
      shelterMask[p][i] = create_allegro_pmask(shelterImage[p][i]);
   }
}


void loadShelters()
{
  int p,i;
  for (p=0;p<=1;p++) {
     for (i=0; i<=3; i++) {
        shelterImage[p][i]=  (BITMAP*)grabframe(data[SHELTERX_BMP].dat, SHELTER_WIDTH, SHELTER_HEIGHT, 0, 0, 1, 0);
        shelterMask[p][i] = create_allegro_pmask(shelterImage[p][i]);
  
        shelter[p][i] = malloc(sizeof(SPRITE));
        shelter[p][i]->dir = 0;
        shelter[p][i]->alive = 1;
        shelter[p][i]->x = SHELTER_STARTX + i * (SHELTER_WIDTH + SHELTER_GAP);
        shelter[p][i]->y = SHELTER_STARTY;
        shelter[p][i]->width = shelterImage[p][i]->w;
        shelter[p][i]->height = shelterImage[p][i]->h;
        shelter[p][i]->xspeed=0;
        shelter[p][i]->yspeed=0;
        shelter[p][i]->xdelay=0;
        shelter[p][i]->ydelay=0;
        shelter[p][i]->xcount=0;
        shelter[p][i]->ycount=0;
        shelter[p][i]->curframe = 0;
        shelter[p][i]->maxframe=0;
        shelter[p][i]->animdir=0;
        shelter[p][i]->framecount=0;
     }
   }
}
void destroyAlienBullets()
{
  int i;
  int j;
  for (i=0;i<=2;i++) {
     free(alienBullets[i]);
     for (j=0;j<=3;j++) {
        destroy_bitmap(alienBulletImage[i][j]);
        destroy_pmask(alienBulletMask[i][j]);
     }
  }
}


void loadAlienBullets()
{
   int i;
   for (i=0; i<=3; i++) {
      alienBulletImage[ALIEN_BULLET_HAMMER][i] = (BITMAP*)grabframe(data[ALIENBULLETHAMMER_BMP].dat, 6, 12, 0, 0, 4, i);
      alienBulletMask[ALIEN_BULLET_HAMMER][i] = create_allegro_pmask(alienBulletImage[ALIEN_BULLET_HAMMER][i]);

      alienBulletImage[ALIEN_BULLET_SPIN][i] = (BITMAP*)grabframe(data[ALIENBULLETSPIN_BMP].dat, 6, 14, 0, 0, 4, i);
      alienBulletMask[ALIEN_BULLET_SPIN][i] = create_allegro_pmask(alienBulletImage[ALIEN_BULLET_SPIN][i]);

      alienBulletImage[ALIEN_BULLET_SQIGGLE][i] = (BITMAP*)grabframe(data[ALIENBULLETSQIGGLE_BMP].dat, 6, 14, 0, 0, 4, i);
      alienBulletMask[ALIEN_BULLET_SQIGGLE][i] = create_allegro_pmask(alienBulletImage[ALIEN_BULLET_SQIGGLE][i]);
   }
   alienBulletSound = (SAMPLE*) data[ALIENFIRE_WAV].dat;
   
   for (i=0; i<=2; i++) {
      alienBullets[i] = malloc(sizeof(SPRITE));
      alienBullets[i]->dir = 0;
      alienBullets[i]->xdir=0;
      alienBullets[i]->ydir=1;
      alienBullets[i]->alive = 0;
      alienBullets[i]->x = 0;
      alienBullets[i]->y = 0;

      alienBullets[i]->width = 6;
      alienBullets[i]->height = 0;
    
     alienBullets[i]->xspeed=0;
      alienBullets[i]->yspeed=2;
      alienBullets[i]->xdelay=0;
      alienBullets[i]->ydelay=1;
      alienBullets[i]->xcount=0;
      alienBullets[i]->ycount=0;
      alienBullets[i]->curframe = 0;
      alienBullets[i]->maxframe=3;
      alienBullets[i]->animdir=1;
      alienBullets[i]->framecount=0;
      alienBullets[i]->framedelay=10;
   }   
}


   
void initAlienBullets()
{
   int intAliensPassed = 0;
   int tries=0;
   int boolPickedOne;
   int pick;
   int bType;
   int xpos,ypos;
   int indx;
   int i;
   if (laserExplode->alive==1) return;
   while (intAlienBulletsLive < intMaxAlienBulletsLive[intPlayer]) {
      boolPickedOne = 0;
//      pick = rand() % ( (150 * (55 -intAliensAlive)/55) +2);
      int boolUnderShelter = FALSE;
      if (abs(aliens[intPlayer]->x[bottomAlien[intPlayer][intAliensPassed]][intAliensPassed] - laser->x) <20) {
         for (i=0;i<=3;i++) {
            if (((laser->x)+15)>=(shelter[intPlayer][i]->x-10) && 
                     laser->x<=(shelter[intPlayer][i]->x+10) + (shelter[intPlayer][i]->height)) {
               boolUnderShelter=TRUE;
               break;
            }
         }
         if (boolUnderShelter) {
            pick = rand() % 11;
         }
         else {
            pick = rand() % 30;
         }
      }
      else {
         pick = rand() % 150;
      }
      if (pick==intAliensPassed) {
         boolPickedOne = 1;
         bType=rand() % (10+1);
      }
      if (boolPickedOne==1) {
         if (countColDead[intPlayer][intAliensPassed]==31)
            tries--;
         else {
            xpos = aliens[intPlayer]->x[bottomAlien[intPlayer][intAliensPassed]][intAliensPassed];
            ypos = aliens[intPlayer]->y[bottomAlien[intPlayer][intAliensPassed]][intAliensPassed];
            indx = 0;
            if (ypos == (ALIEN_STARTY + 160)) continue;
            while(indx<intMaxAlienBulletsLive[intPlayer]-1) {
               if (alienBullets[indx]->alive==0)
                  break;
               indx++;
            }
            
            
            alienBullets[indx]->x = xpos + 12;
            alienBullets[indx]->y = ypos;
            alienBullets[indx]->alive=1;
            
            if (bType>=1 && bType<=3) {
               alienBullets[indx]->type=ALIEN_BULLET_HAMMER;
                alienBullets[indx]->height = 12;
                alienBullets[indx]->curframe = 0;
            }
            if (bType>=4 && bType<=6) {
               alienBullets[indx]->type=ALIEN_BULLET_SPIN;
                alienBullets[indx]->height = 14;
                alienBullets[indx]->curframe = 0;
            }
            if (bType>=7 && bType<=10) {
               alienBullets[indx]->type=ALIEN_BULLET_SQIGGLE;
                alienBullets[indx]->height = 14;
                alienBullets[indx]->curframe = 0;
            }
            intAlienBulletsLive++;
            play_sample(alienBulletSound, 255, 1000, 0, FALSE);
         }
         return;
      }
      intAliensPassed++;
      
      if (intAliensPassed==11) intAliensPassed=0;
      tries++;
      if (tries==11) return;
   }
}
void destroyLaserBullet()
{
   destroy_bitmap(laserBulletImage);
   free(laserBullet);
//   destroy_sample(laserBulletSound);
}
void destroyShelters()
{
   int p,i;
   for (p=0;p<=1;p++) {
      for (i=0; i<=3; i++) {
         destroy_bitmap(shelterImage[p][i]);
         free(shelter[p][i]);
         destroy_pmask(shelterMask[p][i]);
      }
   }
}
void destroySaucer()
{  
   destroy_bitmap(saucerImage);
   free(saucer);
   destroy_pmask(saucerMask);
}  
void destroyLaser()
{  
   destroy_bitmap(laserImage);
   free(laser);
   destroy_pmask(laserMask);
} 


void loadSprites()
{
   data = load_datafile("spaceInvaders.dat");
   loadSaucer(); 
   loadLaser();
   loadShelters(); 
   loadLaserBullet();
   loadSaucerExplode();
   loadAliens();
   loadAlienExplode();
   loadAlienBullets();
   loadLetterBitmaps(letters, data[ALPHABET_BMP].dat, data[NUMBERS_BMP].dat);
   loadLaserExplode();
   loadBulletCollision();
   loadUpsideDownY();
   loadCoinC();
   loadLaserBulletExplode();
   loadAlienBulletExplode();
   loadStartScreenAlien();
}

void destroySprites()
{ 
  destroySaucer();
   destroyLaser();
   destroyShelters();
   destroyLaserBullet();
   destroySaucerExplode();
   destroyAliens();
   destroyAlienExplode();
   destroyAlienBullets();
   destroyLaserExplode();
   destroyBulletCollision();
   destroyUpsideDownY();
   destroyCoinC();
   destroyLaserBulletExplode();
   destroyAlienBulletExplode();
   destroyStartScreenAlien();
} 


   

int aliensMovedH()
{
   int x = aliens[intPlayer]->x[0][0];
   int i;
   if (!boolAliensHaveMoved[intPlayer]) return 0;
   for (i=1; i<=4; i++)
   if (aliens[intPlayer]->x[i][0] !=x) return 0;
   boolAliensHaveMoved[intPlayer]=0;
   return 1;
}
int aliensMovedDown()
{
   if (aliens[intPlayer]->yspeed>0 && aliens[intPlayer]->ycount[4]==0)
      return 1;
   return 0;
}

int alienMaxY()
{
   int maxY=0;
   int i,j;
   for (i=0;i<=4;i++)
     for (j=0;j<=10;j++)
       if (aliens[intPlayer]->alive[i][j]==1 && aliens[intPlayer]->y[i][j] > maxY) maxY = aliens[intPlayer]->y[i][j];
       
       
       
   return maxY;
}

void updateAliens()
{
   int i, j,aType = 0;
   int k, x1,x2,shelterX, shelterY;
             int maxX=0; int minX=999;
             int boolStopNext=0;
   if (aliensMovedH()) {

      if (aliens[intPlayer]->yspeed>0) {
         if (aliensMovedDown()) 
         {
           intAlienLevel[intPlayer]++;
           intAlienDrops[intPlayer]++;

           if (alienMaxY()==(ALIEN_STARTY+176)) {
              laser->alive=0;
              play_sample(laserExplodeSound,255, 1000, 0, FALSE);
              laserExplode->x = laser->x;
              laserExplode->y = laser->y;
              laserExplode->alive=1;
              laserExplode->xcount=1;
              laserBullet->alive=0;
              boolLostLive=TRUE;
              intLives[intPlayer]=0;
           }
           updateAlienDelay(1);   
         }       

      }
      else {
          updateAlienDelay(0);
          if (aliens[intPlayer]->xdir>0) {
             
             for (j=10; j>=0; j--) {
                if (boolStopNext) break;
                for (i=0; i<=4; i++) {

                   if ((aliens[intPlayer]->alive[i][j]==1) && (aliens[intPlayer]->x[i][j] > maxX))  {
                      maxX = aliens[intPlayer]->x[i][j];boolStopNext=1;
                   }

                }
             }
          }
          if (aliens[intPlayer]->xdir<0) {

            for (j=0; j<=10; j++) {
               if (boolStopNext) break;
               for (i=0; i<=4; i++) {
             
                   if ((aliens[intPlayer]->alive[i][j]==1) && (aliens[intPlayer]->x[i][j] < minX)) {
                      minX = aliens[intPlayer]->x[i][j];boolStopNext=1;
                   }

                }
             }
          }
          if (maxX==ALIEN_XMAX || minX==ALIEN_XMIN) {
              aliens[intPlayer]->xdir *= -1;
              aliensMoveDown();
          }

   
      }
   }
   if (!boolPauseAliens && laserExplode->alive==0) {   
      updateAlienSprites(aliens[intPlayer]);                      
   }
   for (i=0;i<=4;i++) {
      aType = getAlienType(i);
      for (j=0; j<=10; j++) {

         if (aliens[intPlayer]->alive[i][j]==1) {

            for (k=0;k<=3;k++) {

               if (check_pmask_collision(shelterMask[intPlayer][k],alienMask[aType][aliens[intPlayer]->curframe[i]], 
                         shelter[intPlayer][k]->x, shelter[intPlayer][k]->y,aliens[intPlayer]->x[i][j], aliens[intPlayer]->y[i][j])) {
                  int shelterHitX = abs(shelter[intPlayer][k]->x - aliens[intPlayer]->x[i][j]);
                  int shelterHitY = abs(aliens[intPlayer]->y[i][j] - shelter[intPlayer][k]->y);
                  if (shelterHitX<0) x1=0;
                  if ((shelterHitX + aliens[intPlayer]->width[i])>43) x2=43; else x2=shelterHitX;
                
                  rectfill(shelterImage[intPlayer][k], x1, shelterHitY, x2, shelterHitY + aliens[intPlayer]->height[i] , 0);
                  destroy_pmask(shelterMask[intPlayer][k]);
                  shelterMask[intPlayer][k]=create_allegro_pmask(shelterImage[intPlayer][k]);
   
               }
            }
            draw_sprite(buffer, alienImage[aType][aliens[intPlayer]->curframe[i]], aliens[intPlayer]->x[i][j], aliens[intPlayer]->y[i][j]); 
         }               
      }
   }
}

int getAlienType(int i)
{
   if (i==0 || i==1) return 0;
   if (i==2 || i==3) return 1;
   if (i==4) return 2;
}
void updateShelters()
{
  int i;
  for (i=0;i<=3;i++)  
    draw_sprite(buffer, shelterImage[intPlayer][i], shelter[intPlayer][i]->x, shelter[intPlayer][i]->y);
}


void updateSaucer()
{
    intSaucerFrames[intPlayer]++;
    int dir;
    if (intSaucerFrames[intPlayer]>FRAMES_TILL_SAUCER) {
       play_sample(saucerSound, 255, 1000, 0,FALSE);
       intSaucerFrames[intPlayer]=0;
       saucer->alive=1;
       dir = rand() % 10000;
       if (dir<5000) { 
          saucer->xdir = -1; 
          saucer->x = 447 + XSHIFT + 32;
       }
       if (dir>=5000) { 
         saucer->xdir = 1;
         saucer->x = -32 + XSHIFT;
       }
    }
    
    if (saucer->alive==1)  {
       if (saucer->x>447 + XSHIFT + 32) saucer->alive=0;
       if (saucer->x<-33) saucer->alive=0;
        updatesprite(saucer);
      draw_sprite(buffer, saucerImage, saucer->x, saucer->y);
   }
}
void updateLaser()
{
   if (laser->alive==1)  {
      updatesprite(laser);
      draw_sprite(buffer, laserImage, laser->x, laser->y);
   }
}

void initLaserBulletExplode()
{
   laserBulletExplode->alive=1;
   laserBulletExplode->x = laserBullet->x-8;
   laserBulletExplode->y = laserBullet->y; 
   laserBulletExplode->xcount=1;
}

void updateLaserBullet()
{
    int i, j, aType, ex,ey, xrand, xranddir; 
    if (laserBullet->alive==1)  {
        // if with range of aliens
        // if within range of the aliens
        if (laserBullet->y <= (aliens[intPlayer]->y[0][0]+ ALIEN_HEIGHT)
          && (laserBullet->y + laserBullet->width)  >= aliens[intPlayer]->y[4][0])
        {
           for (i=0;i<=4;i++)  {
              for (j=0;j<=10;j++) {
                 if (aliens[intPlayer]->alive[i][j]==1) { 
                    aType = getAlienType(i);
                    if (check_pmask_collision(alienMask[aType][aliens[intPlayer]->curframe[i]], 
                        laserBulletMask,aliens[intPlayer]->x[i][j], aliens[intPlayer]->y[i][j], laserBullet->x, laserBullet->y)) {
                        alienExplode->x = aliens[intPlayer]->x[i][j];
                        alienExplode->y = aliens[intPlayer]->y[i][j];
                        alienExplode->alive=1;
                        alienExplode->ycount=1;
                        laserBullet->alive=0;
                        aliens[intPlayer]->alive[i][j]=0;
                        countColDead[intPlayer][j] += pow(2,i);
                        play_sample(alienExplodeSound, 255, 1000, 0, FALSE);
                        if (countColDead[intPlayer][j] < 31) {
                           if (bottomAlien[intPlayer][j] == i) {
                              int k;
                              for (k=i+1; k<=4; k++) {
                                 if (aliens[intPlayer]->alive[k][j]==1) {
                                    bottomAlien[intPlayer][j]=k;
                                    break;
                                 }
                              }
                           }
                        }
                     
                     
                        boolPauseAliens = 1;
                        intAliensAlive[intPlayer]--;
                        if (i==0 || i==1) {  
                           intScore[intPlayer]+=10;
                           intScoreExtraLive[intPlayer]+=10;
                        }
                        else if (i==2 || i==3) {
                           intScore[intPlayer]+=20;
                           intScoreExtraLive[intPlayer]+=20;
                        } 
                        else if (i==4) {
                           intScore[intPlayer]+=30;
                           intScoreExtraLive[intPlayer]+=30;
                        }
                        return;
                     }
                  }
               }
            }
         }
         // have we hit a shelter?
         
         for (i=0; i<=3; i++) {
            if (check_pmask_collision(laserBulletMask, 
                        shelterMask[intPlayer][i], laserBullet->x, laserBullet->y,shelter[intPlayer][i]->x, shelter[intPlayer][i]->y)) {
               int x1,x2,boxY;

               laserBullet->alive=0;
               int shelterHitX = abs(shelter[intPlayer][i]->x - laserBullet->x);
               int shelterHitY = abs(shelter[intPlayer][i]->y - laserBullet->y);
               boxY = shelterHitY-7;
               if ((shelterHitX-7)<0)
                  boxY=0;
               xrand = rand() % 3;
               xranddir = rand() % 100;
               if (xranddir>50) xranddir=1;else xranddir=-1;
               if ((shelterHitX-2)<0) x1=0; else x1=shelterHitX-2;
               if ((shelterHitX+2)>43) x2=43; else x2=shelterHitX+2;
               
               for (ey=(laserBulletExplodeImage->h); ey>=0;ey--)  {
                  for(ex=0; ex<laserBulletExplodeImage->w; ex++) {  
                     if (getpixel(laserBulletExplodeImage, ex, ey))
                     putpixel(shelterImage[intPlayer][i], x1-7+ (xrand * xranddir) +ex,shelterHitY  - abs(ey - laserBulletExplodeImage->h)+11  , 0);
                  }
               }
              // rectfill(shelterImage[intPlayer][i], x1,boxY, x2, SHELTER_HEIGHT-1, 0);
               destroy_pmask(shelterMask[intPlayer][i]);
               shelterMask[intPlayer][i]=create_allegro_pmask(shelterImage[intPlayer][i]);
               
               initLaserBulletExplode();              
              // laserBullet->alive=0;

             }
         }
          
         if ( saucer->alive==1 && check_pmask_collision(laserBulletMask, 
                        saucerMask, laserBullet->x, laserBullet->y,saucer->x, saucer->y)) {   
             int scoreType;
             laserBullet->alive=0;
             saucer->alive=0;
             play_sample(laserExplodeSound, 255, 1000, 0, FALSE);
             saucerExplode->xcount=1;
             saucerExplode->alive=1;
             saucerExplode->x = saucer->x;
             saucerExplode->y = saucer->y;
             if (intMaxedOut[intPlayer]==0 && intLaserBulletsFired[intPlayer]==23) {
                saucerExplode->type=3;
                intMaxedOut[intPlayer]++;
                intScoreExtraLive[intPlayer]+=300;
                intScore[intPlayer] += 300;
                intLaserBulletsFired[intPlayer]=0;
             } 
             else if (intMaxedOut[intPlayer]==1 && intLaserBulletsFired[intPlayer]==15) {
                saucerExplode->type=3;
                intScore[intPlayer] +=-300;
                intScoreExtraLive[intPlayer]+=300;
                intLaserBulletsFired[intPlayer]=0;
             }
             else {
                scoreType = rand() % 150;
                if (scoreType <=50) { 
                   intScore[intPlayer]+=50;
                   intScoreExtraLive[intPlayer]+=50;
                   saucerExplode->type=0;
                }
                else if (scoreType >=51 && scoreType<=100)  {
                   intScore[intPlayer]+=100;
                   intScoreExtraLive[intPlayer]+=100;
                   saucerExplode->type=1;
                }
                else if (scoreType>=101) {
                   intScore[intPlayer]+=150;
                   intScoreExtraLive[intPlayer]+=150;
                   saucerExplode->type=2;
                }
                intMaxedOut[intPlayer]=2;
             }
         }   
                
         for (i=0;i<=intMaxAlienBulletsLive[intPlayer]-1; i++) {
            if (alienBullets[i]->alive==1 && check_pmask_collision(laserBulletMask, 
                        alienBulletMask[alienBullets[i]->type][alienBullets[i]->curframe], laserBullet->x, laserBullet->y,alienBullets[i]->x, alienBullets[i]->y)) {
                int destroyAlienBullet = rand() % 5000;
                bulletCollision[i]->type=2; 
            
                if (destroyAlienBullet <250) {
                   alienBullets[i]->alive=0;
                   intAlienBulletsLive--;
                   bulletCollision[i]->type=1;
                }
  
                alienBullets[i]->yspeed=0;
                laserBullet->alive=0;
                bulletCollision[i]->alive=1;
                bulletCollision[i]->x = alienBullets[i]->x-12;
                bulletCollision[i]->y = alienBullets[i]->y;
                bulletCollision[i]->xcount=1;       
                bulletCollision[i]->type=i;
             }
         }
    
    }       
       
    if (laserBullet->alive==1) {              
         updatesprite(laserBullet);
         if (laserBullet->y<=LASER_BULLET_MINY-4) {
            initLaserBulletExplode();
            laserBullet->alive=0;
         }
         draw_sprite(buffer, laserBulletImage, laserBullet->x, laserBullet->y);
    }
    
}

void updateLaserBulletExplode()
{

   if (laserBulletExplode->alive==1) {
      updatesprite(laserBulletExplode);
      draw_sprite(buffer, laserBulletExplodeImage, laserBulletExplode->x,laserBulletExplode->y);
      if (laserBulletExplode->xcount==0) laserBulletExplode->alive=0;
   }

}

void updateAlienBulletExplode()
{
   int i;
   for (i=0;i<=2;i++) {
      if (alienBulletExplode[i]->alive==1) {
        updatesprite(alienBulletExplode[i]);
        draw_sprite(buffer, alienBulletExplodeImage, alienBulletExplode[i]->x, alienBulletExplode[i]->y);
        if (alienBulletExplode[i]->xcount==0) alienBulletExplode[i]->alive=0;
      }
   }
}

void initAlienBulletExplode(int i)
{
   alienBulletExplode[i]->alive=1;
   alienBulletExplode[i]->x = alienBullets[i]->x-8;
   alienBulletExplode[i]->y = alienBullets[i]->y+8; 
   alienBulletExplode[i]->xcount=1;
}
void updateAlienBullet()
{
   int i,j,shelterHitX,shelterHitY,X,Y,p;
   int ey, ex, xrand, xranddir;
   for (i=0;i<=2;i++) {
      if (alienBullets[i]->alive==1) {
        
         for (j=0; j<=3; j++) {
            if (check_pmask_collision(alienBulletMask[alienBullets[i]->type][alienBullets[i]->curframe],
                        shelterMask[intPlayer][i], alienBullets[i]->x, alienBullets[i]->y,shelter[intPlayer][j]->x, shelter[intPlayer][j]->y)) {
               alienBullets[i]->alive=0;
               intAlienBulletsLive--;
               shelterHitX = abs(shelter[intPlayer][j]->x - alienBullets[i]->x);
               if ((SHELTER_STARTY - (alienBullets[i]->y + alienBullets[i]->height))>0) {
                  shelterHitY=0;
               }
               else {
                  shelterHitY = abs((alienBullets[i]->y + alienBullets[i]->height)) - shelter[intPlayer][j]->y;
               }
        
               xrand = rand() % 4;
               xranddir = rand() % 10;
               if (xranddir >5) xranddir = -1; else xranddir=1;
               for (ey=(alienBulletExplodeImage->h); ey>=0;ey--) {
                  for(ex=0; ex<alienBulletExplodeImage->w; ex++) {  
                     if (getpixel(alienBulletExplodeImage, ex, ey))
                     putpixel(shelterImage[intPlayer][j], shelterHitX-7+ (xrand * xranddir) +ex,shelterHitY  + abs(ey - alienBulletExplodeImage->h)-5  , 0);
                  }
               }

               destroy_pmask(shelterMask[intPlayer][j]);
               shelterMask[intPlayer][j]=create_allegro_pmask(shelterImage[intPlayer][j]);
               initAlienBulletExplode(i);
            }      
                             
         }
         if (laser->alive==1 && check_pmask_collision(alienBulletMask[alienBullets[i]->type][alienBullets[i]->curframe],
                        laserMask, alienBullets[i]->x, alienBullets[i]->y,laser->x, laser->y)) { 
            alienBullets[i]->alive=0;
            intAlienBulletsLive--;
            laser->alive=0;
            play_sample(laserExplodeSound,255, 1000, 0, FALSE);
            laserExplode->x = laser->x;
            laserExplode->y = laser->y;
            laserExplode->alive=1;
            laserExplode->xcount=1;
            laserBullet->alive=0;
            alienBullets[i]->alive=0;
            boolLostLive=TRUE;
            intLives[intPlayer]--;
         }

         updatesprite(alienBullets[i]);
         if ((alienBullets[i]->y)>440) 
         {
            initAlienBulletExplode(i);
            alienBullets[i]->alive=0;
            intAlienBulletsLive--;
         }
         
         
         draw_sprite(buffer, alienBulletImage[alienBullets[i]->type][alienBullets[i]->curframe],
                        alienBullets[i]->x, alienBullets[i]->y);
      }
   }

 

}


void updateBulletCollision()
{
   int i;
   for (i=0;i<=2;i++)  {
      if (bulletCollision[i]->alive==1) {
         updatesprite(bulletCollision[i]);
         if (bulletCollision[i]->xcount==0) {
            bulletCollision[i]->alive=0;
            alienBullets[bulletCollision[i]->type]->yspeed =2;
            alienBullets[bulletCollision[i]->type]->alive=1;
         } 
         if (bulletCollision[i]->type==1) {
            draw_sprite(buffer, alienBulletExplodeImage, bulletCollision[i]->x, bulletCollision[i]->y);
            draw_sprite(buffer, laserBulletExplodeImage, bulletCollision[i]->x, bulletCollision[i]->y);
         }
         else {
            draw_sprite(buffer, alienBulletExplodeImage, bulletCollision[i]->x, bulletCollision[i]->y);
         }
      }
   }
}

void updateLaserExplode()
{
   if (laserExplode->alive==1) {
      if (laserExplode->xcount==0) {
         laserExplode->alive=0;
         laser->x=LASER_STARTX;
         laser->y=LASER_STARTY;
         laser->alive=1;
      }
      else {
          
         updatesprite(laserExplode);
         if (laserExplode->xcount<200)
             draw_sprite(buffer, laserExplodeImage[laserExplode->curframe],laserExplode->x, laserExplode->y);
      }
   }
}
void updateAlienExplode()
{
   if (alienExplode->alive==1) {
      updatesprite(alienExplode);
      draw_sprite(buffer, alienExplodeImage, alienExplode->x, alienExplode->y);
      if (alienExplode->ycount==0) {
         alienExplode->alive=0;
         boolPauseAliens=0;
      }
   }
}

void updateSaucerExplode()
{
   BITMAP *exImage;
   if (saucerExplode->alive==1) {
      if (saucerExplode->xcount==99 && saucerExplode->curframe==1) {
         saucerExplode->alive=0;
      }
      updatesprite(saucerExplode);
      if (saucerExplode->curframe==1) 
            exImage= saucerExplodeImage[saucerExplode->type];
      else
            exImage = saucerExplodeImage[4];
      draw_sprite(buffer, exImage, saucerExplode->x, saucerExplode->y);
   }
}

int updateAlienSprites(ALIENSX *al)
// From Game Programming all in one, by J Harbour
// (Just to get me started hehe)
{
    //update x position
    int i;int j;
    for(i=0;i<=4;i++)  {
       if (++al->xcount[i] > al->xdelay) {
             al->xcount[i] = 0;
          for (j=0;j<11;j++) {
             al->x[i][j] += al->xspeed * al->xdir;
             boolAliensHaveMoved[intPlayer]=1;
          }
       }

          //update y position
       if (++al->ycount[i] > al->ydelay) {
          al->ycount[i] = 0;
          for (j=0;j<=10;j++)  { 
             
             al->y[i][j] += al->yspeed * al->ydir;
          }
       }
  
      //update frame based on animdir
      if (++al->framecount[i] > al->framedelay)  {
         al->framecount[i] = 0;
         if (al->animdir == -1)  {
            if (--al->curframe[i] < 0)
                al->curframe[i] = al->maxframe;
         }
         else if (al->animdir == 1) {
            if (++al->curframe[i] > al->maxframe)
                al->curframe[i] = 0;
         }
      }
   }
}

int updatesprite(SPRITE *spr)
// From Game Programming all in one, by J Harbour
// (Just to get me started hehe)
{
    //update x position
    if (++spr->xcount > spr->xdelay)  {
        spr->xcount = 0;
        spr->x += spr->xspeed * spr->xdir;
    }

    //update y position
    if (++spr->ycount > spr->ydelay)  {
        spr->ycount = 0;
        spr->y += spr->yspeed * spr->ydir;
    }

    //update frame based on animdir
    if (++spr->framecount > spr->framedelay) {
        spr->framecount = 0;
        if (spr->animdir == -1)  {
            if (--spr->curframe < 0)
                spr->curframe = spr->maxframe;
        }
        else if (spr->animdir == 1) {
            if (++spr->curframe > spr->maxframe)
                spr->curframe = 0;
        }
    }
}

void playAlienMoveSound()
{        
   if (intAlienSoundTicks >= alienDelay[intPlayer] &&  voice_get_position(intAlienMoveVoice)==-1) {
      intAlienMoveVoice = play_sample(aliensSound[intAlienCurrentSound], 255, 1000, 1, FALSE);
      intAlienCurrentSound++;
      if (intAlienCurrentSound==4) intAlienCurrentSound=0;
      intAlienSoundTicks=0;   
   }
   intAlienSoundTicks++;

}



void displayStats()
{
  // textprintf(buffer, font, 0, 420, WHITE, "alien level %i", intLevel[intPlayer]);
}

void target_incrementor(void)
{
   target_cycle++;
}
END_OF_FUNCTION(target_incrementor);
void gameCycle()
{
   clear(buffer);
   drawBorders();
   displayScore(intScore[0],0);
   displayScore(intScore[1],1);
   displayScoreHeading();
   displayHiScore(intHiScore);
   displayCredits(intCredits);
   displayLives(intLives[intPlayer]);
   initAlienBullets();
   updateLaser();
   updateLaserBullet();
   updateAlienBullet();
   if (intAlienDrops[intPlayer]==5 || intAliensAlive[intPlayer]==25) intMaxAlienBulletsLive[intPlayer]=2;
   if (intAliensAlive[intPlayer]<6)
   {
      intMaxAlienBulletsLive[intPlayer]=3;
   }  
   updateAliens();
   updateAlienExplode();
   updateSaucerExplode(); 
   updateLaserBulletExplode();     
   updateShelters();
   updateLaserExplode();
   updateBulletCollision();
   playAlienMoveSound();
   updateSaucer();
   updateAlienBulletExplode();
   displayStats();
//     alienMoveSound();

     
     
   if (intAliensAlive[intPlayer]==2) {  
      alienDelayDX[intPlayer]=2;
      alienDelay[intPlayer]=2;
   }
   else if(intAliensAlive[intPlayer]==1) {
      alienDelayDX[intPlayer]=0;
      alienDelay[intPlayer]=0;
   }
   else {
      alienDelay[intPlayer]=110-((55-intAliensAlive[intPlayer])*2);
      alienDelayDX[intPlayer] = alienDelay[intPlayer]/5;   
   }
   if (intScoreExtraLive[intPlayer]>=1500) {
      intLives[intPlayer]++;
      intScoreExtraLive[intPlayer]=intScoreExtraLive[intPlayer] - 1500;
   }
   actual_cycle++;
}

void drawFrame()
{

   acquire_screen();
   vsync();   
   blit(buffer, screen, 0, 0, 0, 0, WIDTH-1, HEIGHT-1);
//      drawBordersScreen();
   release_screen();
   frame_counter++;
   ticks++;
}
void timer1(void)
{
   counter++;
   framerate = ticks;
   ticks=0;
   rested=resting;
   
}

void rest1(void)
{
   resting++;
}
END_OF_FUNCTION(timer1);

void initialize()
{
   allegro_init();
   install_keyboard();
   install_timer();
   set_gfx_mode(MODE, WIDTH, HEIGHT, 0, 0);
   
   set_color_depth(8);
   text_mode(-1);
   buffer = create_bitmap(WIDTH, HEIGHT); 
   if (buffer==NULL) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error creating double buffer");
      return;
   }
   clear(buffer);
   set_clip(buffer, XSHIFT-5, 0, 447+XSHIFT+5, HEIGHT);

   reserve_voices(8,8);
   set_volume_per_voice(2);
   if (install_sound(DIGI_AUTODETECT, MIDI_NONE, "")!=0)  {
       allegro_message("Error initializing sound system");
       return;
   }
   
   
   LOCK_VARIABLE(counter);
   LOCK_VARIABLE(framerate);
   LOCK_VARIABLE(ticks);
   LOCK_FUNCTION(timer1);
   LOCK_VARIABLE(target_cycle);
   LOCK_FUNCTION(target_incrementor);
   install_int_ex(target_incrementor, BPS_TO_TIMER(140));
   install_int(timer1, 1000);
   actual_cycle = ticks = target_cycle = 0;
}

void initLevel(int player)
{
   int i;
   for (i=0;i<=10;i++)  { 
      countColDead[player][i]=0;
      bottomAlien[player][i]=0;
   }
   intLaserBulletsFired[player]=0;
   boolAliensHaveMoved[player]=0;
   alienDelay[player]=110;
   alienDelayDX[player] = alienDelay[player]/5;   
   updateAlienDelay(1);
   intAliensAlive[player]=55; 
   intAlienBulletsLive=0;
   intMaxedOut[player]=0;
   boolPauseAliens = 0;
   intAlienLevel[player] = intLevel[player];
   intMaxAlienBulletsLive[player]=1;
   intAlienDrops[player]=0;
   intSaucerFrames[player]=0;
   saucer->alive=0;
   intAlienSoundTicks=0;
   laser->x = LASER_STARTX;
   for (i=0;i<=2;i++) alienBullets[i]->alive=0;
   laserBullet->alive=0;
}
void increaseLevel(int player)
{
  // if (intLevel[player]==1) {
  //    intLevel[player]=5;
  // }
  // else
      intLevel[player]++;
   if (intLevel[player]>=10) intLevel[player]=1;
   initAliensForLevel(intLevel[player],player);
   initSheltersForLevel(player);
   initLevel(player);
   alienExplode->alive=0;         
   alienExplode->ycount=0;
   laserBullet->alive=0;
   buildAliens(player);
}


void initGame(int player)
{
   int i;
   intScore[player]=0;
   intScoreExtraLive[player]=0;
   intLives[player] = 3;
   intLevel[player]=1; 

}
void checkInput()
{
   if (boolDemoOn) {
      
      if (target_cycle>=demo[intDemoMovesDone][1]) {
         if (demo[intDemoMovesDone][0]==1) {      
            laser->x -= 1;
            if (laser->x<LASER_XMIN) laser->x = LASER_XMIN;
          
         }
         if (demo[intDemoMovesDone][0]==2) {
           laser->x += 1;
           if (laser->x>LASER_XMAX) laser->x = LASER_XMAX;
         }
         if (demo[intDemoMovesDone][0]==3) {
            if (laserBulletExplode->alive==0 && laserBullet->alive==0 && 
               alienExplode->ycount==0 && laser->alive==1) {  
               play_sample(laserBulletSound, 255,1000,0, FALSE);
               laserBullet->alive=1;
               laserBullet->x = laser->x + laser->width/2;
               laserBullet->y = laser->y;
               intLaserBulletsFired[intPlayer]++;
            }
   
         }
         intDemoMovesDone++;   
      }
      if (key[KEY_ESC]) boolShutDown=1;
   }
   else if (!boolDemoOn) {
      if (key[KEY_LEFT]) {
         laser->x -= 1;
#if defined(_RECORDINGDEMO)      
         fprintf(fpKeyPresses, "demo[%i][0]=1;\ndemo[%i][1]=%i;\n",intDemoMoves, intDemoMoves,target_cycle);
         intDemoMoves++; 
#endif      
         if (laser->x<LASER_XMIN) laser->x = LASER_XMIN;
      }
      if (key[KEY_RIGHT]) {
#if defined(_RECORDINGDEMO)      
         fprintf(fpKeyPresses, "demo[%i][0]=2;\ndemo[%i][1]=%i;\n",intDemoMoves, intDemoMoves,target_cycle);
         intDemoMoves++; 
#endif
         laser->x += 1;
         if (laser->x>LASER_XMAX) laser->x = LASER_XMAX;
      }
      if (key[KEY_SPACE]) {
#if defined(_RECORDINGDEMO)      
         fprintf(fpKeyPresses, "demo[%i][0]=3;\ndemo[%i][1]=%i;\n",intDemoMoves, intDemoMoves,target_cycle);
         intDemoMoves++; 
#endif
         if (laserBulletExplode->alive==0 && laserBullet->alive==0 && 
             alienExplode->ycount==0 && laser->alive==1) {  
           
            play_sample(laserBulletSound, 255,1000,0, FALSE);
            laserBullet->alive=1;
            laserBullet->x = laser->x + laser->width/2;
            laserBullet->y = laser->y;
            intLaserBulletsFired[intPlayer]++;
          }
      }   
      if (key[KEY_ESC]) boolShutDown=1;
   }
}



void playTwoPlayerGame()
{
   actual_cycle = ticks = target_cycle = 0;
   intPlayer=0;
   int boolGameOver = 0;
   initGame(0);
   initLevel(0);
   
   initAliensForLevel(intLevel[intPlayer],0);
   initSheltersForLevel(0);


   initGame(1);
   initLevel(1);
   
   initAliensForLevel(intLevel[1],1);
   initSheltersForLevel(1);

   boolLostLive= FALSE;

   int intCurrLives  = intLives[0];
   int boolSwitchPlayers=FALSE;
   int i;
   while ((intLives[0]>0 || intLives[1] >0) && !boolShutDown) { 
      boolLostLive=FALSE;
      boolSwitchPlayers=FALSE; 
      playPlayerScreen(intPlayer);

      buildAliens(intPlayer);

      intAlienBulletsLive=0;
      for (i=0;i<=2;i++) alienBullets[i]->alive=0;
      saucer->alive=0;
      gameCycle();
  

      while(!boolShutDown && !boolGameOver && !boolSwitchPlayers) {  
         drawFrame();
         while (target_cycle>actual_cycle && !boolShutDown && !boolGameOver && !boolSwitchPlayers) {       
            intCurrLives = intLives[intPlayer];   
            checkInput();
            gameCycle();
            if (intAliensAlive[intPlayer]==0) {
               drawFrame();
               rest(500);
               increaseLevel(intPlayer);
               gameCycle();
               break;
            }
            if (intLives[intPlayer]==0) {
               if (laserExplode->xcount==0) {
                  writeString(buffer,"GAME   ....OVER", 146 + XSHIFT,128 + YSHIFT, letters);
                  drawFrame();
                  rest(3000);
                  if (intScore[intPlayer]>intHiScore) intHiScore = intScore[intPlayer];
                  boolSwitchPlayers=TRUE;
               } 
            }
  
            if (boolLostLive && laserExplode->xcount==0) {
               if (intPlayer==0 && intLives[1]>0) intPlayer=1; else intPlayer=0;
             
               boolSwitchPlayers = TRUE;
               laserExplode->alive=0;
               laser->alive=1;
               laser->x = LASER_STARTX;
            }   
         } 
  
      }  
  
  
   }
   intScore[0]=0;
   intScore[1]=0;
}   

void playOnePlayerGame()
{
   actual_cycle = ticks = target_cycle = 0;
   intPlayer=0;
   int boolGameOver = 0;
   initGame(0);
   initLevel(0);
#if defined(_RECORDINGDEMO) 
   intDemoMoves=0;
   fpKeyPresses = fopen("keys.txt","w");
   srand(300);
#endif    
   initAliensForLevel(intLevel[0],0);

   initSheltersForLevel(0);
   buildAliens(0);
  


   actual_cycle = ticks = target_cycle = 0;
   if (boolDemoOn) 
   {
      intDemoMovesDone=0;
      intDemoDiff=target_cycle;
   }
   gameCycle();
  
   while(!boolShutDown && !boolGameOver) {  
      drawFrame();
      while (target_cycle>actual_cycle && !boolShutDown && !boolGameOver) {       
         checkInput();
         gameCycle();
         if (intAliensAlive[0]==0) {
            drawFrame();
            rest(500);
            increaseLevel(0);
            gameCycle();
            break;
         }
         if (intLives[0]==0) {
            if (laserExplode->xcount==0) {
               writeString(buffer,"GAME   ....OVER", 146 + XSHIFT,128 + YSHIFT, letters);
               drawFrame();
               rest(3000);
               boolGameOver=1;
               if (intScore[0]>intHiScore) intHiScore = intScore[0];
               intScore[0]=0;
            } 
         }
      } 
   }  
#if defined(_RECORDINGDEMO)  
   fclose(fpKeyPresses);
#endif
}   

void demoScreen()
{
   srand(300);
   actual_cycle = ticks = target_cycle = 0;
   intPlayer=0;
   int boolGameOver = 0;
   boolLostLive=0;
   initGame(0);
   initLevel(0);
  
   intDemoMovesDone=0;

    
   initAliensForLevel(intLevel[0],0);

   initSheltersForLevel(0);
   buildAliens(0);
   intPlayer=0;

   actual_cycle = ticks = target_cycle = 0;
   boolDemoOn=1;
   gameCycle();

   while(!boolShutDown && !boolGameOver && intCredits==0) {  
      drawFrame();
      while (target_cycle>actual_cycle && !boolShutDown && !boolGameOver && intCredits==0) {       
         checkInput();
         if (key[KEY_3]) {
            clear_keybuf();
            intCredits++; 
            rest(1500);
            clear_keybuf();
         }
         gameCycle();
         if (boolLostLive && laserExplode->xcount==0) boolGameOver=1;
      } 
 
   }  
   boolDemoOn=0;
   intScore[0]=0;
   intLives[0]=0;
}   

void main(void)
{
   int boolShowAnimation=0;

   intHiScore = 0;
   intCredits = 0;
   boolStartGame=0;
   boolShutDown=0;
   intAlienCurrentSound=0;
   intAlienMoveVoice=0;
   intPlayer=0;

   initialize();
   loadSprites(); 
   initDemo(); 

   while (!boolShutDown) {

      while (intCredits==0 && !boolShutDown) {
         scoreAdvanceScreen(boolShowAnimation);
         if (intCredits>0 || boolShutDown) break;

         playerInfoScreen(boolShowAnimation);
         if (boolShowAnimation==1) boolShowAnimation=0;else boolShowAnimation=1;
         if (intCredits>0 || boolShutDown) break;
         demoScreen();
         clearAliens();
      }
  
      while (intCredits>0 && !boolShutDown) {

         startGameScreen();
         if (boolStartGame==1) {
            srand(0);
            boolStartGame=0;
            intCredits--;
            playPlayerScreen(0);
            playOnePlayerGame();
            clearAliens();
         }
         else if (boolStartGame==2) { 
            srand(0);
            boolStartGame=0;
            intCredits-=2;
            playTwoPlayerGame();
            clearAliens();
         }
      
      }
   
   } 
   destroySprites();
   destroyLetterBitmaps(letters);
   unload_datafile(data);
   destroy_bitmap(buffer);
   remove_sound();

   allegro_exit();
  

}
END_OF_MAIN();
