#include <allegro.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "pmask.h"

#ifdef _DEBUG
#define res_type  GFX_AUTODETECT_WINDOWED
#else
#define res_type  GFX_AUTODETECT_FULLSCREEN
#endif

#define res_x     800
#define res_y     600
#define res_z     16

#define physics_x     4000
#define physics_y     4000

#define file_name1 "a.dat"

struct ASTDATA {
	float x, y;
	float vx, vy;
	float angle, spin;
	float mass;
};

int view_x = 0;
int view_y = 0;
int num_asteroids = 0;
enum { max_asteroids = 5000 };
struct ASTDATA asteroid[max_asteroids];
BITMAP *vscreen = NULL;//screen buffer
BITMAP *sprite[64];
PMASK *mask[64];

#ifndef PI
#define PI 3.14159265358979
#endif

void add_asteroid() {
	int n = num_asteroids;
	if (n == max_asteroids) return;
	asteroid[n].x = physics_x * rand() / (float)RAND_MAX;
	asteroid[n].y = physics_y * rand() / (float)RAND_MAX;
	asteroid[n].vx = 2.0 * (2.0 * (rand() / (float)RAND_MAX - 0.5));
	asteroid[n].vy = 2.0 * (2.0 * (rand() / (float)RAND_MAX - 0.5));
	asteroid[n].angle = PI * 2 * (rand() / (float)RAND_MAX);
	asteroid[n].spin = 1.0 / 64 * PI * 2 * (2.0 * (rand() / (float)RAND_MAX - 0.5));
	asteroid[n].mass = 0.1 + 1.0 * (rand() / (float)RAND_MAX);
	num_asteroids += 1;
}
void remove_asteroid() {
	if (num_asteroids == 0) return;
	num_asteroids -= 1;
}
void collide_asteroids ( struct ASTDATA *a1, struct ASTDATA *a2 ) {
	float dx = a1->x - a2->x;
	float dy = a1->y - a2->y;
	float d = sqrt(dx * dx + dy * dy);
	float dvx = a1->vx - a2->vx;
	float dvy = a1->vy - a2->vy;
	float impact = -2 / d * (dx * dvx + dy * dvy);
	if (d == 0) return;//we can't handle this...
	//move each one 1 pixel further away...
	dx /= d;
	dy /= d;
	a1->x += dx;
	a1->y += dy;
	a2->x -= dx;
	a2->y -= dy;
	//adjust velocities
	if (impact < 0) return;//weird collision (should only happen in unusual circumstances)
//	return;
	impact = impact / (a1->mass + a2->mass);
	a1->vx += impact * a2->mass * dx;
	a1->vy += impact * a2->mass * dy;
	a2->vx -= impact * a1->mass * dx;
	a2->vy -= impact * a1->mass * dy;
	return;
}
void do_physics(float dt) {
	int i;
	enum { max_collisions = 1024 };//maximum number of collisions in a single frame of physics
	int num_collisions;
	PMASKDATA_FLOAT *collidable = malloc(sizeof(PMASKDATA_FLOAT) * num_asteroids);
	struct ASTDATA *collision_list[max_collisions * 2];
	for (i = 0; i < num_asteroids; i += 1) {
		asteroid[i].x += asteroid[i].vx * dt;
		if (asteroid[i].x < 0) {
			asteroid[i].x = 0;
			asteroid[i].vx = fabs(asteroid[i].vx);
		}
		if (asteroid[i].x > physics_x) {
			asteroid[i].x = physics_x;
			asteroid[i].vx = -1 * fabs(asteroid[i].vx);
		}
		asteroid[i].y += asteroid[i].vy * dt;
		if (asteroid[i].y < 0) {
			asteroid[i].y = 0;
			asteroid[i].vy = fabs(asteroid[i].vy);
		}
		if (asteroid[i].y > physics_y) {
			asteroid[i].y = physics_y;
			asteroid[i].vy = -1 * fabs(asteroid[i].vy);
		}
		asteroid[i].angle += asteroid[i].spin * dt;
		while (asteroid[i].angle < 0) asteroid[i].angle += PI * 2;
		while (asteroid[i].angle >= PI * 2) asteroid[i].angle -= PI * 2;
	}
	for (i = 0; i < num_asteroids; i += 1) {
		int index = asteroid[i].angle * 64 / (PI * 2);
		if (index >= 64) {
			__asm int 3
			index = 63;//exit(1);
		}
		if (index < 0) {
			__asm int 3
		}
		collidable[i].x = asteroid[i].x;
		collidable[i].y = asteroid[i].y;
		collidable[i].pmask = mask[index];
		collidable[i].data = &asteroid[i];
	}
	num_collisions = check_pmask_collision_list_float(&collidable[0], num_asteroids, collision_list, max_collisions);
	free(collidable);
	for (i = 0; i < num_collisions; i += 1) {
		collide_asteroids(collision_list[i * 2], collision_list[i * 2 + 1]);
	}
	return;
}
void do_graphics() {
	int i;
	for (i = 0; i < num_asteroids; i += 1) {
		int index = asteroid[i].angle * 64 / (PI * 2);
		//if (index >= 64) index = 63;//exit(1);
		if (index < 0) {
			__asm int 3
		}
		if (index >= 64) {
			__asm int 3
		}
		draw_sprite(vscreen, sprite[index], asteroid[i].x - view_x, asteroid[i].y - view_y);
	}
	return;
}
void do_flip() {
//	vsync();
	blit(vscreen, screen, 0, 0, 0, 0, vscreen->w, vscreen->h);
	clear_to_color(vscreen, 0);
	return;
}

int main (int argc, char **argv) {
	int i;
	int otime, bob = 0;
	DATAFILE *data;
	RLE_SPRITE *tmprle;
	BITMAP *tmpbmp;
	srand(time(NULL));
	allegro_init();
	install_keyboard();
	install_timer();
	set_color_depth(res_z);
	if (set_gfx_mode(res_type, res_x, res_y, 0, 0) < 0) {
		allegro_message(allegro_error);
		exit(0);
	}
//	vscreen = create_video_bitmap(res_x, res_y);
	if (!vscreen) vscreen = create_bitmap(res_x, res_y);
	if (!vscreen) {
		textprintf(screen, font, 0, 100, palette_color[15], "An error occured creating a bitmap");
		while (!keypressed()) ;
		exit(0);
	}

	data = load_datafile(file_name1);
	if (!data) {
		textprintf(screen, font, 0, 100, palette_color[15], "An error occured loading the file %s", file_name1);
		while (!keypressed()) ;
		exit(0);
	}
	tmprle = data[0].dat;
	tmpbmp = create_bitmap_ex(tmprle->color_depth, tmprle->w, tmprle->h);
	if (!tmpbmp) {
		textprintf(screen, font, 0, 100, palette_color[15], "An error occured creating a bitmap");
		while (!keypressed()) ;
		exit(0);
	}
	clear_to_color(tmpbmp, bitmap_mask_color(tmpbmp));
	draw_rle_sprite(tmpbmp, tmprle, 0, 0);
	unload_datafile(data);
	tmprle = NULL;

	install_pmask();
	for (i = 0; i < 64; i += 1) {
		sprite[i] = create_sub_bitmap(tmpbmp, (i%8) * tmpbmp->w / 8, (i/8) * tmpbmp->h / 8, tmpbmp->w / 8, tmpbmp->h / 8);
		mask[i] = create_allegro_pmask(sprite[i]);
		if (!tmpbmp) {
			textprintf(screen, font, 0, 100, palette_color[15], "An error occured");
			while (!keypressed()) ;
			exit(0);
		}
	}

	while (keypressed()) readkey();

	for (i = 0; i < 1000; i += 1) add_asteroid();
	otime = retrace_count;
	while (!key[KEY_ESC]) {
		int dt = retrace_count - otime;
		otime += dt;
		if (dt > 0) {
			bob += dt;
			if (key[KEY_RIGHT] || key[KEY_6_PAD]) {
				view_x += dt * 5;
				if (view_x > physics_x - res_x) {
					view_x = physics_x - res_x;
					if (view_x < 0) view_x = 0;
				}
			}
			if (key[KEY_LEFT] || key[KEY_4_PAD]) {
				view_x -= dt * 5;
				if (view_x < 0) view_x = 0;
			}
			if (key[KEY_UP] || key[KEY_8_PAD]) {
				view_y -= dt * 5;
				if (view_y < 0) view_y = 0;
			}
			if (key[KEY_DOWN] || key[KEY_2_PAD]) {
				view_y += dt * 5;
				if (view_y > physics_y - res_y) {
					view_y = physics_y - res_y;
					if (view_y < 0) view_y = 0;
				}
			}
			if (bob >= 5) {
				do_graphics();
				text_mode(-1);
				textprintf(vscreen, font, 0, 0, palette_color[15], 
					"This is a test program for Pixel MASK collision detection library");
				textprintf(vscreen, font, 0, 15, palette_color[15], 
					"With %d asteroids bouncing around in real-time", num_asteroids);
				textprintf(vscreen, font, 0, 30, palette_color[15], 
					"In a %d by %d pixel region", (int)physics_x, (int)physics_y);
				textprintf(vscreen, font, 0, 45, palette_color[15], 
					"You're only seeing the upper left %d by %d pixels", (int) res_x, (int) res_y);
				textprintf(vscreen, font, 0, 60, palette_color[15], 
					"Press Page Up / Page Down to increase / decrease the # of asteroids.");
				textprintf(vscreen, font, 0, 75, palette_color[15], 
					"Use the arrow keys to move your view-point");
				textprintf(vscreen, font, 0, 90, palette_color[15], 
					"Press ESCAPE to quit.");
				if (dt > 4) textprintf(vscreen, font, 0, 105, palette_color[12], 
					"The current number of asteroids cannot be simulated at full speed");
				while (keypressed()) switch (readkey() >> 8) {
					case KEY_PGUP:
						for (i = 0; i < 50; i += 1) add_asteroid();
						break;
					case KEY_PGDN:
						for (i = 0; i < 50; i += 1) remove_asteroid();
						break;
				}
				do_flip();
				bob = 0;
			}
			if (dt > 4) dt = 4;
			do_physics(dt * 0.25);
		}
	}

	for (i = 0; i < 64; i += 1) {
		destroy_bitmap(sprite[i]);
		destroy_pmask(mask[i]);
	}

	return 0;
}
END_OF_MAIN()
