#ifndef _SPACEINVADERS_H
#define _SPACEINVADERS_H
#include "pmask.h"
#define WHITE makecol(255,255,255)
#define GRAY makecol(60,60,60)
#define RED makecol(200,0,0)

#define ub unsigned char
#define sb char
#define us unsigned short
#define ss short
#define ul unsigned long
#define sl long


typedef struct ALIENSX
{
  sb xdir;
  sb ydir;
  ul alive[5][11];
  us x[5][11];
  us y[5][11];
  us xspeed;
  us yspeed;
  us xdelay;
  us ydelay;
  us width[5];
  us height[5];
  us xcount[5];
  us ycount[5];
  ss curframe[5];
  us maxframe;
  sb animdir;
  us framecount[5];
  us framedelay;
} ALIENSX;


typedef struct SPRITE
{
   int dir;
   int type;
   int xdir, alive;
   int ydir;
   int x,y;
   int width,height;
   int xspeed,yspeed;
   int xdelay,ydelay;
   int xcount,ycount;
   int curframe,maxframe,animdir;
   int framecount,framedelay;
} SPRITE;



int alienDelay[2];
int alienDelayDX[2];

int boolPauseAliens;
int intAliensAlive[2];
int intAlienBulletsLive;

int countColDead[2][11];
int bottomAlien[2][11];

volatile int counter;
volatile int ticks;
volatile int framerate;
volatile int resting,rested;

volatile int target_cycle;
volatile int last_fps;
volatile int frame_counter;
int actual_cycle;

DATAFILE *data;
BITMAP * letters[128];



BITMAP *buffer;
BITMAP *temp;

BITMAP *laserImage;
SPRITE *laser;
PMASK * laserMask;

SPRITE *laserExplode;
BITMAP *laserExplodeImage[2];
SAMPLE *laserExplodeSound;
//SPRITE *laserExplodeMask;


BITMAP *laserBulletImage;
SPRITE *laserBullet;
PMASK *laserBulletMask;
SAMPLE *laserBulletSound;
BITMAP *laserBulletExplodeImage;
SPRITE * laserBulletExplode;


BITMAP *alienImage[3][2];
ALIENSX *aliens[2];
PMASK *alienMask[3][2];
SAMPLE *aliensSound[4];

BITMAP *alienExplodeImage;
SPRITE *alienExplode;
SAMPLE *alienExplodeSound;


BITMAP *alienBulletImage[3][4];
SPRITE *alienBullets[3];
PMASK *alienBulletMask[3][4];
SAMPLE *alienBulletSound;

BITMAP * alienBulletExplodeImage;
SPRITE * alienBulletExplode[3];

int intAlienCurrentSound;
int boolAlienSoundPlaying;

BITMAP *bulletCollisionImage;
SPRITE *bulletCollision[3];

BITMAP *saucerImage;
SPRITE *saucer;
PMASK *saucerMask;
SAMPLE *saucerSound;
/*
typedef struct player
{

   unsigned short intLaserBulletsFired;
   unsigned short intMaxedOut;
   unsigned intMaxBulletsAllowed;
   BITMAP *shelterImage[4];
   SPRITE *shelter[4];
   PMASK * shelterMask[4];
   unsigned short intLives;
   unsigned short intLevel;
   unsigned short intAlienLevel;
   unsigned short intMaxAlienBulletsLive;
   unsigned short intScoreExtraLive;

} PLAYER
*/

   int intSaucerFrames[2];
   int intLaserBulletsFired[2];
   int intMaxedOut[2];
   int intMaxBulletsAllowed[2];


BITMAP *saucerExplodeImage[5];
SPRITE *saucerExplode;
SAMPLE *saucerExplodeSound;



BITMAP *shelterImage[2][4];
SPRITE *shelter[2][4];
PMASK * shelterMask[2][4];


FILE * fpKeyPresses;
int intDemoMoves;
int boolDemoOn;
int intDemoMovesDone;
int intDemoDiff;


BITMAP * upsideDownYImage;
SPRITE * upsideDownY;
SPRITE * startScreenAlien;
BITMAP * coinCImage;
SPRITE * coinC;
PMASK * coinCMask;
int boolAliensMovedH;

int boolStopForDebug;
int intHiScore;
int boolLostLive;
int boolShutDown;
int boolStartGame;
int intPlayer;
int intCredits;

unsigned short intAlienDrops[2];
unsigned short boolAliensHaveMoved[2];
int intScore[2];


unsigned short intLives[2];

unsigned short intLevel[2];

unsigned short intAlienLevel[2];

unsigned short intMaxAlienBulletsLive[2];

int intScoreExtraLive[2];

int intAlienMoveVoice;

int intAlienSoundTicks;
#endif

