/***************************************************************************/
/*                                                                         */
/*                              W A V E . C P P                            */
/*                              Code Module                                */
/*                                                                         */
/*     Content : Wave Generator and Export to .wav                         */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 8th, 2005                                  */
/*     Licence : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <degui.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <sndwaveg.h>
#include <gui.h>

s_wave_entry* wcontain; // global pointer
s_wave_parameter wparam;
SAMPLE *mainsample;



#ifndef ALLEGRO_WINDOWS
   double dblmaxval = MAXINT;
#else   
   double dblmaxval = RAND_MAX;
#endif


/* Takes the parameters to generate a sound and generate the sound in
an allegro sample the sample is created by this function*/
SAMPLE* generate_sound ( s_wave_parameter wav )
{
   short bitmax=0;
   double deforminc=0;
   double tmpdbl;
//   double tmpdbl2;
   tiny *dataptr8b;
   short *dataptr16b;
   double freqpart;
   double radinc;
   double radian = 0;
   double tmpvalue;
   double tmpradian;
   int wcutinc=0;
   int wcutcount=0;
   int wcutsizecount=0;
   int wcutrelsize=0;
   int wcutvarrelsize=0;
   int wcutID=0;
   int i;
   int m;
   SAMPLE* smp;
   double freqsize = 0;
   double freqcount = 0;
   double propsize = 0;
   double propcount = 0;
   double propmax = 0;
   double varnumcount = 0;
   double varsize = 0;
   double tmpvarprop = 0;
   double tmpvarfreq = 0;
   bool lower = true;
   bool changepropmax = true;
   double wfampvarpos = 1;
   double wfampvarneg = 1;
   double wffrevar = 0;
   double tmpdouble;
   double tmpdouble2;
   double tmpdouble3;
   double zerolineoffset = 0;
   bool zlineraise = true;
   bool ampvraise = false;
   bool frevraise = true;
   int tmpint;

   //----- Limit Values ( maybe place in gui instead ) -----
   if ( wav.waveform.zlinelevel > 100 )
      wav.waveform.zlinelevel = 100;

   //----- Allocate Data in memeory -----
   smp = create_sample( wav.bitrate, wav.stereo, wav.frequency, wav.length);
 //  wcontain = (s_wave_entry*) malloc ( sizeof ( s_wave_entry ) * wav.length );

   //----- Setup -----
   dataptr8b = (tiny*)smp->data;
   dataptr16b = (short*)smp->data;

   switch ( wav.bitrate )
   {
      case BITRATE_8BIT :
         bitmax = 127;
      break;
      case BITRATE_16BIT :
         bitmax = 32767;
      break;
   }

   //---------- empty container ---------

   for ( i = 0 ; i < wav.length ; i++ )
   {
//      wcontain [ i ] . waveform = 0;
      wcontain [ i ] . envelope = 0;
      wcontain [ i ] . frequency = 1;
   }

   //----- Generate the Container Envellope-----

   short envinc = wav.length / 100;

   for ( i = 0 ; i < 7 ; i++ )
   {
      switch ( wav.envform.pointformtype )
      {
         case POINTFORMTYPE_SLOPE :
            do_line(screen,
            wav.envelope[i].x * envinc, ( wav.envelope[i].y * bitmax ) / 50,
            wav.envelope[i+1].x * envinc, ( wav.envelope[i+1].y * bitmax ) / 50,
            0, envelope_callback);
         break;
         case POINTFORMTYPE_PLATFORM :
            do_line(screen,
            wav.envelope[i].x * envinc, ( wav.envelope[i].y * bitmax ) / 50,
            wav.envelope[i+1].x * envinc, ( wav.envelope[i].y * bitmax ) / 50,
            0, envelope_callback);
         break;
         case POINTFORMTYPE_SAWTOOTH :
            do_line(screen,
            wav.envelope[i].x * envinc, ( wav.envelope[i].y * bitmax ) / 50,
            wav.envelope[i+1].x * envinc, ( 0 * bitmax ) / 50,
            0, envelope_callback);
         break;
         case POINTFORMTYPE_RSAWTOOTH :
            do_line(screen,
            wav.envelope[i].x * envinc, ( 0 * bitmax ) / 50,
            wav.envelope[i+1].x * envinc, ( wav.envelope[i+1].y * bitmax ) / 50,
            0, envelope_callback);
         
         break;
      }
   }
   //----- generate pitch gradien -----

   short pitinc = wav.length / 100;

   for ( i = 0 ; i < 7 ; i++ )
   {
      switch ( wav.pitform.pointformtype )
      {
         case POINTFORMTYPE_SLOPE :
            do_line(screen,
               wav.pitch[i].x * pitinc, (wav.pitch[i].y * 5 ) + 10,
               wav.pitch[i+1].x * pitinc, ( wav.pitch[i+1].y * 5 ) + 10,
               0, pitch_callback);
         break;
         case POINTFORMTYPE_PLATFORM :
            do_line(screen,
               wav.pitch[i].x * pitinc, (wav.pitch[i].y * 5 ) + 10,
               wav.pitch[i+1].x * pitinc, ( wav.pitch[i].y * 5 ) + 10,
               0, pitch_callback);
         break;
         case POINTFORMTYPE_SAWTOOTH :
            do_line(screen,
               wav.pitch[i].x * pitinc, (wav.pitch[i].y * 5 ) + 10,
               wav.pitch[i+1].x * pitinc, ( 0 * 5 ) + 10,
               0, pitch_callback);
         break;
         case POINTFORMTYPE_RSAWTOOTH :
            do_line(screen,
               wav.pitch[i].x * pitinc, ( 0 * 5 ) + 10,
               wav.pitch[i+1].x * pitinc, ( wav.pitch[i+1].y * 5 ) + 10,
               0, pitch_callback);
         break;
         
      }
   }

   //----- Envellope Variation -----

   if ( wav.envform.varfreq != 0 && wav.envform.varprop != 0 )
   {
      tmpdbl = wav.frequency;
      tmpvarprop = wav.envform.varprop;
      tmpvarfreq = wav.envform.varfreq;
      freqsize = (tmpdbl / tmpvarfreq ) / 2;
      freqcount = 0;
      propsize = 0;
      propcount = 0;
      propmax = 0;
      varnumcount = 0;
      varsize = tmpvarprop / tmpvarfreq;
      lower = true;
      changepropmax = true;

      for ( i = 0 ; i < wav.length ; i++ )
      {

         if ( changepropmax == true )
         {
            switch ( wav.envform.varvartype )
            {
               case ENVPITVARVARTYPE_STABLE :
                  propmax = wav.envform.varprop;
               break;
               case ENVPITVARVARTYPE_INCREMENT :
                  propmax = (varnumcount+1) * varsize;
               break;
               case ENVPITVARVARTYPE_DECREMENT :
                  propmax = tmpvarprop - (varnumcount * varsize);
               break;
               case ENVPITVARVARTYPE_PEAK :
                  if ( (varnumcount+1) > ( tmpvarfreq / 2 ) )
                     propmax = tmpvarprop -
                     ((varnumcount - ( tmpvarfreq / 2 )) * (varsize*2));
                  else
                     propmax = (varnumcount+1) * (varsize * 2);
               break;
               case ENVPITVARVARTYPE_CREVACE :
                  if ( (varnumcount+1) > ( tmpvarfreq / 2 ) )
                     propmax = (varnumcount+1-(tmpvarfreq / 2))
                        * (varsize * 2);
                  else
                     propmax = tmpvarprop - (varnumcount * (varsize*2));
               break;
               case ENVPITVARVARTYPE_RANDOM :
                  propmax = rnd ( wav.envform.varprop );
               break;
            }
            propsize = propmax / freqsize;
            varnumcount++;
            changepropmax = false;
            if ( varnumcount > tmpvarfreq )
               varnumcount = 0;

            switch ( wav.envform.vartype )
            {
               case ENVPITVARTYPE_SOFT :
               case ENVPITVARTYPE_HARD :
               case ENVPITVARTYPE_SAWTOOTH :
                  propcount = 0;
               break;
               case ENVPITVARTYPE_RSAWTOOTH :
                  propcount = propmax;
               break;
            }
         }

         if ( lower == true )
         {
            switch ( wav.envform.vartype )
            {
               case ENVPITVARTYPE_SOFT :
                  propcount = propcount + propsize;
               break;
               case ENVPITVARTYPE_HARD :
                  propcount = propmax;
               break;
               case ENVPITVARTYPE_SAWTOOTH :
                  propcount = propcount + (propsize / 2);
               break;
               case ENVPITVARTYPE_RSAWTOOTH :
                  propcount = propcount - (propsize / 2);
               break;
            }
         }
         else
         {
            switch ( wav.envform.vartype )
            {
               case ENVPITVARTYPE_SOFT :            
                  propcount = propcount - propsize;
               break;
               case ENVPITVARTYPE_HARD :
                  propcount = 0;
               break;
               case ENVPITVARTYPE_SAWTOOTH :
                  propcount = propcount + (propsize / 2);
               break;
               case ENVPITVARTYPE_RSAWTOOTH :
                  propcount = propcount - (propsize / 2);
               break;
            }

            if ( propcount < 0 )
               propcount = 0;
         }

         wcontain [ i ] . envelope = wcontain [ i ] . envelope -
            (short) ( ( wcontain [ i ] . envelope * propcount ) / 100 );

         if ( wcontain [ i ] . envelope < 0 )
            wcontain [ i ] . envelope = 0;
         else
            if ( wcontain [ i ] . envelope > bitmax )
               wcontain [ i ] . envelope = bitmax;

         freqcount++;
         if ( freqcount > freqsize )
         {
            freqcount = 0;
            if ( lower == true )
               lower = false;
            else
            {
               lower = true;
               changepropmax = true;
            }
         }
            
      }

      
   }

   //----- Gradient Variation -----

   if ( wav.pitform.varfreq != 0 && wav.pitform.varprop != 0 )
   {
      tmpdbl = wav.frequency;
      tmpvarprop = wav.pitform.varprop;
      tmpvarfreq = wav.pitform.varfreq;
      freqsize = (tmpdbl / tmpvarfreq ) / 2;
      freqcount = 0;
      propsize = 0;
      propcount = 0;
      propmax = 0;
      varnumcount = 0;
      varsize = tmpvarprop / tmpvarfreq;
      lower = true;
      changepropmax = true;

      for ( i = 0 ; i < wav.length ; i++ )
      {

         if ( changepropmax == true )
         {
            switch ( wav.pitform.varvartype )
            {
               case ENVPITVARVARTYPE_STABLE :
                  propmax = wav.pitform.varprop;
               break;
               case ENVPITVARVARTYPE_INCREMENT :
                  propmax = (varnumcount+1) * varsize;
               break;
               case ENVPITVARVARTYPE_DECREMENT :
                  propmax = tmpvarprop - (varnumcount * varsize);
               break;
               case ENVPITVARVARTYPE_PEAK :
                  if ( (varnumcount+1) > ( tmpvarfreq / 2 ) )
                     propmax = tmpvarprop -
                     ((varnumcount - ( tmpvarfreq / 2 )) * (varsize*2));
                  else
                     propmax = (varnumcount+1) * (varsize * 2);
               break;
               case ENVPITVARVARTYPE_CREVACE :
                  if ( (varnumcount+1) > ( tmpvarfreq / 2 ) )
                     propmax = (varnumcount+1-(tmpvarfreq / 2))
                        * (varsize * 2);
                  else
                     propmax = tmpvarprop - (varnumcount * (varsize*2));
               break;
               case ENVPITVARVARTYPE_RANDOM :
                  propmax = rnd ( wav.pitform.varprop );
               break;
            }
            propsize = propmax / freqsize;
            varnumcount++;
            changepropmax = false;
            if ( varnumcount > tmpvarfreq )
               varnumcount = 0;

            switch ( wav.pitform.vartype )
            {
               case ENVPITVARTYPE_SOFT :
               case ENVPITVARTYPE_HARD :
               case ENVPITVARTYPE_SAWTOOTH :
                  propcount = 0;
               break;
               case ENVPITVARTYPE_RSAWTOOTH :
                  propcount = propmax;
               break;
            }
         }

         if ( lower == true )
         {
            switch ( wav.pitform.vartype )
            {
               case ENVPITVARTYPE_SOFT :
                  propcount = propcount + propsize;
               break;
               case ENVPITVARTYPE_HARD :
                  propcount = propmax;
               break;
               case ENVPITVARTYPE_SAWTOOTH :
                  propcount = propcount + (propsize / 2);
               break;
               case ENVPITVARTYPE_RSAWTOOTH :
                  propcount = propcount - (propsize / 2);
               break;
            }
         }
         else
         {
            switch ( wav.pitform.vartype )
            {
               case ENVPITVARTYPE_SOFT :            
                  propcount = propcount - propsize;
               break;
               case ENVPITVARTYPE_HARD :
                  propcount = 0;
               break;
               case ENVPITVARTYPE_SAWTOOTH :
                  propcount = propcount + (propsize / 2);
               break;
               case ENVPITVARTYPE_RSAWTOOTH :
                  propcount = propcount - (propsize / 2);
               break;
            }

            if ( propcount < 0 )
               propcount = 0;
         }

         wcontain [ i ] . frequency = wcontain [ i ] . frequency -
            (short) ( ( wcontain [ i ] . frequency * propcount ) / 100 );

         if ( wcontain [ i ] . frequency == 0 )
            wcontain [ i ] . frequency = 1;
         if ( wcontain [ i ] . frequency > 1010 )
            wcontain [ i ] . frequency = 1010;

         freqcount++;
         if ( freqcount > freqsize )
         {
            freqcount = 0;
            if ( lower == true )
               lower = false;
            else
            {
               lower = true;
               changepropmax = true;
            }
         }
            
      }
   }

   //----- Generate the wave -----


   if ( wav.waveform.cutfreq > 0 )
   {
      wcutrelsize = wav.waveform.cutsize * (wav.frequency/11025);
      wcutinc = (wav.length - (wcutrelsize*wav.waveform.cutfreq) ) / wav.waveform.cutfreq;
      wcutcount = wcutinc / 2;
      wcutsizecount = 0;
      wcutID = 0;
      switch ( wav.waveform.cuttype )
      {
         case WAVECUTTYPE_PEAK :
         case WAVECUTTYPE_INCREMENT :
            wcutvarrelsize = 0;
         break;
         case WAVECUTTYPE_RANDOM :
            wcutvarrelsize = rnd (wcutrelsize );
         break;
         case WAVECUTTYPE_CREVACE :
         case WAVECUTTYPE_DECREMENT :
         case WAVECUTTYPE_STABLE :
            wcutvarrelsize = wcutrelsize;
         break;
      }

   }

   tiny pivot = 0;
   radian = 6.29;
   for ( i = 0; i < wav.length; i = i + 1 )
   {

      while ( radian > 6.28 )
      {
         tmpradian = radian - 6.28;
         radian = tmpradian;

         if ( pivot == 0 ) pivot = 1;
            else if ( pivot == 1 ) pivot = 0;

         // changing wave form aplitude variation parameters
         //?? maybe ad feature, same value on both side(for random??)
         //?? in parallel and opposite mode, allow to determine increment.
         //   maybe use ( fast, slow, vfast, etc. )
         switch ( wav.waveform.ampvtype )
         {
            case AMPVARTYPE_NOVARIATION :
            break;
            case AMPVARTYPE_RANDOM :
               tmpint = 200 - (wav.waveform.ampvprop * 2);
               tmpdouble3 = wav.waveform.ampvprop * 2;
            
               //?? random case only available now
               tmpdouble = rnd ( tmpint ) + tmpdouble3;
               tmpdouble2 = rnd ( tmpint ) + tmpdouble3;

               if ( wav.waveform.ampvbust == FALSE )
               {
                  wfampvarpos = (tmpdouble / 2 ) / 100;
                  wfampvarneg = (tmpdouble2 / 2 ) / 100;
               }
               else
               {
                  wfampvarpos = ( tmpdouble - 100 ) / 100;
                  wfampvarneg = ( tmpdouble2 - 100 ) / 100;
               }
            break;
            case AMPVARTYPE_STABLE :
/*               if ( ampvraise == false )
               {
                  wfampvarpos = wfampvarpos - 0.05;
                  wfampvarneg = wfampvarneg + 0.05;
                  if ( wfampvarpos  <= ( wav.waveform.ampvprop / 100 ) )
                     ampvraise = true;
               }
               else
               {
                  wfampvarpos = wfampvarpos - 0.05;
                  wfampvarneg = wfampvarneg + 0.05;
                  if ( wfampvarpos  >= 1 )
                     ampvraise = false;
               }  */
               tmpdouble = wav.waveform.ampvprop;
               wfampvarpos = tmpdouble / 100;
               wfampvarneg = wfampvarpos;
            break;
            case AMPVARTYPE_OPPOSITE :
               if ( ampvraise == false )
               {
                  wfampvarpos = wfampvarpos - 0.05;
                  wfampvarneg = wfampvarneg - 0.05;
                  if ( wfampvarpos  <= ( wav.waveform.ampvprop / 100 ) )
                     ampvraise = true;
               }
               else
               {
                  wfampvarpos = wfampvarpos + 0.05;
                  wfampvarneg = wfampvarneg + 0.05;
                  if ( wfampvarpos  >= 1 )
                     ampvraise = false;
               }
            break;
            case AMPVARTYPE_MINMAX :
               if ( ampvraise == true )
               {
                  wfampvarpos = 1;
                  wfampvarneg = 1;
                  ampvraise = false;
               }
               else
               {
                  tmpdouble = wav.waveform.ampvprop;
                  wfampvarpos = tmpdouble / 100;
                  wfampvarneg = wfampvarpos;
                  ampvraise = true;
               }
            
            break;
         }

         // changing waveform frequency variation parameter
         
         if ( wav.waveform.frevprop != 0 )
         {
            switch ( wav.waveform.frevtype )
            {
               case FREVARTYPE_RANDOM :
                  tmpdouble = rnd ( wav.waveform.frevprop ) - 1;
                  wffrevar = tmpdouble / 100;
               break;
               case FREVARTYPE_RAISELOWER :
                  if ( frevraise == true )
                  {
                     wffrevar = wffrevar + 0.05;
                     tmpdouble = wav.waveform.frevprop;
                     tmpdouble = tmpdouble / 100;
                     if ( wffrevar >= tmpdouble )
                     {
                        wffrevar = tmpdouble;
                        frevraise = false;
                     }
                  }
                  else
                  {
                     wffrevar = wffrevar - 0.05;
                     if ( wffrevar <= 0 )
                     {
                        wffrevar = 0;
                        frevraise = true;
                     }
                  }
               break;
               case FREVARTYPE_MINMAX :
                  if ( pivot == 1 )
                  {
                     tmpdouble = wav.waveform.frevprop;
                     wffrevar = tmpdouble / 100;
                  }
                  else
                     wffrevar = 0;
               break;
            }
         }

         // changing Zeroline posision
         if ( wav.waveform.zlinelevel != 0 )
         {
            switch ( wav.waveform.zlinetype )
            {
               case ZLINETYPE_RANDOM :
                  tmpdouble = rnd ( wav.waveform.zlinelevel * 2 );
                  tmpdouble = tmpdouble - wav.waveform.zlinelevel;
                  zerolineoffset = tmpdouble / 100;
               break;
               case ZLINETYPE_RAISELOWER :
               if ( zlineraise == true )
               {
                  zerolineoffset += 0.05;
                  tmpdouble = wav.waveform.zlinelevel;
                  tmpdouble = tmpdouble / 100;
                  if ( zerolineoffset >= tmpdouble )
                     zlineraise = false;
               }
               else
               {
                  zerolineoffset -= 0.05;
                  tmpdouble = wav.waveform.zlinelevel;
                  tmpdouble = 0 - ( tmpdouble / 100);
                  if ( zerolineoffset <= tmpdouble )
                     zlineraise = true;
               }
//               zerolineoffset = 0.50;
               break;

               case ZLINETYPE_MINMAX :

                  if ( zlineraise == true )
                  {
                     tmpdouble = wav.waveform.zlinelevel;
                     tmpdouble = tmpdouble / 100;
                     zerolineoffset = tmpdouble;
                     zlineraise = false;
                  }
                  else
                  {
                     tmpdouble = wav.waveform.zlinelevel;
                     tmpdouble = 0 - ( tmpdouble / 100);
                     zerolineoffset = tmpdouble;
                     zlineraise = true;
                  }
//               zerolineoffset = -1.00;
               break;
            }
         
         }
         else
            zerolineoffset = 0;
         
      }

      tmpvalue = wave_base ( wav.waveform.base, radian );
      tmpvalue = wave_function ( wav.waveform.function, tmpvalue );
      tmpvalue = wave_modifier ( wav.waveform.filter, tmpvalue, pivot );

      // cut limits
      if ( tmpvalue > 1 )
         tmpvalue = 1;
      else
         if ( tmpvalue < -1 )
            tmpvalue = -1;

      //--- deformwave ---
      if ( wav.waveform.deformspeed != DEFORMSPEED_NONE
         && wav.waveform.deformlevel != 0 )
      {
         tmpdbl = wav.waveform.deformlevel; // to make fractional division
         switch ( wav.waveform.deformtype )
         {
            default:
            case DEFORMTYPE_STABLE :
               deforminc = tmpdbl / 100;
            break;
            case DEFORMTYPE_VARIABLE :
               if ( pivot == 0 )
                  deforminc = ( tmpdbl * (radian/6.28 ) ) / 100;
               else
                  if ( pivot == 1 )
                     deforminc = ( tmpdbl * ( (6.28 -radian )/ 6.28 ) )/ 100;
            break;
            case DEFORMTYPE_RANDOM :
               deforminc = (tmpdbl * dblrnd ) / 100;
            break;
         }
         
         m = i % wav.waveform.deformspeed;
         if ( m == 0 )
         {
            tmpvalue = tmpvalue + deforminc;
            if ( tmpvalue > 1 ) tmpvalue = 1;
         }
         else
            if ( m == ( wav.waveform.deformspeed / 2 ) )
            {
               tmpvalue = tmpvalue - deforminc;
               if ( tmpvalue < -1 ) tmpvalue = -1;
            }
      }


      //--- Cut wave effect ---
      if ( wav.waveform.cutfreq > 0 )
      {
         wcutcount++;
         if ( wcutcount >= wcutinc )
         {
            tmpvalue = 0;
            wcutsizecount++;
            if ( wcutsizecount >= wcutvarrelsize )
            {
               wcutcount = 0;
               wcutsizecount = 0;
               wcutID++;
               switch ( wav.waveform.cuttype )
               {
                  case WAVECUTTYPE_STABLE :
                     wcutvarrelsize = wcutrelsize;
                  break;
                  case WAVECUTTYPE_INCREMENT :
                     wcutvarrelsize = (wcutID * wcutrelsize)
                        / wav.waveform.cutfreq;
                  break;
                  case WAVECUTTYPE_DECREMENT :
                     wcutvarrelsize = ((wav.waveform.cutfreq-wcutID)
                        * wcutrelsize) / wav.waveform.cutfreq;
                  break;
                  case WAVECUTTYPE_PEAK :
                     if ( wcutID+1 > (wav.waveform.cutfreq/2) )
                        wcutvarrelsize = (((wav.waveform.cutfreq/2)
                        -(wcutID-(wav.waveform.cutfreq/2)))
                        * wcutrelsize) / wav.waveform.cutfreq;
                     else
                        wcutvarrelsize = (wcutID * wcutrelsize)
                        / (wav.waveform.cutfreq/2);
                  break;
                  case WAVECUTTYPE_CREVACE :
                     if ( wcutID+1 > (wav.waveform.cutfreq/2) )
                        wcutvarrelsize = (( wcutID-(wav.waveform.cutfreq/2) )
                        * wcutrelsize)
                        / (wav.waveform.cutfreq/2);
                     else
                        wcutvarrelsize = (((wav.waveform.cutfreq/2)
                        -(wcutID/*-(wav.waveform.cutfreq/2)*/))
                        * wcutrelsize) / wav.waveform.cutfreq;
                  break;
                  
                  case WAVECUTTYPE_RANDOM :
                     wcutvarrelsize = rnd (wcutrelsize );
                  break;
               }
            }
         }
      }

      // wave form amplitude variation
      if ( tmpvalue > 0 )
         tmpvalue = tmpvalue * wfampvarpos;
      else
         if ( tmpvalue < 0 )
            tmpvalue = tmpvalue * wfampvarneg;

      // zero line modification

      tmpvalue = tmpvalue + zerolineoffset;

      // cut limits again
      if ( tmpvalue > 1 )
         tmpvalue = 1;
      else
         if ( tmpvalue < -1 )
            tmpvalue = -1;


//      wcontain [ i ] . waveform = (short)(tmpvalue * 32767); // container waveform
      tmpvalue = tmpvalue * wcontain [ i ] . envelope;


      

      // copy wave
      switch ( wav.bitrate )
      {
         case BITRATE_8BIT :
            dataptr8b [ i ] = (tiny) tmpvalue;
         break;
         case BITRATE_16BIT :
            dataptr16b [ i ] = (short) tmpvalue;
         break;
      }

      //----- Radian Modification -----
      freqpart = wav.frequency / wcontain [ i ] . frequency;
      radinc = 6.28 / freqpart;

      radian = radian + radinc;
      radian = radian + wffrevar; // adding frequency variation
      

   }

//   free ( wcontain );

   return ( smp );
}


/*return the the wave value according to the wave form selected*/
double wave_base ( tiny type, double radian )
{
   double tmpvalue=0;
   
   switch ( type )
   {
      case WAVEBASE_SIN :
         tmpvalue = sin ( radian );
      break;
      case WAVEBASE_SAWTOOTH :
         tmpvalue = ( radian / 3.14) - 1;
      break;
      case WAVEBASE_RANDOM :
         tmpvalue = dblrnd;
//         tmpvalue = acosh( radian );
      break;
      case WAVEBASE_SINH :
         tmpvalue = sinh( radian );
      break;
      case WAVEBASE_ATAN :
         tmpvalue = atan( radian );
      break;
      case WAVEBASE_EMPTY0 :
//         tmpvalue = atanh( radian );
      break;
      case WAVEBASE_TAN :
         tmpvalue = tan( radian );
      break;
      case WAVEBASE_TANH :
         tmpvalue = tanh( radian );
      break;
      case WAVEBASE_J0 :
         tmpvalue = j0( radian );
      break;
      case WAVEBASE_J1 :
         tmpvalue = j1( radian );
      break;
      case WAVEBASE_Y0 :
         tmpvalue = y0( radian );
      break;
      case WAVEBASE_Y1 :
         tmpvalue = y1( radian );
      break;
      case WAVEBASE_SQRT :
         tmpvalue = sqrt( radian );
      break;
      case WAVEBASE_EXPM1 :
        tmpvalue = pow(2.718281828,radian) - 1;
      break;
      case WAVEBASE_FLOOR :
         tmpvalue = floor( radian );
      break;
      case WAVEBASE_FMOD :
         tmpvalue = fmod( radian, 1 );
      break;
      case WAVEBASE_EMPTY1 :

      break;
      case WAVEBASE_ILOGB :
         tmpvalue = ilogb( radian );
      break;
      case WAVEBASE_LDEXP :
         tmpvalue = ldexp( radian, 1 );
      break;
      case WAVEBASE_LOG :
         tmpvalue = log( radian );
      break;
      case WAVEBASE_LOG10 :
         tmpvalue = log10( radian );
      break;
      case WAVEBASE_POW3 :
         tmpvalue = pow( radian, 3 );
      break;
      case WAVEBASE_RINT :
         tmpvalue = rint( radian );
      break;
   }

   return ( tmpvalue);
}

double wave_modifier ( tiny type, double value, tiny pivot )
{
   double tmpvalue=0;
   
   switch ( type )
   {
      case WAVEMODIFIER_NONE :
         tmpvalue = value;
      break;
      case WAVEMODIFIER_ABS :
         tmpvalue = fabs(value);
      break;
      case WAVEMODIFIER_MIN0 :
         if ( value < 0 )
            tmpvalue = 0;
         else
            tmpvalue = value;
      break;
      case WAVEMODIFIER_MAX0 :
         if ( value > 0 )
            tmpvalue = 0;
         else
            tmpvalue = value;
      break;
      case WAVEMODIFIER_MIRROR :
         if ( pivot == 1 )
            tmpvalue = value * -1;
         else
            tmpvalue = value;
      break;
      case WAVEMODIFIER_INVERT :
         if ( value > 0 )
            tmpvalue = value - 1;
         else
            if ( value < 0 )
               tmpvalue = value + 1;
      break;
      case WAVEMODIFIER_AMPLIFY :
         tmpvalue = value * 2;
      break;
      case WAVEMODIFIER_DEAMPLIFY :
         tmpvalue = value / 2;
      break;
      case WAVEMODIFIER_ADDRANDOM :
         tmpvalue = value + dblrnd;
      break;
      case WAVEMODIFIER_BORDER :
         if ( value > 0 && value < 0.5 )
            tmpvalue = 0.5;
         else
            if ( value < 0 && value > -0.5 )
               tmpvalue = -0.5;
            else
               tmpvalue = value;
      break;
   }

   return ( tmpvalue);

}

double wave_function ( tiny type, double value )
{
   double tmpvalue=0;
   
   switch ( type )
   {
      case WAVEFUNCTION_NONE :
         tmpvalue = value;
      break;
      case WAVEFUNCTION_SIN :
         tmpvalue = sin ( value );
      break;
      case WAVEFUNCTION_COS :
         tmpvalue = cos ( value );
      break;
      case WAVEFUNCTION_TAN :
         tmpvalue = tan ( value );
      break;
      case WAVEFUNCTION_ASIN :
         tmpvalue = asin ( value );
      break;
      case WAVEFUNCTION_ACOS :
         tmpvalue = acos ( value );
      break;
      case WAVEFUNCTION_ATAN :
         tmpvalue = atan ( value );
      break;
      case WAVEFUNCTION_FLOOR :
         tmpvalue = floor(value);
      break;
      case WAVEFUNCTION_SQRT :
         tmpvalue = sqrt(value);
      break;
      case WAVEFUNCTION_SCALBN2 :
         tmpvalue = scalbn(value, 2);
      break;
      case WAVEFUNCTION_POW3 :
         tmpvalue = pow(value, 3);
      break;
      case WAVEFUNCTION_POW4 :
         tmpvalue = pow(value, 4);
      break;
      case WAVEFUNCTION_LOG :
         tmpvalue = log(value);
      break;
      case WAVEFUNCTION_LOG1P :
         tmpvalue = log1p(value);
      break;
      case WAVEFUNCTION_MULRANDOM :
         tmpvalue = value * dblrnd;
      break;
      case WAVEFUNCTION_EXPM1 :
         tmpvalue = pow(2.718281828,value) - 1;
      break;
      case WAVEFUNCTION_EXP :
         tmpvalue = exp(value);
      break;
      case WAVEFUNCTION_ERF :
         tmpvalue = erf(value);
      break;
      case WAVEFUNCTION_CBRT :
         tmpvalue = cbrt(value);
      break;
      case WAVEFUNCTION_J0 :
         tmpvalue = j0(value);
      break;
      case WAVEFUNCTION_J1 :
         tmpvalue = j1(value);
      break;
      case WAVEFUNCTION_Y0 :
         tmpvalue = y0(value);
      break;
      case WAVEFUNCTION_Y1 :
         tmpvalue = y1(value);
      break;

   }
   return ( tmpvalue );

}

void envelope_callback(BITMAP *bmp, int x, int y, int d)
{
   wcontain [ x ]. envelope = y;
}

void pitch_callback(BITMAP *bmp, int x, int y, int d)
{
   wcontain [ x ]. frequency = y;
   
}


void validate_wave_parameter ( s_wave_parameter *wavp )
{
   tiny i;


   switch ( wavp->bitrate )
   {
      case 8 :
      case 16 :
      break;
      default : wavp->bitrate = 8;
      break;
   }

   wavp->stereo = 0;

   switch ( wavp->frequency )
   {
      case 11025 :
      case 22050 :
      case 44100 :
      break;
      default : wavp->frequency = 11025;
      break;
   }

   if ( wavp->length < (wavp->frequency / 10 ) )
      wavp->length = wavp->frequency / 10;
   else
      if ( wavp->length > ( wavp->frequency * 10 ) )
         wavp->length = wavp->frequency * 10;

   if ( wavp->waveform.base < 0 || wavp->waveform.base > SLST_WAVEBASE_SIZE )
       wavp->waveform.base = 0;

   if ( wavp->waveform.function < 0 || wavp->waveform.function > SLST_WAVEFUNCTION_SIZE )
       wavp->waveform.function = 0;

   if ( wavp->waveform.filter < 0 || wavp->waveform.filter > SLST_WAVEFILTER_SIZE )
       wavp->waveform.filter = 0;

   if ( wavp->waveform.deformlevel < 0 )
      wavp->waveform.deformlevel = 0;
   else
      if (wavp->waveform.deformlevel > 100)
         wavp->waveform.deformlevel = 100;

   switch ( wavp->waveform.deformspeed )
   {
      case DEFORMSPEED_NONE :
      case DEFORMSPEED_VERYFAST :
      case DEFORMSPEED_FAST :
      case DEFORMSPEED_MEDIUM :
      case DEFORMSPEED_SLOW :
      case DEFORMSPEED_VERYSLOW :
      break;
      default : wavp->waveform.deformspeed = DEFORMSPEED_NONE;
   }

   if ( wavp->waveform.deformtype < 0 || wavp->waveform.deformtype > SLST_DEFORMTYPE_SIZE )
       wavp->waveform.deformtype = 0;

      if (wavp->waveform.cutfreq > 10000)
         wavp->waveform.cutfreq = 10000;

      if (wavp->waveform.cutsize > 5000)
         wavp->waveform.cutsize = 5000;

   for ( i = 0 ; i < 8 ; i++ )
   {
      if ( i == 0 )
      {
         if ( wavp->envelope [ i ] . x < 0 ) wavp->envelope [ i ] . x = 0;
            else if ( wavp->envelope [ i ] . x > 93 ) wavp->envelope [ i ] . x = 93;
         if ( wavp->envelope [ i ] . y < -50 ) wavp->envelope [ i ] . y = -50;
            else if ( wavp->envelope [ i ] . y > 50 ) wavp->envelope [ i ] . y = 50;
         if ( wavp->pitch [ i ] . x < 0 ) wavp->pitch [ i ] . x = 0;
            else if ( wavp->pitch [ i ] . x > 93 ) wavp->pitch [ i ] . x = 93;
         if ( wavp->pitch [ i ] . y < 0 ) wavp->pitch [ i ] . y = 0;
            else if ( wavp->pitch [ i ] . y > 200 ) wavp->pitch [ i ] . y = 200;
      }
      else
      {
         if ( wavp->envelope [ i ] . x < wavp->envelope [ i - 1 ] . x )
            wavp->envelope [ i ] . x = wavp->envelope [ i - 1 ] . x + 1;
         else if ( wavp->envelope [ i ] . x > 93 + i ) wavp->envelope [ i ] . x = 93 + i;
         if ( wavp->envelope [ i ] . y < -50 ) wavp->envelope [ i ] . y = -50;
         else if ( wavp->envelope [ i ] . y > 50 ) wavp->envelope [ i ] . y = 50;
         
         if ( wavp->pitch [ i ] . x < wavp->pitch [ i - 1 ] . x )
            wavp->pitch [ i ] . x = wavp->pitch [ i - 1 ] . x + 1;
         else if ( wavp->pitch [ i ] . x > 93 + i ) wavp->pitch [ i ] . x = 93 + i;
         if ( wavp->pitch [ i ] . y < 0 ) wavp->pitch [ i ] . y = 0;
         else if ( wavp->pitch [ i ] . y > 200 ) wavp->pitch [ i ] . y = 200;
      }
   }

   if ( wavp->envform.varfreq < 0 ) wavp->envform.varfreq = 0;
   else if ( wavp->envform.varfreq > 100 ) wavp->envform.varfreq = 100;
   if ( wavp->envform.varprop < 0 ) wavp->envform.varprop = 0;
   else if ( wavp->envform.varprop > 100 ) wavp->envform.varprop = 100;
   if ( wavp->envform.vartype < 0 || wavp->envform.vartype > SLST_ENVPITVARTYPE_SIZE )
       wavp->envform.vartype = 0;
   if ( wavp->envform.varvartype < 0 || wavp->envform.varvartype > SLST_ENVPITVARVARTYPE_SIZE )
       wavp->envform.varvartype = 0;
   if ( wavp->envform.pointformtype < 0 || wavp->envform.pointformtype > SLST_ENVPITPOINTFORMTYPE_SIZE )
       wavp->envform.pointformtype = 0;


   if ( wavp->pitform.varfreq < 0 ) wavp->pitform.varfreq = 0;
   else if ( wavp->pitform.varfreq > 100 ) wavp->pitform.varfreq = 100;
   if ( wavp->pitform.varprop < 0 ) wavp->pitform.varprop = 0;
   else if ( wavp->pitform.varprop > 100 ) wavp->pitform.varprop = 100;
   if ( wavp->pitform.vartype < 0 || wavp->pitform.vartype > SLST_ENVPITVARTYPE_SIZE )
       wavp->pitform.vartype = 0;
   if ( wavp->pitform.varvartype < 0 || wavp->pitform.varvartype > SLST_ENVPITVARVARTYPE_SIZE )
       wavp->pitform.varvartype = 0;
   if ( wavp->pitform.pointformtype < 0 || wavp->pitform.pointformtype > SLST_ENVPITPOINTFORMTYPE_SIZE )
       wavp->pitform.pointformtype = 0;

}

void reset_wave_parameter ( s_wave_parameter *wavp )
{
   strncpy ( wavp->swgfileID, FILEVERSION, 4 );
   wavp->bitrate = 8;
   wavp->stereo = 0;
   wavp->frequency = 11025;
   wavp->length = 11025;
   wavp->waveform.base = 0;
   wavp->waveform.filter = 0;
   wavp->waveform.function = 0;
   wavp->waveform.deformlevel = 0;
   wavp->waveform.deformspeed = 0;
   wavp->waveform.deformtype = DEFORMTYPE_STABLE;
   wavp->waveform.cutfreq = 0;
   wavp->waveform.cutsize = 0;
   wavp->waveform.cuttype = WAVECUTTYPE_STABLE;
   wavp->waveform.ampvprop = 0;
   wavp->waveform.ampvbust = FALSE;
   wavp->waveform.ampvtype = AMPVARTYPE_NOVARIATION;
   wavp->waveform.frevprop = 0;
   wavp->waveform.frevtype = FREVARTYPE_RANDOM;
   wavp->waveform.zlinelevel = 0;
   wavp->waveform.zlinetype = ZLINETYPE_RANDOM;
   wavp->envelope [0].x = 0;
   wavp->envelope [0].y = 50;
   wavp->envelope [1].x = 14;
   wavp->envelope [1].y = 50;
   wavp->envelope [2].x = 28;
   wavp->envelope [2].y = 50;
   wavp->envelope [3].x = 43;
   wavp->envelope [3].y = 50;
   wavp->envelope [4].x = 57;
   wavp->envelope [4].y = 50;
   wavp->envelope [5].x = 71;
   wavp->envelope [5].y = 50;
   wavp->envelope [6].x = 85;
   wavp->envelope [6].y = 50;
   wavp->envelope [7].x = 100;
   wavp->envelope [7].y = 50;
   wavp->envform.varfreq = 0;
   wavp->envform.varprop = 0;
   wavp->envform.vartype = ENVPITVARTYPE_SOFT;
   wavp->envform.varvartype = ENVPITVARVARTYPE_STABLE;
   wavp->envform.pointformtype = POINTFORMTYPE_SLOPE;
   wavp->pitch [0].x = 0;
   wavp->pitch [0].y = 50;
   wavp->pitch [1].x = 14;
   wavp->pitch [1].y = 50;
   wavp->pitch [2].x = 28;
   wavp->pitch [2].y = 50;
   wavp->pitch [3].x = 43;
   wavp->pitch [3].y = 50;
   wavp->pitch [4].x = 57;
   wavp->pitch [4].y = 50;
   wavp->pitch [5].x = 71;
   wavp->pitch [5].y = 50;
   wavp->pitch [6].x = 85;
   wavp->pitch [6].y = 50;
   wavp->pitch [7].x = 100;
   wavp->pitch [7].y = 50;
   wavp->pitform.varfreq = 0;
   wavp->pitform.varprop = 0;
   wavp->pitform.vartype = ENVPITVARTYPE_SOFT;
   wavp->pitform.varvartype = ENVPITVARVARTYPE_STABLE;
   wavp->pitform.pointformtype = POINTFORMTYPE_SLOPE;
   

}

SAMPLE* make_test_waveform ( s_wave_parameter wavp )
{
   SAMPLE *tmpsample;

   wavp.bitrate = 8;
   wavp.stereo = 0;
//   wavp.frequency = 11025;
//   wavp.length = 11025;
   wavp.envelope [0].x = 0;
   wavp.envelope [0].y = 50;
   wavp.envelope [1].x = 15;
   wavp.envelope [1].y = 50;
   wavp.envelope [2].x = 30;
   wavp.envelope [2].y = 50;
   wavp.envelope [3].x = 45;
   wavp.envelope [3].y = 50;
   wavp.envelope [4].x = 60;
   wavp.envelope [4].y = 50;
   wavp.envelope [5].x = 75;
   wavp.envelope [5].y = 50;
   wavp.envelope [6].x = 90;
   wavp.envelope [6].y = 50;
   wavp.envelope [7].x = 100;
   wavp.envelope [7].y = 50;
   wavp.envform.varfreq = 0;
   wavp.envform.varprop = 0;
   wavp.envform.vartype = ENVPITVARTYPE_SOFT;
   wavp.envform.varvartype = ENVPITVARVARTYPE_STABLE;
   wavp.envform.pointformtype = POINTFORMTYPE_SLOPE;
   wavp.pitch [0].x = 0;
   wavp.pitch [0].y = 50;
   wavp.pitch [1].x = 15;
   wavp.pitch [1].y = 50;
   wavp.pitch [2].x = 30;
   wavp.pitch [2].y = 50;
   wavp.pitch [3].x = 45;
   wavp.pitch [3].y = 50;
   wavp.pitch [4].x = 60;
   wavp.pitch [4].y = 50;
   wavp.pitch [5].x = 75;
   wavp.pitch [5].y = 50;
   wavp.pitch [6].x = 90;
   wavp.pitch [6].y = 50;
   wavp.pitch [7].x = 100;
   wavp.pitch [7].y = 50;
   wavp.pitform.varfreq = 0;
   wavp.pitform.varprop = 0;
   wavp.pitform.vartype = ENVPITVARTYPE_SOFT;
   wavp.pitform.varvartype = ENVPITVARVARTYPE_STABLE;
   wavp.pitform.pointformtype = POINTFORMTYPE_SLOPE;
   

   s_wave_parameter tmparam = wavp;
   validate_wave_parameter ( &tmparam );

   tmpsample = generate_sound ( tmparam );

   return ( tmpsample );
   // don't forget to destroy sample

}

SAMPLE* make_test_envelope ( s_wave_parameter wavp )
{
   SAMPLE *tmpsample;

   wavp.bitrate = 8;
   wavp.stereo = 0;
//   wavp.frequency = 11025;
//   wavp.length = 11025;
   wavp.waveform.base = WAVEBASE_SIN;
   wavp.waveform.filter = 0;
   wavp.waveform.function = WAVEFUNCTION_COS;
   wavp.waveform.deformlevel = 0;
   wavp.waveform.deformspeed = 0;
   wavp.waveform.deformtype = DEFORMTYPE_STABLE;
   wavp.waveform.cutfreq = 0;
   wavp.waveform.cutsize = 0;
   wavp.waveform.cuttype = WAVECUTTYPE_STABLE;
   wavp.pitch [0].x = 0;
   wavp.pitch [0].y = 50;
   wavp.pitch [1].x = 15;
   wavp.pitch [1].y = 50;
   wavp.pitch [2].x = 30;
   wavp.pitch [2].y = 50;
   wavp.pitch [3].x = 45;
   wavp.pitch [3].y = 50;
   wavp.pitch [4].x = 60;
   wavp.pitch [4].y = 50;
   wavp.pitch [5].x = 75;
   wavp.pitch [5].y = 50;
   wavp.pitch [6].x = 90;
   wavp.pitch [6].y = 50;
   wavp.pitch [7].x = 100;
   wavp.pitch [7].y = 50;
   wavp.pitform.varfreq = 0;
   wavp.pitform.varprop = 0;
   wavp.pitform.vartype = ENVPITVARTYPE_SOFT;
   wavp.pitform.varvartype = ENVPITVARVARTYPE_STABLE;
   wavp.pitform.pointformtype = POINTFORMTYPE_SLOPE;
   

   s_wave_parameter tmparam = wavp;

   validate_wave_parameter ( &tmparam );

   tmpsample = generate_sound ( tmparam );

   return ( tmpsample );
   // don't forget to destroy sample


}

SAMPLE* make_test_pitch ( s_wave_parameter wavp )
{
   SAMPLE *tmpsample;

   wavp.bitrate = 8;
   wavp.stereo = 0;
//   wavp.frequency = 11025;
//   wavp.length = 11025;
   wavp.waveform.base = WAVEBASE_SIN;
   wavp.waveform.filter = 0;
   wavp.waveform.function = WAVEFUNCTION_COS;
   wavp.waveform.deformlevel = 0;
   wavp.waveform.deformspeed = 0;
   wavp.waveform.deformtype = DEFORMTYPE_STABLE;
   wavp.waveform.cutfreq = 0;
   wavp.waveform.cutsize = 0;
   wavp.waveform.cuttype = WAVECUTTYPE_STABLE;
   wavp.envelope [0].x = 0;
   wavp.envelope [0].y = 50;
   wavp.envelope [1].x = 15;
   wavp.envelope [1].y = 50;
   wavp.envelope [2].x = 30;
   wavp.envelope [2].y = 50;
   wavp.envelope [3].x = 45;
   wavp.envelope [3].y = 50;
   wavp.envelope [4].x = 60;
   wavp.envelope [4].y = 50;
   wavp.envelope [5].x = 75;
   wavp.envelope [5].y = 50;
   wavp.envelope [6].x = 90;
   wavp.envelope [6].y = 50;
   wavp.envelope [7].x = 100;
   wavp.envelope [7].y = 50;
   wavp.envform.varfreq = 0;
   wavp.envform.varprop = 0;
   wavp.envform.vartype = ENVPITVARTYPE_SOFT;
   wavp.envform.varvartype = ENVPITVARVARTYPE_STABLE;
   wavp.envform.pointformtype = POINTFORMTYPE_SLOPE;
   

   s_wave_parameter tmparam = wavp;
   validate_wave_parameter ( &tmparam );

   tmpsample = generate_sound ( tmparam );

   return ( tmpsample );
   // don't forget to destroy sample

}

tiny export_to_wav ( SAMPLE *tmpsample, char *filename )
{
   FILE *wav_file;

   s_WAV_riff_header h_riff;
   s_WAV_format_header h_format;
   s_WAV_sample_header h_sample;
   bool addbyte = false;
   byte dummy = 128;
   byte *dataptr8b = (byte*)tmpsample->data;
   short *dataptr16b = (short*)tmpsample->data;


   int samplesize = (tmpsample->bits/8) * tmpsample->len * 1/*mono*/;

   if ( samplesize % 2 != 0 )
   {
      samplesize++;
      addbyte = true;
   }

   //----- Setting Headers -----

   h_riff.ChunkID[0] = 0x52; //R
   h_riff.ChunkID[1] = 0x49; //I
   h_riff.ChunkID[2] = 0x46; //F
   h_riff.ChunkID[3] = 0x46; //F
   h_riff.format[0] = 0x57; //W
   h_riff.format[1] = 0x41; //A
   h_riff.format[2] = 0x56; //V
   h_riff.format[3] = 0x45; //E
   h_riff.ChunkSize = 36 + samplesize;

   h_format.ChunkID[0] = 0x66; // f
   h_format.ChunkID[1] = 0x6d; // m
   h_format.ChunkID[2] = 0x74; // t
   h_format.ChunkID[3] = 0x20; //
   h_format.ChunkSize = 16;
   h_format.AudioFormat = 1;//PCM
   h_format.NumChannel = 1;//Monoral
   h_format.SampleRate = tmpsample->freq;
   h_format.ByteRate = tmpsample->freq * 1 /*mono*/ * (tmpsample->bits/8);
   h_format.BlockAlign = 1 /*Mono*/ * (tmpsample->bits/8);
   h_format.BitsPerSample = tmpsample->bits;

   h_sample.ChunkID[0] = 0x64; // d
   h_sample.ChunkID[1] = 0x61; // a
   h_sample.ChunkID[2] = 0x74; // t
   h_sample.ChunkID[3] = 0x61; // a
   h_sample.ChunkSize = samplesize;

   // Writing file

   wav_file = fopen ( filename, "wb" );
   if ( wav_file == NULL )
      return ( 1 );

   fwrite ( &h_riff, sizeof ( h_riff ), 1, wav_file);
   fwrite ( &h_format, sizeof ( h_format ), 1, wav_file);
   fwrite ( &h_sample, sizeof ( h_sample ), 1, wav_file);

   switch ( tmpsample->bits )
   {
      case 8 :
         fwrite ( dataptr8b, sizeof ( byte ), tmpsample->len, wav_file );
      break;
      case 16 :
         fwrite ( dataptr16b, sizeof ( short ), tmpsample->len, wav_file );
      break;
   }

   if ( addbyte == true )
      fwrite ( &dummy, sizeof ( byte ), 1, wav_file );
   

   fclose ( wav_file );
   return ( 0 );
}

tiny save_to_swg ( s_wave_parameter wavp, char *filename )
{
   FILE *swg_file;

   swg_file = fopen ( filename, "wb" );
   if ( swg_file == NULL )
      return ( 1 );

   fwrite ( &wavp, sizeof ( wavp ), 1, swg_file);

   fclose ( swg_file );
   return ( 0);
}

tiny load_from_swg ( s_wave_parameter *wavp, char *filename )
{
   FILE *swg_file;
   char verstr[4];

   swg_file = fopen ( filename, "rb" );
   if ( swg_file == NULL )
      return ( 1 );

   fread ( &verstr, sizeof ( char ), 4, swg_file );
   fclose ( swg_file );

   if ( strncmp ( verstr, FILEVERSION, 4 ) != 0 )
      return ( 1 );
   else
   {
      swg_file = fopen ( filename, "rb" );
      fread ( wavp, sizeof ( s_wave_parameter ), 1, swg_file);
      fclose ( swg_file );
   }
   return ( 0 );
}

/*void copy_wave_parameter ( s_wave_parameter *wavd,  s_wave_parameter wavs )
{

} */


/*void do_line(BITMAP *bmp, int x1, y1, x2, y2, int d, 
             void (*proc)(BITMAP *bmp, int x, int y, int d));
   Calculates all the points along a line from point (x1, y1) to (x2, y2), 
   calling the supplied function for each one. This will be passed a copy of 
   the bmp parameter, the x and y position, and a copy of the d parameter, 
   so it is suitable for use with putpixel().
*/
