/***************************************************************************/
/*                                                                         */
/*                           S C R E E N . C P P                           */
/*                               Code Module                               */
/*                                                                         */
/*     Content : High level screen management                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 8th, 2005                                  */
/*     Licence : GNU General Public License                                */
/*                                                                         */
/*          Contains the high level function to manage the user interface  */
/*     Call back function for object are in guicallb.cpp                   */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <degui.h>
#include <string.h>
#include <sndwaveg.h>
#include <gui.h>
#include <datafile.h>

//--------- Global object for easy access -----

//--- Waveform Windows ---
hidden_list_object ghls_winwav_basewave (flst_wavebase, 12);
hidden_list_object ghls_winwav_function (flst_wavefunction, 12);
hidden_list_object ghls_winwav_filter (flst_wavefilter, 12);
hidden_list_object ghls_winwav_deformspeed  (flst_deformspeed, 6);
hidden_list_object ghls_winwav_deformtype (flst_deformtype, 3);
hidden_list_object ghls_winwav_wavecuttype (flst_envpitvarvartype/*same values*/, 6 );
hidden_list_object ghls_winwav_ampvartype(flst_ampvartype, 5);//new
hidden_list_object ghls_winwav_frevartype(flst_frevartype, 3);//new
hidden_list_object ghls_winwav_zlinetype(flst_zlinetype, 3);//new
edittext_object getx_winwav_deformlevel("0",3);
edittext_object getx_winwav_wcutfreq("0",5);
edittext_object getx_winwav_wcutlength("0",4);
edittext_object getx_winwav_ampvarprop("0",3);//new
edittext_object getx_winwav_frevarprop("0",3);//new
edittext_object getx_winwav_zlinelevel("0",3);//new
bitmap_object gbmp_winwav_waveform(bbmp_waveform);
checkbox_object gchk_winwav_ampvarzline("Zeroline Busting");//new



//--- Main Form ---
bitmap_object gbmp_main_waveform(bbmp_waveform);
bitmap_object gbmp_main_envelope(bbmp_envelope);
bitmap_object gbmp_main_pitch(bbmp_pitch);
bitmap_object gbmp_main_waveforminfo(bbmp_waveforminfo);
bitmap_object gbmp_main_envelopeinfo(bbmp_envelopeinfo);
bitmap_object gbmp_main_pitchinfo(bbmp_pitchinfo);
bitmap_object gbmp_main_generalinfo(bbmp_generalinfo);
slider_object gsld_main_volume ( 128, 255 );
winbutton_object gbtn_exit("Exit",0,true);

//--- Envelope Windows ---

//edittext_object getx_winenv_varfreq("0",5);
//edittext_object getx_winenv_varprop("0",3);
//bitmap_object gbmp_winenv_envelope(bbmp_envelope);
bitmap_object gbmp_winenv_envelope(bbmp_envelope);
edittext_object getx_winenv_varfreq("0",3);
edittext_object getx_winenv_varprop("0",3);
hidden_list_object ghls_winenv_vartype (flst_envpitvartype, 4 );
hidden_list_object ghls_winenv_varvartype (flst_envpitvarvartype, 6 );
hidden_list_object ghls_winenv_pointformtype (flst_envpitpointformtype, 5 );

//---  pitch window ---

//bitmap_object gbmp_winpit_pitch(bbmp_pitch);
//edittext_object getx_winpit_freq("0",5);
//edittext_object getx_winpit_prop("0",3);
bitmap_object gbmp_winpit_pitch(bbmp_pitch);
edittext_object getx_winpit_freq("0",3);
edittext_object getx_winpit_prop("0",3);
hidden_list_object ghls_winpit_vartype (flst_envpitvartype, 4 );
hidden_list_object ghls_winpit_varvartype (flst_envpitvarvartype, 6 );
hidden_list_object ghls_winpit_pointformtype (flst_envpitpointformtype, 5 );


//--- setting window ---

hidden_list_object ghls_winset_bitrate (flst_settingbitrate, 2 );
hidden_list_object ghls_winset_samfreq (flst_settingfrequency, 3 );
edittext_object getx_winset_length("1",4);

//---generated Windows ---

bitmap_object gbmp_wingen_generate(bbmp_generate);

void init_gui ( void )
{
   // Setup GUI
   set_default_object_colors(
      makecol(0, 0, 0 ), // text
      makecol(89, 151, 100 ), // Object item
      makecol(162, 200, 169 ),// Object
      makecol(200, 250, 200 ), // High Border Border
      makecol( 89, 151, 100 ), // Low Border
      makecol(120, 225, 150 ), // Button Click, list selection
      makecol(225, 250, 225 ), // Inside Object
      makecol(250, 0, 0 ));

/*   set_default_object_colors(
      makecol(0, 0, 0 ), // text
      makecol(0, 150, 0 ), // Object item
      makecol(100, 225, 100 ),// Object
      makecol(200, 250, 250 ), // High Border Border
      makecol(0, 100, 0 ), // Low Border
      makecol(100, 200, 150 ), // Button Click, list selection
      makecol(175, 250, 225 ), // Inside Object
      makecol(250, 0, 0 ));
*/

   gui_mouse_focus = 0;

   // Global Setup
   bbmp_waveform = create_bitmap ( 200, 100 );
   clear_to_color ( bbmp_waveform, makecol ( 0, 0, 0 ) );
   bbmp_envelope = create_bitmap ( 200, 100 );
   clear_to_color ( bbmp_envelope, makecol ( 0, 0, 0 ) );
   bbmp_pitch = create_bitmap ( 200, 100 );
   clear_to_color ( bbmp_pitch, makecol ( 0, 0, 0 ) );
   bbmp_generate = create_bitmap ( 600, 300 );
   clear_to_color ( bbmp_generate, makecol ( 0, 0, 0 ) );

   bbmp_waveforminfo = create_bitmap (220,110);
   clear_to_color ( bbmp_waveforminfo, makecol ( 225,225, 225 ) );
   bbmp_envelopeinfo = create_bitmap (220,110);
   clear_to_color ( bbmp_envelopeinfo, makecol (225,225, 225 ) );
   bbmp_pitchinfo = create_bitmap (220,110);
   clear_to_color ( bbmp_pitchinfo, makecol ( 225,225, 225 ) );
   bbmp_generalinfo = create_bitmap (140,350);
   clear_to_color ( bbmp_generalinfo, makecol ( 225,225,225 ) );

   wcontain = (s_wave_entry*) malloc ( sizeof ( s_wave_entry) * 44100 * 10 );

//   bbmp_test = create_bitmap ( 200, 100 );
//   clear_to_color ( bbmp_test, makecol ( 0, 0, 0 ) );

   #ifndef ALLEGRO_WINDOWS
      srandom ( time(NULL) );   
   #else
      srand ( time(NULL) );
   #endif

}

void show_mainform ( void )
{

   clear_screen_object gclr_main;
   panel_groove_object object_1;
   text_object gtxt_main_waveform("Wave Form");
   panel_groove_object object_4;
   text_object gtxt_main_envelope("Sound Envelope");
   panel_groove_object object_7;
   text_object gtxt_main_pitch("Pitch Gradient");
   panel_sunken_object object_10;
   panel_groove_object object_14;
   text_object gtxt_main_general("General Info");
//   winbutton_object object_18("Waveform",0,false);
//   winbutton_object object_19("Envelope",0,false);
//   winbutton_object object_20("Pitch",0,false);
//   winbutton_object object_21("Random",0,false);
//   winbutton_object object_22("Setting",0,false);
   text_object gtxt_main_volume("Volume");
   winbutton_object object_17("Generate",0,false);

   gbmp_main_waveform.set_bitmap(bbmp_waveform);
   gbmp_main_envelope.set_bitmap(bbmp_envelope);
   gbmp_main_pitch.set_bitmap(bbmp_pitch);
   gbmp_main_waveforminfo.set_bitmap(bbmp_waveforminfo);
   gbmp_main_envelopeinfo.set_bitmap(bbmp_envelopeinfo);
   gbmp_main_pitchinfo.set_bitmap(bbmp_pitchinfo);
   gbmp_main_generalinfo.set_bitmap(bbmp_generalinfo);

   object_17.set_click_callback ( gc_main_generate_click );
   

   //Menu Generation

   menu mnu_main;
   menu mnu_file;
   menu mnu_help;
   menu mnu_parameter;

   mnu_file.add("New", mnu_file_new );
   mnu_file.add("Open Swg", mnu_file_open );
   mnu_file.add("Save Swg", mnu_file_save );
//   mnu_file.add("Exit", mnu_file_exit );

   mnu_parameter.add("Settings ", mnu_param_setting );
   mnu_parameter.add("Waveform", mnu_param_waveform );
   mnu_parameter.add("Envelope", mnu_param_envelope );
   mnu_parameter.add("Pitch Gradient", mnu_param_pitch );

//   mnu_help.add("Help", mnu_help_help );
   mnu_help.add("About", mnu_help_about );

   mnu_main.add("File",mnu_file);
   mnu_main.add("Parameter",mnu_parameter);
   mnu_main.add("Help", mnu_help );

   menu_object main_menu ( mnu_main );

   //Hook Function

   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gclr_main,0,0,640,480);
   the_dialog.add(object_1,10,20,450,130);
   the_dialog.add(gbmp_main_waveform,20,40,200,100);
   the_dialog.add(gtxt_main_waveform,20,30,72,8);
   the_dialog.add(object_4,10,160,450,130);
   the_dialog.add(gbmp_main_envelope,20,180,200,100);
   the_dialog.add(gtxt_main_envelope,20,170,112,8);
   the_dialog.add(object_7,10,300,450,130);
   the_dialog.add(gbmp_main_pitch,20,320,200,100);
   the_dialog.add(gtxt_main_pitch,20,310,112,8);
   the_dialog.add(object_10,10,440,620,30);
   the_dialog.add(object_14,470,20,160,410);
   the_dialog.add(gtxt_main_general,480,30,152,8);
   the_dialog.add(object_17,10,440,90,30);
//   the_dialog.add(object_21,100,440,90,30);
//   the_dialog.add(object_19,190,440,90,30);
//   the_dialog.add(object_20,280,440,90,30);
//   the_dialog.add(object_21,460,440,90,30);
//   the_dialog.add(object_22,370,440,90,30);
   the_dialog.add(gbtn_exit,550,440,80,30);
   the_dialog.add(gbmp_main_waveforminfo,230,30,220,110);
   the_dialog.add(gbmp_main_envelopeinfo,230,170,220,110);
   the_dialog.add(gbmp_main_pitchinfo,230,310,220,110);
   the_dialog.add(gbmp_main_generalinfo,480,40,140,350);
   the_dialog.add(gtxt_main_volume,480, 392, 140, 8);
   the_dialog.add(gsld_main_volume,480, 404, 140, 16 );
   

   
   the_dialog.add(main_menu,0,0,300,100);

   // seting up the information
   draw_main_property ( wparam );
   draw_main_bitmap ( wparam );
//   draw_waveform ();
   
   the_dialog.execute();

//   PALETTE pal;
//   save_pcx ( "main.pcx", screen, pal );

}

void show_waveform_property ( void )
{

   window_object gwin_waveform("Wave Form Parameters");
   centerd_text_object object_3("Generated Wave Form");
   centerd_text_object object_7("Base Wave");
   centerd_text_object object_8("Function Modifier");
   centerd_text_object object_9("Filter Modifier");
   panel_groove_object gpan_deform;
   centerd_text_object object_11("Wave Deformation");
   text_object gtxt_deformlevel("Level %");
   text_object gtxt_deformspeed("Speed");
   panel_groove_object gpan_wavecut;
   centerd_text_object object_17("Wave Cut");
   text_object gtxt_wcutfreq("Frequency");
   text_object gtxt_wcutlength("Length");
   panel_sunken_object gpan_command;
   winbutton_object gwbt_winwav_accept("Accept",0,true);
   winbutton_object gwbt_winwav_preview("Preview",0,false);
   winbutton_object gwbt_winwav_cancel("Cancel",0,true);
   text_object gtxt_deformtype("Type");
   text_object gtxt_wavecuttype("Type");
   panel_groove_object gpan_freq_variation;
   panel_groove_object gpan_zeroline_move;
   panel_groove_object gpan_amp_variation;
   centerd_text_object gtxt_amp_variation("Amplitude Variation");
   text_object gtxt_ampvarminprop("Min Prop. %");
   text_object gtxt_ampvar_type("Type");
   text_object gtxt_freqvar("Frequency Variation");
   text_object gtxt_frevar_maxprop("Max Increment");
   text_object gtxt_frevartype("Type");
   text_object gtxt_zerolinemove("Zero Line Movement");
   text_object gtxt_zlinelevel("Level %");
   text_object gtxt_zlinetype("Type");

   //hook function
   gbmp_winwav_waveform.set_bitmap(bbmp_waveform);
   gwbt_winwav_accept.set_click_callback ( gc_waveform_accept_click );
   gwbt_winwav_cancel.set_click_callback ( gc_waveform_cancel_click );
   gwbt_winwav_preview.set_click_callback ( gc_waveform_preview_click );
//   gwbt_cancel.set_click_callback ( gc_waveform_cancel_click );



   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_waveform,100,30,420,420);
   the_dialog.add(gbmp_winwav_waveform,110,60,200,100);
   the_dialog.add(object_3,210,50,76,8);
   the_dialog.add(ghls_winwav_basewave,328,66,180,16);
   the_dialog.add(ghls_winwav_function,328,106,178,16);
   the_dialog.add(ghls_winwav_filter,328,146,178,16);
   the_dialog.add(object_7,408,50,36,8);
   the_dialog.add(object_8,416,90,68,8);
   the_dialog.add(object_9,416,130,60,8);
   the_dialog.add(gpan_deform,110,170,190,82);
   the_dialog.add(object_11,210,180,64,8);
   the_dialog.add(gtxt_deformlevel,120,192,56,8);
   the_dialog.add(gtxt_deformspeed,120,212,40,8);
   the_dialog.add(ghls_winwav_deformspeed,192,208,96,16);
   the_dialog.add(getx_winwav_deformlevel,256,188,32,16);
   the_dialog.add(gpan_wavecut,320,170,188,82);
   the_dialog.add(object_17,420,180,32,8);
   the_dialog.add(gtxt_wcutfreq,328,192,72,8);
   the_dialog.add(gtxt_wcutlength,328,212,48,8);
   the_dialog.add(getx_winwav_wcutfreq,448,188,48,16);
   the_dialog.add(getx_winwav_wcutlength,456,208,40,16);
   the_dialog.add(gpan_command,110,400,400,40);
   the_dialog.add(gwbt_winwav_accept,430,400,80,40);
   the_dialog.add(gwbt_winwav_preview,110,400,80,40);
   the_dialog.add(gwbt_winwav_cancel,350,400,80,40);
   the_dialog.add(ghls_winwav_deformtype,192,228,96,16);
   the_dialog.add(gtxt_deformtype,120,232,32,8);
   the_dialog.add(ghls_winwav_wavecuttype,400,228,96,16);
   the_dialog.add(gtxt_wavecuttype,328,232,32,8);
   the_dialog.add(gpan_freq_variation,320,260,188,60);
   the_dialog.add(gpan_zeroline_move,320,328,188,64);
   the_dialog.add(gpan_amp_variation,108,260,192,72);
   the_dialog.add(gtxt_amp_variation,204,268,76,8);
   the_dialog.add(gtxt_ampvarminprop,120,284,88,8);
   the_dialog.add(getx_winwav_ampvarprop,256,280,32,13);
   the_dialog.add(gchk_winwav_ampvarzline,116,316,152,12);
   the_dialog.add(ghls_winwav_ampvartype,168,296,120,16);
   the_dialog.add(gtxt_ampvar_type,120,300,32,8);
   the_dialog.add(gtxt_freqvar,340,268,152,8);
   the_dialog.add(gtxt_frevar_maxprop,328,284,104,8);
   the_dialog.add(getx_winwav_frevarprop,464,280,32,13);
   the_dialog.add(ghls_winwav_frevartype,380,300,116,12);
   the_dialog.add(gtxt_frevartype,328,304,32,8);
   the_dialog.add(gtxt_zerolinemove,340,336,144,8);
   the_dialog.add(gtxt_zlinelevel,328,352,56,8);
   the_dialog.add(getx_winwav_zlinelevel,464,348,32,13);
   the_dialog.add(ghls_winwav_zlinetype,376,368,120,16);
   the_dialog.add(gtxt_zlinetype,328,372,32,8);
   the_dialog.center();
   the_dialog.popup();

   // Add Objects to the dialog
/*   dialog the_dialog;
   the_dialog.add(gwin_waveform,100,60,420,300);
   the_dialog.add(gbmp_winwav_waveform,110,90,200,100);
   the_dialog.add(object_3,210,80,76,8);
   the_dialog.add(ghls_winwav_basewave,328,96,180,16);
   the_dialog.add(ghls_winwav_function,328,136,178,16);
   the_dialog.add(ghls_winwav_filter,328,176,178,16);
   the_dialog.add(object_7,408,80,36,8);
   the_dialog.add(object_8,416,120,68,8);
   the_dialog.add(object_9,416,160,60,8);
   the_dialog.add(gpan_deform,110,200,190,100);
   the_dialog.add(object_11,210,210,64,8);
   the_dialog.add(gtxt_deformlevel,120,232,56,8);
   the_dialog.add(gtxt_deformspeed,120,256,40,8);
   the_dialog.add(ghls_winwav_deformspeed,192,248,96,16);
   the_dialog.add(getx_winwav_deformlevel,256,224,32,16);
   the_dialog.add(gpan_wavecut,320,200,190,100);
   the_dialog.add(object_17,420,210,32,8);
   the_dialog.add(gtxt_wcutfreq,328,232,72,8);
   the_dialog.add(gtxt_wcutlength,328,256,48,8);
   the_dialog.add(getx_winwav_wcutfreq,448,224,48,16);
   the_dialog.add(getx_winwav_wcutlength,456,248,40,16);
   the_dialog.add(gpan_command,110,310,400,40);
   the_dialog.add(gwbt_winwav_accept,430,310,80,40);
   the_dialog.add(gwbt_winwav_preview,110,310,80,40);
   the_dialog.add(gwbt_winwav_cancel,350,310,80,40);
   the_dialog.add(ghls_winwav_deformtype,192,272,96,16);
   the_dialog.add(gtxt_deformtype,120,280,32,8);
   the_dialog.add(ghls_winwav_wavecuttype,400,272,96,16);
   the_dialog.add(gtxt_wavecuttype,328,280,32,8);
   the_dialog.center();
   the_dialog.popup();*/



}

void show_envelope_property ( void )
{

   // Object definitions - DEGUI 1.25 beta
   window_object gwin_envelope("Envelope Properties");
   text_object gtxt_envelopeform("Envelope");
   winbutton_object gwbt_winenv_pointA("Point A",0,false);
   winbutton_object gwbt_winenv_pointB("Point B",0,false);
   winbutton_object gwbt_winenv_pointC("Point C",0,false);
   winbutton_object gwbt_winenv_pointD("Point D",0,false);
   text_object gtxt_ruleinfo("Choose a point, use arrows and press Enter");
   panel_groove_object object_9;
   text_object gtxt_varfreq("Frequency");
   text_object gtxt_variation("Variation");
   text_object gtxt_proportion("Proportion %");
   panel_sunken_object object_13;
   winbutton_object gwbt_winenv_preview("Preview",0,false);
   winbutton_object gwbt_winenv_accept("Accept",0,true);
   winbutton_object gwbt_winenv_cancel("Cancel",0,true);
   winbutton_object gwbt_winenv_pointE("Point E",0,false);
   winbutton_object gwbt_winenv_pointF("Point F",0,false);
   winbutton_object gwbt_winenv_pointG("Point G",0,false);
   winbutton_object gwbt_winenv_pointH("Point H",0,false);
   text_object gtxt_pointformtype("Type");
   text_object gtxt_vartype("Type");
   text_object gtxt_varvartype("Variation");

   // hook
   gbmp_winenv_envelope.set_bitmap(bbmp_envelope);
   gwbt_winenv_pointA.set_click_callback ( gc_envelope_pointA_click );
   gwbt_winenv_pointB.set_click_callback ( gc_envelope_pointB_click );
   gwbt_winenv_pointC.set_click_callback ( gc_envelope_pointC_click );
   gwbt_winenv_pointD.set_click_callback ( gc_envelope_pointD_click );
   gwbt_winenv_pointE.set_click_callback ( gc_envelope_pointE_click );
   gwbt_winenv_pointF.set_click_callback ( gc_envelope_pointF_click );
   gwbt_winenv_pointG.set_click_callback ( gc_envelope_pointG_click );
   gwbt_winenv_pointH.set_click_callback ( gc_envelope_pointH_click );
   gwbt_winenv_preview.set_click_callback ( gc_envelope_preview_click );
   gwbt_winenv_accept.set_click_callback ( gc_envelope_accept_click );
   gwbt_winenv_cancel.set_click_callback ( gc_envelope_cancel_click );


   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_envelope,120,80,370,280);
   the_dialog.add(gbmp_winenv_envelope,130,110,200,100);
   the_dialog.add(gtxt_envelopeform,130,100,64,8);
   the_dialog.add(gwbt_winenv_pointA,344,98,64,16);
   the_dialog.add(gwbt_winenv_pointB,344,122,64,16);
   the_dialog.add(gwbt_winenv_pointC,344,146,64,16);
   the_dialog.add(gwbt_winenv_pointD,344,170,64,16);
   the_dialog.add(gtxt_ruleinfo,140,220,328,8);
   the_dialog.add(object_9,130,230,350,70);
   the_dialog.add(gtxt_varfreq,140,260,72,8);
   the_dialog.add(gtxt_variation,140,240,72,8);
   the_dialog.add(gtxt_proportion,140,280,96,8);
   the_dialog.add(object_13,130,310,350,40);
   the_dialog.add(gwbt_winenv_preview,130,310,80,40);
   the_dialog.add(gwbt_winenv_accept,400,310,80,40);
   the_dialog.add(gwbt_winenv_cancel,320,310,80,40);
   the_dialog.add(getx_winenv_varfreq,256,256,32,16);
   the_dialog.add(getx_winenv_varprop,256,280,32,13);
   the_dialog.add(gwbt_winenv_pointE,416,98,64,16);
   the_dialog.add(gwbt_winenv_pointF,416,122,64,16);
   the_dialog.add(gwbt_winenv_pointG,416,146,64,16);
   the_dialog.add(gwbt_winenv_pointH,416,170,64,16);
   the_dialog.add(ghls_winenv_pointformtype,400,192,80,16);
   the_dialog.add(gtxt_pointformtype,344,200,32,8);
   the_dialog.add(ghls_winenv_vartype,384,256,88,16);
   the_dialog.add(ghls_winenv_varvartype,384,280,88,8);
   the_dialog.add(gtxt_vartype,304,264,32,8);
   the_dialog.add(gtxt_varvartype,304,280,72,8);
   the_dialog.center();
   the_dialog.popup();

/*   window_object gwin_envelope("Envelope Properties");
   text_object gtxt_envelopeform("Envelope");
   winbutton_object object_4("Set Point A",0,false);
   winbutton_object object_5("Set Point B",0,false);
   winbutton_object object_6("Set Point C",0,false);
   winbutton_object object_7("Set Point D",0,false);
   text_object gtxt_ruleinfo("Choose a point, use arrows and press Enter");
   panel_groove_object object_9;
   text_object gtxt_varfreq("Frequency");
   text_object gtxt_variation("Variation");
   text_object gtxt_proportion("Proportion %");
   panel_sunken_object object_13;
   winbutton_object object_14("Preview",0,false);
   winbutton_object object_15("Accept",0,true);
   winbutton_object object_16("Cancel",0,true);

   gbmp_winenv_envelope.set_bitmap(bbmp_envelope);

   // hook function
   object_4.set_click_callback ( gc_envelope_pointA_click );
   object_5.set_click_callback ( gc_envelope_pointB_click );
   object_6.set_click_callback ( gc_envelope_pointC_click );
   object_7.set_click_callback ( gc_envelope_pointD_click );
   object_14.set_click_callback ( gc_envelope_preview_click );
   object_15.set_click_callback ( gc_envelope_accept_click );
   object_16.set_click_callback ( gc_envelope_cancel_click );

   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_envelope,120,80,350,280);
   the_dialog.add(gbmp_winenv_envelope,130,110,200,100);
   the_dialog.add(gtxt_envelopeform,130,100,64,8);
   the_dialog.add(object_4,350,100,108,18);
   the_dialog.add(object_5,350,130,108,18);
   the_dialog.add(object_6,350,160,108,18);
   the_dialog.add(object_7,350,190,108,18);
   the_dialog.add(gtxt_ruleinfo,130,220,328,8);
   the_dialog.add(object_9,130,230,330,70);
   the_dialog.add(gtxt_varfreq,140,260,72,8);
   the_dialog.add(gtxt_variation,140,240,72,8);
   the_dialog.add(gtxt_proportion,140,280,96,8);
   the_dialog.add(object_13,130,310,330,40);
   the_dialog.add(object_14,130,310,80,40);
   the_dialog.add(object_15,380,310,80,40);
   the_dialog.add(object_16,300,310,80,40);
   the_dialog.add(getx_winenv_varfreq,280,260,48,13);
   the_dialog.add(getx_winenv_varprop,280,280,32,13);
//   the_dialog.add(grad_winenv_vartypeA,370,260,72,12);
//   the_dialog.add(grad_winenv_vartypeB,370,280,72,12);
   the_dialog.center();
   the_dialog.popup();*/

   
}

void show_pitch_property ( void )
{

   window_object gwin_pitch("Pitch Gradient Parameters");
   text_object gtxt_winpit_pgradien("Pitch Gradien");
   winbutton_object gwbt_winpit_pointA("Point A",0,false);
   winbutton_object gwbt_winpit_pointB("Point B",0,false);
   winbutton_object gwbt_winpit_pointC("Point C",0,false);
   winbutton_object gwbt_winpit_pointD("Point D",0,false);
   text_object gtxt_winpit_rule("Click button, use arrows then press Enter");
   panel_groove_object object_10;
   text_object gtxt_winpit_variation("Variation");
   text_object gtxt_winpit_frequency("Frequency Hz");
   text_object gtxt_winpit_proportion("Proportion %");
   panel_sunken_object object_18;
   winbutton_object gwbt_winpit_preview("Preview",0,false);
   winbutton_object gwbt_winpit_accept("Accept",0,true);
   winbutton_object gwbt_winpit_cancel("Cancel",0,true);
   winbutton_object gwbt_winpit_pointE("Point E",0,false);
   winbutton_object gwbt_winpit_pointF("Point F",0,false);
   winbutton_object gwbt_winpit_pointG("Point G",0,false);
   winbutton_object gwbt_winpit_pointH("Point H",0,false);
   text_object gtxt_pointformtype("Type");
   text_object gtxt_vartype("Type");
   text_object gtxt_varvartype("Variation");

   //hook functions
   gbmp_winpit_pitch.set_bitmap(bbmp_pitch);
   gwbt_winpit_pointA.set_click_callback ( gc_pitch_pointA_click );
   gwbt_winpit_pointB.set_click_callback ( gc_pitch_pointB_click );
   gwbt_winpit_pointC.set_click_callback ( gc_pitch_pointC_click );
   gwbt_winpit_pointD.set_click_callback ( gc_pitch_pointD_click );
   gwbt_winpit_pointE.set_click_callback ( gc_pitch_pointE_click );
   gwbt_winpit_pointF.set_click_callback ( gc_pitch_pointF_click );
   gwbt_winpit_pointG.set_click_callback ( gc_pitch_pointG_click );
   gwbt_winpit_pointH.set_click_callback ( gc_pitch_pointH_click );
   gwbt_winpit_preview.set_click_callback ( gc_pitch_preview_click );
   gwbt_winpit_accept.set_click_callback ( gc_pitch_accept_click );
   gwbt_winpit_cancel.set_click_callback ( gc_pitch_cancel_click );


   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_pitch,120,90,370,280);
   the_dialog.add(gbmp_winpit_pitch,130,120,200,100);
   the_dialog.add(gtxt_winpit_pgradien,130,110,104,8);
   the_dialog.add(gwbt_winpit_pointA,344,106,64,16);
   the_dialog.add(gwbt_winpit_pointB,344,130,64,16);
   the_dialog.add(gwbt_winpit_pointC,344,154,64,16);
   the_dialog.add(gwbt_winpit_pointD,344,178,64,16);
   the_dialog.add(gtxt_winpit_rule,130,230,328,8);
   the_dialog.add(ghls_winpit_pointformtype,400,200,82,16);
   the_dialog.add(object_10,130,240,350,70);
   the_dialog.add(gtxt_winpit_variation,140,250,72,8);
   the_dialog.add(gtxt_winpit_frequency,140,270,96,8);
   the_dialog.add(gtxt_winpit_proportion,140,290,96,8);
   the_dialog.add(getx_winpit_freq,248,264,32,16);
   the_dialog.add(getx_winpit_prop,248,288,32,13);
   the_dialog.add(ghls_winpit_vartype,384,264,88,12);
   the_dialog.add(ghls_winpit_varvartype,384,288,88,16);
   the_dialog.add(object_18,130,320,350,40);
   the_dialog.add(gwbt_winpit_preview,130,320,80,40);
   the_dialog.add(gwbt_winpit_accept,400,320,80,40);
   the_dialog.add(gwbt_winpit_cancel,320,320,80,40);
   the_dialog.add(gwbt_winpit_pointE,416,106,64,16);
   the_dialog.add(gwbt_winpit_pointF,416,130,64,16);
   the_dialog.add(gwbt_winpit_pointG,416,154,64,16);
   the_dialog.add(gwbt_winpit_pointH,416,178,64,16);
   the_dialog.add(gtxt_pointformtype,344,208,32,8);
   the_dialog.add(gtxt_vartype,296,272,32,8);
   the_dialog.add(gtxt_varvartype,296,296,72,8);
   the_dialog.center();
   the_dialog.popup();
   
/*   window_object gwin_pitch("Pitch Gradient Parameters");
   text_object gtxt_winpit_pgradien("Pitch Gradien");
   text_object gtxt_winpit_rule("Choose a point, use arrows and press Enter");
   panel_groove_object object_10;
   text_object gtxt_winpit_variation("Variation");
   text_object gtxt_winpit_frequency("Frequency Hz");
   text_object gtxt_winpit_proportion("Proportion %");
   panel_sunken_object object_18;
   winbutton_object gbtn_winpit_pointa("Set Point A",0,false);
   winbutton_object gbtn_winpit_pointb("Set Point B",0,false);
   winbutton_object gbtn_winpit_pointc("Set Point C",0,false);
   winbutton_object gbtn_winpit_pointd("Set Point D",0,false);
   winbutton_object gbtn_winpit_preview("Preview",0,false);
   winbutton_object gbtn_winpit_accept("Accept",0,true);
   winbutton_object gbtn_winpit_cancel("Cancel",0,true);


   gbmp_winpit_pitch.set_bitmap(bbmp_pitch);
   
   // hook function

   gbtn_winpit_pointa.set_click_callback ( gc_pitch_pointA_click );
   gbtn_winpit_pointb.set_click_callback ( gc_pitch_pointB_click );
   gbtn_winpit_pointc.set_click_callback ( gc_pitch_pointC_click );
   gbtn_winpit_pointd.set_click_callback ( gc_pitch_pointD_click );
   gbtn_winpit_preview.set_click_callback ( gc_pitch_preview_click );
   gbtn_winpit_accept.set_click_callback ( gc_pitch_accept_click );
   gbtn_winpit_cancel.set_click_callback ( gc_pitch_cancel_click );


   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_pitch,120,90,350,280);
   the_dialog.add(gbmp_winpit_pitch,130,120,200,100);
   the_dialog.add(gtxt_winpit_pgradien,130,110,104,8);
   the_dialog.add(gbtn_winpit_pointa,350,110,110,20);
   the_dialog.add(gbtn_winpit_pointb,350,132,110,20);
   the_dialog.add(gbtn_winpit_pointc,350,154,110,20);
   the_dialog.add(gbtn_winpit_pointd,350,176,110,20);
   the_dialog.add(gtxt_winpit_rule,130,230,328,8);
//   the_dialog.add(glst_winpit_preset,350,200,110,20);
   the_dialog.add(object_10,130,240,330,70);
   the_dialog.add(gtxt_winpit_variation,140,250,72,8);
   the_dialog.add(gtxt_winpit_frequency,140,270,96,8);
   the_dialog.add(gtxt_winpit_proportion,140,290,96,8);
   the_dialog.add(getx_winpit_freq,250,270,48,13);
   the_dialog.add(getx_winpit_prop,250,290,32,13);
//   the_dialog.add(ghls_winpit_vtype,320,260,130,20);
//   the_dialog.add(ghls_winpit_vswitch,320,280,130,20);
   the_dialog.add(object_18,130,320,330,40);
   the_dialog.add(gbtn_winpit_preview,130,320,80,40);
   the_dialog.add(gbtn_winpit_accept,380,320,80,40);
   the_dialog.add(gbtn_winpit_cancel,300,320,80,40);
   the_dialog.center();
   the_dialog.popup();*/


   
}

void show_setting_property ( void )
{
   
   window_object gwin_setting("Sound Sample Settings");
   text_object gtxt_bitrate("Bitrate");
   text_object gtxt_samplefreq("Sampling Frequency");
   text_object gtxt_length("Length in Seconds");
   panel_sunken_object object_8;
   winbutton_object gbtn_winset_accept("Accept",0,true);
   winbutton_object gbtn_winset_close("Cancel",0,true);

   //hook function
   gbtn_winset_accept.set_click_callback ( gc_setting_accept_click );

   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_setting,190,120,270,160);
   the_dialog.add(gtxt_bitrate,200,150,56,8);
   the_dialog.add(ghls_winset_bitrate,380,140,70,20);
   the_dialog.add(gtxt_samplefreq,200,170,144,8);
   the_dialog.add(ghls_winset_samfreq,350,160,100,20);
   the_dialog.add(gtxt_length,200,190,136,8);
   the_dialog.add(getx_winset_length,390,190,48,13);
   the_dialog.add(object_8,200,230,250,40);
   the_dialog.add(gbtn_winset_accept,370,230,80,40);
   the_dialog.add(gbtn_winset_close,290,230,80,40);
   the_dialog.center();
   the_dialog.popup();



}

void show_generated_sample ( void )
{


   window_object gwin_generate("Generated Sound Sample");
   panel_sunken_object object_3;
   winbutton_object gbtn_wingen_play("Play",0,false);
   winbutton_object gbtn_wingen_export("Export",0,false);
   winbutton_object gbtn_wingen_close("Close",0,true);

   gbmp_wingen_generate.set_bitmap(bbmp_generate);
   gbtn_wingen_play.set_click_callback ( gc_generate_play_click );
   gbtn_wingen_export.set_click_callback ( gc_generate_export_click );
   gbtn_wingen_close.set_click_callback ( gc_generate_close_click );
   
   
   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(gwin_generate,10,20,620,380);
   the_dialog.add(gbmp_wingen_generate,20,40,600,300);
   the_dialog.add(object_3,20,350,600,40);
   the_dialog.add(gbtn_wingen_play,20,350,80,40);
   the_dialog.add(gbtn_wingen_export,100,350,80,40);
   the_dialog.add(gbtn_wingen_close,180,350,80,40);
   the_dialog.center();
   the_dialog.popup();

}

void show_about ( void )
{
   char tmpstr [ 80 ];
   

   window_object object_1;
   centerd_text_object object_2("Sound Wave Generator");
   strcpy ( tmpstr, "Version ");
   strcat ( tmpstr, VERSION );
   strcat ( tmpstr, ", file ver. ");
   strcat ( tmpstr, FILEVERSION );
   text_object object_3(tmpstr);
   text_object object_4(DATE);
   text_object object_5("By Eric Pietrocupo");
   text_object object_6("E-Mail Address");
   text_object object_7("ericp@ariel.bdeb.qc.ca");
   text_object object_8("My Allegro Website");
   text_object object_9("ariel.bdeb.qc.ca/~ericp/allegro");

   // Add Objects to the dialog
   dialog the_dialog;
   the_dialog.add(object_1,170,90,280,190);
   the_dialog.add(object_2,310,110,70,10);
   the_dialog.add(object_3,180,130,104,8);
   the_dialog.add(object_4,180,150,104,8);
   the_dialog.add(object_5,180,170,144,8);
   the_dialog.add(object_6,180,200,112,8);
   the_dialog.add(object_7,190,220,128,8);
   the_dialog.add(object_8,180,240,120,8);
   the_dialog.add(object_9,190,260,248,8);
   the_dialog.center();
   the_dialog.popup();
}

void show_intro ( void )
{
   BITMAP *buffer;
   BITMAP *nextbuf;
   DATAFILE *datf;

   buffer = create_bitmap ( 640, 480 );
   nextbuf = create_bitmap ( 640, 480 );

   // loading
   clear_to_color ( buffer, makecol ( 0, 0, 0 ) );
   clear_to_color ( nextbuf, makecol ( 0, 0, 0 ) );
   textout_centre ( buffer, font, "This software is powered by",
      320, 240, makecol ( 225, 225, 225 ) );
   blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );
   datf = load_datafile ( "sndwavg.dat" );

   rest ( 1500 );
   // building allegro bitmap

   blit ( (BITMAP*)datf[BMP_allegro].dat, nextbuf, 0, 0, 160, 120, 320,240 );
   textout_centre ( nextbuf, font, "Video Game Library", 320, 380, makecol ( 225, 225, 225 ) );

   do_algo7_animation ( buffer, nextbuf );

   rest(2000);
   // Building degui bitmap

   blit ( (BITMAP*)datf[BMP_degui].dat, nextbuf, 0, 0, 160, 120, 320,240 );
   textout_centre ( nextbuf, font, "Allegro GUI c++ Extension", 320, 380, makecol ( 225, 225, 225 ) );

   do_algo7_animation ( buffer, nextbuf );

   rest (2000);
   // clear screen
   
   clear_to_color ( nextbuf, makecol ( 0, 0, 0 ) );
   do_algo7_animation ( buffer, nextbuf );

   rest (500);
   // show sound wave gen

   blit ( (BITMAP*)datf[BMP_soundwavegen].dat, buffer, 0, 0, 160, 80, 320,240 );
   textout_centre ( buffer, font, "Coded by : Eric Pietrocupo", 320, 340, makecol ( 225, 225, 225 ) );
   textout_centre ( buffer, font, "This programm is distributed", 320, 380, makecol ( 225, 225, 225 ) );
   textout_centre ( buffer, font, "as Open Source Software", 320, 390, makecol ( 225, 225, 225 ) );
   textout_centre ( buffer, font, "For more information see", 320, 430, makecol ( 225, 225, 225 ) );
   textout_centre ( buffer, font, "Readme.txt or my Allegro website", 320, 440, makecol ( 225, 225, 225 ) );
   textout_centre ( buffer, font, "Push Enter to start", 320, 470, makecol ( 225, 225, 225 ) );

   blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );

   while ( ( readkey() >> 8 ) != KEY_ENTER );

   clear_to_color ( screen, makecol ( 0, 0, 0 ) );

   destroy_bitmap ( buffer );
   destroy_bitmap ( nextbuf );

   unload_datafile ( datf );
}

void do_algo7_animation ( BITMAP *buffer, BITMAP *nextbuf )
{
      short i;
      short j;
      short tmpj;
      short x;
      short y;
      short xrel;
      short yrel;

      j = 0;
      for ( i = 0 ; i < 16 ; i++ )
      {
         // calculating correct j value;

         if ( j > 15 )
            j = j - 16;
      
         // interpretation of relative pixel
         tmpj = j;
         xrel = 0;
         yrel = 0;
         while ( tmpj > 3 )
         {
            yrel++;
            tmpj = tmpj - 4;
         }
         xrel = tmpj;
         
         // draw the pixel
         for ( y = 0 ; y < 480 ; y = y + 4 )
            for ( x = 0 ; x < 640 ; x = x + 4 )
               putpixel ( buffer, x + xrel, y + yrel, getpixel ( nextbuf, x + xrel, y+ yrel ) );
         blit ( buffer, screen, 0, 0, 0, 0, 640, 480 );

         // incrementing j;
         j = j + 7;
         rest(10);
      }

}



