/**************************************************************************/
/*                                                                        */
/*              S O U N D    W A V E    G E N E R A T O R                 */
/*                                                                        */
/*    This is a small utility that allows to generate simple sound wave   */
/*    by adjusting the envelope, picth gradient and wave type. There      */
/*    might also be a randomiser to generate theses parameters randomly.  */
/*    It wil probably support various bitrate and sampling frequencies.   */
/*                                                                        */
/*     Content : main Programm                                            */
/*     Programmer : Eric Pietrocupo                                       */
/*     Starting Date : February 8th, 2005                                 */
/*     Licence : GNU General Public License                               */
/*                                                                        */
/**************************************************************************/

#include <allegro.h>
#include <degui.h>
#include <math.h>
#include <sndwaveg.h>
#include <setup.h>
#include <string.h>
//#include <stdio.h>


int main ( int nb_param, char *param[] )
{

   SAMPLE* smp_main;
   SAMPLE* smp_second;
   s_wave_parameter wav_main;
   int i;

   //---------- Initialisation ----------
   allegro_init();

   detect_digi_driver(DIGI_AUTODETECT);
   detect_digi_driver(MIDI_AUTODETECT);

   install_timer();
   install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
   install_keyboard();
   install_mouse();

   //run setup if the user want to
   if ( nb_param > 1 )
      if ( strcmp ( param [ 1 ] , "-setup" ) == 0 )
      {
         set_color_depth (8);
         set_gfx_mode ( GFX_SAFE, 320, 200, 0, 0 );

         setup_main();
         return ( 0 );
      }
   
   set_color_depth (16);
   set_gfx_mode ( GFX_AUTODETECT, 640, 480, 0, 0 );

   show_intro ();

   reset_wave_parameter ( &wparam );
   init_gui ();

   show_mainform();

   allegro_exit();
   return ( 0 );
}
END_OF_MAIN();



// sample information
//   typedef struct SAMPLE                  /* a sample */
//{
//   int bits;                           /* 8 or 16 */
//   int stereo;                         /* sample type flag */
//   int freq;                           /* sample frequency */
//   int priority;                       /* 0-255 */
//   unsigned long len;                  /* length (in samples) */
//   unsigned long loop_start;           /* loop start position */
//   unsigned long loop_end;             /* loop finish position */
//   unsigned long param;                /* for internal use by the driver */
//   void *data;                         /* sample data */
//} SAMPLE;

//frequency speed
//11025, 22050, 44100


