/***************************************************************************/
/*                                                                         */
/*                             G U I . C P P                               */
/*                             Code Module                                 */
/*                                                                         */
/*     Content : GUI related procedures                                    */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : February 9th, 2005                                  */
/*     Licence : GNU General Public License                                */
/*                                                                         */
/***************************************************************************/

#include <allegro.h>
#include <degui.h>
#include <string.h>
#include <stdio.h>
#include <sndwaveg.h>
#include <gui.h>

//-------------------------Global  Variables -----------------------



BITMAP* bbmp_waveform;
BITMAP* bbmp_envelope;
BITMAP* bbmp_pitch;
BITMAP* bbmp_generate;

BITMAP* bbmp_waveforminfo;
BITMAP* bbmp_envelopeinfo;
BITMAP* bbmp_pitchinfo;
BITMAP* bbmp_generalinfo;

s_coordinate winenvvar [ 8 ];
s_coordinate winpitvar [ 8 ];

int z;

//---------------------------- List Procedures -------------------------

char *flst_wavebase (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_WAVEBASE_SIZE;
   else
      return ( SLST_WAVEBASE [ index ] );
}

char SLST_WAVEBASE [ SLST_WAVEBASE_SIZE ] [ 26 ] =
{
   "Sine",                            //#define WAVEBASE_SIN         0
   "Sawtooth",                        //#define WAVEBASE_SAWTOOTH    1
   "Random",                          //#define WAVEBASE_RANDOM       2
   "Hyperbolic Sine",                 //#define WAVEBASE_SINH        3
   "Arc Tangent",                     //#define WAVEBASE_ATAN        4
   "-- Empty --",          //#define WAVEBASE_EMPTY0       5
   "Tangent",                         //#define WAVEBASE_TAN         6
   "Hyperbolic Tangent",              //#define WAVEBASE_TANH        7
   "Bessel j0",                       //#define WAVEBASE_J0          8
   "Bessel j1",                       //#define WAVEBASE_J1          9
   "Bessel y0",                       //#define WAVEBASE_Y0          10
   "Bessel y1",                       //#define WAVEBASE_Y1          11
   "Square Root",                     //#define WAVEBASE_SQRT        12
   "e exponent X-1",                 //#define WAVEBASE_EXPM1       13
   "Floor",                           //#define WAVEBASE_FLOOR       14
   "Float Pnt. Remainder",        //#define WAVEBASE_FMOD        15
   "-- Empty --",              //#define WAVEBASE_EMPTY1       16
   "I Logarithm B",                   //#define WAVEBASE_ILOGB       17
   "Double Exponential",              //#define WAVEBASE_LDEXP       18
   "Logarithm",                       //#define WAVEBASE_LOG         19
   "Logarithm base 10",               //#define WAVEBASE_LOG10       20
   "Power 3",                         //#define WAVEBASE_POW3        21
   "Round Integer",                   //#define WAVEBASE_RINT        22
};

char *flst_wavefunction (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_WAVEFUNCTION_SIZE;
   else
      return ( SLST_WAVEFUNCTION [ index ] );
}

char SLST_WAVEFUNCTION [ SLST_WAVEFUNCTION_SIZE ] [ 26 ] =
{
   "None",                   //#define WAVEFUNCTION_NONE    0
   "Sine",                   //#define WAVEFUNCTION_SIN     1
   "Cosine",                 //#define WAVEFUNCTION_COS     2
   "Tangent",                //#define WAVEFUNCTION_TAN     3
   "Arc Sine",               //#define WAVEFUNCTION_ASIN    4
   "Arc Cosine",             //#define WAVEFUNCTION_ACOS    5
   "Arc Tangent",            //#define WAVEFUNCTION_ATAN    6
   "Floor",                  //#define WAVEFUNCTION_FLOOR   7
   "Square Root",            //#define WAVEFUNCTION_SQRT    8
   "Scale X by 2",           //#define WAVEFUNCTION_SCALBN2 9
   "Power of 3",             //#define WAVEFUNCTION_POW3    10
   "Power of 4",             //#define WAVEFUNCTION_POW4    11
   "Logarithm",              //#define WAVEFUNCTION_LOG     12
   "Logarithm 1+X",          //#define WAVEFUNCTION_LOG1P   13
   "Multiply by Random",     //#define WAVEFUNCTION_MULRANDOM   14
   "e exponent X-1",        //#define WAVEFUNCTION_EXPM1   15
   "Exponential",            //#define WAVEFUNCTION_EXP     16
   "Error Approximation",    //#define WAVEFUNCTION_ERF     17
   "Cubic Root",             //#define WAVEFUNCTION_CBRT    18
   "Bessel j0",              //#define WAVEFUNCTION_J0      19
   "Bessel j1",              //#define WAVEFUNCTION_J1      20
   "Bessel y0",              //#define WAVEFUNCTION_Y0      21
   "Bessel y1",              //#define WAVEFUNCTION_Y1      22
};

char *flst_wavefilter (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_WAVEFILTER_SIZE;
   else
      return ( SLST_WAVEFILTER [ index ] );
}

char SLST_WAVEFILTER [ SLST_WAVEFILTER_SIZE ] [ 26 ] =
{
   "None",        //#define WAVEMODIFIER_NONE    0
   "Absolute",    //#define WAVEMODIFIER_ABS     1
   "Minimum 0",   //#define WAVEMODIFIER_MIN0    2
   "Maximum 0",   //#define WAVEMODIFIER_MAX0    3
   "Mirror",      //#define WAVEMODIFIER_MIRROR  4
   "Invert",      //   #define WAVEMODIFIER_INVERT      5
   "Amplify x2",  //#define WAVEMODIFIER_AMPLIFY     6
   "De-Amplify /2",//#define WAVEMODIFIER_DEAMPLIFY   7
   "Add Random",   //#define WAVEMODIFIER_ADDRANDOM   8
   "Border",       //#define WAVEMODIFIER_BORDER      9

};


char *flst_deformspeed (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_DEFORMSPEED_SIZE;
   else
      return ( SLST_DEFORMSPEED [ index ] );
}


char SLST_DEFORMSPEED [ SLST_DEFORMSPEED_SIZE ] [ 11 ] =
{
   "None  ",
   "Very High",
   "High  ",
   "Medium",
   "Low   ",
   "Very Low"
};

char *flst_deformtype (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_DEFORMTYPE_SIZE;
   else
      return ( SLST_DEFORMTYPE [ index ] );
}

char SLST_DEFORMTYPE [ SLST_DEFORMTYPE_SIZE ] [ 11 ] =
{
   "Stable",
   "Variable",
   "Random"
};

char *flst_ampvartype (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_AMPVARTYPE_SIZE;
   else
      return ( SLST_AMPVARTYPE [ index ] );
}

char SLST_AMPVARTYPE [ SLST_AMPVARTYPE_SIZE ] [ 16 ] =
{
   "No Variation",
   "Random",
   "Stable",
   "Opposite",
   "Max-Min"
};

char *flst_frevartype (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_FREVARTYPE_SIZE;
   else
      return ( SLST_FREVARTYPE [ index ] );
}

char SLST_FREVARTYPE [ SLST_FREVARTYPE_SIZE ] [ 16 ] =
{
   "Random",
   "Raise-Lower",
   "Max-Min"
};

char *flst_zlinetype (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_ZLINETYPE_SIZE;
   else
      return ( SLST_ZLINETYPE [ index ] );
}

char SLST_ZLINETYPE [ SLST_ZLINETYPE_SIZE ] [ 16 ] =
{
   "Random",
   "Raise-Lower",
   "Max-Min"
};




char *flst_envpitvartype (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_ENVPITVARTYPE_SIZE;
   else
      return ( SLST_ENVPITVARTYPE [ index ] );
}

char SLST_ENVPITVARTYPE [ SLST_ENVPITVARTYPE_SIZE ] [ 16 ] =
{
   "Soft",
   "Hard",
   "Sawtooth",
   "Rev. Sawtooth"
};

char *flst_envpitvarvartype (int index, int *list_index )

{
   if ( index < 0 )
      *list_index = SLST_ENVPITVARVARTYPE_SIZE;
   else
      return ( SLST_ENVPITVARVARTYPE [ index ] );

}

char SLST_ENVPITVARVARTYPE [ SLST_ENVPITVARVARTYPE_SIZE ] [ 11 ] =
{
   "Stable",
   "Increment",
   "Decrement",
   "Peak",
   "Crevace",
   "Random"
};

char *flst_envpitpointformtype (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_ENVPITPOINTFORMTYPE_SIZE;
   else
      return ( SLST_ENVPITPOINTFORMTYPE [ index ] );
}


char SLST_ENVPITPOINTFORMTYPE [ SLST_ENVPITPOINTFORMTYPE_SIZE ] [ 16 ] =
{
   "Slope",
   "Platform",
   "Sawtooth",
   "Rev. Sawtooth"
};


char *flst_settingbitrate (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_SETTINGBITRATE_SIZE;
   else
      return ( SLST_SETTINGBITRATE [ index ] );
}

char SLST_SETTINGBITRATE [ SLST_SETTINGBITRATE_SIZE ] [ 9 ] =
{
   "8 Bits",
   "16 Bits"
};

char *flst_settingfrequency (int index, int *list_index )
{
   if ( index < 0 )
      *list_index = SLST_SETTINGFREQUENCY_SIZE;
   else
      return ( SLST_SETTINGFREQUENCY [ index ] );

}

char SLST_SETTINGFREQUENCY [ SLST_SETTINGFREQUENCY_SIZE ] [ 9 ] =
{
   "11025",
   "22050",
   "44100"
};






/*
      char *foobar(int index, int *list_size);

   If index is zero or positive, the function should return a pointer to the 
   string which is to be displayed at position index in the list. If index 
   is negative, it should return NULL and list_size should be set to the 
   number of items in the list. 
*/

tiny DEFORMSPEED [ DEFORMSPEED_SIZE ] =
{
   DEFORMSPEED_NONE,
   DEFORMSPEED_VERYFAST,
   DEFORMSPEED_FAST,
   DEFORMSPEED_MEDIUM,
   DEFORMSPEED_SLOW,
   DEFORMSPEED_VERYSLOW,
};


int FREQUENCY [ FREQUENCY_SIZE ] =
{
   11025,
   22050,
   44100
};



void set_waveform_property ( s_wave_parameter *wavp )
{
   wavp->waveform.base = ghls_winwav_basewave.selection();
   wavp->waveform.filter = ghls_winwav_filter.selection();
   wavp->waveform.function = ghls_winwav_function.selection();
   wavp->waveform.deformlevel = atoi (getx_winwav_deformlevel.get_text());
   wavp->waveform.deformspeed = DEFORMSPEED [ghls_winwav_deformspeed.selection()];
   wavp->waveform.deformtype = ghls_winwav_deformtype.selection();   
   wavp->waveform.cutfreq = atoi (getx_winwav_wcutfreq.get_text());
   wavp->waveform.cutsize = atoi (getx_winwav_wcutlength.get_text());
   wavp->waveform.cuttype = ghls_winwav_wavecuttype.selection();
   wavp->waveform.ampvprop = atoi (getx_winwav_ampvarprop.get_text());
   wavp->waveform.ampvtype = ghls_winwav_ampvartype.selection();
   wavp->waveform.frevprop = atoi (getx_winwav_frevarprop.get_text());
   wavp->waveform.frevtype = ghls_winwav_frevartype.selection();
   wavp->waveform.zlinelevel = atoi (getx_winwav_zlinelevel.get_text());
   wavp->waveform.zlinetype = ghls_winwav_zlinetype.selection();

   if ( gchk_winwav_ampvarzline.selected() == false )
      wavp->waveform.ampvbust = FALSE;
   else
      wavp->waveform.ampvbust = TRUE;

   if ( wavp->waveform.ampvprop > 100 )
      wavp->waveform.ampvprop = 100;

   if ( wavp->waveform.deformlevel > 100 )
      wavp->waveform.deformlevel = 100;

   if ( wavp->waveform.cutfreq > 30000 )
      wavp->waveform.cutfreq = 30000;
      
   if ( wavp->waveform.cutsize > 30000 )
      wavp->waveform.cutsize = 30000;
     
   if ( wavp->waveform.frevprop > 100 )
      wavp->waveform.frevprop = 100;

   if ( wavp->waveform.zlinelevel > 100 )
      wavp->waveform.zlinelevel = 100;


}

void get_waveform_property ( s_wave_parameter wavp )
{
   char tmpstr[6];
   ghls_winwav_basewave.selection(wavp.waveform.base);
   ghls_winwav_filter.selection(wavp.waveform.filter );
   ghls_winwav_function.selection(wavp.waveform.function);
   ghls_winwav_deformtype.selection(wavp.waveform.deformtype);
   ghls_winwav_wavecuttype.selection(wavp.waveform.cuttype);
   ghls_winwav_ampvartype.selection(wavp.waveform.ampvtype);
   ghls_winwav_frevartype.selection(wavp.waveform.frevtype);
   ghls_winwav_zlinetype.selection(wavp.waveform.zlinetype);

   sprintf ( tmpstr, "%d", wavp.waveform.deformlevel );
   getx_winwav_deformlevel.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.waveform.cutfreq );
   getx_winwav_wcutfreq.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.waveform.cutsize );
   getx_winwav_wcutlength.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.waveform.ampvprop );
   getx_winwav_ampvarprop.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.waveform.frevprop );
   getx_winwav_frevarprop.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.waveform.zlinelevel );
   getx_winwav_zlinelevel.set_text(tmpstr);

   //?? to do, get checkbox

   switch (wavp.waveform.deformspeed)
   {
      case DEFORMSPEED_NONE :
         ghls_winwav_deformspeed.selection(0);
      break;
      case DEFORMSPEED_VERYFAST :
         ghls_winwav_deformspeed.selection(1);
      break;
      case DEFORMSPEED_FAST :
         ghls_winwav_deformspeed.selection(2);
      break;
      case DEFORMSPEED_MEDIUM :
         ghls_winwav_deformspeed.selection(3);
      break;
      case DEFORMSPEED_SLOW :
         ghls_winwav_deformspeed.selection(4);
      break;
      case DEFORMSPEED_VERYSLOW :
         ghls_winwav_deformspeed.selection(5);
      break;
   }

   if ( wavp.waveform.ampvbust == TRUE )
      gchk_winwav_ampvarzline.select();
   else
      gchk_winwav_ampvarzline.deselect();
   
}

void set_envelope_property ( s_wave_parameter *wavp )
{
   char tmpstr [40 ];
   int i;

   for ( i = 0 ; i < 8 ; i++ )
   {
      wavp->envelope[i].x = winenvvar[i].x;
      wavp->envelope[i].y = winenvvar[i].y;
   }

   wavp->envform.varfreq = atoi (getx_winenv_varfreq.get_text());
   wavp->envform.varprop = atoi (getx_winenv_varprop.get_text());
   wavp->envform.vartype = ghls_winenv_vartype.selection();
   wavp->envform.varvartype = ghls_winenv_varvartype.selection();
   wavp->envform.pointformtype = ghls_winenv_pointformtype.selection();

   if ( wavp->envform.varfreq > 100 )
      wavp->envform.varfreq = 100;

   if ( wavp->envform.varprop > 100 )
      wavp->envform.varprop = 100;

}

void get_envelope_property ( s_wave_parameter wavp )
{
   char tmpstr [40 ];
   int i;

   for ( i = 0 ; i < 8 ; i++ )
   {
      winenvvar[i].x = wavp.envelope[i].x;
      winenvvar[i].y = wavp.envelope[i].y;
   }

   sprintf ( tmpstr, "%d", wavp.envform.varfreq );
   getx_winenv_varfreq.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.envform.varprop );
   getx_winenv_varprop.set_text(tmpstr);

   ghls_winenv_vartype.selection(wavp.envform.vartype);
   ghls_winenv_varvartype.selection(wavp.envform.varvartype);
   ghls_winenv_pointformtype.selection(wavp.envform.pointformtype);
   
}

void set_pitch_property ( s_wave_parameter *wavp )
{
   char tmpstr [40 ];
   int i;

   for ( i = 0 ; i < 8 ; i++ )
   {
      wavp->pitch[i].x = winpitvar[i].x;
      wavp->pitch[i].y = winpitvar[i].y;
   }

   wavp->pitform.varfreq = atoi (getx_winpit_freq.get_text());
   wavp->pitform.varprop = atoi (getx_winpit_prop.get_text());
   wavp->pitform.vartype = ghls_winpit_vartype.selection();
   wavp->pitform.varvartype = ghls_winpit_varvartype.selection();
   wavp->pitform.pointformtype = ghls_winpit_pointformtype.selection();

   if ( wavp->pitform.varfreq > 100 )
      wavp->pitform.varfreq = 100;

   if ( wavp->pitform.varprop > 100 )
      wavp->pitform.varprop = 100;


}

void get_pitch_property ( s_wave_parameter wavp  )
{
   char tmpstr [40 ];
   int i;

   for ( i = 0 ; i < 8 ; i++ )
   {
      winpitvar[i].x = wavp.pitch[i].x;
      winpitvar[i].y = wavp.pitch[i].y;
   }

   sprintf ( tmpstr, "%d", wavp.pitform.varfreq );
   getx_winpit_freq.set_text(tmpstr);
   sprintf ( tmpstr, "%d", wavp.pitform.varprop );
   getx_winpit_prop.set_text(tmpstr);

   ghls_winpit_vartype.selection(wavp.pitform.vartype);
   ghls_winpit_varvartype.selection(wavp.pitform.varvartype);
   ghls_winpit_pointformtype.selection(wavp.pitform.pointformtype);
}

void set_setting_property ( s_wave_parameter *wavp )
{
   double tmpval;
   switch ( ghls_winset_bitrate.selection() )
   {
      case 0 : wavp->bitrate = 8;
      break;
      case 1 : wavp->bitrate = 16;
      break;
   }

   wavp->frequency = FREQUENCY [ ghls_winset_samfreq.selection() ];

   tmpval = atof (getx_winset_length.get_text()) * wavp->frequency;
   wavp->length = (dword) tmpval;
}

void get_setting_property ( s_wave_parameter wavp  )
{
   char tmpstr [ 41 ];
   double tmpval;

   if ( wavp.bitrate == 8 )
      ghls_winset_bitrate.selection(0);
   else
      ghls_winset_bitrate.selection(1);
      
   switch ( wavp.frequency )
   {
      case 11025 : ghls_winset_samfreq.selection(0);
      break;
      case 22050 : ghls_winset_samfreq.selection(1);
      break;
      case 44100 : ghls_winset_samfreq.selection(2);
      break;
   }

   tmpval = wavp.length;
   tmpval = tmpval / wavp.frequency;
   sprintf ( tmpstr, "%3.1f", tmpval );
   getx_winset_length.set_text(tmpstr);

}



void draw_main_property ( s_wave_parameter wavp )
{
   double tmpval;

   clear_to_color ( bbmp_generalinfo, makecol ( 255,225,225 ) );
   clear_to_color ( bbmp_waveforminfo, makecol ( 255,225,225 ) );
   clear_to_color ( bbmp_envelopeinfo, makecol ( 255,225,225 ) );
   clear_to_color ( bbmp_pitchinfo, makecol ( 255,225,225 ) );

   text_mode(-1);
//void textprintf(BITMAP *bmp, const FONT *f, int x, y, color, const char *fmt, ...);
   textprintf ( bbmp_generalinfo, font, 0, 0, makecol(0, 0, 0), "Bit Rate");
   textprintf ( bbmp_generalinfo, font, 0, 8, makecol(0, 0, 0),
      "%12d Bits", wavp.bitrate );
   textprintf ( bbmp_generalinfo, font, 0, 16, makecol(0, 0, 0), "Mono");
   textprintf ( bbmp_generalinfo, font, 0, 32, makecol(0, 0, 0), "Frequency");
   textprintf ( bbmp_generalinfo, font, 0, 40, makecol(0, 0, 0),
      "%14d Hz", wavp.frequency );
   textprintf ( bbmp_generalinfo, font, 0, 48, makecol(0, 0, 0), "Length");
   textprintf ( bbmp_generalinfo, font, 0, 56, makecol(0, 0, 0),
      "%17d", wavp.length );
   tmpval = wavp.length;
   tmpval = tmpval / wavp.frequency;
   textprintf ( bbmp_generalinfo, font, 0, 64, makecol(0, 0, 0),
      "%9.1f Seconds", tmpval );
   textprintf ( bbmp_generalinfo, font, 0, 72, makecol(0, 0, 0),
      "%11d Bytes", wavp.length * ( wavp.bitrate / 8 ) );

   //?? add filesize

   textprintf ( bbmp_waveforminfo, font, 0, 0, makecol(0, 0, 0),
      "Base     %s", SLST_WAVEBASE [ wavp.waveform.base ] );
   textprintf ( bbmp_waveforminfo, font, 0, 8, makecol(0, 0, 0),
      "Function %s", SLST_WAVEFUNCTION [ wavp.waveform.function ]);
   textprintf ( bbmp_waveforminfo, font, 0, 16, makecol(0, 0, 0),
      "Filter   %s", SLST_WAVEFILTER [ wavp.waveform.filter ]);
   textprintf ( bbmp_waveforminfo, font, 0, 40, makecol(0, 0, 0),
      "Cutting : %5d Hz %5d", wavp.waveform.cutfreq, wavp.waveform.cutsize );
   textprintf ( bbmp_waveforminfo, font, 0, 48, makecol(0, 0, 0),
      "                %s", SLST_ENVPITVARVARTYPE [ wavp.waveform.cuttype ] );
      

   int index;

   switch ( wavp.waveform.deformspeed )
   {
      case DEFORMSPEED_VERYFAST :
         index = 1;
      break;
      case DEFORMSPEED_FAST :
         index = 2;
      break;
      case DEFORMSPEED_MEDIUM :
         index = 3;
      break;
      case DEFORMSPEED_SLOW :
         index = 4;
      break;
      case DEFORMSPEED_VERYSLOW :
         index = 5;
      break;
      default :
         index = 0;
      break;
   }
   textprintf ( bbmp_waveforminfo, font, 0, 24, makecol(0, 0, 0),
      "Deformation :   %3d%% %6s", wavp.waveform.deformlevel,
      SLST_DEFORMSPEED [ index ] );
   textprintf ( bbmp_waveforminfo, font, 0, 32, makecol(0, 0, 0),
      "                %s", SLST_DEFORMTYPE [ wavp.waveform.deformtype ] );
   textprintf ( bbmp_waveforminfo, font, 0, 56, makecol(0, 0, 0),
      "Ampl. Var.:%3d%% %s", wavp.waveform.ampvprop,
      SLST_AMPVARTYPE [ wavp.waveform.ampvtype ] );
   if ( wavp.waveform.ampvbust == TRUE )
      textprintf ( bbmp_waveforminfo, font, 0, 64, makecol(0, 0, 0),
         "   Bust the Zero line");
   else
      textprintf ( bbmp_waveforminfo, font, 0, 64, makecol(0, 0, 0),
      "   Don't bust Zero line");
   textprintf ( bbmp_waveforminfo, font, 0, 72, makecol(0, 0, 0),
      "Freq. Var.:%3d  %s", wavp.waveform.frevprop,
      SLST_FREVARTYPE [ wavp.waveform.frevtype ] );
   textprintf ( bbmp_waveforminfo, font, 0, 80, makecol(0, 0, 0),
      "ZLine Move:%3d%% %s", wavp.waveform.zlinelevel,
      SLST_ZLINETYPE [ wavp.waveform.zlinetype ] );


   textprintf ( bbmp_envelopeinfo, font, 0, 0, makecol(0, 0, 0),
      "Mode : %s", SLST_ENVPITPOINTFORMTYPE [ wavp.envform.pointformtype ] );
   textprintf ( bbmp_envelopeinfo, font, 0, 8, makecol(0, 0, 0),
      "Variation : %5d Hz %3d%%", wavp.envform.varfreq, wavp.envform.varprop );
   textprintf ( bbmp_envelopeinfo, font, 0, 16, makecol(0, 0, 0),
      "            %s", SLST_ENVPITVARTYPE [ wavp.envform.vartype ] );
   textprintf ( bbmp_envelopeinfo, font, 0, 24, makecol(0, 0, 0),
      "            %s", SLST_ENVPITVARVARTYPE [ wavp.envform.varvartype ] );
      
      
   textprintf ( bbmp_pitchinfo, font, 0, 0, makecol(0, 0, 0),
      "Mode : %s", SLST_ENVPITPOINTFORMTYPE [ wavp.pitform.pointformtype ] );
   textprintf ( bbmp_pitchinfo, font, 0, 8, makecol(0, 0, 0),
      "Variation : %5d Hz %3d%%", wavp.pitform.varfreq, wavp.pitform.varprop );
   textprintf ( bbmp_pitchinfo, font, 0, 16, makecol(0, 0, 0),
      "            %s", SLST_ENVPITVARTYPE [ wavp.pitform.vartype ] );
   textprintf ( bbmp_pitchinfo, font, 0, 24, makecol(0, 0, 0),
      "            %s", SLST_ENVPITVARVARTYPE [ wavp.pitform.varvartype ] );
      

   text_mode(makecol ( 225,225,225 ));


//   gbmp_main_waveforminfo.send_message(MSG_DRAW,0);
//   gbmp_main_envelopeinfo.send_message(MSG_DRAW,0);
//   gbmp_main_pitchinfo.send_message(MSG_DRAW,0);
//   gbmp_main_generalinfo.send_message(MSG_DRAW,0);
   gbmp_main_waveforminfo.redraw();
   gbmp_main_envelopeinfo.redraw();
   gbmp_main_pitchinfo.redraw();
   gbmp_main_generalinfo.redraw();
     
   
   
}

void draw_main_bitmap ( s_wave_parameter wavp )
{
   SAMPLE* tmpsample;

   tmpsample = make_test_waveform ( wavp );
   draw_waveform ( tmpsample );
   destroy_sample ( tmpsample );

   tmpsample = make_test_envelope ( wavp );
   draw_envelopeform ( tmpsample );
   draw_envelope ( wavp );
   destroy_sample ( tmpsample );

   tmpsample = make_test_pitch ( wavp );
   draw_pitchform ( tmpsample );
   draw_pitch ( wavp );
   destroy_sample ( tmpsample );

   gbmp_main_waveform.redraw();
   gbmp_main_envelope.redraw();
   gbmp_main_pitch.redraw();

}

void draw_waveform ( SAMPLE *tmpsample )
{
   tiny *dataptr8b = NULL;
   short *dataptr16b = NULL;
   int i;
   
   switch ( tmpsample->bits )
   {
      case 8 :
         dataptr8b = (tiny*)tmpsample->data;
      break;
      case 16 :

         dataptr16b = (short*)tmpsample->data;
      break;
   }
   
   // draw wave form

   clear_to_color ( bbmp_waveform, makecol ( 0, 0, 0 ));

   hline ( bbmp_waveform, 0, 50, 200, makecol ( 150, 150, 150 ) );


   for ( i = 1 ; i < 200; i++ )
   {
      switch ( tmpsample->bits )
      {
         case 8 :
         line ( bbmp_waveform, i-1, 50 - ( ( dataptr8b [ i - 1 ] * 50 ) / 127),
               i, 50 - ( ( dataptr8b [ i ] * 50 ) / 127),
               makecol (50, 255, 50 ) );
         break;
         case 16 :
            line ( bbmp_waveform, i-1, 50 - ( ( dataptr16b [ i - 1 ] * 50 ) / 32767),
               i, 50 - ( ( dataptr16b [ i ] * 50 ) / 32767),
               makecol (50, 255, 50 ) );
         break;
      }
   }

}

void draw_envelopeform ( SAMPLE *tmpsample )
{
   short tmpy;
   short envinc;
   short bitmax=0;
   short clrv;
   short i;
   short j;

   switch ( tmpsample->bits )
   {
      case BITRATE_8BIT :
         bitmax = 127;
      break;
      case BITRATE_16BIT :
         bitmax = 32767;
      break;
   }

   clear_to_color ( bbmp_envelope, makecol ( 0, 0, 0 ));
   hline ( bbmp_envelope, 0, 50, 200, makecol ( 150, 150, 150 ) );

   envinc = tmpsample->len / 200;

   for  ( i = 0 ; i < 200 ; i++ )
   {
      tmpy = ( ( wcontain [ i * envinc ].envelope ) * 50 ) / bitmax;

      for ( j = 50-tmpy; j < 50+ tmpy; j++ )
      {
         clrv = abs(j-50);
         putpixel ( bbmp_envelope, i, j,
            makecol ( 0+(clrv*3), 0+(clrv*3), 200+clrv ) );
      }
   }


}

void draw_pitchform ( SAMPLE *tmpsample )
{
   short tmpy;
   short pitinc;
   short clrv=0;
   short i;
   short j;

   clear_to_color ( bbmp_pitch, makecol ( 0, 0, 0 ));
   pitinc = tmpsample->len / 200;

   for  ( i = 0 ; i < 200 ; i++ )
   {
      tmpy = ( ( wcontain [ i * pitinc ].frequency ) -10 ) / 5 ;

         for ( j = 200-tmpy; j < 200; j++ )
         {
            clrv = (200-j) /2;
            putpixel ( bbmp_pitch, i, j/2,
               makecol ( 150+clrv, 50+(clrv), 50+(clrv ) ) );
         }
      
   }

}

void draw_envelope ( s_wave_parameter wavp )
{
   short i;
   short ya=0;
   short yb=0;
   
   for ( i = 0 ; i < 7 ; i++ )
   {
      switch ( wavp.envform.pointformtype )
      {
         case POINTFORMTYPE_SLOPE :
            ya = wavp.envelope[i].y;
            yb = wavp.envelope[i+1].y;
         break;
         case POINTFORMTYPE_PLATFORM :
            ya = wavp.envelope[i].y;
            yb = wavp.envelope[i].y;
         break;
         case POINTFORMTYPE_SAWTOOTH :
            ya = wavp.envelope[i].y;
            yb = 0;
         break;
         case POINTFORMTYPE_RSAWTOOTH :
            ya = 0;
            yb = wavp.envelope[i+1].y;
         break;
      }
      line(bbmp_envelope,
         wavp.envelope[i].x*2, 50-ya,
         wavp.envelope[i+1].x*2, 50-yb ,
         makecol ( 255, 255, 255 ));
      rect ( bbmp_envelope, (wavp.envelope[i].x*2)-1, 50-wavp.envelope[i].y-1,
         (wavp.envelope[i].x*2)+1, 50-wavp.envelope[i].y+1,
         makecol ( 255, 255, 255 ) );
      line(bbmp_envelope,
         wavp.envelope[i].x*2, 49+ya,
         wavp.envelope[i+1].x*2, 49+yb ,
         makecol ( 255, 255, 255 ));
      rect ( bbmp_envelope, (wavp.envelope[i].x*2)-1, 49+wavp.envelope[i].y-1,
         (wavp.envelope[i].x*2)+1, 49+wavp.envelope[i].y+1,
         makecol ( 255, 255, 255 ) );

   }

   rect ( bbmp_envelope, (wavp.envelope[7].x*2)-2, 50-wavp.envelope[7].y-1,
      (wavp.envelope[7].x*2)+0, 50-wavp.envelope[7].y+1,
      makecol ( 255, 255, 255 ) );
   
   rect ( bbmp_envelope, (wavp.envelope[7].x*2)-2, 49+wavp.envelope[7].y-1,
      (wavp.envelope[7].x*2)+0, 49+wavp.envelope[7].y+1,
      makecol ( 255, 255, 255 ) );

}

void draw_pitch ( s_wave_parameter wavp )
{
   short i;
   short ya=0;
   short yb=0;
   
   for ( i = 0 ; i < 7 ; i++ )
   {
      switch ( wavp.pitform.pointformtype )
      {
         case POINTFORMTYPE_SLOPE :
            ya = wavp.pitch[i].y;
            yb = wavp.pitch[i+1].y;
         break;
         case POINTFORMTYPE_PLATFORM :
            ya = wavp.pitch[i].y;
            yb = wavp.pitch[i].y;
         break;
         case POINTFORMTYPE_SAWTOOTH :
            ya = wavp.pitch[i].y;
            yb = 0;
         break;
         case POINTFORMTYPE_RSAWTOOTH :
            ya = 0;
            yb = wavp.pitch[i+1].y;
         break;
      }
   
      line(bbmp_pitch,
         wavp.pitch[i].x*2, ( 200-ya) /2,
         wavp.pitch[i+1].x*2, ( 200-yb) /2 ,
         makecol ( 255, 255, 255 ));
      rect ( bbmp_pitch, (wavp.pitch[i].x*2)-1, ( 200-wavp.pitch[i].y-1) /2,
         (wavp.pitch[i].x*2)+1, (200-wavp.pitch[i].y+1) /2,
         makecol ( 255, 255, 255 ) );
   }

   rect ( bbmp_pitch, (wavp.pitch[7].x*2)-2, (200-wavp.pitch[7].y-1)/2,
      (wavp.pitch[7].x*2)+0, (200-wavp.pitch[7].y+1)/2,
      makecol ( 255, 255, 255 ) );
   

}

void draw_generate ( SAMPLE *tmpsample )
{
   tiny *dataptr8b = NULL;
   short *dataptr16b = NULL;
   int i;
   short wavinc;
   
   switch ( tmpsample->bits )
   {
      case 8 :
         dataptr8b = (tiny*)tmpsample->data;
      break;
      case 16 :
         dataptr16b = (short*)tmpsample->data;
      break;
   }
   
   // draw wave form

   clear_to_color ( bbmp_generate, makecol ( 0, 0, 0 ));

   hline ( bbmp_generate, 0, 300, 600, makecol ( 150, 150, 150 ) );


   wavinc = tmpsample->len / 600;

//   textprintf ( bbmp_generate, font, 0, 0, makecol(225, 225, 225 ),
//      "Test waveinc : %d , bitrate : %d , length %d",
//      wavinc, tmpsample->bits, tmpsample->len );
   
   for ( i = 1 ; i < 600; i++ )
   {
      switch ( tmpsample->bits )
      {
         case 8 :
         line ( bbmp_generate, i-1, 150 - ( ( dataptr8b [ (i - 1)*wavinc ] * 150 ) / 127),
               i, 150 - ( ( dataptr8b [ i * wavinc] * 150 ) / 127),
               makecol (50, 255, 50 ) );
         break;
         case 16 :
            line ( bbmp_generate, i-1, 150 - ( ( dataptr16b [ (i - 1)* wavinc ] * 150 ) / 32767),
               i, 150 - ( ( dataptr16b [ i*wavinc ] * 150 ) / 32767),
               makecol (50, 255, 50 ) );
         break;
      }
   }

   

}


//----------------------------- Gui Handler Routines -------------------

int gc_waveform_preview_click ( void )
{
   SAMPLE *tmpsample;

   s_wave_parameter tmparam;

   reset_wave_parameter ( &tmparam );
   set_waveform_property ( &tmparam );
   
//   tmparam.length = (int)(tmparam.frequency * 1.5);
//   validate_wave_parameter ( &tmparam );
//   tmpsample = generate_sound ( tmparam );

   tmpsample = make_test_waveform ( tmparam );
   draw_waveform ( tmpsample );
   
   gbmp_winwav_waveform.send_message(MSG_DRAW,0);


   play_sample ( tmpsample, gsld_main_volume.value(), 128, 1000, 0 );
   rest ( /*(tmparam.length / tmparam.frequency ) * */1000 );
   destroy_sample ( tmpsample );

//   save_bitmap ( "waveform.pcx", screen, NULL );
   get_waveform_property ( tmparam ); // recopy parameters after validation


//   return ( D_REDRAW );
   return ( D_O_K );
}

int gc_waveform_accept_click ( void )
{
   SAMPLE* tmpsample;
   set_waveform_property ( &wparam );
   validate_wave_parameter ( &wparam );

   draw_main_property( wparam );
   draw_main_bitmap( wparam );

   return ( D_O_K );
}

int gc_waveform_cancel_click ( void )
{

   return ( D_O_K );
}

int gc_envelope_preview_click ( void )
{
   SAMPLE *tmpsample;

   s_wave_parameter tmparam;

   reset_wave_parameter ( &tmparam );
   set_envelope_property ( &tmparam );
   
//   tmparam.length = (int)(tmparam.frequency * 1.5);
//   validate_wave_parameter ( &tmparam );
//   tmpsample = generate_sound ( tmparam );

   tmpsample = make_test_envelope ( tmparam );
   draw_envelopeform ( tmpsample );
   draw_envelope ( tmparam );
   
   gbmp_winenv_envelope.send_message(MSG_DRAW,0);
   
   play_sample ( tmpsample, gsld_main_volume.value(), 128, 1000, 0 );
   rest ( /*(tmparam.length / tmparam.frequency ) * */1000 );
   destroy_sample ( tmpsample );

//   save_bitmap ( "envelope.pcx", screen, NULL );
   get_envelope_property ( tmparam ); // recopy parameters after validation


//   return ( D_REDRAW );
   return ( D_O_K );   

}

int gc_envelope_accept_click ( void )
{
   SAMPLE* tmpsample;

   set_envelope_property ( &wparam );
   validate_wave_parameter ( &wparam );

   draw_main_property( wparam );
   draw_main_bitmap( wparam );
   

   return ( D_O_K );
}

int gc_envelope_cancel_click ( void )
{
   return ( D_CLOSE );
}

int gc_envelope_pointA_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 0 ) );
}
int gc_envelope_pointB_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 1 ) );
}
int gc_envelope_pointC_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 2 ) );
}
int gc_envelope_pointD_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 3 ) );
}
int gc_envelope_pointE_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 4 ) );
}
int gc_envelope_pointF_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 5 ) );
}
int gc_envelope_pointG_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 6 ) );
}
int gc_envelope_pointH_click ( void )
{
   return ( gc_envelope_pointgeneric_click ( 7 ) );
}
int gc_envelope_pointgeneric_click ( int pointID )
{
   s_wave_parameter tmparam;

   reset_wave_parameter ( &tmparam );
   POINTCOPY ( tmparam.envelope, winenvvar);
   move_envelope_point ( pointID, &tmparam );
   POINTCOPY ( winenvvar, tmparam.envelope);
   return ( D_O_K );
}


int gc_pitch_preview_click ( void )
{

   SAMPLE *tmpsample;

   s_wave_parameter tmparam;

   reset_wave_parameter ( &tmparam );
   set_pitch_property ( &tmparam );
   
//   tmparam.length = (int)(tmparam.frequency * 1.5);
//   validate_wave_parameter ( &tmparam );
//   tmpsample = generate_sound ( tmparam );

   tmpsample = make_test_pitch ( tmparam );
   draw_pitchform ( tmpsample );
   draw_pitch ( tmparam );
   
   gbmp_winpit_pitch.send_message(MSG_DRAW,0);
   
   play_sample ( tmpsample, gsld_main_volume.value(), 128, 1000, 0 );
   rest ( /*(tmparam.length / tmparam.frequency ) * */1000 );
   destroy_sample ( tmpsample );

//   save_bitmap ( "pitch.pcx", screen, NULL );
   get_pitch_property ( tmparam ); // recopy parameters after validation


//   return ( D_REDRAW );
   return ( D_O_K );

}

int gc_pitch_accept_click ( void )
{
   SAMPLE* tmpsample;

   set_pitch_property ( &wparam );
   validate_wave_parameter ( &wparam );

   draw_main_property( wparam );
   draw_main_bitmap( wparam );

   return ( D_O_K );

}

int gc_pitch_cancel_click ( void )
{
   return ( D_CLOSE );
}

int gc_pitch_pointA_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 0 ) );
}
int gc_pitch_pointB_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 1 ) );
}
int gc_pitch_pointC_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 2 ) );
}
int gc_pitch_pointD_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 3 ) );
}
int gc_pitch_pointE_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 4 ) );
}
int gc_pitch_pointF_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 5 ) );
}
int gc_pitch_pointG_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 6 ) );
}
int gc_pitch_pointH_click ( void )
{
   return (gc_pitch_pointgeneric_click ( 7 ) );
}
int gc_pitch_pointgeneric_click ( int pointID )
{
   s_wave_parameter tmparam;

   reset_wave_parameter ( &tmparam );
   POINTCOPY ( tmparam.pitch, winpitvar );
   move_pitch_point ( pointID, &tmparam );
   POINTCOPY ( winpitvar, tmparam.pitch );
   return ( D_O_K );
}


int gc_setting_accept_click ( void )
{
   SAMPLE* tmpsample;

   set_setting_property ( &wparam );
   validate_wave_parameter ( &wparam );

   draw_main_property( wparam );
   draw_main_bitmap( wparam );
   return ( D_O_K );
}

int gc_generate_play_click ( void  )
{
   play_sample ( mainsample, gsld_main_volume.value(), 128, 1000, 0 );
//   save_bitmap ( "generate.pcx", screen, NULL );
   return ( D_O_K );
}

int gc_generate_export_click ( void  )
{
   char tmpstr [ 481 ];
   int retval;

   strcpy ( tmpstr, "" );

   retval = degui_file_select("Export sound on which name", tmpstr, "WAV");

   if ( retval != 0 )
   {
      retval = export_to_wav ( mainsample, tmpstr );

      if ( retval == 1 )
      {
         degui_alert ( "An Error occured when attempting to save ", tmpstr,
            "", "Ok",NULL, KEY_ENTER,0 );
      }
   }

   return ( D_O_K );
}

int gc_generate_close_click ( void  )
{
   destroy_sample ( mainsample );
   return ( D_CLOSE );
}

int gc_main_generate_click ( void )
{

   mainsample = generate_sound ( wparam );
   draw_generate ( mainsample );
   gbmp_wingen_generate.redraw();

   show_generated_sample();


//   play_sample ( tmpsample, gsld_main_volume.value(), 128, 1000, 0 );
//   rest ( 1000 );


//   get_envelope_property ( tmparam ); // recopy parameters after validation

//   return ( D_REDRAW );

   return ( D_O_K );
}


void move_envelope_point ( int pointid, s_wave_parameter *wavp )
{
   bool exit_loop = false;
   int tmpkey;
   int vertex [ 8 ];

   text_mode ( -1 );

   while ( exit_loop == false )
   {
      clear_to_color ( bbmp_envelope, makecol ( 0, 0, 0 ) );
      draw_envelope ( *wavp );

      // draw selector
      vertex [ 0 ] = wavp->envelope [ pointid ].x*2;
      vertex [ 1 ] = 50 - wavp->envelope [ pointid ].y - 5;
      vertex [ 2 ] = wavp->envelope [ pointid ].x*2 + 5;
      vertex [ 3 ] = 50 -wavp->envelope [ pointid ].y;
      vertex [ 4 ] = wavp->envelope [ pointid ].x*2;
      vertex [ 5 ] = 50 -wavp->envelope [ pointid ].y + 5;
      vertex [ 6 ] = wavp->envelope [ pointid ].x*2 - 5;
      vertex [ 7 ] = 50 -wavp->envelope [ pointid ].y;
      polygon(bbmp_envelope, 4, vertex, makecol ( 255, 255, 255 ) );

      //draw coordonates
      textprintf (bbmp_envelope, font, 0, 92, makecol ( 225, 225, 225 ),
         "xy(%d,%d)", wavp->envelope [ pointid ].x,
         wavp->envelope [ pointid ].y );
      

      //--------------
      gbmp_winenv_envelope.send_message (MSG_DRAW,0);

      tmpkey = readkey() >> 8;
      switch ( tmpkey )
      {
         case KEY_ENTER :
            exit_loop = true;
         break;
         case KEY_UP :
            if ( wavp->envelope [ pointid ].y < 50 )
               wavp->envelope [ pointid ].y++;
         break;
         case KEY_DOWN :
            if ( wavp->envelope [ pointid ].y > 0 )
               wavp->envelope [ pointid ].y--;
         break;
         case KEY_LEFT :
            if ( wavp->envelope [ pointid ].x > 0 )
            {
               if ( pointid > 0 )
               {
                  if ( wavp->envelope [ pointid ].x >
                     wavp->envelope [ pointid -1 ].x + 1 )
                     wavp->envelope [ pointid ].x--;
               }
               else
                  wavp->envelope [ pointid ].x--;
            }
         break;
         case KEY_RIGHT :
            if ( wavp->envelope [ pointid ].x < 100 )
            {
               if ( pointid < 7 )
               {
                  if ( wavp->envelope [ pointid ].x <
                     wavp->envelope [ pointid + 1 ].x - 1 )
                     wavp->envelope [ pointid ].x++;
               }
               else
                  wavp->envelope [ pointid ].x++;
            }
         break;
         
      }
   }
   clear_to_color ( bbmp_envelope, makecol ( 0, 0, 0 ) );
   draw_envelope ( *wavp );
   gbmp_winenv_envelope.redraw();
   text_mode(makecol ( 225,225,225 ));   
}

void move_pitch_point ( int pointid, s_wave_parameter *wavp )
{
   bool exit_loop = false;
   int tmpkey;
   int vertex [ 8 ];

   text_mode ( -1 );

   while ( exit_loop == false )
   {
      clear_to_color ( bbmp_pitch, makecol ( 0, 0, 0 ) );
      draw_pitch ( *wavp );
      
      // draw selector
      vertex [ 0 ] = wavp->pitch [ pointid ].x*2;
      vertex [ 1 ] = ( 200 - wavp->pitch [ pointid ].y) /2 - 5;
      vertex [ 2 ] = wavp->pitch [ pointid ].x*2 + 5;
      vertex [ 3 ] = ( 200 -wavp->pitch [ pointid ].y ) /2;
      vertex [ 4 ] = wavp->pitch [ pointid ].x*2;
      vertex [ 5 ] = ( 200 -wavp->pitch [ pointid ].y ) /2 + 5;
      vertex [ 6 ] = wavp->pitch [ pointid ].x*2 - 5;
      vertex [ 7 ] = ( 200 -wavp->pitch [ pointid ].y ) /2;
      polygon(bbmp_pitch, 4, vertex, makecol ( 255, 255, 255 ) );

      //draw coordonates
      textprintf (bbmp_pitch, font, 0, 92, makecol ( 225, 225, 225 ),
         "xy(%d,%d)", wavp->pitch [ pointid ].x,
         wavp->pitch [ pointid ].y );

      
      //--------------
      gbmp_winpit_pitch.send_message (MSG_DRAW,0);

      tmpkey = readkey() >> 8;
      switch ( tmpkey )
      {
         case KEY_ENTER :
            exit_loop = true;
         break;
         case KEY_UP :
            if ( wavp->pitch [ pointid ].y < 200 )
               wavp->pitch [ pointid ].y++;
         break;
         case KEY_DOWN :
            if ( wavp->pitch [ pointid ].y > 0 )
               wavp->pitch [ pointid ].y--;
         break;
         case KEY_LEFT :
            if ( wavp->pitch [ pointid ].x > 0 )
            {
               if ( pointid > 0 )
               {
                  if ( wavp->pitch [ pointid ].x >
                     wavp->pitch [ pointid -1 ].x + 1 )
                     wavp->pitch [ pointid ].x--;
               }
               else
                  wavp->pitch [ pointid ].x--;
            }
         break;
         case KEY_RIGHT :
            if ( wavp->pitch [ pointid ].x < 100 )
            {
               if ( pointid < 7 )
               {
                  if ( wavp->pitch [ pointid ].x <
                     wavp->pitch [ pointid + 1 ].x - 1 )
                     wavp->pitch [ pointid ].x++;
               }
               else
                  wavp->pitch [ pointid ].x++;
            }
         break;
         
      }
   }
   clear_to_color ( bbmp_pitch, makecol ( 0, 0, 0 ) );
   draw_pitch ( *wavp );
   gbmp_winpit_pitch.redraw();
   text_mode(makecol ( 225,225,225 ));

}


/*   D_O_K          - normal return status
   D_CLOSE        - tells the dialog manager to close the dialog
   D_REDRAW       - tells the dialog manager to redraw the entire dialog
   D_REDRAWME     - tells the dialog manager to redraw the current object
   D_WANTFOCUS    - requests that the input focus be given to this object
   D_USED_CHAR    - MSG_CHAR and MSG_XCHAR return this if they used the key
*/

/*-------------------------------------------------------------------------*/
/*-                               Menu Procedures                         -*/
/*-------------------------------------------------------------------------*/

int mnu_proc ( void )
{

}

int mnu_file_new ( void )
{
   reset_wave_parameter ( &wparam );
   draw_main_property( wparam );
   draw_main_bitmap( wparam );
   
}

int mnu_file_open ( void )
{
   char tmpstr [ 481 ];
   char tmpstr2 [ 551 ];
   int retval;

   strcpy ( tmpstr, "" );
   strcpy ( tmpstr2, "" );
   
   retval = degui_file_select("Select a file to LOAD", tmpstr, "SWG");
//int file_select_ex(const char *message, char *path, const char *ext,
//                    int size, int w, int h);

   if ( retval != 0 )
   {
      retval =load_from_swg ( &wparam, tmpstr );

      if ( retval == 0 )
      {
         draw_main_property( wparam );
         draw_main_bitmap( wparam );
      }
      else
      {
         strcpy ( tmpstr2, "Error loading :" );
         strcat ( tmpstr2, tmpstr );
         degui_alert ( tmpstr2, "The SWG file is not the same version",
         "or it is simply not a valid SWG file", "Ok",NULL, KEY_ENTER,0 );
      }

   }

}

int mnu_file_save ( void )
{
   char tmpstr [ 481 ];
   int retval;

   strcpy ( tmpstr, "" );

   retval = degui_file_select("SAVE file on which name", tmpstr, "SWG");

   if ( retval != 0 )
   {
      retval = save_to_swg ( wparam, tmpstr );

      if ( retval == 0 )
      {
         draw_main_property( wparam );
         draw_main_bitmap( wparam );
      }
      else
      {
         degui_alert ( "An Error occured when attempting to save ", tmpstr, "",
            "Ok",NULL, KEY_ENTER,0 );
      }
   }
}

/*int mnu_file_exit ( void )
{
   gbtn_exit.msg_click();
   return ( D_CLOSE );
} */

int mnu_param_setting ( void )
{
   get_setting_property ( wparam );
   show_setting_property ();
}

int mnu_param_waveform ( void )
{
   get_waveform_property ( wparam );
   show_waveform_property();
}

int mnu_param_envelope ( void )
{
   get_envelope_property (wparam );
   show_envelope_property();
}

int mnu_param_pitch ( void )
{
   get_pitch_property ( wparam );
   show_pitch_property();
}

int mnu_help_help ( void )
{

}

int mnu_help_about ( void )
{
   show_about ();
}


//--------------- table copy -----------------------

/*void pointcopy ( s_coordinate *dst[], s_coordinate *src[] )
{
   int i;

   for ( i = 0 ; i < 4 ; i++ )
   {
      dst [ i ] -> x = src [ i ] -> x;
      dst [ i ] -> y = src [ i ] -> y;
   }
} */

